/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.twilightanvil.RenameGui;
import net.borisshoes.arcananovum.gui.twilightanvil.TwilightAnvilGui;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TwilightAnvilBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private int origin;
    private String customName;
    private final Multiblock multiblock = ((MultiblockCore)((Object)ArcanaRegistry.TWILIGHT_ANVIL)).getMultiblock();
    private boolean assembled;
    private boolean seenForge;

    public TwilightAnvilBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.TWILIGHT_ANVIL_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, int origin, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.origin = origin;
        this.customName = customName == null ? "" : customName;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof TwilightAnvilBlockEntity) {
            TwilightAnvilBlockEntity anvil = (TwilightAnvilBlockEntity)e;
            anvil.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (serverWorld.method_8503().method_3780() % 10 == 0) {
            this.assembled = this.multiblock.matches(this.getMultiblockCheck());
            boolean bl = this.seenForge = StarlightForge.findActiveForge(serverWorld, this.field_11867) != null;
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.assembled && this.seenForge) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
    }

    public void openGui(int screen, class_3222 player, String data) {
        Object gui = null;
        if (screen == 0) {
            gui = new TwilightAnvilGui(class_3917.field_17337, player, this, screen);
            gui.buildMenuGui();
        } else if (screen == 1) {
            gui = new TwilightAnvilGui(class_3917.field_17326, player, this, screen);
            gui.buildAnvilGui();
        } else if (screen == 2) {
            gui = new TwilightAnvilGui(class_3917.field_18666, player, this, screen);
            gui.buildTinkerGui();
        } else if (screen == 3) {
            gui = new RenameGui(player, this);
            ((RenameGui)((Object)gui)).build();
        } else if (screen == 4) {
            gui = new TwilightAnvilGui(class_3917.field_17327, player, this, screen);
            TomeGui.buildItemGui(gui, player, data);
        }
        if (gui != null) {
            gui.open();
        }
    }

    public AnvilOutputSet calculateOutput(class_1799 input1, class_1799 input2) {
        int repairedDamage;
        class_1799 output = input1.method_7972();
        int repairItemUsage = 0;
        int runningLevelCost = 0;
        long combinedRepairCost = 0L;
        if (input1.method_7960() || !class_1890.method_57529((class_1799)input1)) {
            return new AnvilOutputSet(input1, input2, class_1799.field_8037, 0, 0);
        }
        class_9304.class_9305 builder = new class_9304.class_9305(class_1890.method_57532((class_1799)output));
        combinedRepairCost += (long)((Integer)input1.method_58695(class_9334.field_49639, (Object)0)).intValue() + (long)((Integer)input2.method_58695(class_9334.field_49639, (Object)0)).intValue();
        if (!input2.method_7960()) {
            boolean input2Enchanted = input2.method_57826(class_9334.field_49643);
            if (output.method_7963() && input1.method_61655(input2)) {
                int repairCount;
                repairedDamage = Math.min(output.method_7919(), output.method_7936() / 4);
                if (repairedDamage <= 0) {
                    return new AnvilOutputSet(input1, input2, class_1799.field_8037, 0, 0);
                }
                for (repairCount = 0; repairedDamage > 0 && repairCount < input2.method_7947(); ++repairCount) {
                    int newDamage = output.method_7919() - repairedDamage;
                    output.method_7974(newDamage);
                    ++runningLevelCost;
                    repairedDamage = Math.min(output.method_7919(), output.method_7936() / 4);
                }
                repairItemUsage = repairCount;
            } else {
                if (!(input2Enchanted || output.method_31574(input2.method_7909()) && output.method_7963())) {
                    return new AnvilOutputSet(input1, input2, class_1799.field_8037, 0, 0);
                }
                if (output.method_7963() && !input2Enchanted) {
                    int input1Durability = input1.method_7936() - input1.method_7919();
                    int input2Durability = input2.method_7936() - input2.method_7919();
                    int bonusDurability = input2Durability + output.method_7936() * 12 / 100;
                    int otherRepairedDamage = input1Durability + bonusDurability;
                    int newDamage = output.method_7936() - otherRepairedDamage;
                    if (newDamage < 0) {
                        newDamage = 0;
                    }
                    if (newDamage < output.method_7919()) {
                        output.method_7974(newDamage);
                        runningLevelCost += 2;
                    }
                }
                class_9304 itemEnchantmentsComponent = class_1890.method_57532((class_1799)input2);
                boolean hasCompatibleEnchant = false;
                boolean hasIncompatibleEnchant = false;
                for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                    int newLevel;
                    class_6880 enchantmentEntry = (class_6880)entry.getKey();
                    class_1887 enchantment = (class_1887)enchantmentEntry.comp_349();
                    int level = builder.method_57546(enchantmentEntry);
                    newLevel = level == (newLevel = entry.getIntValue()) ? newLevel + 1 : Math.max(newLevel, level);
                    boolean canCombine = enchantment.method_8192(input1);
                    if (input1.method_31574(class_1802.field_8598)) {
                        canCombine = true;
                    }
                    for (class_6880 enchantmentEntry2 : builder.method_57545()) {
                        if (enchantmentEntry2.equals((Object)enchantmentEntry) || class_1887.method_60033((class_6880)enchantmentEntry, (class_6880)enchantmentEntry2)) continue;
                        canCombine = false;
                        ++runningLevelCost;
                    }
                    if (!canCombine) {
                        hasIncompatibleEnchant = true;
                        continue;
                    }
                    hasCompatibleEnchant = true;
                    if (newLevel > enchantment.method_8183()) {
                        newLevel = enchantment.method_8183();
                    }
                    builder.method_57547(enchantmentEntry, newLevel);
                    int enchantCost = enchantment.method_58446();
                    if (input2Enchanted) {
                        enchantCost = Math.max(1, enchantCost / 2);
                    }
                    runningLevelCost += enchantCost * newLevel;
                    if (input1.method_7947() <= 1) continue;
                    runningLevelCost = 40;
                }
                boolean enhancingStats = false;
                if (input1.method_31574(input2.method_7909())) {
                    boolean enhanced2;
                    boolean enhanced1 = EnhancedStatUtils.isEnhanced(input1);
                    enhancingStats = enhanced2 = EnhancedStatUtils.isEnhanced(input2);
                    if (enhanced1 && enhanced2) {
                        double stat1 = ArcanaItem.getDoubleProperty(input1, EnhancedStatUtils.ENHANCED_STAT_TAG);
                        double stat2 = ArcanaItem.getDoubleProperty(input2, EnhancedStatUtils.ENHANCED_STAT_TAG);
                        double combined = Math.min(1.0, EnhancedStatUtils.combineStats(stat1, stat2) + 0.025 * (double)ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.ENHANCED_ENHANCEMENTS.id));
                        EnhancedStatUtils.enhanceItem(output, combined);
                        runningLevelCost += (int)(40.0 * combined);
                    } else if (enhanced2) {
                        double stat2 = ArcanaItem.getDoubleProperty(input2, EnhancedStatUtils.ENHANCED_STAT_TAG);
                        EnhancedStatUtils.enhanceItem(output, stat2);
                        runningLevelCost += (int)(20.0 * stat2);
                    }
                }
                if (hasIncompatibleEnchant && !hasCompatibleEnchant && !enhancingStats) {
                    return new AnvilOutputSet(input1, input2, class_1799.field_8037, 0, 0);
                }
            }
        }
        int levelCost = (int)class_3532.method_53062((long)(combinedRepairCost + (long)runningLevelCost), (long)0L, (long)Integer.MAX_VALUE);
        if (runningLevelCost <= 0) {
            output = class_1799.field_8037;
        }
        if (!output.method_7960()) {
            repairedDamage = (Integer)output.method_58695(class_9334.field_49639, (Object)0);
            if (repairedDamage < (Integer)input2.method_58695(class_9334.field_49639, (Object)0)) {
                repairedDamage = (Integer)input2.method_58695(class_9334.field_49639, (Object)0);
            }
            repairedDamage = class_1706.method_20398((int)repairedDamage);
            output.method_57379(class_9334.field_49639, (Object)repairedDamage);
            class_1890.method_57530((class_1799)output, (class_9304)builder.method_57549());
        }
        return new AnvilOutputSet(input1, input2, output, levelCost, repairItemUsage);
    }

    @Override
    public boolean isAssembled() {
        return this.assembled;
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.TWILIGHT_ANVIL)).getCheckOffset()), null);
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getOrigin() {
        return this.origin;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.TWILIGHT_ANVIL;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.origin = view.method_71424("synthetic", 0);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71465("synthetic", this.origin);
    }

    public record AnvilOutputSet(class_1799 input1, class_1799 input2, class_1799 output, int levelCost, int itemRepairUsage) {
        public AnvilOutputSet {
            Objects.requireNonNull(input1);
            Objects.requireNonNull(input2);
            Objects.requireNonNull(output);
        }
    }
}

