/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.bosses.dragon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.borisshoes.arcananovum.bosses.dragon.DragonDialog;
import net.borisshoes.arcananovum.utils.SpawnPile;
import net.borisshoes.borislib.utils.MathUtils;
import net.minecraft.class_10707;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5454;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class DragonLairActions {
    private final int terrainDur = 60;
    private final int dimensionDur = 60;
    private final int quakeDur = 200;
    private final int starfallDur = 600;
    private final int lapseDur = 600;
    private int terrainTicks;
    private int dimensionTicks;
    private int quakeTicks;
    private int starfallTicks;
    private DragonLairActionTypes curAct;
    private ArrayList<class_243> stars;
    private HashMap<String, Integer> starHits;
    private boolean chasm;
    private class_2338 chasmStart;
    private class_2338 chasmEnd;
    private HashMap<Integer, ArrayList<class_2338>> chasmBlocks;
    private ArrayList<Spike> spikes;
    private HashMap<Integer, ArrayList<class_2338>> spikeBlocks;
    private final class_1510 dragon;
    private final MinecraftServer server;
    private final class_3218 endWorld;

    public DragonLairActions(MinecraftServer server, class_3218 endWorld, class_1510 dragon) {
        this.server = server;
        this.endWorld = endWorld;
        this.dragon = dragon;
        this.terrainTicks = 0;
        this.dimensionTicks = 0;
        this.quakeTicks = 0;
        this.starfallTicks = 0;
        this.curAct = null;
    }

    public void tick() {
        List nearbyPlayers = this.endWorld.method_18766(p -> p.method_5707(new class_243(0.0, 100.0, 0.0)) <= 90000.0 && !p.method_7325() && !p.method_68878());
        if (this.terrainTicks > 0) {
            if (this.chasm) {
                if (this.terrainTicks % 4 == 0) {
                    int iter;
                    depthMod = 16 - this.terrainTicks / 4;
                    for (class_2338 class_23382 : this.chasmBlocks.get(depthMod)) {
                        this.endWorld.method_8501(class_23382, class_2246.field_10124.method_9564());
                    }
                    if (this.spikeBlocks != null && this.spikeBlocks.get(iter = this.terrainTicks / 4) != null) {
                        for (class_2338 block : this.spikeBlocks.get(iter)) {
                            this.endWorld.method_8501(block, class_2246.field_10124.method_9564());
                        }
                    }
                }
            } else if (this.terrainTicks % 4 == 0) {
                if (this.chasmBlocks != null && this.chasmBlocks.get(depthMod = this.terrainTicks / 4) != null) {
                    for (class_2338 class_23383 : this.chasmBlocks.get(depthMod)) {
                        this.endWorld.method_8501(class_23383, class_2246.field_10471.method_9564());
                    }
                }
                int iter = 16 - this.terrainTicks / 4;
                for (Spike spike : this.spikes) {
                    double sizeMod = spike.radius / 15.0 * (double)iter;
                    ArrayList<class_2338> blocks = spike.generate(this.endWorld, sizeMod);
                    if (this.spikeBlocks.containsKey(iter)) {
                        ArrayList<class_2338> oldBlocks = this.spikeBlocks.get(iter);
                        oldBlocks.addAll(blocks);
                        this.spikeBlocks.put(iter, oldBlocks);
                    } else {
                        this.spikeBlocks.put(iter, blocks);
                    }
                    for (class_2338 block : blocks) {
                        this.endWorld.method_8501(block, class_2246.field_10471.method_9564());
                    }
                }
            }
            --this.terrainTicks;
        }
        if (this.dimensionTicks > 0) {
            if (this.dimensionTicks == 1) {
                ArrayList<class_2338> locations = SpawnPile.makeSpawnLocations(nearbyPlayers.size(), 50, this.endWorld);
                int i = 0;
                for (class_3222 player : nearbyPlayers) {
                    class_2338 pos = (class_2338)locations.get(i);
                    player.method_61275(new class_5454(this.endWorld, pos.method_46558(), player.method_18798(), (float)(Math.random() * 360.0 - 180.0), (float)(Math.random() * 360.0 - 180.0), class_5454.field_52245));
                    this.endWorld.method_65096((class_2394)class_2398.field_23190, (double)pos.method_10263(), (double)pos.method_10264() + 1.5, (double)pos.method_10260(), 300, 0.3, 1.0, 0.3, 3.0);
                    player.method_7353((class_2561)class_2561.method_43470((String)"Ender Energy Surges Through You!").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}), true);
                    ++i;
                }
            } else {
                for (class_3222 player : nearbyPlayers) {
                    this.endWorld.method_65096((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318() - 0.5, player.method_23321(), 1, 0.3, 1.0, 0.3, 0.3);
                }
            }
            --this.dimensionTicks;
        }
        if (this.quakeTicks > 0) {
            for (class_3222 player : nearbyPlayers) {
                this.endWorld.method_65096((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10471.method_9564()), player.method_23317(), player.method_23318() - 0.5, player.method_23321(), 20, 3.0, 1.0, 3.0, 0.5);
                if (this.quakeTicks % 4 != 0) continue;
                player.method_48761(Math.random() * 5.0 - 2.5, Math.random() * 5.0 - 2.5);
            }
            --this.quakeTicks;
        }
        if (this.starfallTicks > 0) {
            int i;
            for (i = 0; i < 40; ++i) {
                this.stars.add(new class_243(Math.random() * 300.0 - 150.0, 160.0, Math.random() * 300.0 - 150.0));
            }
            for (i = 0; i < this.stars.size(); ++i) {
                class_243 star2 = this.stars.get(i);
                star2 = star2.method_1031(0.0, -1.0, 0.0);
                this.stars.set(i, star2);
                this.endWorld.method_65096((class_2394)class_2398.field_11207, star2.method_10216(), star2.method_10214(), star2.method_10215(), 2, 0.1, 0.1, 0.1, 0.0);
                this.endWorld.method_65096((class_2394)class_2398.field_11207, star2.method_10216(), star2.method_10214() - 0.25, star2.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                class_243 class_2432 = star2;
                List hitPlayers = this.endWorld.method_18766(p -> p.method_5707(finalStar) <= 4.0 && !p.method_7325() && !p.method_68878() && !this.starHits.containsKey(p.method_5845()));
                for (class_3222 player : hitPlayers) {
                    if (player.method_6039() && player.method_36455() < -60.0f) {
                        class_10707 blocksAttacksComponent;
                        class_1799 itemStack = player.method_62821();
                        class_10707 class_107072 = blocksAttacksComponent = itemStack != null ? (class_10707)itemStack.method_58694(class_9334.field_56396) : null;
                        if (blocksAttacksComponent != null) {
                            blocksAttacksComponent.method_67200(this.endWorld, (class_1309)player, 10.0f, itemStack);
                        }
                    } else {
                        player.method_64397(this.endWorld, new class_1282(this.endWorld.method_48963().method_48831().method_48793(), (class_1297)this.dragon, (class_1297)this.dragon), 10.0f);
                    }
                    this.starHits.put(player.method_5845(), 10);
                }
            }
            this.stars.removeIf(star -> star.method_10214() < 0.0);
            this.stars.removeIf(star -> this.endWorld.method_8320(class_2338.method_49637((double)((int)(star.method_10216() + 0.5)), (double)((int)star.method_10214()), (double)((int)(star.method_10215() + 0.5)))).method_26225());
            for (Map.Entry<String, Integer> hitPlayer : this.starHits.entrySet()) {
                hitPlayer.setValue(hitPlayer.getValue() - 1);
            }
            this.starHits.entrySet().removeIf(entry -> (Integer)entry.getValue() < 0);
            --this.starfallTicks;
        }
    }

    public boolean startAction(DragonLairActionTypes action) {
        List nearbyPlayers = this.endWorld.method_18766(p -> p.method_5707(new class_243(0.0, 100.0, 0.0)) <= 90000.0 && !p.method_7325() && !p.method_68878());
        switch (action.ordinal()) {
            case 0: {
                boolean bl = this.chasm = !this.chasm;
                if (this.chasm) {
                    double radius = 60.0;
                    double theta = Math.random() * 1.1415926535897931 + 2.0;
                    double offset = Math.random() * 2.0 * Math.PI;
                    int x1 = (int)(radius * Math.cos(offset));
                    int z1 = (int)(radius * Math.sin(offset));
                    int x2 = (int)(radius * Math.cos(theta + offset));
                    int z2 = (int)(radius * Math.sin(theta + offset));
                    this.chasmBlocks = new HashMap();
                    this.chasmStart = new class_2338(x1, 65, z1);
                    this.chasmEnd = new class_2338(x2, 65, z2);
                    this.makeChasm(this.chasmStart, this.chasmEnd);
                } else {
                    int numSpikes = 6;
                    this.spikes = new ArrayList();
                    this.spikeBlocks = new HashMap();
                    for (int i = 0; i < numSpikes; ++i) {
                        int x1 = (int)(Math.random() * 100.0 - 50.0);
                        int y1 = 55;
                        int z1 = (int)(Math.random() * 100.0 - 50.0);
                        class_243 start = new class_243((double)x1 + 0.5, (double)y1 + 0.5, (double)z1 + 0.5);
                        double phi = Math.random() * 2.0 * Math.PI;
                        double theta = Math.random() * 1.0471975511965976;
                        double length = Math.random() * 30.0 + 30.0;
                        double x2 = length * Math.sin(theta) * Math.cos(phi);
                        double z2 = length * Math.sin(theta) * Math.sin(phi);
                        double y2 = length * Math.cos(theta);
                        class_243 end = start.method_1031(x2, y2, z2);
                        double size = Math.random() * 5.0 + 5.0;
                        this.spikes.add(new Spike(start, end, size));
                    }
                }
                DragonDialog.announce(DragonDialog.Announcements.ABILITY_TERRAIN_SHIFT, this.endWorld.method_8503(), null);
                this.terrainTicks = 60;
                break;
            }
            case 1: {
                for (class_3222 player : nearbyPlayers) {
                    if (player.method_68878() || player.method_7325()) continue;
                    class_1293 jump = new class_1293(class_1294.field_5913, 600, 14, false, false, true);
                    class_1293 hover = new class_1293(class_1294.field_5906, 600, 0, false, false, true);
                    player.method_6092(jump);
                    player.method_6092(hover);
                }
                DragonDialog.announce(DragonDialog.Announcements.ABILITY_GRAVITY_LAPSE, this.endWorld.method_8503(), null);
                break;
            }
            case 2: {
                this.dimensionTicks = 60;
                DragonDialog.announce(DragonDialog.Announcements.ABILITY_DIMENSION_SHIFT, this.endWorld.method_8503(), null);
                break;
            }
            case 3: {
                this.quakeTicks = 200;
                for (class_3222 player : nearbyPlayers) {
                    class_1293 slow = new class_1293(class_1294.field_5909, 200, 0, false, false, true);
                    player.method_6092(slow);
                    class_1293 fatigue = new class_1293(class_1294.field_5901, 200, 0, false, false, true);
                    player.method_6092(fatigue);
                }
                DragonDialog.announce(DragonDialog.Announcements.ABILITY_QUAKE, this.endWorld.method_8503(), null);
                break;
            }
            case 4: {
                this.stars = new ArrayList();
                this.starHits = new HashMap();
                this.starfallTicks = 600;
                DragonDialog.announce(DragonDialog.Announcements.ABILITY_STARFALL, this.endWorld.method_8503(), null);
            }
        }
        return true;
    }

    public boolean startAction(int phase) {
        DragonLairActionTypes action = this.rollAction(phase);
        return this.startAction(action);
    }

    public DragonLairActionTypes rollAction(int phase) {
        ArrayList<class_3545> actions = new ArrayList<class_3545>();
        ArrayList<DragonLairActionTypes> weighted = new ArrayList<DragonLairActionTypes>();
        if (phase == 1) {
            actions.add(new class_3545((Object)DragonLairActionTypes.TERRAIN_SHIFT, (Object)8));
            actions.add(new class_3545((Object)DragonLairActionTypes.GRAVITY_LAPSE, (Object)1));
            actions.add(new class_3545((Object)DragonLairActionTypes.DIMENSION_SHIFT, (Object)3));
            actions.add(new class_3545((Object)DragonLairActionTypes.QUAKE, (Object)3));
            actions.add(new class_3545((Object)DragonLairActionTypes.STARFALL, (Object)1));
        } else if (phase == 2) {
            actions.add(new class_3545((Object)DragonLairActionTypes.TERRAIN_SHIFT, (Object)6));
            actions.add(new class_3545((Object)DragonLairActionTypes.GRAVITY_LAPSE, (Object)6));
            actions.add(new class_3545((Object)DragonLairActionTypes.DIMENSION_SHIFT, (Object)2));
            actions.add(new class_3545((Object)DragonLairActionTypes.QUAKE, (Object)2));
            actions.add(new class_3545((Object)DragonLairActionTypes.STARFALL, (Object)3));
        } else if (phase == 3) {
            actions.add(new class_3545((Object)DragonLairActionTypes.TERRAIN_SHIFT, (Object)4));
            actions.add(new class_3545((Object)DragonLairActionTypes.GRAVITY_LAPSE, (Object)2));
            actions.add(new class_3545((Object)DragonLairActionTypes.DIMENSION_SHIFT, (Object)5));
            actions.add(new class_3545((Object)DragonLairActionTypes.QUAKE, (Object)1));
            actions.add(new class_3545((Object)DragonLairActionTypes.STARFALL, (Object)5));
        }
        for (class_3545 action : actions) {
            for (int i = 0; i < (Integer)action.method_15441(); ++i) {
                weighted.add((DragonLairActionTypes)((Object)action.method_15442()));
            }
        }
        return (DragonLairActionTypes)((Object)weighted.get((int)(Math.random() * (double)weighted.size())));
    }

    private HashMap<Integer, ArrayList<class_2338>> makeChasm(class_2338 start, class_2338 end) {
        int minX = Math.min(start.method_10263(), end.method_10263());
        int minZ = Math.min(start.method_10260(), end.method_10260());
        int maxX = Math.max(start.method_10263(), end.method_10263());
        int maxZ = Math.max(start.method_10260(), end.method_10260());
        int midY = (int)(0.5 * (double)(start.method_10264() + end.method_10264()));
        int extra = 10;
        ArrayList tiers = new ArrayList();
        for (int i = 0; i <= 15; ++i) {
            tiers.add(new ArrayList());
        }
        for (class_2338 blockPos : class_2338.method_10094((int)(minX - 10), (int)midY, (int)(minZ - 10), (int)(maxX + 10), (int)midY, (int)(maxZ + 10))) {
            double dist = this.weightDist(new class_243((double)start.method_10263() + 0.5, (double)start.method_10264() + 0.5, (double)start.method_10260() + 0.5), new class_243((double)end.method_10263() + 0.5, (double)end.method_10264() + 0.5, (double)end.method_10260() + 0.5), new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5));
            if (!(dist <= 15.0)) continue;
            double maxDepth = Math.min(16.0, 30.0 / Math.max(0.0, dist - 0.5) + 1.0);
            int depth = (int)(0.3333333333333333 * maxDepth * maxDepth);
            block2: for (int i = -3; i < depth; ++i) {
                for (int dm = 1; dm <= 15; ++dm) {
                    double tierDepthMax = Math.min((double)(dm + 1), (double)(2 * dm) / Math.max(0.0, dist - 0.5) + 1.0);
                    int tierDepth = (int)(0.3333333333333333 * tierDepthMax * tierDepthMax);
                    if (!(dist <= (double)dm) || i >= tierDepth) continue;
                    class_2338 pos = blockPos.method_10069(0, -i, 0);
                    class_2680 state = this.endWorld.method_8320(pos);
                    float hardness = state.method_26214((class_1922)this.endWorld, pos);
                    if (state.method_26204() != class_2246.field_10471 && (!(hardness <= 4.0f) || !(hardness > 0.0f)) || state.method_26215()) continue;
                    ((ArrayList)tiers.get(dm)).add(pos);
                    continue block2;
                }
            }
        }
        for (int i = 1; i <= 15; ++i) {
            this.chasmBlocks.put(i, (ArrayList)tiers.get(i));
        }
        return this.chasmBlocks;
    }

    private double weightDist(class_243 start, class_243 end, class_243 pos) {
        double weight = 0.8;
        double px = end.field_1352 - start.field_1352;
        double pz = end.field_1350 - start.field_1350;
        double temp = px * px + pz * pz;
        double u = ((pos.field_1352 - start.field_1352) * px + (pos.field_1350 - start.field_1350) * pz) / temp;
        u = u > 1.0 ? 1.0 : (u < 0.0 ? 0.0 : u);
        double x = start.field_1352 + u * px;
        double z = start.field_1350 + u * pz;
        double dx = x - pos.field_1352;
        double dz = z - pos.field_1350;
        double lineDist = Math.sqrt(dx * dx + dz * dz);
        double mx = 0.5 * (start.field_1352 + end.field_1352);
        double mz = 0.5 * (start.field_1350 + end.field_1350);
        double midDist = Math.sqrt((pos.field_1352 - mx) * (pos.field_1352 - mx) + (pos.field_1350 - mz) * (pos.field_1350 - mz));
        return 0.8 * lineDist + 0.19999999999999996 * midDist;
    }

    public static enum DragonLairActionTypes {
        TERRAIN_SHIFT,
        GRAVITY_LAPSE,
        DIMENSION_SHIFT,
        QUAKE,
        STARFALL;


        public static DragonLairActionTypes fromLabel(String id) {
            return DragonLairActionTypes.valueOf(id.toUpperCase(Locale.ROOT));
        }
    }

    private static class Spike {
        public class_243 start;
        public class_243 end;
        public double radius;

        private Spike(class_243 s, class_243 e, double r) {
            this.start = s;
            this.end = e;
            this.radius = r;
        }

        public ArrayList<class_2338> generate(class_3218 endWorld, double sizeMod) {
            ArrayList<class_2338> blocks = new ArrayList<class_2338>();
            int intervals = 20;
            class_243 dir = this.end.method_1020(this.start);
            double len = dir.method_1033();
            double fullSegLen = sizeMod * len / this.radius;
            double segLen = fullSegLen / (double)intervals;
            class_243 sizeEnd = dir.method_1021(fullSegLen / len);
            for (int i = 0; i < intervals; ++i) {
                class_243 segDir = dir.method_1021(segLen / len * (double)(i + 1));
                double segR = (double)(intervals - i) * sizeMod / (double)intervals + 1.0;
                class_243 segEnd = this.start.method_1019(segDir);
                double minX = Math.min(this.start.method_10216(), this.end.method_10216());
                double minZ = Math.min(this.start.method_10215(), this.end.method_10215());
                double maxY = Math.max(this.start.method_10214(), this.end.method_10214());
                double minY = Math.min(this.start.method_10214(), this.end.method_10214());
                double maxX = Math.max(this.start.method_10216(), this.end.method_10216());
                double maxZ = Math.max(this.start.method_10215(), this.end.method_10215());
                double extra = segR + 3.0;
                class_2338 corner1 = new class_2338((int)(minX - extra), (int)(minY - extra), (int)(minZ - extra));
                class_2338 corner2 = new class_2338((int)(maxX + extra), (int)(maxY + extra), (int)(maxZ + extra));
                for (class_2338 blockPos : class_2338.method_10097((class_2338)corner1, (class_2338)corner2)) {
                    double dist;
                    class_2680 state = endWorld.method_8320(blockPos);
                    if (!state.method_26215() || !((dist = MathUtils.distToLine((class_243)new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), (class_243)this.start, (class_243)segEnd)) <= segR)) continue;
                    class_2338 copy = new class_2338(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                    blocks.add(copy);
                }
            }
            return blocks;
        }
    }
}

