/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.bosses.dragon.guis;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Collections;
import net.borisshoes.arcananovum.bosses.dragon.DragonBossFight;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class PuzzleGui
extends SimpleGui {
    private Puzzle curPuzzle;
    private int level = 1;
    private boolean complete = false;
    private final DragonBossFight.ReclaimState reclaimState;

    public PuzzleGui(class_3917<?> type, class_3222 player, DragonBossFight.ReclaimState reclaimState) {
        super(type, player, false);
        this.reclaimState = reclaimState;
        this.setTitle((class_2561)class_2561.method_43470((String)"Tower Reclamation"));
    }

    public void buildPuzzle() {
        this.curPuzzle = Puzzle.generatePuzzle(this.level);
        ArrayList<class_1792> puzzleItems = this.curPuzzle.getPuzzleItems();
        class_1792 targetItem = this.curPuzzle.getTargetItem();
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43470((String)"Tower Reclamation").method_27692(class_124.field_1076));
        GuiElementBuilder targetGuiItem = new GuiElementBuilder(targetItem).hideDefaultTooltip();
        targetGuiItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)targetItem.method_7876()).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})));
        targetGuiItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click this item!").method_27692(class_124.field_1064))));
        this.setSlot(4, (GuiElementBuilderInterface)targetGuiItem);
        for (int i = 46; i < 53; ++i) {
            int lvl = i - 45;
            GuiElementBuilder progressGuiItem = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)(lvl <= this.level ? 51450 : 2756918))).hideDefaultTooltip();
            progressGuiItem.setName((class_2561)class_2561.method_43470((String)("(" + this.level + "/7)")).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
            this.setSlot(i, (GuiElementBuilderInterface)progressGuiItem);
        }
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < puzzleItems.size()) {
                    GuiElementBuilder puzzleItem = new GuiElementBuilder(puzzleItems.get(k)).hideDefaultTooltip();
                    puzzleItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)puzzleItems.get(k).method_7876()).method_27692(class_124.field_1054)));
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)puzzleItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean indexInCenter = index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8;
        int ind = 7 * (index / 9 - 1) + (index % 9 - 1);
        if (indexInCenter) {
            class_1792 selected = this.curPuzzle.getPuzzleItems().get(ind);
            if (selected == class_1802.field_8162) {
                return true;
            }
            if (selected == this.curPuzzle.getTargetItem()) {
                if (this.level == 7) {
                    this.complete = true;
                    this.close();
                } else {
                    ++this.level;
                    this.buildPuzzle();
                }
            } else {
                this.complete = false;
                this.close();
            }
        }
        return true;
    }

    public void onClose() {
        if (this.reclaimState != null) {
            if (this.complete) {
                this.reclaimState.playerSolved();
                this.player.method_7353((class_2561)class_2561.method_43470((String)"The Tower's Arcana Surges Through You!").method_27695(new class_124[]{class_124.field_1067, class_124.field_1062}), true);
            } else {
                this.reclaimState.setPlayer(null);
                this.player.method_7353((class_2561)class_2561.method_43470((String)"You Fail To Channel The Tower's Magic").method_27695(new class_124[]{class_124.field_1056, class_124.field_1061}), true);
            }
        } else if (this.complete) {
            this.player.method_64398((class_2561)class_2561.method_43470((String)"Success!").method_27695(new class_124[]{class_124.field_1067, class_124.field_1062}));
        } else {
            this.player.method_64398((class_2561)class_2561.method_43470((String)"Fail!").method_27695(new class_124[]{class_124.field_1056, class_124.field_1061}));
        }
    }

    private static class Puzzle {
        private ArrayList<class_1792> puzzleItems;
        private class_1792 targetItem;
        private static final int[] itemsPerLevel = new int[]{28, 28, 28, 28, 28, 28, 28};
        private static final class_1792[] targetItems = new class_1792[]{class_1802.field_8301, class_1802.field_8281, class_1802.field_8449, class_1802.field_27063, class_1802.field_22421, class_1802.field_8137, class_1802.field_8301};

        private Puzzle() {
        }

        public static Puzzle generatePuzzle(int level) {
            Puzzle puzzle = new Puzzle();
            class_1792 targetItem = targetItems[class_3532.method_15340((int)(level - 1), (int)0, (int)6)];
            int numItems = itemsPerLevel[class_3532.method_15340((int)(level - 1), (int)0, (int)6)];
            ArrayList<class_1792> puzzleItems = new ArrayList<class_1792>();
            for (int i = 0; i < 28; ++i) {
                class_1792 item = class_1802.field_8162;
                if (i == 0) {
                    item = targetItem;
                } else if (i < numItems) {
                    while ((item = (class_1792)class_7923.field_41178.method_10200((int)(Math.random() * (double)class_7923.field_41178.method_10204()))) == targetItem || !class_7923.field_41178.method_10221((Object)item).method_12836().equals("minecraft")) {
                    }
                }
                puzzleItems.add(item);
            }
            Collections.shuffle(puzzleItems);
            puzzle.puzzleItems = puzzleItems;
            puzzle.targetItem = targetItem;
            return puzzle;
        }

        public ArrayList<class_1792> getPuzzleItems() {
            return this.puzzleItems;
        }

        public class_1792 getTargetItem() {
            return this.targetItem;
        }
    }
}

