/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.entities;

import com.google.common.collect.ImmutableList;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.entities.NulGuardianEntity;
import net.borisshoes.arcananovum.mixins.LivingEntityAccessor;
import net.borisshoes.arcananovum.mixins.WitherEntityAccessor;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.arcananovum.utils.Dialog;
import net.borisshoes.arcananovum.utils.DialogHelper;
import net.borisshoes.arcananovum.utils.SpawnPile;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.CodecUtils;
import net.borisshoes.borislib.utils.MathUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1687;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_2715;
import net.minecraft.class_2743;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_5702;
import net.minecraft.class_5819;
import net.minecraft.class_8042;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_8956;
import net.minecraft.class_9381;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class NulConstructEntity
extends class_1588
implements PolymerEntity,
class_1603 {
    private static final class_2940<Integer> TRACKED_ENTITY_ID_1 = class_2945.method_12791(NulConstructEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TRACKED_ENTITY_ID_2 = class_2945.method_12791(NulConstructEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TRACKED_ENTITY_ID_3 = class_2945.method_12791(NulConstructEntity.class, (class_2941)class_2943.field_13327);
    private static final List<class_2940<Integer>> TRACKED_ENTITY_IDS = ImmutableList.of(TRACKED_ENTITY_ID_1, TRACKED_ENTITY_ID_2, TRACKED_ENTITY_ID_3);
    private static final class_2940<Integer> INVUL_TIMER = class_2945.method_12791(NulConstructEntity.class, (class_2941)class_2943.field_13327);
    private final int[] skullCooldowns = new int[2];
    private final int[] chargedSkullCooldowns = new int[2];
    private final class_3213 bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795).method_5406(true);
    public static final double FIGHT_RANGE = 64.0;
    private static final double DECAY_RANGE = 32.0;
    private static final double BLAST_RANGE = 24.0;
    private static final double TELEPORT_RANGE = 16.0;
    private static final double RAY_RANGE = 32.0;
    private static final class_4051.class_10254 CAN_ATTACK_PREDICATE = (entity, world) -> !entity.method_5864().method_20210(ArcanaRegistry.NUL_CONSTRUCT_FRIENDS) && entity.method_6102() && !entity.method_56992() && !entity.method_7325();
    private static final class_4051 HEAD_TARGET_PREDICATE = class_4051.method_36625().method_18418(32.0).method_18420(CAN_ATTACK_PREDICATE);
    private class_1657 summoner;
    private boolean shouldHaveSummoner;
    private boolean summonerHasWings;
    private boolean summonerHasDivine;
    private boolean isExalted;
    private boolean initializedAttributes = false;
    private float prevHP;
    private int numPlayers;
    private int spellCooldown;
    private float adaptiveResistance;
    private HashMap<ConstructSpellType, ConstructSpell> spells;
    private HashMap<ConstructAdaptations, Boolean> adaptations;
    private HashMap<class_2338, Integer> blockDamage;
    private List<class_3222> players;
    private List<class_3545<class_2338, Integer>> blockPacketQueue;
    private ConstructMovementType movementType = ConstructMovementType.WAIT;
    public class_243 targetPosition;
    public class_2338 circlingCenter;
    private int movementChangeTime;
    private int acquireTargetCooldown = 0;
    private float strafeYaw = 0.0f;
    private float strafeRadius = 5.0f;
    private float strafeHeight = 5.0f;
    private float strafeRate = 2.0f;
    private int attackCooldown = 0;

    public NulConstructEntity(class_1299<? extends NulConstructEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_6033(this.method_6063());
        this.field_6194 = 1000;
        this.blockDamage = new HashMap();
        this.movementChangeTime = this.field_6012 + this.field_5974.method_39332(200, 500);
        this.targetPosition = this.method_19538();
        this.circlingCenter = this.method_24515();
        this.adaptiveResistance = 0.0f;
        this.adaptations = new HashMap();
        this.players = new ArrayList<class_3222>();
        this.blockPacketQueue = new ArrayList<class_3545<class_2338, Integer>>();
        for (ConstructAdaptations value : ConstructAdaptations.values()) {
            this.adaptations.put(value, false);
        }
        this.createSpells();
    }

    private void createSpells() {
        this.spellCooldown = 220;
        this.spells = new HashMap();
        for (ConstructSpellType value : ConstructSpellType.values()) {
            this.spells.put(value, new ConstructSpell(value));
        }
    }

    private void initializeAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(1024.0);
        this.method_5996(class_5134.field_23719).method_6192((double)0.85f);
        this.method_5996(class_5134.field_23720).method_6192((double)0.85f);
        this.method_5996(class_5134.field_23724).method_6192(10.0);
        this.method_5996(class_5134.field_23725).method_6192(10.0);
        this.method_5996(class_5134.field_23717).method_6192(128.0);
        this.method_5996(class_5134.field_23721).method_6192(10.0);
        this.initializedAttributes = true;
    }

    public static class_5132.class_5133 createConstructAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 1024.0).method_26868(class_5134.field_23719, (double)0.85f).method_26868(class_5134.field_23720, (double)0.85f).method_26868(class_5134.field_23717, 128.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23725, 10.0).method_26868(class_5134.field_23721, 10.0);
    }

    public class_1299<?> getPolymerEntityType(PacketContext context) {
        return class_1299.field_6119;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TRACKED_ENTITY_ID_1, (Object)0);
        builder.method_56912(TRACKED_ENTITY_ID_2, (Object)0);
        builder.method_56912(TRACKED_ENTITY_ID_3, (Object)0);
        builder.method_56912(INVUL_TIMER, (Object)0);
    }

    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        data.add(new class_2945.class_7834(WitherEntityAccessor.getTRACKED_ENTITY_ID_1().comp_2327(), WitherEntityAccessor.getTRACKED_ENTITY_ID_1().comp_2328(), (Object)this.getTrackedEntityId(0)));
        data.add(new class_2945.class_7834(WitherEntityAccessor.getTRACKED_ENTITY_ID_2().comp_2327(), WitherEntityAccessor.getTRACKED_ENTITY_ID_2().comp_2328(), (Object)this.getTrackedEntityId(1)));
        data.add(new class_2945.class_7834(WitherEntityAccessor.getTRACKED_ENTITY_ID_3().comp_2327(), WitherEntityAccessor.getTRACKED_ENTITY_ID_3().comp_2328(), (Object)this.getTrackedEntityId(2)));
        data.add(new class_2945.class_7834(WitherEntityAccessor.getINVUL_TIMER().comp_2327(), WitherEntityAccessor.getINVUL_TIMER().comp_2328(), (Object)this.getInvulnerableTimer()));
        data.add(new class_2945.class_7834(LivingEntityAccessor.getHEALTH().comp_2327(), LivingEntityAccessor.getHEALTH().comp_2328(), (Object)Float.valueOf(this.getTrackedHealth())));
    }

    private float getTrackedHealth() {
        if (this.isShieldActive()) {
            return Math.min(this.method_6032(), this.method_6063() / 2.0f - 1.0f);
        }
        return Math.max(this.method_6032(), this.method_6063() / 2.0f + 1.0f);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public int getInvulnerableTimer() {
        return (Integer)this.field_6011.method_12789(INVUL_TIMER);
    }

    public void setInvulTimer(int ticks) {
        this.field_6011.method_12778(INVUL_TIMER, (Object)ticks);
    }

    public int getTrackedEntityId(int headIndex) {
        return (Integer)this.field_6011.method_12789(TRACKED_ENTITY_IDS.get(headIndex));
    }

    public void setTrackedEntityId(int headIndex, int id) {
        this.field_6011.method_12778(TRACKED_ENTITY_IDS.get(headIndex), (Object)id);
    }

    private double getHeadX(int headIndex) {
        if (headIndex <= 0) {
            return this.method_23317();
        }
        float f = (this.field_6283 + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float g = class_3532.method_15362((float)f);
        return this.method_23317() + (double)g * 1.3 * (double)this.method_55693();
    }

    private double getHeadY(int headIndex) {
        float f = headIndex <= 0 ? 3.0f : 2.2f;
        return this.method_23318() + (double)(f * this.method_55693());
    }

    private double getHeadZ(int headIndex) {
        if (headIndex <= 0) {
            return this.method_23321();
        }
        float f = (this.field_6283 + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float g = class_3532.method_15374((float)f);
        return this.method_23321() + (double)g * 1.3 * (double)this.method_55693();
    }

    public class_1657 getSummoner() {
        return this.summoner;
    }

    public boolean isExalted() {
        return this.isExalted;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    protected class_3414 method_5994() {
        return class_3417.field_15163;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14688;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15136;
    }

    public void method_5844(class_2680 state, class_243 multiplier) {
    }

    public boolean method_6049(class_1293 effect) {
        return effect.method_55654(ArcanaRegistry.DAMAGE_AMP_EFFECT);
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71465("numPlayers", this.numPlayers);
        view.method_71465("spellCooldown", this.spellCooldown);
        view.method_71472("shouldHaveSummoner", this.shouldHaveSummoner);
        view.method_71472("summonerHasDivine", this.summonerHasDivine);
        view.method_71472("summonerHasWings", this.summonerHasWings);
        view.method_71472("isExalted", this.isExalted);
        view.method_71464("prevHP", this.prevHP);
        view.method_71464("adaptiveResistance", this.adaptiveResistance);
        view.method_71465("invulnerableTimer", this.getInvulnerableTimer());
        if (this.summoner != null) {
            view.method_71469("summoner", this.summoner.method_5845());
        }
        class_2487 spellsTag = new class_2487();
        for (Map.Entry<ConstructSpellType, ConstructSpell> entry : this.spells.entrySet()) {
            spellsTag.method_10566(entry.getKey().id, (class_2520)entry.getValue().toNbt());
        }
        view.method_71468("spells", class_2487.field_25128, (Object)spellsTag);
        class_2487 adaptationsTag = new class_2487();
        this.adaptations.forEach((adaptation, bool) -> adaptationsTag.method_10556(adaptation.id, bool.booleanValue()));
        view.method_71468("adaptations", class_2487.field_25128, (Object)adaptationsTag);
        class_2487 blockDamageTag = new class_2487();
        this.blockDamage.forEach((block, damage) -> {
            class_2487 blockTag = new class_2487();
            blockTag.method_10569("x", block.method_10263());
            blockTag.method_10569("y", block.method_10264());
            blockTag.method_10569("z", block.method_10260());
            blockTag.method_10569("damage", damage.intValue());
        });
        view.method_71468("blockDamage", class_2487.field_25128, (Object)blockDamageTag);
        view.method_71468("players", CodecUtils.STRING_LIST, this.players.stream().map(class_1297::method_5845).toList());
    }

    protected void method_5749(class_11368 view) {
        class_3218 serverWorld;
        class_1937 class_19372;
        super.method_5749(view);
        this.numPlayers = view.method_71424("numPlayers", 0);
        this.spellCooldown = view.method_71424("spellCooldown", 0);
        this.shouldHaveSummoner = view.method_71433("shouldHaveSummoner", false);
        this.summonerHasDivine = view.method_71433("summonerHasDivine", false);
        this.summonerHasWings = view.method_71433("summonerHasWings", false);
        this.isExalted = view.method_71433("isExalted", false);
        this.prevHP = view.method_71423("prevHP", 0.0f);
        this.adaptiveResistance = view.method_71423("adaptiveResistance", 0.0f);
        this.setInvulTimer(view.method_71424("invulnerableTimer", 0));
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218 && (class_19372 = (serverWorld = (class_3218)class_19372).method_66347(AlgoUtils.getUUID((String)view.method_71428("summoner", "")))) instanceof class_1657) {
            class_1657 player = (class_1657)class_19372;
            this.summoner = player;
        }
        this.spells = new HashMap();
        class_2487 spellsTag = view.method_71426("spells", class_2487.field_25128).orElse(new class_2487());
        for (Object key : spellsTag.method_10541()) {
            this.spells.put(ConstructSpellType.fromString((String)key), ConstructSpell.fromNbt(spellsTag.method_68568((String)key)));
        }
        this.adaptations = new HashMap();
        class_2487 adaptationsTag = view.method_71426("adaptations", class_2487.field_25128).orElse(new class_2487());
        for (String key : adaptationsTag.method_10541()) {
            this.adaptations.put(ConstructAdaptations.fromString(key), adaptationsTag.method_68566(key, false));
        }
        this.blockDamage = new HashMap();
        class_2487 blockDamageTag = view.method_71426("blockDamage", class_2487.field_25128).orElse(new class_2487());
        for (String key : blockDamageTag.method_10541()) {
            class_2487 compound = blockDamageTag.method_68568(key);
            this.blockDamage.put(new class_2338(compound.method_68083("x", 0), compound.method_68083("y", 0), compound.method_68083("z", 0)), compound.method_68083("damage", 0));
        }
        this.players = new ArrayList<class_3222>();
        for (String id : (List)view.method_71426("players", CodecUtils.STRING_LIST).orElse(new ArrayList())) {
            class_3218 serverWorld2;
            class_1937 class_19373 = this.method_37908();
            if (!(class_19373 instanceof class_3218) || !((class_19373 = (serverWorld2 = (class_3218)class_19373).method_66347(AlgoUtils.getUUID((String)id))) instanceof class_3222)) continue;
            class_3222 player = (class_3222)class_19373;
            this.players.add(player);
        }
    }

    protected void method_30076() {
        this.blockDamage.clear();
        super.method_30076();
    }

    public void onSummoned(class_1657 summoner) {
        this.onSummoned(summoner, false);
    }

    public void onSummoned(class_1657 summoner, boolean mythic) {
        class_5250 witherName;
        this.setInvulTimer(220);
        this.bossBar.method_5408(0.0f);
        this.method_6033(this.method_6063() / 3.0f);
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        this.summoner = summoner;
        this.shouldHaveSummoner = true;
        this.isExalted = mythic;
        if (summoner instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)summoner;
            this.players.add(serverPlayer);
        }
        this.numPlayers = 1;
        if (this.isExalted) {
            witherName = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\u2756").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\u2593").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)"\u2756").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"Exalted Nul Construct").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"\u2756").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\u2593").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)"\u2756").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067}));
            ArcanaEffectUtils.exaltedConstructSummon(serverWorld, this.method_19538().method_1031(0.0, 0.0, 0.0), 0);
            class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23721);
            class_1322 entityAttributeModifier = new class_1322(class_2960.method_60655((String)"arcananovum", (String)"exalted"), 15.0, class_1322.class_1323.field_6328);
            if (entityAttributeInstance != null && !entityAttributeInstance.method_6196(class_2960.method_60655((String)"arcananovum", (String)"exalted"))) {
                entityAttributeInstance.method_26837(entityAttributeModifier);
            }
        } else {
            witherName = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"=").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"Nul Construct").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"=").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1063));
            ArcanaEffectUtils.nulConstructSummon(serverWorld, this.method_19538().method_1031(0.0, 0.0, 0.0), 0);
        }
        this.method_5665((class_2561)witherName);
        this.method_5880(true);
        this.method_5971();
        this.summonerHasWings = ArcanaNovum.data(summoner).hasCrafted(ArcanaRegistry.WINGS_OF_ENDERIA);
        this.summonerHasDivine = this.summonerHasWings || ArcanaNovum.data(summoner).hasCrafted(ArcanaRegistry.DIVINE_CATALYST);
        class_1661 inv = summoner.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
            if (arcanaItem == null || arcanaItem.getRarity() != ArcanaRarity.DIVINE) continue;
            this.summonerHasDivine = true;
        }
        this.prevHP = this.method_6032();
        NulConstructDialog.announce(summoner.method_5682(), summoner, this, Announcements.SUMMON_TEXT);
        NulConstructEntity construct = this;
        BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(this.getInvulnerableTimer(), () -> {
            NulConstructDialog.announce(summoner.method_5682(), summoner, construct, Announcements.SUMMON_DIALOG, new boolean[]{this.summonerHasDivine, this.summonerHasWings, !this.summonerHasWings, false, true, this.isExalted, !this.isExalted});
            this.method_6033(this.method_6063());
        }));
    }

    public void method_6078(class_1282 damageSource) {
        boolean dropped;
        class_1799 stack;
        super.method_6078(damageSource);
        MinecraftServer server = this.method_5682();
        if (server == null) {
            return;
        }
        if (this.isExalted) {
            this.dropItem(this.method_37908(), class_1802.field_8137.method_7854().method_46651(24), this.method_19538());
            this.dropItem(this.method_37908(), new class_1799((class_1935)ArcanaRegistry.DIVINE_ARCANE_PAPER, this.field_5974.method_39332(8, 16)), this.method_19538());
        } else {
            for (int i = 0; i < this.field_5974.method_39332(4, 16); ++i) {
                stack = class_1802.field_8137.method_7854().method_7972();
                this.dropItem(this.method_37908(), stack, this.method_19538());
                this.dropItem(this.method_37908(), stack.method_46651(1), this.method_19538());
            }
            this.dropItem(this.method_37908(), new class_1799((class_1935)ArcanaRegistry.DIVINE_ARCANE_PAPER, this.field_5974.method_39332(4, 12)), this.method_19538());
        }
        if (this.summoner == null) {
            return;
        }
        boolean bl = dropped = this.isExalted || (double)this.field_5974.method_43057() < 0.01;
        if (dropped) {
            stack = ArcanaRegistry.NUL_MEMENTO.addCrafter(ArcanaRegistry.NUL_MEMENTO.getNewItem(), this.summoner.method_5845(), 0, server);
            ArcanaNovum.data(this.summoner).addCraftedSilent(stack);
            this.dropItem(this.method_37908(), stack.method_46651(1), this.method_19538());
        }
        if (!this.isExalted) {
            stack = ArcanaRegistry.DIVINE_CATALYST.addCrafter(ArcanaRegistry.DIVINE_CATALYST.getNewItem(), this.summoner.method_5845(), 0, server);
            ArcanaNovum.data(this.summoner).addCraftedSilent(stack);
            this.dropItem(this.method_37908(), stack.method_46651(1), this.method_19538());
        }
        NulConstructDialog.announce(server, this.summoner, this, Announcements.SUCCESS, new boolean[]{this.summonerHasDivine, this.summonerHasWings, !this.summonerHasWings, dropped, !dropped, this.isExalted, !this.isExalted});
        class_1657 class_16572 = this.summoner;
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            ArcanaAchievements.grant(player, ArcanaAchievements.CONSTRUCT_DECONSTRUCTED.id);
            if (dropped) {
                ArcanaAchievements.grant(player, ArcanaAchievements.DIVINE_FAVOR.id);
            }
        }
    }

    public void deconstruct() {
        if (this.summoner != null) {
            NulConstructDialog.announce(this.method_5682(), this.summoner, this, Announcements.FAILURE, new boolean[]{this.summonerHasDivine, this.summonerHasWings, !this.summonerHasWings, false, true, this.isExalted, !this.isExalted});
        }
        this.dropItem(this.method_37908(), new class_1799((class_1935)class_1802.field_22018).method_46651(1), this.method_19538());
        this.method_31472();
    }

    private void dropItem(class_1937 world, class_1799 stack, class_243 pos) {
        class_1542 itemEntity = new class_1542(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), stack);
        itemEntity.method_6982(40);
        itemEntity.method_6976();
        float f = world.field_9229.method_43057() * 0.1f;
        float g = world.field_9229.method_43057() * ((float)Math.PI * 2);
        itemEntity.method_18800((double)(-class_3532.method_15374((float)g) * f), (double)0.2f, (double)(class_3532.method_15362((float)g) * f));
        world.method_8649((class_1297)itemEntity);
    }

    public static class_2700 getConstructPattern() {
        return class_2697.method_11701().method_11702(new String[]{"^^^", "#@#", "~#~"}).method_11700('#', pos -> pos.method_11681().method_26164(class_3481.field_22274)).method_11700('^', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10177).or((Predicate)class_2715.method_11758((class_2248)class_2246.field_10101)))).method_11700('~', class_2694.method_11678(class_4970.class_4971::method_26215)).method_11700('@', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_22108))).method_11704();
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        class_3222 player;
        class_1297 entity;
        if (this.method_5679(world, source)) {
            return false;
        }
        if (source.method_48789(ArcanaRegistry.NUL_CONSTRUCT_IMMUNE_TO) || source.method_5529() instanceof NulConstructEntity) {
            return false;
        }
        if (this.getInvulnerableTimer() > 0 && !source.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (this.isShieldActive() && ((entity = source.method_5526()) instanceof class_1665 || entity instanceof class_8956)) {
            return false;
        }
        entity = source.method_5529();
        if (entity != null && entity.method_5864().method_20210(ArcanaRegistry.NUL_CONSTRUCT_FRIENDS)) {
            return false;
        }
        if (entity instanceof class_3222 && !this.players.contains(player = (class_3222)entity)) {
            this.triggerAdaptation(ConstructAdaptations.ADDITIONAL_PLAYERS);
            this.players.add(player);
            this.numPlayers = this.players.size();
            this.adaptiveResistance += 0.05f;
        }
        for (int i = 0; i < this.chargedSkullCooldowns.length; ++i) {
            this.chargedSkullCooldowns[i] = this.chargedSkullCooldowns[i] + 3;
        }
        return super.method_64397(world, source, amount);
    }

    protected float method_6036(class_1282 source, float amount) {
        class_1297 attacker;
        float modified = super.method_6036(source, amount);
        if (source.method_5530() || source.method_48789(class_8103.field_42242)) {
            return modified;
        }
        double healthPercent = this.method_6032() / this.method_6063();
        modified *= this.isExalted ? 0.6f : 0.75f;
        if ((modified *= 1.0f - Math.min(0.5f, this.adaptiveResistance)) > 100.0f) {
            modified = 100.0f;
            this.triggerAdaptation(ConstructAdaptations.MASSIVE_BLOW);
            this.adaptiveResistance += 0.05f;
        }
        if (source.method_48789(ArcanaRegistry.NUL_CONSTRUCT_VULNERABLE_TO)) {
            modified *= this.isExalted ? 1.25f : 1.5f;
        }
        if (source.method_48789(ArcanaRegistry.NUL_CONSTRUCT_RESISTANT_TO)) {
            modified *= this.isExalted ? 0.35f : 0.5f;
        }
        if (healthPercent > 0.5 && source.method_49708(class_8111.field_42320)) {
            modified *= this.isExalted ? 1.25f : 1.5f;
        }
        if (healthPercent < 0.5 && source.method_5526() instanceof class_1665) {
            modified *= this.isExalted ? 0.35f : 0.5f;
        }
        if (source.method_60948() != null && (source.method_60948().method_31574(class_1802.field_49814) || source.method_60948().method_31574(ArcanaRegistry.GRAVITON_MAUL.getItem()))) {
            this.triggerAdaptation(ConstructAdaptations.DAMAGED_BY_MACE);
        }
        if (this.isReflectionActive() && (attacker = source.method_5529()) instanceof class_1309) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                attacker.method_64397(serverWorld, this.method_48923().method_48818((class_1297)this), amount * 0.5f);
            }
            this.conversionHeal(amount * 0.25f);
        }
        return modified;
    }

    public void triggerAdaptation(ConstructAdaptations adaptation) {
        if (!this.hasActivatedAdaptation(adaptation) || adaptation.repeatable) {
            NulConstructDialog.abilityText(this.summoner, this, adaptation.abilityTexts[(int)(Math.random() * (double)adaptation.abilityTexts.length)]);
        }
        this.adaptations.put(adaptation, true);
    }

    public boolean hasActivatedAdaptation(ConstructAdaptations adaptation) {
        return this.adaptations.getOrDefault((Object)adaptation, false);
    }

    private boolean shouldChangeMovementType() {
        if (this.movementType == ConstructMovementType.WAIT && this.method_5968() != null) {
            return true;
        }
        if (this.movementType == ConstructMovementType.SPAWNING && this.getInvulnerableTimer() <= 0) {
            return true;
        }
        if (this.movementType == ConstructMovementType.LASER && !this.spells.get((Object)ConstructSpellType.WITHERING_RAY).isActive()) {
            return true;
        }
        if (this.movementType == ConstructMovementType.CHARGE && !this.spells.get((Object)ConstructSpellType.RELENTLESS_ONSLAUGHT).isActive()) {
            return true;
        }
        return this.field_6012 > this.movementChangeTime;
    }

    protected void method_5958(class_3218 world) {
        try {
            class_1309 blindness2;
            if (this.spells == null || this.spells.isEmpty()) {
                this.createSpells();
            }
            if (!this.initializedAttributes) {
                this.initializeAttributes();
            }
            if (this.getInvulnerableTimer() > 0) {
                int i = this.getInvulnerableTimer() - 1;
                this.bossBar.method_5408(1.0f - (float)i / 220.0f);
                if (i <= 0) {
                    world.method_8537((class_1297)this, this.method_23317(), this.method_23320(), this.method_23321(), 7.0f, false, class_1937.class_7867.field_40890);
                    if (!this.method_5701()) {
                        world.method_8474(1023, this.method_24515(), 0);
                    }
                }
                this.setInvulTimer(i);
                if (this.field_6012 % 10 == 0) {
                    this.method_6025(35.0f);
                }
            } else {
                super.method_5958(world);
                for (int ix = 1; ix < 3; ++ix) {
                    int j;
                    if (this.field_6012 < this.skullCooldowns[ix - 1]) continue;
                    this.skullCooldowns[ix - 1] = this.field_6012 + 10 + this.field_5974.method_43048(10);
                    if (world.method_8407() == class_1267.field_5802 || world.method_8407() == class_1267.field_5807) {
                        int n = ix - 1;
                        int n2 = this.chargedSkullCooldowns[n];
                        this.chargedSkullCooldowns[n] = n2 + 1;
                        if (n2 > 15) {
                            float f = 10.0f;
                            float g = 5.0f;
                            double d = class_3532.method_15366((class_5819)this.field_5974, (double)(this.method_23317() - (double)f), (double)(this.method_23317() + (double)f));
                            double e2 = class_3532.method_15366((class_5819)this.field_5974, (double)(this.method_23318() - (double)g), (double)(this.method_23318() + (double)g));
                            double h = class_3532.method_15366((class_5819)this.field_5974, (double)(this.method_23321() - (double)f), (double)(this.method_23321() + (double)f));
                            this.shootSkullAt(ix + 1, d, e2, h, true);
                            this.chargedSkullCooldowns[ix - 1] = 0;
                        }
                    }
                    if ((j = this.getTrackedEntityId(ix)) > 0) {
                        class_1309 livingEntity = (class_1309)this.method_37908().method_8469(j);
                        if (livingEntity != null && this.method_18395(livingEntity) && !(this.method_5858((class_1297)livingEntity) > 900.0) && this.method_6057((class_1297)livingEntity)) {
                            this.shootSkullAt(ix + 1, livingEntity);
                            this.skullCooldowns[ix - 1] = this.field_6012 + 40 + this.field_5974.method_43048(20);
                            this.chargedSkullCooldowns[ix - 1] = 0;
                            continue;
                        }
                        this.setTrackedEntityId(ix, 0);
                        continue;
                    }
                    List list = world.method_64392(class_1309.class, HEAD_TARGET_PREDICATE, (class_1309)this, this.method_5829().method_1009(20.0, 8.0, 20.0));
                    if (list.isEmpty()) continue;
                    class_1309 livingEntity2 = (class_1309)list.get(this.field_5974.method_43048(list.size()));
                    this.setTrackedEntityId(ix, livingEntity2.method_5628());
                }
                if (this.method_5968() != null) {
                    this.setTrackedEntityId(0, this.method_5968().method_5628());
                } else {
                    this.setTrackedEntityId(0, 0);
                }
                if (this.field_6012 % 20 == 0) {
                    if (this.isConversionActive()) {
                        this.method_6025(this.isExalted ? 10.0f : 5.0f);
                    } else {
                        this.method_6025(this.isExalted ? 2.5f : 1.0f);
                    }
                }
                this.bossBar.method_5408(this.method_6032() / this.method_6063());
            }
            if (this.shouldHaveSummoner) {
                if (this.summoner == null || this.summoner.method_29504() || !this.summoner.method_37908().method_27983().equals(this.method_37908().method_27983())) {
                    this.deconstruct();
                }
                if ((double)this.method_5739((class_1297)this.summoner) >= 64.0) {
                    this.spells.get((Object)ConstructSpellType.SHADOW_SHROUD).setCooldown(0);
                    this.castSpell(this.spells.get((Object)ConstructSpellType.SHADOW_SHROUD));
                }
                if (this.summoner.method_6059(ArcanaRegistry.GREATER_INVISIBILITY_EFFECT)) {
                    this.triggerAdaptation(ConstructAdaptations.TRUE_INVISIBILITY);
                    class_1293 blindness2 = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, 110, 3, false, false, false);
                    this.summoner.method_6092(blindness2);
                    this.summoner.method_6016(ArcanaRegistry.GREATER_INVISIBILITY_EFFECT);
                }
            } else if (this.method_5968() != null && (blindness2 = this.method_5968()) instanceof class_3222) {
                class_3222 player = (class_3222)blindness2;
                this.summoner = player;
                this.shouldHaveSummoner = true;
                this.triggerAdaptation(ConstructAdaptations.SPAWNED_CONSTRUCT_FINDS_PLAYER);
            }
            if (this.hasActivatedAdaptation(ConstructAdaptations.DAMAGED_BY_MACE)) {
                for (class_3222 player : this.players) {
                    class_1799 weapon;
                    if (!player.method_51469().method_27983().equals(this.method_37908().method_27983()) || !(player.method_23318() > this.method_23318() + 10.0) || !(weapon = player.method_59958()).method_31574(class_1802.field_49814) && !weapon.method_31574(ArcanaRegistry.GRAVITON_MAUL.getItem())) continue;
                    this.castSpell(this.spells.get((Object)ConstructSpellType.SHADOW_SHROUD));
                    this.spells.get((Object)ConstructSpellType.SHADOW_SHROUD).setCooldown(80);
                    break;
                }
            }
            if (this.field_6012 % 20 == 0) {
                if (world.method_64395().method_8355(class_1928.field_19388)) {
                    this.destructiveAura();
                }
                if (this.isExalted) {
                    List players = this.method_37908().method_18023((class_5575)class_1299.field_6097, this.method_5829().method_1014(64.0), e -> true);
                    for (class_1657 player : players) {
                        class_1293 amp = new class_1293(ArcanaRegistry.DAMAGE_AMP_EFFECT, 100, 1, false, true, true);
                        player.method_6092(amp);
                    }
                }
            }
            if (this.spellCooldown > 0) {
                --this.spellCooldown;
            }
            for (ConstructSpell spell : this.spells.values()) {
                if (spell.isActive()) {
                    this.tickSpell(spell);
                }
                if (spell.getCooldown() <= 0) continue;
                spell.setCooldown(spell.getCooldown() - 1);
            }
            float curHP = this.method_6032();
            class_1282 recentDamage = this.method_6081();
            if (recentDamage != null && recentDamage.method_49708(class_8111.field_42340) && this.spells.get((Object)ConstructSpellType.SHADOW_SHROUD).getCooldown() <= 0) {
                this.castSpell(this.spells.get((Object)ConstructSpellType.SHADOW_SHROUD));
            } else if ((int)(curHP * 4.0f / this.method_6063()) < (int)(this.prevHP * 4.0f / this.method_6063()) && this.spells.get((Object)ConstructSpellType.REFLEXIVE_BLAST).getCooldown() <= 0) {
                this.castSpell(this.spells.get((Object)ConstructSpellType.REFLEXIVE_BLAST));
            } else if (this.getInvulnerableTimer() <= 0 && this.spellCooldown <= 0) {
                this.castSpell(this.spells.get((Object)this.getWeightedResult(this.buildWeightedSpellList())));
            }
            if (!this.blockPacketQueue.isEmpty()) {
                this.sendBlockBreakPackets();
            }
            this.prevHP = curHP;
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public void method_6007() {
        this.tickCustomAI();
        super.method_6007();
        if (this.getInvulnerableTimer() > 0) {
            this.movementType = ConstructMovementType.SPAWNING;
        } else if (this.spells.get((Object)ConstructSpellType.WITHERING_RAY).isActive()) {
            this.movementType = ConstructMovementType.LASER;
        } else if (this.spells.get((Object)ConstructSpellType.RELENTLESS_ONSLAUGHT).isActive()) {
            this.movementType = ConstructMovementType.CHARGE;
        } else if (this.shouldChangeMovementType()) {
            this.movementChangeTime = this.field_6012 + this.field_5974.method_39332(200, 500);
            float healthThreshold = this.method_6032() / this.method_6063() * 0.6f + 0.2f;
            float random = this.field_5974.method_43057();
            this.movementType = random > healthThreshold ? ConstructMovementType.MELEE_PURSUIT : ((double)this.field_5974.method_43057() > (this.shouldHaveSummoner && this.summoner != null && (double)this.method_5739((class_1297)this.summoner) > 25.6 ? 0.2 : 0.8) ? ConstructMovementType.RANGED_PURSUIT : ConstructMovementType.STRAFE);
        }
        boolean shieldActive = this.isShieldActive();
        for (int jx = 0; jx < 3; ++jx) {
            double p = this.getHeadX(jx);
            double q = this.getHeadY(jx);
            double r = this.getHeadZ(jx);
            float s = 0.3f * this.method_55693();
            this.method_37908().method_8406((class_2394)class_2398.field_11251, p + this.field_5974.method_43059() * (double)s, q + this.field_5974.method_43059() * (double)s, r + this.field_5974.method_43059() * (double)s, 0.0, 0.0, 0.0);
            if (!shieldActive || this.method_37908().field_9229.method_43048(4) != 0) continue;
            class_9381 particle = class_9381.method_58255((class_2396)class_2398.field_11226, (float)0.7f, (float)0.7f, (float)0.5f);
            this.method_37908().method_8406((class_2394)particle, p + this.field_5974.method_43059() * (double)s, q + this.field_5974.method_43059() * (double)s, r + this.field_5974.method_43059() * (double)s, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTimer() > 0) {
            float t = 3.3f * this.method_55693();
            for (int u = 0; u < 3; ++u) {
                class_9381 particle = class_9381.method_58255((class_2396)class_2398.field_11226, (float)0.7f, (float)0.7f, (float)0.9f);
                this.method_37908().method_8406((class_2394)particle, this.method_23317() + this.field_5974.method_43059(), this.method_23318() + (double)(this.field_5974.method_43057() * t), this.method_23321() + this.field_5974.method_43059(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void tickCustomAI() {
        block28: {
            double sqrDistToPosition;
            class_3218 serverWorld;
            block30: {
                block29: {
                    block27: {
                        class_1937 class_19372 = this.method_37908();
                        if (!(class_19372 instanceof class_3218)) {
                            return;
                        }
                        serverWorld = (class_3218)class_19372;
                        this.method_5875(true);
                        double speed = this.method_45325(class_5134.field_23720);
                        if (this.movementType == ConstructMovementType.SPAWNING) {
                            if (this.summoner != null) {
                                this.method_5951((class_1297)this.summoner, 30.0f, 30.0f);
                            }
                            this.method_18800(0.0, 0.0, 0.0);
                            return;
                        }
                        if (this.movementType == ConstructMovementType.WAIT) {
                            this.acquireTargetCooldown = 0;
                            this.targetPosition = this.method_19538();
                            this.circlingCenter = this.method_24515();
                        }
                        if (this.acquireTargetCooldown-- <= 0) {
                            List<class_1309> targets = this.getPrioritizedTargets();
                            int headIndex = 0;
                            boolean initSet = false;
                            for (class_1309 target : targets) {
                                if (headIndex > 2) break;
                                if (!initSet) {
                                    this.method_5980(target);
                                    this.setTrackedEntityId(0, target.method_5628());
                                    this.setTrackedEntityId(1, target.method_5628());
                                    this.setTrackedEntityId(2, target.method_5628());
                                    initSet = true;
                                }
                                if (!((double)this.method_5739((class_1297)target) <= 32.0)) continue;
                                this.setTrackedEntityId(headIndex, target.method_5628());
                                ++headIndex;
                            }
                            if (initSet) {
                                this.acquireTargetCooldown = 20;
                            }
                        }
                        if (this.method_5968() == null) {
                            this.movementType = ConstructMovementType.WAIT;
                        } else {
                            this.method_5951((class_1297)this.method_5968(), 30.0f, 30.0f);
                        }
                        if (this.movementType != ConstructMovementType.CHARGE && this.movementType != ConstructMovementType.MELEE_PURSUIT) break block27;
                        double sqrDistToTarget = this.method_5649(this.method_5968().method_23317(), this.method_5968().method_23318(), this.method_5968().method_23321());
                        double attackRange = this.method_17681() * 2.0f * this.method_17681() * 2.0f;
                        if (this.isExalted) {
                            List players = this.method_37908().method_18023((class_5575)class_1299.field_6097, this.method_5829().method_1014(64.0), e -> true);
                            class_1293 blind = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, 30, 20, false, true, true);
                            players.forEach(p -> p.method_6092(blind));
                        }
                        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
                        if (!(sqrDistToTarget > attackRange) && this.attackCooldown == 0) {
                            this.attackCooldown = 15;
                            this.method_6121(serverWorld, (class_1297)this.method_5968());
                            class_1293 wither = new class_1293(class_1294.field_5920, 80, 0, false, true, true);
                            this.method_5968().method_6092(wither);
                        }
                        speed *= 1.5;
                        this.targetPosition = this.method_5968().method_19538();
                        break block28;
                    }
                    if (this.movementType != ConstructMovementType.RANGED_PURSUIT) break block29;
                    double sqrDistToTarget = this.method_5649(this.method_5968().method_23317(), this.method_5968().method_23318(), this.method_5968().method_23321());
                    if (sqrDistToTarget < 1024.0 && this.method_5985().method_6369((class_1297)this.method_5968())) {
                        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
                        if (this.attackCooldown == 0) {
                            this.attackCooldown = 45;
                            this.method_7105(this.method_5968(), 1.0f);
                        }
                    }
                    class_243 targetDiff = this.method_5968().method_19538().method_1020(this.method_19538());
                    double lengthDiff = targetDiff.method_1033() - 16.0;
                    class_243 newTargetPos = this.method_19538().method_1019(targetDiff.method_1029().method_1021(lengthDiff));
                    this.targetPosition = new class_243(newTargetPos.field_1352, this.method_5968().method_23318() + (double)this.strafeHeight, newTargetPos.field_1350);
                    break block28;
                }
                if (this.movementType != ConstructMovementType.STRAFE) break block30;
                this.circlingCenter = this.method_5968().method_24515();
                int up = 0;
                while (this.method_37908().method_8320(this.circlingCenter.method_10084()).method_26215() && (float)up < this.strafeHeight) {
                    this.circlingCenter = this.circlingCenter.method_10084();
                    ++up;
                }
                if (this.field_6012 % 100 == 0) {
                    this.strafeRadius = this.field_5974.method_43057() * 8.0f + 8.0f;
                    this.strafeRate = this.field_5974.method_43057() * 4.0f + 0.5f;
                    this.strafeRate *= this.field_5974.method_43056() ? -1.0f : 1.0f;
                }
                this.strafeYaw = class_3532.method_15393((float)(this.strafeYaw + this.strafeRate));
                class_243 circleOffset = new class_243(Math.cos(Math.toRadians(this.strafeYaw)), 0.0, Math.sin(Math.toRadians(this.strafeYaw))).method_1021((double)this.strafeRadius);
                this.targetPosition = circleOffset.method_1019(this.circlingCenter.method_46558());
                double sqrDistToTarget = this.method_5649(this.method_5968().method_23317(), this.method_5968().method_23318(), this.method_5968().method_23321());
                if (!(sqrDistToTarget < 1024.0) || !this.method_5985().method_6369((class_1297)this.method_5968())) break block28;
                this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
                if (this.attackCooldown != 0) break block28;
                this.attackCooldown = 45;
                this.method_7105(this.method_5968(), 1.0f);
                break block28;
            }
            if (this.movementType == ConstructMovementType.LASER && (sqrDistToPosition = this.method_5707(this.targetPosition)) <= 4.0) {
                this.method_5951((class_1297)this.method_5968(), 360.0f, 360.0f);
                for (int i = 0; i < 3; ++i) {
                    int id = this.getTrackedEntityId(i);
                    if (id <= 0) continue;
                    class_1309 livingEntity = (class_1309)serverWorld.method_8469(id);
                    if (livingEntity != null && this.method_18395(livingEntity) && this.method_5858((class_1297)livingEntity) < 1024.0) {
                        class_243 headPos = new class_243(this.getHeadX(i), this.getHeadY(i), this.getHeadZ(i));
                        MinecraftUtils.LasercastResult lasercast = MinecraftUtils.lasercast((class_1937)serverWorld, (class_243)headPos, (class_243)livingEntity.method_19538().method_1020(headPos).method_1029(), (double)32.0, (boolean)true, (class_1297)this);
                        if (this.field_6012 % 10 == 0) {
                            float damage = this.isExalted ? 2.0f : 4.0f;
                            for (class_1297 hit : lasercast.sortedHits()) {
                                double dp;
                                class_3222 hitPlayer;
                                if (!(hit instanceof class_1309)) continue;
                                class_1309 livingHit = (class_1309)hit;
                                if (hit.method_5864().method_20210(ArcanaRegistry.NUL_CONSTRUCT_FRIENDS)) continue;
                                if (hit instanceof class_3222 && (hitPlayer = (class_3222)hit).method_6039() && (dp = hitPlayer.method_5663().method_1029().method_1026(lasercast.direction().method_1029())) < -0.6) {
                                    ArcanaUtils.blockWithShield((class_1309)hitPlayer, damage);
                                    continue;
                                }
                                hit.method_64397(serverWorld, ArcanaDamageTypes.of(this.method_37908(), ArcanaDamageTypes.NUL, (class_1297)this), damage);
                                class_1293 wither = new class_1293(class_1294.field_5920, this.isExalted ? 100 : 40, 1, false, true, true);
                                class_1293 blind = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, 40, 25, false, true, true);
                                class_1293 slow = new class_1293(class_1294.field_5909, this.isExalted ? 100 : 40, 1, false, true, true);
                                class_1293 fatigue = new class_1293(class_1294.field_5901, this.isExalted ? 100 : 40, 2, false, true, true);
                                class_1293 weakness = new class_1293(class_1294.field_5911, this.isExalted ? 100 : 40, 1, false, true, true);
                                if (this.isExalted) {
                                    livingHit.method_6092(blind);
                                }
                                livingHit.method_6092(slow);
                                livingHit.method_6092(fatigue);
                                livingHit.method_6092(weakness);
                                livingHit.method_6092(wither);
                                this.conversionHeal(damage * 0.8f);
                            }
                        }
                        if (this.field_6012 % 3 == 0) {
                            class_2390 dust = new class_2390(0x2A2A2A, 1.5f);
                            int intervals = (int)(lasercast.startPos().method_1020(lasercast.endPos()).method_1033() * 4.0);
                            ArcanaEffectUtils.line((class_3218)serverWorld, null, (class_243)lasercast.startPos(), (class_243)lasercast.endPos(), (class_2394)dust, (int)intervals, (int)1, (double)0.08, (double)0.0);
                        }
                        if (this.field_6012 % 5 != 0) continue;
                        for (int xOff = -1; xOff <= 1; ++xOff) {
                            for (int zOff = -1; zOff <= 1; ++zOff) {
                                for (int yOff = -1; yOff <= 1; ++yOff) {
                                    int x = (int)(lasercast.endPos().field_1352 + (double)xOff);
                                    int y = (int)(lasercast.endPos().field_1351 + (double)yOff);
                                    int z = (int)(lasercast.endPos().field_1350 + (double)zOff);
                                    class_2338 blockPos = new class_2338(x, y, z);
                                    int blockDamage = (int)(2.5 - 0.8 * (double)(xOff * xOff + zOff * zOff + yOff * yOff));
                                    this.damageBlock(blockPos, blockDamage);
                                }
                            }
                        }
                        continue;
                    }
                    this.setTrackedEntityId(i, 0);
                }
            }
        }
        class_243 delta = this.targetPosition.method_1020(this.method_19538());
        this.method_18799(delta.method_1029().method_1021(speed *= 1.0 / (1.0 + Math.exp(-0.25 * (delta.method_1033() - 8.0)))));
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_70686();
        birdNavigation.method_6354(true);
        return birdNavigation;
    }

    public HashSet<class_3222> getParticipatingPlayers() {
        class_1283 tracker = this.method_6066();
        HashSet<class_3222> participatingPlayers = new HashSet<class_3222>();
        for (class_1281 damageRecord : tracker.field_5870) {
            class_1297 class_12972 = damageRecord.comp_1535().method_5529();
            if (!(class_12972 instanceof class_3222)) continue;
            class_3222 player = (class_3222)class_12972;
            participatingPlayers.add(player);
        }
        return participatingPlayers;
    }

    private List<class_1309> getPrioritizedTargets() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return new ArrayList<class_1309>();
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ArrayList<class_1309> targets = new ArrayList<class_1309>(this.method_37908().method_8390(class_1309.class, this.method_53510().method_1014(64.0), e -> CAN_ATTACK_PREDICATE.method_18303(e, serverWorld)));
        HashSet<class_3222> participatingPlayers = this.getParticipatingPlayers();
        targets.sort(Comparator.comparingDouble(entity -> {
            double distVal = entity.method_5739((class_1297)this);
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                distVal = this.summoner != null && this.summoner.method_5845().equals(serverPlayer.method_5845()) ? (distVal -= 640.0) : (participatingPlayers.contains(serverPlayer) ? (distVal -= 320.0) : (distVal -= 192.0));
            }
            return distVal;
        }));
        return targets;
    }

    private void shootSkullAt(int headIndex, double targetX, double targetY, double targetZ, boolean charged) {
        if (!this.method_5701()) {
            this.method_37908().method_8444(null, 1024, this.method_24515(), 0);
        }
        double d = this.getHeadX(headIndex);
        double e = this.getHeadY(headIndex);
        double f = this.getHeadZ(headIndex);
        double g = targetX - d;
        double h = targetY - e;
        double i = targetZ - f;
        class_243 vec3d = new class_243(g, h, i);
        class_1687 witherSkullEntity = new class_1687(this.method_37908(), (class_1309)this, vec3d.method_1029());
        witherSkullEntity.method_7432((class_1297)this);
        if (charged) {
            witherSkullEntity.method_7502(true);
        }
        witherSkullEntity.method_23327(d, e, f);
        this.method_37908().method_8649((class_1297)witherSkullEntity);
    }

    private void shootSkullAt(int headIndex, class_1309 target) {
        this.shootSkullAt(headIndex, target.method_23317(), target.method_23318() + (double)target.method_5751() * 0.5, target.method_23321(), headIndex == 0 && this.field_5974.method_43057() < 0.001f);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.shootSkullAt(0, target);
    }

    private boolean damageBlock(class_2338 pos, int damage) {
        if (damage <= 0) {
            return false;
        }
        class_2680 blockState = this.method_37908().method_8320(pos);
        if (!NulConstructEntity.canDestroy(blockState)) {
            return false;
        }
        boolean blocked = true;
        for (class_2350 direction : class_2350.values()) {
            class_243 vec3d3 = this.method_19538().method_43206(direction, (double)1.0E-5f);
            if (this.method_37908().method_32880(new class_5702(vec3d3, pos.method_46558(), state -> state.method_26164(class_3481.field_17754))).method_17783() == class_239.class_240.field_1332) continue;
            blocked = false;
            break;
        }
        if (blocked) {
            return false;
        }
        int maxDmg = (int)Math.ceil(5.0 * Math.log10(Math.max(1.0f, blockState.method_26204().method_36555() + 1.0f)));
        int curDmg = this.blockDamage.getOrDefault(pos, 0);
        if (curDmg + damage > maxDmg) {
            boolean broken = this.method_37908().method_8651(pos, true, (class_1297)this);
            if (broken) {
                this.method_37908().method_8444(null, 1022, this.method_24515(), 0);
                this.blockDamage.remove(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                this.blockPacketQueue.add((class_3545<class_2338, Integer>)new class_3545((Object)pos, (Object)0));
                return true;
            }
        } else {
            int dmgLvl = (int)Math.ceil(9.0 * (double)(curDmg + damage) / (double)maxDmg);
            this.blockPacketQueue.add((class_3545<class_2338, Integer>)new class_3545((Object)pos, (Object)dmgLvl));
            this.blockDamage.put(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()), curDmg + damage);
        }
        return false;
    }

    public static boolean canDestroy(class_2680 block) {
        return !block.method_26215() && !block.method_26164(class_3481.field_17754);
    }

    private void sendBlockBreakPackets() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        int toSend = Math.min(4096, this.blockPacketQueue.size());
        for (class_3222 serverPlayerEntity : serverWorld.method_8503().method_3760().method_14571()) {
            if (serverPlayerEntity == null || serverPlayerEntity.method_51469() != serverWorld || serverPlayerEntity.method_5628() == this.method_5628() || !((double)serverPlayerEntity.method_5739((class_1297)this) <= 64.0)) continue;
            ArrayList<class_2620> list = new ArrayList<class_2620>();
            for (int i = 0; i < toSend; ++i) {
                class_2338 pos = (class_2338)this.blockPacketQueue.get(i).method_15442();
                int prog = (Integer)this.blockPacketQueue.get(i).method_15441();
                list.add(new class_2620(this.field_5974.method_43054(), pos, prog));
            }
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_8042(list));
        }
        for (int i = 0; i < toSend; ++i) {
            this.blockPacketQueue.removeFirst();
        }
    }

    private void tickSpell(ConstructSpell spell) {
        int tick = spell.tick();
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_243 pos = this.method_19538();
        if (spell.getType() == ConstructSpellType.CURSE_OF_DECAY) {
            if (tick % 12 == 0) {
                List entities = world.method_8333((class_1297)this, this.method_5829().method_1014(64.0), e -> !e.method_7325() && (double)e.method_5739((class_1297)this) < 32.0 && e instanceof class_1309 && !e.method_5864().method_20210(ArcanaRegistry.NUL_CONSTRUCT_FRIENDS));
                for (class_1297 entity1 : entities) {
                    if (!(entity1 instanceof class_1309)) continue;
                    class_1309 living = (class_1309)entity1;
                    float dmg = living.method_6063() / 15.0f;
                    float mod = living instanceof class_3222 ? 0.35f : 0.75f;
                    living.method_64397(world, ArcanaDamageTypes.of(this.method_37908(), ArcanaDamageTypes.NUL, (class_1297)this), dmg);
                    this.conversionHeal(dmg * mod);
                    class_1293 slow = new class_1293(class_1294.field_5909, this.isExalted ? 500 : 20, 1, false, true, true);
                    class_1293 weak = new class_1293(class_1294.field_5911, this.isExalted ? 500 : 20, 1, false, true, true);
                    class_1293 wither = new class_1293(class_1294.field_5920, this.isExalted ? 250 : 40, 1, false, true, true);
                    class_1293 fatigue = new class_1293(class_1294.field_5901, this.isExalted ? 500 : 20, 2, false, true, true);
                    living.method_6092(wither);
                    living.method_6092(slow);
                    living.method_6092(weak);
                    living.method_6092(fatigue);
                    ArcanaEffectUtils.nulConstructCurseOfDecay(world, entity1.method_19538());
                }
            }
        } else if (spell.getType() != ConstructSpellType.WITHERING_RAY) {
            if (spell.getType() == ConstructSpellType.NECROTIC_CONVERSION) {
                ArcanaEffectUtils.nulConstructNecroticConversion(world, this.method_19538());
            } else if (spell.getType() == ConstructSpellType.REFLECTIVE_ARMOR) {
                ArcanaEffectUtils.nulConstructReflectiveArmor(world, this.method_19538());
            } else if (spell.getType() == ConstructSpellType.RELENTLESS_ONSLAUGHT) {
                if (tick % 15 == 0) {
                    List entities = world.method_8333((class_1297)this, this.method_5829().method_1014(64.0), e -> !e.method_7325() && (double)e.method_5739((class_1297)this) < 32.0 && e instanceof class_1309);
                    for (class_1297 entity1 : entities) {
                        class_243 dirToEntity;
                        double dp;
                        class_1309 living;
                        if (!(entity1 instanceof class_1309) || !this.method_42150(living = (class_1309)entity1) || !(Math.toDegrees(Math.acos(dp = (dirToEntity = entity1.method_19538().method_1020(this.method_19538()).method_1029()).method_1026(this.method_5720()))) <= 60.0)) continue;
                        this.method_6121(world, (class_1297)this.method_5968());
                    }
                    SoundUtils.playSound((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_3414)class_3417.field_14706, (class_3419)class_3419.field_15251, (float)0.75f, (float)((float)((double)this.field_5974.method_43057() * 0.5 + 0.75)));
                }
                ArcanaEffectUtils.nulConstructChargeAttack(world, this.method_19538(), this.method_36454());
            }
        }
    }

    private void castSpell(ConstructSpell spell) {
        class_1937 class_19372;
        if (spell == null || !((class_19372 = this.method_37908()) instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        if (spell.getCooldown() > 0) {
            return;
        }
        class_243 pos = this.method_19538();
        this.spellCooldown = this.isExalted ? 160 : 200;
        float cooldownMod = 1.0f;
        float durationMod = 1.0f;
        if (spell.spellType == ConstructSpellType.SHADOW_SHROUD) {
            class_243 tpPos = this.findConstructTpPos(new class_243(0.0, 1.0, 0.0));
            ArcanaEffectUtils.nulConstructNecroticShroud(world, this.method_19538());
            this.method_5859(tpPos.method_10216(), tpPos.method_10214(), tpPos.method_10215());
            ArcanaEffectUtils.nulConstructNecroticShroud(world, tpPos);
            if (this.isExalted) {
                List players = this.method_37908().method_18023((class_5575)class_1299.field_6097, this.method_5829().method_1014(64.0), e -> true);
                class_1293 blind = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, 60, 15, false, true, true);
                players.forEach(p -> p.method_6092(blind));
            }
        } else if (spell.spellType == ConstructSpellType.REFLEXIVE_BLAST) {
            List entities = world.method_8333((class_1297)this, this.method_5829().method_1014(48.0), e -> !e.method_7325() && (double)e.method_5739((class_1297)this) <= 24.0 && e instanceof class_1309);
            for (class_1297 entity1 : entities) {
                class_243 diff = entity1.method_19538().method_1020(pos);
                double multiplier = class_3532.method_15350((double)(18.0 - diff.method_1033() * 0.5), (double)0.1, (double)3.0);
                class_243 motion = diff.method_18805(1.0, 0.0, 1.0).method_1031(0.0, 0.5, 0.0).method_1029().method_1021(multiplier);
                entity1.method_18800(motion.field_1352, motion.field_1351, motion.field_1350);
                entity1.method_64397(world, ArcanaDamageTypes.of(this.method_37908(), ArcanaDamageTypes.NUL, (class_1297)this), 4.0f);
                if (!(entity1 instanceof class_3222)) continue;
                class_3222 player = (class_3222)entity1;
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
            }
            for (class_2338 blockPos : class_2338.method_25996((class_2338)this.method_24515(), (int)24, (int)24, (int)24)) {
                int damage = (int)(10.0 - 15.0 * Math.pow(blockPos.method_10262((class_2382)this.method_24515()) / 576.0, 0.25));
                this.damageBlock(blockPos, damage);
            }
            ArcanaEffectUtils.nulConstructReflexiveBlast(world, this.method_19538(), 0);
        } else if (spell.spellType != ConstructSpellType.CURSE_OF_DECAY) {
            if (spell.spellType == ConstructSpellType.FORGOTTEN_ARMY) {
                ArrayList<class_2338> poses = SpawnPile.makeSpawnLocations(32, 24, world, class_1299.field_6076, this.method_24515());
                int numWarriors = this.isExalted ? this.field_5974.method_39332(6, 10) : this.field_5974.method_39332(3, 6);
                int numMages = this.isExalted ? this.field_5974.method_39332(4, 6) : this.field_5974.method_39332(2, 4);
                for (int i = 0; i < numWarriors + numMages; ++i) {
                    class_243 spawnPos = ((class_2338)poses.get(i)).method_46558();
                    NulGuardianEntity skeleton = new NulGuardianEntity((class_1937)world, this, i < numMages);
                    skeleton.method_5943((class_5425)world, world.method_8404(this.method_24515()), class_3730.field_16471, null);
                    skeleton.method_23327(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215());
                    world.method_30736((class_1297)skeleton);
                }
            } else if (spell.spellType != ConstructSpellType.REFLECTIVE_ARMOR && spell.spellType != ConstructSpellType.RELENTLESS_ONSLAUGHT && spell.spellType != ConstructSpellType.NECROTIC_CONVERSION && spell.spellType == ConstructSpellType.WITHERING_RAY) {
                this.targetPosition = this.method_19538();
                for (int tries = 0; tries < 1000; ++tries) {
                    class_11 path;
                    double posX = this.method_23317() + (double)this.field_5974.method_39332(-8, 8);
                    double posY = this.method_23318() + (double)this.field_5974.method_39332(2, 7);
                    double posZ = this.method_23321() + (double)this.field_5974.method_39332(-8, 8);
                    class_243 newPos = new class_243(posX, posY, posZ);
                    if (this.method_5968() != null && newPos.method_1022(this.method_5968().method_19538()) >= 24.0 || (path = this.method_5942().method_6352(posX, posY, posZ, 64)) == null) continue;
                    this.targetPosition = newPos;
                    break;
                }
            }
        }
        spell.setCooldown((int)((float)spell.spellType.baseCooldown * cooldownMod));
        spell.cast(this, (int)((float)spell.spellType.duration * durationMod));
        this.tickSpell(spell);
    }

    private void destructiveAura() {
        int thisX = class_3532.method_15357((double)this.method_23317());
        int thisY = class_3532.method_15357((double)this.method_23318());
        int thisZ = class_3532.method_15357((double)this.method_23321());
        for (int xOff = -3; xOff <= 3; ++xOff) {
            for (int zOff = -3; zOff <= 3; ++zOff) {
                for (int yOff = -1; yOff <= 4; ++yOff) {
                    int x = thisX + xOff;
                    int y = thisY + yOff;
                    int z = thisZ + zOff;
                    class_2338 blockPos = new class_2338(x, y, z);
                    double yMod = yOff < 0 ? 1.5 * Math.sqrt(-yOff) + 2.0 : (double)yOff;
                    int damage = (int)(10.0 - 0.8 * ((double)(xOff * xOff + zOff * zOff) + yMod * yMod));
                    this.damageBlock(blockPos, damage);
                }
            }
        }
    }

    private boolean isShieldActive() {
        if (this.getInvulnerableTimer() > 0) {
            return true;
        }
        if (this.spells == null) {
            return false;
        }
        if (this.spells.containsKey((Object)ConstructSpellType.REFLECTIVE_ARMOR) && this.spells.get((Object)ConstructSpellType.REFLECTIVE_ARMOR).isActive()) {
            return true;
        }
        return this.spells.containsKey((Object)ConstructSpellType.RELENTLESS_ONSLAUGHT) && this.spells.get((Object)ConstructSpellType.RELENTLESS_ONSLAUGHT).isActive();
    }

    private boolean isReflectionActive() {
        if (this.spells == null) {
            return false;
        }
        return this.spells.containsKey((Object)ConstructSpellType.REFLECTIVE_ARMOR) && this.spells.get((Object)ConstructSpellType.REFLECTIVE_ARMOR).isActive();
    }

    private boolean isConversionActive() {
        if (this.spells == null) {
            return false;
        }
        return this.spells.containsKey((Object)ConstructSpellType.NECROTIC_CONVERSION) && this.spells.get((Object)ConstructSpellType.NECROTIC_CONVERSION).isActive();
    }

    private void conversionHeal(double damage) {
        float healMod;
        float f = healMod = this.isExalted ? 0.35f : 0.25f;
        if (this.isConversionActive()) {
            healMod += this.isExalted ? 0.4f : 0.25f;
        }
        this.method_6025((float)((double)healMod * damage));
    }

    private HashMap<ConstructSpellType, Integer> buildWeightedSpellList() {
        HashMap<ConstructSpellType, Integer> availableSpells = new HashMap<ConstructSpellType, Integer>();
        for (ConstructSpellType spellType : this.spells.keySet()) {
            ConstructSpell spell = this.spells.get((Object)spellType);
            int cd = spell.getCooldown();
            if (cd > 0) continue;
            int weight = spell.getWeight();
            if (spellType == ConstructSpellType.CURSE_OF_DECAY) {
                List entities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(64.0), e -> !e.method_7325() && (double)e.method_5739((class_1297)this) < 32.0 && e instanceof class_1309);
                weight += (int)((double)entities.size() * 0.5);
            } else if (spellType == ConstructSpellType.WITHERING_RAY) {
                double hpPercent = this.method_6032() / this.method_6063();
                weight += (int)(hpPercent * 8.0);
                if (this.spells.get((Object)ConstructSpellType.RELENTLESS_ONSLAUGHT).isActive()) {
                    weight -= 100;
                }
            } else if (spellType == ConstructSpellType.NECROTIC_CONVERSION) {
                double hpPercent = this.method_6032() / this.method_6063();
                weight += (int)((1.0 - hpPercent) * 10.0);
            } else if (spellType == ConstructSpellType.REFLECTIVE_ARMOR) {
                double hpPercent = this.method_6032() / this.method_6063();
                weight += (int)((1.0 - hpPercent) * 5.0);
            } else if (spellType == ConstructSpellType.RELENTLESS_ONSLAUGHT) {
                double hpPercent = this.method_6032() / this.method_6063();
                weight += (int)((1.0 - hpPercent) * 8.0);
                if (this.spells.get((Object)ConstructSpellType.WITHERING_RAY).isActive()) {
                    weight -= 100;
                }
            } else if (spellType == ConstructSpellType.FORGOTTEN_ARMY) {
                weight = this.spells.get((Object)ConstructSpellType.NECROTIC_CONVERSION).isActive() ? (weight -= 5) : (weight += 8);
            } else if (spellType == ConstructSpellType.SHADOW_SHROUD) {
                if (this.spells.get((Object)ConstructSpellType.NECROTIC_CONVERSION).isActive()) {
                    weight -= 8;
                }
            } else if (spellType == ConstructSpellType.REFLEXIVE_BLAST) {
                weight = 0;
            }
            if (weight <= 0) continue;
            availableSpells.put(spellType, weight);
        }
        return availableSpells;
    }

    private ConstructSpellType getWeightedResult(HashMap<ConstructSpellType, Integer> map) {
        ArrayList<ConstructSpellType> pool = new ArrayList<ConstructSpellType>();
        for (Map.Entry<ConstructSpellType, Integer> entry : map.entrySet()) {
            ConstructSpellType key = entry.getKey();
            for (int j = 0; j < entry.getValue(); ++j) {
                pool.add(key);
            }
        }
        if (pool.isEmpty()) {
            return null;
        }
        return (ConstructSpellType)((Object)pool.get(this.field_5974.method_43048(pool.size())));
    }

    private class_243 findConstructTpPos(class_243 biasDirection) {
        class_243 sourcePos = this.summoner != null ? this.summoner.method_19538() : this.method_19538();
        biasDirection = biasDirection.method_1029();
        for (int tries = 0; tries < 1000; ++tries) {
            class_243 randomPoint = MathUtils.randomSpherePoint((class_243)class_243.field_1353, (double)1.0).method_1029();
            class_243 dir = randomPoint.method_1019(biasDirection).method_1029().method_1021((double)this.field_5974.method_43057() * 12.0 + 4.0);
            class_243 inWorld = sourcePos.method_1019(dir);
            if (!this.method_37908().method_8587((class_1297)this, this.method_5829().method_997(this.method_19538().method_22882()).method_997(inWorld))) continue;
            return inWorld;
        }
        return this.method_19538();
    }

    static enum ConstructMovementType {
        LASER,
        STRAFE,
        CHARGE,
        RANGED_PURSUIT,
        MELEE_PURSUIT,
        WAIT,
        SPAWNING;

    }

    public static enum ConstructAdaptations {
        USED_TOTEM("used_totem", false, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Is that an attempt at mockery? Try that again!").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   I permit you one extra chance. No more, no less.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Cheating death will only get you so far. Don't become reliant on it.").method_27692(class_124.field_1056).method_54663(0x999999))}),
        USED_MEMENTO("used_memento", true, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Now, now my champion, you have done this before. My ward is not to be used in this manner.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Using my gift like this is such a waste, I shall lessen it's benefit.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   You are making me question my faith in you. Don't rely on my power as a crutch.").method_27692(class_124.field_1056).method_54663(0x999999))}),
        USED_VENGEANCE_TOTEM("used_vengeance_totem", false, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   An interesting gambit! But will it pay off?").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   I like your spirit! But conviction is only half the battle.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   A curious trinket. Be wary, such soul magic is a dangerous game.").method_27692(class_124.field_1056).method_54663(0x999999))}),
        DAMAGED_BY_MACE("damaged_by_mace", false, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   A gravitic weapon? My construct will adapt accordingly.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   A creative approach, unfortunately you won't be able to land a solid hit.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   An intriguing weapon, but gravity won't be your ally in this fight.").method_27692(class_124.field_1056).method_54663(0x999999))}),
        MASSIVE_BLOW("massive_blow", true, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   A solid hit! However, my construct will adapt.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   A good blow! Let's make this harder...").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"The construct grows more resilient...").method_27692(class_124.field_1056).method_54663(0x999999)}),
        TRUE_INVISIBILITY("true_invisibility", false, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Can you fight without seeing your opponent? My construct can!").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Cheap tricks will get you nowhere!").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Hiding is a coward's game!").method_27692(class_124.field_1056).method_54663(0x999999))}),
        ADDITIONAL_PLAYERS("additional_players", false, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   You brought friends! Friends have a habit of dying on you.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   You think allies will make this easier? Don't trip over each other.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Regardless of aid, my challenge remains. My construct will ensure an adequate test.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   More swords aren't always better. Are these reinforcements worthy fighters?").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   So another soul wishes to get in on the action? What is one more life to wither away?").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   If you think you can make up for your lack of skill with numbers, you are mistaken...").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Another foe into the fray! Another soul to wither away!").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   If you wish to bring reinforcements, so be it. My construct only grows stronger.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   My construct adapts to any situation, multiple opponents included.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   If you wish to attempt my challenge together, at least try to not kill each other.").method_27692(class_124.field_1056).method_54663(0x999999))}),
        SPAWNED_CONSTRUCT_FINDS_PLAYER("spawned_construct_finds_player", false, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   I yearn for a player to test! Are you up to the challenge?").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   You may not have summoned me, but you will do. Fight!").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   I challenge you! Defend yourself!").method_27692(class_124.field_1056).method_54663(0x999999))});

        public final String id;
        public final boolean repeatable;
        public final class_2561[] abilityTexts;

        private ConstructAdaptations(String id, boolean repeatable, class_2561[] abilityTexts) {
            this.id = id;
            this.repeatable = repeatable;
            this.abilityTexts = abilityTexts;
        }

        public static ConstructAdaptations fromString(String id) {
            for (ConstructAdaptations adaptation : ConstructAdaptations.values()) {
                if (!adaptation.id.equalsIgnoreCase(id)) continue;
                return adaptation;
            }
            return null;
        }
    }

    private static enum ConstructSpellType {
        CURSE_OF_DECAY("Curse of Decay", "curse_of_decay", 115, 550, new class_2561[]{class_2561.method_43470((String)"The decay takes hold...").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"You feel your soul being siphoned away...").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"A curse permeates your soul...").method_27692(class_124.field_1056).method_54663(0x999999)}),
        REFLEXIVE_BLAST("Reflexive Blast", "reflexive_blast", 0, 200, new class_2561[]{class_2561.method_43470((String)"The construct surges!").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"A blast knocks you!").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"A shockwave emanates from the construct!").method_27692(class_124.field_1056).method_54663(0x999999)}),
        WITHERING_RAY("Withering Ray", "withering_ray", 150, 275, new class_2561[]{class_2561.method_43470((String)"A necrotic ray bursts forth!").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"The construct emits a withering ray!").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"A withering beam emanates from the construct!").method_27692(class_124.field_1056).method_54663(0x999999)}),
        NECROTIC_CONVERSION("Necrotic Conversion", "necrotic_conversion", 300, 475, new class_2561[]{class_2561.method_43470((String)"The construct mends...").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"The construct's bones heal...").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"The construct regenerates...").method_27692(class_124.field_1056).method_54663(0x999999)}),
        SHADOW_SHROUD("Shadow Shroud", "shadow_shroud", 0, 200, new class_2561[]{class_2561.method_43470((String)"The construct shifts...").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"The construct vanishes...").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Don't lose your mark.").method_27692(class_124.field_1056).method_54663(0x999999))}),
        FORGOTTEN_ARMY("Forgotten Army", "forgotten_army", 0, 625, new class_2561[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   The forgotten army rises again!").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   My brethren live as long as I remain.").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   The ancient warriors march forth!").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   You're outnumbered now...").method_27692(class_124.field_1056).method_54663(0x999999)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n   Don't get surrounded.").method_27692(class_124.field_1056).method_54663(0x999999))}),
        REFLECTIVE_ARMOR("Reflective Armor", "reflective_armor", 200, 325, new class_2561[]{class_2561.method_43470((String)"The construct shimmers...").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"A shining field embraces the construct.").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"The construct becomes reflective.").method_27692(class_124.field_1056).method_54663(0x999999)}),
        RELENTLESS_ONSLAUGHT("Relentless Onslaught", "relentless_onslaught", 160, 450, new class_2561[]{class_2561.method_43470((String)"The construct pursues you!").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"The construct charges you!").method_27692(class_124.field_1056).method_54663(0x999999), class_2561.method_43470((String)"The construct approaches aggressively!").method_27692(class_124.field_1056).method_54663(0x999999)});

        public final String name;
        public final String id;
        public final int duration;
        public final int baseCooldown;
        public final class_2561[] abilityTexts;

        private ConstructSpellType(String name, String id, int duration, int baseCooldown, class_2561[] abilityTexts) {
            this.name = name;
            this.id = id;
            this.duration = duration;
            this.baseCooldown = baseCooldown;
            this.abilityTexts = abilityTexts;
        }

        public static ConstructSpellType fromString(String id) {
            for (ConstructSpellType spell : ConstructSpellType.values()) {
                if (!spell.id.equalsIgnoreCase(id)) continue;
                return spell;
            }
            return null;
        }
    }

    private static class ConstructSpell {
        private final ConstructSpellType spellType;
        private final int weight;
        private int cooldown;
        private int tick;
        private boolean active;

        private ConstructSpell(ConstructSpellType spellType) {
            this.spellType = spellType;
            this.cooldown = 0;
            this.weight = (int)(Math.random() * 10.0 + 1.0);
            this.active = false;
            this.tick = 0;
        }

        private ConstructSpell(ConstructSpellType spellType, int cooldown, int weight, boolean active, int tick) {
            this.spellType = spellType;
            this.cooldown = cooldown;
            this.weight = weight;
            this.active = active;
            this.tick = tick;
        }

        public class_2487 toNbt() {
            class_2487 tag = new class_2487();
            tag.method_10582("type", this.spellType.id);
            tag.method_10569("cooldown", this.cooldown);
            tag.method_10569("weight", this.weight);
            tag.method_10569("tick", this.tick);
            tag.method_10556("active", this.active);
            return tag;
        }

        private static ConstructSpell fromNbt(class_2487 tag) {
            return new ConstructSpell(ConstructSpellType.fromString(tag.method_68564("type", "")), tag.method_68083("cooldown", 0), tag.method_68083("weight", 0), tag.method_68566("active", false), tag.method_68083("tick", 0));
        }

        public void cast(NulConstructEntity construct, int tick) {
            this.active = true;
            this.tick = tick;
            NulConstructDialog.abilityText(construct.summoner, construct, this.spellType.abilityTexts[(int)(Math.random() * (double)this.spellType.abilityTexts.length)]);
        }

        public int tick() {
            --this.tick;
            if (this.tick <= 0) {
                this.active = false;
            }
            return this.tick;
        }

        public boolean isActive() {
            return this.active;
        }

        public ConstructSpellType getType() {
            return this.spellType;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public void setCooldown(int cooldown) {
            this.cooldown = cooldown;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public static enum Announcements {
        SUMMON_TEXT,
        SUMMON_DIALOG,
        SUCCESS,
        FAILURE;

    }

    private static class NulConstructDialog {
        public static HashMap<Announcements, ArrayList<Dialog>> DIALOG = new HashMap();

        private NulConstructDialog() {
        }

        public static void abilityText(class_1657 summoner, NulConstructEntity construct, class_2561 text) {
            class_3222 player;
            List playersInRange = construct.method_37908().method_18467(class_3222.class, construct.method_5829().method_1014(50.0));
            if (summoner instanceof class_3222 && !playersInRange.contains(player = (class_3222)summoner)) {
                playersInRange.add(player);
            }
            for (class_3222 inRange : playersInRange) {
                inRange.method_7353(text, false);
            }
        }

        public static void announce(MinecraftServer server, class_1657 summoner, NulConstructEntity construct, Announcements type) {
            NulConstructDialog.announce(server, summoner, construct, type, new boolean[0]);
        }

        public static void announce(MinecraftServer server, class_1657 summoner, NulConstructEntity construct, Announcements type, boolean[] args) {
            class_3222 player;
            DialogHelper dialogHelper = new DialogHelper(DIALOG.get((Object)type), args);
            ArrayList<class_5250> message = dialogHelper.getWeightedResult().message();
            List playersInRange = construct.method_37908().method_18467(class_3222.class, construct.method_5829().method_1014(50.0));
            if (summoner instanceof class_3222 && !playersInRange.contains(player = (class_3222)summoner)) {
                playersInRange.add(player);
            }
            for (class_5250 msg : message) {
                boolean foundSummoner = false;
                for (class_3222 playerInRange : playersInRange) {
                    playerInRange.method_7353((class_2561)msg, false);
                    if (playerInRange.method_5628() != summoner.method_5628()) continue;
                    foundSummoner = true;
                }
                if (type != Announcements.FAILURE || summoner == null || foundSummoner) continue;
                summoner.method_7353((class_2561)msg, false);
            }
        }

        static {
            for (Announcements type : Announcements.values()) {
                DIALOG.put(type, new ArrayList());
            }
            DIALOG.get((Object)Announcements.SUMMON_TEXT).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You Feel ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"Divine Energy").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" Flow Into The ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"Construct").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"Dark Presence").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" Looms...").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 1, 1, 0));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Player").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" knocks on the door of the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"? They know not what they are toying with...").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Those unworthy of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"knowledge").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" shall be reduced to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"nothing").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"...").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Player").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" grow bolder by the minute. Perhaps they need to be put in their place.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Player").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" seeks to harness ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine Energy").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"? Let them try...").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Of all the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Gods").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" to call upon, you disturb me? You must be ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"ignorant").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" of my domain, or ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"arrogant").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" enough to tempt ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Death").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"I am the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"God").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Death").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Knowledge").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)". If my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Construct").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" does not give you the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"former").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)", you shall earn the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"latter").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 1, 1, 0));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"So you have defeated ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" and now knock on my door? You seek to challenge the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"God").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Death").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"!?").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 2));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"I watched as you defeated ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)". Do not think that I am as ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"weak").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" or ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"indolent").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" as her.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 2));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have tasted the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" and want more? Lets hope your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"greed").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" is not your downfall.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 1));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Just because you already carry the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" does not mean you are ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"entitled").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" to more.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 1));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"So you would sacrifice my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"gift").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" to curry my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"favor").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"? Let's see if you're worth it...").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 32));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You reject my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"divine gift").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"? If it's me you want, you must prove yourself ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"worthy").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 32));
            DIALOG.get((Object)Announcements.SUMMON_DIALOG).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"If you want my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"favor").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" you must face a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"real").method_27695(new class_124[]{class_124.field_1065, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" challenge!").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 32));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have impressed me ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Player").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)", you have earned a taste of my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" power.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Impressive, I have imbued your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Catalyst").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine Energy").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)", I'm curious as to how you'll use it.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have defeated my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Construct").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)", no easy feat. Gather what ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine Energy").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" remains for your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Catalyst").method_27692(class_124.field_1065)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Death").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" does not come for you today, I shall grant you what you have sought.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Catalytic Matrix").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" of yours is a quaint toy, lets see if you can handle a taste of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"true power").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A valiant fight! ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" must be getting nervous. Perhaps she will finally learn her lesson...").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 1, 0, 4));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"I can see how you defeated ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)", however I am not so ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"weak").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)". Be thankful I only sent a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Construct").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" to greet you.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 2));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You helped my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Sister").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" see the truth, and now you have proven yourself. Take this ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Boon").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" and may we meet again.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 2));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have earned your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Catalyst").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)", but don't get ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"overzealous").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)", or else I will deal with you ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"personally").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 1));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It seems you are worthy enough to add another piece of the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" to your collection.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 10, 1));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You are unlike any I have seen before. Perhaps you are worthy of my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"guidance").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)". This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Memento").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" shall be my gift to you.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, -1, 72));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You did well to survive my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"stronger construct").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)", but not well enough to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"impress").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" me.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 48));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You may have survived, but your performance showed ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"weakness").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" that I do not ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"tolerate").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 48));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"So your").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" gambit").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" paid off... I am ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"impressed").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" Player, let my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Memento").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" offer you ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"wisdom").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 40));
            DIALOG.get((Object)Announcements.SUCCESS).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"spectacular").method_27695(new class_124[]{class_124.field_1065, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" display of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"competence").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"! Take my ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Memento").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)", and let my new gift ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"guide").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" you well.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 40));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Another arrogant ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Player").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)", not worthy of my time.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 5, 5, 0));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Such a simple ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Construct").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" defeated you? You are not worthy of the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Such a small sample of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine Power").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" overwhelmed you? How did you plan on ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"harnessing").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" it in the first place?").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"An expected result from calling upon the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"God").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" of Death").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)". Do not waste my time again.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arrogant enough to tempt ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Death").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"... I can't fathom how you expected to win.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 3, 3, 0));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"There is ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"knowledge").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" in failure, but only if you have the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"wisdom").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to find it.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 1, 1, 0));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"death").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" is a mercy. Do not be ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"foolish").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" enough to find out why.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 1, 1, 0));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"weakling").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" like you defeated ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"? And I thought my opinion of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"her").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" couldn't get any lower.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 20, 2));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Whatever petty tricks got you the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Divine").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" in the past won't work on me. ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Knowledge").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" must be earned!").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 20, 1));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"I always knew you were too ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"weak").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" to handle real ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"power").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"...").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 150, 32));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"An interesting ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"gambit").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)", too bad you aren't ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"skilled").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" enough to execute it.").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 32));
            DIALOG.get((Object)Announcements.FAILURE).add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"weakness").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" is ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"revolting!").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" Your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"divine catalyst").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" is ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"forfeit").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1063)), class_2561.method_43470((String)""))), new ArrayList<Dialog.DialogSound>(), new int[0], 0, 200, 32));
        }
    }
}

