/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.arcananovum.gui.altars.StarpathTargetGui;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class StarpathAltarChartsGui
extends SimpleGui {
    private final StarpathAltarBlockEntity blockEntity;
    private final SimpleGui returnGui;
    private List<StarpathAltarBlockEntity.TargetEntry> destinations;
    private DestinationSort sort = DestinationSort.ALPHABETICAL;
    private int page = 1;
    private final boolean stargate;

    public StarpathAltarChartsGui(class_3222 player, SimpleGui returnGui, StarpathAltarBlockEntity blockEntity) {
        super(class_3917.field_17327, player, false);
        this.blockEntity = blockEntity;
        this.returnGui = returnGui;
        this.destinations = new ArrayList<StarpathAltarBlockEntity.TargetEntry>(blockEntity.getSavedTargets());
        this.stargate = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.STARGATE.id) > 0;
        this.setTitle((class_2561)class_2561.method_43470((String)"Star Charts"));
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean indexInCenter = index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8;
        int numPages = (int)Math.ceil((double)this.destinations.size() / 28.0);
        if (index == 0) {
            boolean backwards = type == ClickType.MOUSE_RIGHT;
            boolean shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
            this.sort = shiftLeft ? DestinationSort.ALPHABETICAL : DestinationSort.cycleSort(this.sort, backwards);
            this.buildGui();
        } else if (index == 45) {
            if (this.page > 1) {
                --this.page;
                this.buildGui();
            }
        } else if (index == 53) {
            if (this.page < numPages) {
                ++this.page;
                this.buildGui();
            }
        } else if (index == 49) {
            AtomicReference newDest = new AtomicReference();
            StarpathTargetGui nameGui = new StarpathTargetGui(this.player, this.blockEntity, false, this, obj -> {
                this.blockEntity.getSavedTargets().add(new StarpathAltarBlockEntity.TargetEntry((String)obj, this.player.method_51469().method_27983().method_29177().toString(), ((class_2338)newDest.get()).method_10263(), ((class_2338)newDest.get()).method_10264(), ((class_2338)newDest.get()).method_10260()));
                this.buildGui();
            });
            StarpathTargetGui targetGui = new StarpathTargetGui(this.player, this.blockEntity, true, (SimpleGui)nameGui, obj -> newDest.set((class_2338)obj));
            targetGui.open();
        } else if (index == 4) {
            this.close();
        } else if (indexInCenter) {
            int ind = 7 * (index / 9 - 1) + (index % 9 - 1) + 28 * (this.page - 1);
            if (ind >= this.destinations.size()) {
                return true;
            }
            if (type == ClickType.MOUSE_RIGHT) {
                StarpathTargetGui gui = new StarpathTargetGui(this.player, this.blockEntity, false, this, obj -> {
                    String newName = (String)obj;
                    StarpathAltarBlockEntity.TargetEntry toRemove = this.destinations.get(ind);
                    this.blockEntity.getSavedTargets().remove(toRemove);
                    this.blockEntity.getSavedTargets().add(new StarpathAltarBlockEntity.TargetEntry(newName, toRemove.dimension(), toRemove.x(), toRemove.y(), toRemove.z()));
                    this.buildGui();
                });
                gui.open();
            } else if (type == ClickType.MOUSE_LEFT_SHIFT) {
                this.blockEntity.getSavedTargets().remove(this.destinations.get(ind));
                this.buildGui();
            } else {
                this.blockEntity.setTarget(this.destinations.get(ind));
                this.close();
            }
        }
        return true;
    }

    public void loadDestinations() {
        this.destinations = new ArrayList<StarpathAltarBlockEntity.TargetEntry>(this.blockEntity.getSavedTargets());
        switch (this.sort.ordinal()) {
            case 0: {
                this.destinations.sort(Comparator.comparingInt(pair -> (int)pair.getBlockCoords().method_10262((class_2382)this.blockEntity.method_11016())));
                break;
            }
            case 1: {
                this.destinations.sort(Comparator.comparingInt(pair -> (int)(-pair.getBlockCoords().method_10262((class_2382)this.blockEntity.method_11016()))));
                break;
            }
            case 2: {
                this.destinations.sort(Comparator.comparing(StarpathAltarBlockEntity.TargetEntry::name));
            }
        }
    }

    public void buildGui() {
        GuiHelper.outlineGUI((SimpleGui)this, (int)1704246, (class_2561)class_2561.method_43470((String)"Saved Locations").method_27692(class_124.field_1078));
        this.loadDestinations();
        int numPages = (int)Math.ceil((double)this.destinations.size() / 28.0);
        GuiElementBuilder labelItem = new GuiElementBuilder(class_1802.field_8449).hideDefaultTooltip();
        labelItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Starpath Altar Destinations").method_27692(class_124.field_1062)));
        labelItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to return to the altar").method_27692(class_124.field_1078))));
        this.setSlot(4, (GuiElementBuilderInterface)labelItem);
        GuiElementBuilder newItem = new GuiElementBuilder(class_1802.field_8674).hideDefaultTooltip();
        newItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"New Destination").method_27692(class_124.field_1062)));
        newItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to add a new destination").method_27692(class_124.field_1078))));
        this.setSlot(49, (GuiElementBuilderInterface)newItem);
        if (numPages > 1) {
            GuiElementBuilder nextArrow = new GuiElementBuilder(class_1802.field_8236).hideDefaultTooltip();
            nextArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Page").method_27692(class_124.field_1065)));
            nextArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + numPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(53, (GuiElementBuilderInterface)nextArrow);
            GuiElementBuilder prevArrow = new GuiElementBuilder(class_1802.field_8236).hideDefaultTooltip();
            prevArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Prev Page").method_27692(class_124.field_1065)));
            prevArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + numPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(45, (GuiElementBuilderInterface)prevArrow);
        }
        GuiElementBuilder sortBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.SORT)).hideDefaultTooltip();
        sortBuilt.setName((class_2561)class_2561.method_43470((String)"Sort Destinations").method_27692(class_124.field_1064));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current sort type.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle sort backwards.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset sort.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sorting By: ").method_27692(class_124.field_1075)).method_10852(DestinationSort.getColoredLabel(this.sort))));
        this.setSlot(0, (GuiElementBuilderInterface)sortBuilt);
        int k = (this.page - 1) * 28;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < this.destinations.size()) {
                    GuiElementBuilder destItem = new GuiElementBuilder(class_1802.field_8204).hideDefaultTooltip();
                    destItem.setName((class_2561)class_2561.method_43470((String)this.destinations.get(k).name()).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)this.destinations.get(k).getBlockCoords().method_23854()).method_27692(class_124.field_1054)));
                    if (this.stargate) {
                        class_5321 dim = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)this.destinations.get(k).dimension()));
                        if (dim == null) {
                            dim = this.blockEntity.method_10997().method_27983();
                        }
                        destItem.addLoreLine((class_2561)class_2561.method_43470((String)"Dimension: ").method_27692(class_124.field_1054).method_10852((class_2561)ArcanaUtils.getFormattedDimName((class_5321<class_1937>)dim)));
                    }
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to select this destination").method_27692(class_124.field_1078))));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to rename this destination").method_27692(class_124.field_1078))));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" to delete this destination").method_27692(class_124.field_1078))));
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)destItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
    }

    public void onTick() {
        class_1937 world;
        if (this.blockEntity != null && ((world = this.blockEntity.method_10997()) == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled() || this.blockEntity.isActive())) {
            this.close();
        }
    }

    public void onClose() {
        if (this.returnGui != null) {
            this.returnGui.open();
        }
    }

    public static enum DestinationSort {
        CLOSEST("Closest"),
        FURTHEST("Furthest"),
        ALPHABETICAL("Alphabetical");

        public final String label;

        private DestinationSort(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(DestinationSort sort) {
            class_5250 text = class_2561.method_43470((String)sort.label);
            return switch (sort.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1076);
                case 1 -> text.method_27692(class_124.field_1064);
                case 2 -> text.method_27692(class_124.field_1060);
            };
        }

        public static DestinationSort cycleSort(DestinationSort sort, boolean backwards) {
            DestinationSort[] sorts = DestinationSort.values();
            int ind = -1;
            for (int i = 0; i < sorts.length; ++i) {
                if (sort != sorts[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= sorts.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = sorts.length - 1;
            }
            return sorts[ind];
        }
    }
}

