/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.arcananovum.gui.altars.StarpathAltarChartsGui;
import net.borisshoes.arcananovum.gui.altars.StarpathTargetGui;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class StarpathAltarGui
extends SimpleGui {
    private final StarpathAltarBlockEntity blockEntity;
    private final boolean starcharts;
    private final boolean stargate;

    public StarpathAltarGui(class_3222 player, StarpathAltarBlockEntity blockEntity) {
        super(class_3917.field_17337, player, false);
        this.blockEntity = blockEntity;
        this.starcharts = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.STAR_CHARTS.id) > 0;
        this.stargate = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.STARGATE.id) > 0;
        this.setTitle((class_2561)class_2561.method_43470((String)"Starpath Altar"));
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        if (index == 2) {
            if (this.starcharts) {
                StarpathAltarChartsGui gui = new StarpathAltarChartsGui(this.player, this, this.blockEntity);
                gui.buildGui();
                gui.open();
            } else {
                StarpathTargetGui gui = new StarpathTargetGui(this.player, this.blockEntity, true, this, obj -> this.blockEntity.setTarget((class_2338)obj));
                gui.open();
            }
        } else if (index == 4) {
            if (this.blockEntity.getCooldown() <= 0) {
                if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)StarpathAltarBlockEntity.COST, (int)this.blockEntity.calculateCost())) {
                    this.blockEntity.startTeleport(this.player);
                    this.close();
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)StarpathAltarBlockEntity.COST.method_7876()).method_27695(new class_124[]{class_124.field_1062, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" to power the Altar").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056})), false);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                    this.close();
                }
            } else {
                this.player.method_7353((class_2561)class_2561.method_43470((String)"The Altar is on Cooldown").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                this.close();
            }
        }
        return true;
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled() || this.blockEntity.isActive()) {
            this.close();
        }
        this.build();
    }

    public void build() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clearSlot(i);
            this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)1704246)).setName((class_2561)class_2561.method_43470((String)"Starpath Altar").method_27692(class_124.field_1064)));
        }
        GuiElementBuilder cooldownItem = new GuiElementBuilder(class_1802.field_8557).hideDefaultTooltip();
        if (this.blockEntity.getCooldown() <= 0) {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Ready").method_27692(class_124.field_1075)));
        } else {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Recharging").method_27692(class_124.field_1062)));
            cooldownItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.blockEntity.getCooldown() / 20 + " Seconds")).method_27692(class_124.field_1080))));
        }
        this.setSlot(0, (GuiElementBuilderInterface)cooldownItem);
        class_2338 target = this.blockEntity.getTarget();
        GuiElementBuilder locationItem = new GuiElementBuilder(class_1802.field_8204).hideDefaultTooltip();
        locationItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Target Location").method_27692(class_124.field_1065)));
        locationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("X: " + target.method_10263())).method_27692(class_124.field_1054))));
        locationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Y: " + target.method_10264())).method_27692(class_124.field_1054))));
        locationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Z: " + target.method_10260())).method_27692(class_124.field_1054))));
        if (this.stargate) {
            locationItem.addLoreLine((class_2561)class_2561.method_43470((String)"Dimension: ").method_27692(class_124.field_1054).method_10852((class_2561)ArcanaUtils.getFormattedDimName(this.blockEntity.getTargetDimension())));
        }
        locationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1054))));
        locationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click to Change Target").method_27692(class_124.field_1054))));
        this.setSlot(2, (GuiElementBuilderInterface)locationItem);
        int cost = this.blockEntity.calculateCost();
        int stacks = cost / 64;
        int leftover = cost % 64;
        GuiElementBuilder activateItem = new GuiElementBuilder(StarpathAltarBlockEntity.COST);
        activateItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Activate Altar").method_27692(class_124.field_1076)));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click to travel the Star's Path").method_27692(class_124.field_1064))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1064))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This Journey Costs: ").method_27692(class_124.field_1075))));
        class_5250 text = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("" + cost)).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43471((String)StarpathAltarBlockEntity.COST.method_7876()).method_27692(class_124.field_1062));
        if (cost > StarpathAltarBlockEntity.COST.method_7882()) {
            text.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1064));
            if (cost > 0) {
                text.method_27693("(" + stacks + " Stacks + " + leftover + ")").method_27692(class_124.field_1054);
            } else {
                text.method_27693("(" + stacks + " Stacks)").method_27692(class_124.field_1054);
            }
        }
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)text));
        this.setSlot(4, (GuiElementBuilderInterface)activateItem);
    }

    public void close() {
        super.close();
    }
}

