/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.midnightenchanter;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.ArcaneSingularityBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.MidnightEnchanterBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.gui.VirtualInventoryGui;
import net.borisshoes.arcananovum.gui.midnightenchanter.MidnightEnchanterInventoryListener;
import net.borisshoes.arcananovum.gui.midnightenchanter.MidnightEnchanterSlot;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;

public class MidnightEnchanterGui
extends VirtualInventoryGui<class_1277> {
    private final MidnightEnchanterBlockEntity blockEntity;
    private MidnightEnchanterInventoryListener listener;
    private class_1799 stack = class_1799.field_8037;
    private int page = 1;
    private int maxPages = 1;
    private int xpCost = 0;
    private int essenceCost = 0;
    private int bookshelves = -1;
    private int lapisLevel = 0;
    private List<EnchantEntry> enchants = new ArrayList<EnchantEntry>();

    public MidnightEnchanterGui(class_3222 player, MidnightEnchanterBlockEntity blockEntity) {
        super(class_3917.field_17327, player, false);
        this.blockEntity = blockEntity;
        this.setTitle((class_2561)class_2561.method_43470((String)"Midnight Enchanter"));
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean precision;
        class_1937 class_19372 = this.blockEntity.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return true;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        boolean enchanted = class_1890.method_58117((class_1799)this.stack);
        boolean bl = precision = ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.PRECISION_DISENCHANTING.id) >= 1;
        if (index == 49) {
            if (this.stack.method_7923() && !enchanted && this.bookshelves >= 0) {
                if (this.lapisLevel == -1) {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You must select a Lapis Level").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                    return true;
                }
                if (this.player.field_7520 < this.xpCost && !this.player.method_68878()) {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough levels").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                    return true;
                }
                if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)class_1802.field_8759, (int)this.lapisLevel)) {
                    this.player.method_7286(this.stack, 0);
                    this.applyEnchants();
                    this.removeXP(this.lapisLevel);
                    MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15119, (float)1.0f, (float)((float)(Math.random() * (double)0.4f + (double)0.8f)));
                    this.listener.setUpdating();
                    ((class_1277)this.inventory).method_5447(0, class_1799.field_8037);
                    this.setItem(class_1799.field_8037);
                    this.listener.finishUpdate();
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)class_1802.field_8759.method_7876()).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056})), false);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                }
            } else if (this.stack.method_31574(ArcanaRegistry.EMPOWERED_ARCANE_PAPER)) {
                if (this.player.field_7520 >= this.xpCost || this.player.method_68878()) {
                    if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)ArcanaRegistry.NEBULOUS_ESSENCE, (int)this.essenceCost)) {
                        this.listener.setUpdating();
                        class_1799 newStack = new class_1799((class_1935)ArcanaRegistry.EXOTIC_ARCANE_PAPER);
                        newStack.method_7939(this.stack.method_7947());
                        ((class_1277)this.inventory).method_5447(0, newStack);
                        this.removeXP(this.xpCost);
                        SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15119, (float)1.0f, (float)((float)(Math.random() * (double)0.4f + (double)0.8f)));
                        MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                        ((class_1277)this.inventory).method_5447(0, class_1799.field_8037);
                        this.setItem(class_1799.field_8037);
                        this.listener.finishUpdate();
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)ArcanaRegistry.NEBULOUS_ESSENCE.method_7876()).method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})), false);
                        SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                    }
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough levels").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                }
            } else {
                if (this.getSelected().isEmpty()) {
                    return true;
                }
                if (this.player.field_7520 >= this.xpCost || this.player.method_68878()) {
                    if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)ArcanaRegistry.NEBULOUS_ESSENCE, (int)this.essenceCost)) {
                        this.applyEnchants();
                        this.removeXP(this.xpCost);
                        SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15119, (float)1.0f, (float)((float)(Math.random() * (double)0.4f + (double)0.8f)));
                        MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                        this.listener.setUpdating();
                        ((class_1277)this.inventory).method_5447(0, class_1799.field_8037);
                        this.setItem(class_1799.field_8037);
                        this.listener.finishUpdate();
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)ArcanaRegistry.NEBULOUS_ESSENCE.method_7876()).method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})), false);
                        SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                    }
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough levels").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                }
            }
            this.buildGui();
        } else if (index == 27) {
            this.prevPage();
            this.buildGui();
        } else if (index == 35) {
            this.nextPage();
            this.buildGui();
        } else if (index == 6 && precision && enchanted) {
            if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)class_1802.field_8529, (int)1)) {
                class_1799 book = new class_1799((class_1935)class_1802.field_8598);
                if (type == ClickType.MOUSE_RIGHT || type == ClickType.MOUSE_RIGHT_SHIFT) {
                    class_9304 comp = class_1890.method_57532((class_1799)this.stack);
                    class_1890.method_57530((class_1799)book, (class_9304)comp);
                    this.disenchantItem();
                } else {
                    class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_9304.field_49385);
                    class_3545<class_6880<class_1887>, Integer> entry = this.removeTopEnchant();
                    enchantBuilder.method_57550((class_6880)entry.method_15442(), ((Integer)entry.method_15441()).intValue());
                    class_1890.method_57530((class_1799)book, (class_9304)enchantBuilder.method_57549());
                }
                class_1277 sinv = new class_1277(new class_1799[]{book});
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15119, (float)1.0f, (float)((float)(Math.random() * (double)0.4f + (double)0.8f)));
                MinecraftUtils.returnItems((class_1263)sinv, (class_1657)this.player);
            } else {
                this.player.method_7353((class_2561)class_2561.method_43470((String)"You need a book to put the enchants on").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
            }
            this.buildGui();
        } else if (index == 7) {
            if (enchanted) {
                int essence;
                class_1277 sinv = new class_1277(essence / 64 + 1);
                ArcanaNovum.data((class_1657)this.player).addXP(ArcanaConfig.getInt(ArcanaRegistry.MIDNIGHT_ENCHANTER_DISENCHANT_PER_ESSENCE) * essence);
                if (essence > 0) {
                    for (essence = (int)((double)ArcanaUtils.calcEssenceFromEnchants(this.stack) * (1.0 + 0.15 * (double)ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.ESSENCE_SUPERNOVA.id))); essence > 64; essence -= 64) {
                        sinv.method_5491(ArcanaRegistry.NEBULOUS_ESSENCE.method_7854().method_46651(64));
                    }
                    if (essence > 0) {
                        sinv.method_5491(ArcanaRegistry.NEBULOUS_ESSENCE.method_7854().method_46651(essence));
                    }
                }
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15119, (float)1.0f, (float)((float)(Math.random() * (double)0.4f + (double)0.8f)));
                MinecraftUtils.returnItems((class_1263)sinv, (class_1657)this.player);
                int maxCount = 0;
                class_9304 comp = class_1890.method_57532((class_1799)this.stack);
                for (Object2IntMap.Entry entry : comp.method_57539()) {
                    if (entry.getIntValue() != ((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183()) continue;
                    ++maxCount;
                }
                if (maxCount >= 5) {
                    ArcanaAchievements.grant(this.player, ArcanaAchievements.MASTERPIECE_TO_NOTHING.id);
                }
                this.disenchantItem();
            } else {
                if (type == ClickType.MOUSE_LEFT_SHIFT) {
                    this.bookshelves = -1;
                } else if (type == ClickType.MOUSE_RIGHT) {
                    if (this.bookshelves == -1) {
                        this.bookshelves = 15;
                    } else if (this.bookshelves > -1) {
                        --this.bookshelves;
                    }
                } else {
                    this.bookshelves = this.bookshelves == 15 ? -1 : ++this.bookshelves;
                }
                this.enchants = this.getEnchantsForItem(this.stack);
                this.lapisLevel = -1;
                this.xpCost = -1;
            }
            this.buildGui();
        } else if (index == 8 && precision && enchanted) {
            ArcaneSingularityBlockEntity singularity;
            StarlightForgeBlockEntity forge = StarlightForge.findActiveForge(serverWorld, this.blockEntity.method_11016());
            if (forge != null && (singularity = (ArcaneSingularityBlockEntity)forge.getForgeAddition(serverWorld, ArcanaRegistry.ARCANE_SINGULARITY_BLOCK_ENTITY)) != null) {
                if (singularity.getNumBooks() < singularity.getCapacity()) {
                    if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)class_1802.field_8529, (int)1)) {
                        class_1799 book = new class_1799((class_1935)class_1802.field_8598);
                        if (type == ClickType.MOUSE_RIGHT || type == ClickType.MOUSE_RIGHT_SHIFT) {
                            class_9304 comp = class_1890.method_57532((class_1799)this.stack);
                            class_1890.method_57530((class_1799)book, (class_9304)comp);
                            this.disenchantItem();
                        } else {
                            class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_9304.field_49385);
                            class_3545<class_6880<class_1887>, Integer> entry = this.removeTopEnchant();
                            enchantBuilder.method_57550((class_6880)entry.method_15442(), ((Integer)entry.method_15441()).intValue());
                            class_1890.method_57530((class_1799)book, (class_9304)enchantBuilder.method_57549());
                        }
                        singularity.addBook(book);
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You need a book to put the enchants on").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                    }
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"The Singularity does not have enough space").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                }
            } else {
                this.player.method_7353((class_2561)class_2561.method_43470((String)"The Enchanter's Forge does not have access to a Singularity").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
            }
            this.buildGui();
        } else if (index % 9 > 0 && index % 9 < 8 && index > 18 && index < 44) {
            if (this.stack.method_7923() && !enchanted && this.bookshelves >= 0) {
                int row = index / 9 - 1;
                if (this.getSlot(index) != null && (this.getSlot(index).getItemStack().method_31574(class_1802.field_8598) || this.getSlot(index).getItemStack().method_31574(class_1802.field_8759))) {
                    this.lapisLevel = row;
                }
                this.buildGui();
            } else {
                int ind = 7 * (index / 9 - 2) + (index % 9 - 1) + 21 * (this.page - 1);
                if (ind >= this.enchants.size()) {
                    return true;
                }
                EnchantEntry entry = this.enchants.get(ind);
                if (this.isCompatible(entry.enchantment, entry.level)) {
                    this.enchants.set(ind, new EnchantEntry(entry.enchantment, entry.level, !entry.selected));
                    this.calculateXPCost();
                    this.buildGui();
                }
            }
        }
        return true;
    }

    public void buildGui() {
        boolean precision = ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.PRECISION_DISENCHANTING.id) >= 1;
        boolean paperUpgrade = this.stack.method_31574(ArcanaRegistry.EMPOWERED_ARCANE_PAPER);
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        this.clearSlot(4);
        if (this.inventory == null) {
            this.inventory = new class_1277(1);
        }
        this.setSlotRedirect(4, new MidnightEnchanterSlot(this.inventory, 0, 0, 0));
        if (this.listener == null) {
            this.listener = new MidnightEnchanterInventoryListener(this, this.blockEntity);
            ((class_1277)this.inventory).method_5489((class_1265)this.listener);
        }
        boolean enchanted = class_1890.method_58117((class_1799)this.stack);
        class_5250 name = this.stack.method_7960() ? class_2561.method_43470((String)"Insert an Enchanted or Enchantable Item").method_27692(class_124.field_1064) : class_2561.method_43470((String)"Add Enchantments or Disenchant Your Item").method_27692(class_124.field_1076);
        int color = this.stack.method_7960() ? 2756918 : 478174;
        for (int i = 0; i < 9; ++i) {
            if (i == 0) {
                this.setSlot(i + 9, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)color)).hideDefaultTooltip().setName((class_2561)name));
                continue;
            }
            if (i == 8) {
                this.setSlot(i + 9, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)color)).hideDefaultTooltip().setName((class_2561)name));
                continue;
            }
            if (i == 3) {
                this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP_RIGHT, (int)color)).hideDefaultTooltip().setName((class_2561)name));
                this.setSlot(i + 9, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_BOTTOM_CONNECTOR, (int)color)).hideDefaultTooltip().setName((class_2561)name));
                continue;
            }
            if (i == 5) {
                this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP_LEFT, (int)color)).hideDefaultTooltip().setName((class_2561)name));
                this.setSlot(i + 9, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_BOTTOM_CONNECTOR, (int)color)).hideDefaultTooltip().setName((class_2561)name));
                continue;
            }
            this.setSlot(i + 9, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_HORIZONTAL, (int)color)).hideDefaultTooltip().setName((class_2561)name));
        }
        if (this.maxPages > 1 && (!this.stack.method_7923() || enchanted || this.bookshelves < 0)) {
            GuiElementBuilder nextArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW)).hideDefaultTooltip();
            nextArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Page").method_27692(class_124.field_1065)));
            nextArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + this.maxPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(35, (GuiElementBuilderInterface)nextArrow);
            GuiElementBuilder prevArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW)).hideDefaultTooltip();
            prevArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Prev Page").method_27692(class_124.field_1065)));
            prevArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + this.maxPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(27, (GuiElementBuilderInterface)prevArrow);
        }
        if (enchanted) {
            essenceItem = GuiElementBuilder.from((class_1799)MinecraftUtils.removeLore((class_1799)ArcanaRegistry.NEBULOUS_ESSENCE.method_7854())).hideDefaultTooltip();
            essenceItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Disenchant into Essence").method_27692(class_124.field_1062)));
            essenceItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to disenchant this item").method_27692(class_124.field_1064))));
            this.setSlot(7, (GuiElementBuilderInterface)essenceItem);
            if (precision) {
                GuiElementBuilder disenchantBookItem = new GuiElementBuilder(class_1802.field_8529).hideDefaultTooltip();
                disenchantBookItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Disenchant onto a Book").method_27692(class_124.field_1078)));
                disenchantBookItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to move the top enchant to a book").method_27692(class_124.field_1064))));
                disenchantBookItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to move all enchants to a book").method_27692(class_124.field_1064))));
                this.setSlot(6, (GuiElementBuilderInterface)disenchantBookItem);
                GuiElementBuilder singularityItem = new GuiElementBuilder(class_1802.field_16312).hideDefaultTooltip();
                singularityItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Disenchant into a Singularity").method_27692(class_124.field_1076)));
                singularityItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to move the top enchant to a Singularity").method_27692(class_124.field_1064))));
                singularityItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to move all enchants to a Singularity").method_27692(class_124.field_1064))));
                this.setSlot(8, (GuiElementBuilderInterface)singularityItem);
            }
        } else if (paperUpgrade) {
            GuiElementBuilder exoticPaper = GuiElementBuilder.from((class_1799)MinecraftUtils.removeLore((class_1799)ArcanaRegistry.EXOTIC_ARCANE_PAPER.method_7854()));
            this.setSlot(7, (GuiElementBuilderInterface)exoticPaper);
        } else {
            if (this.bookshelves < 0) {
                essenceItem = new GuiElementBuilder(class_1802.field_8449).hideDefaultTooltip();
                essenceItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Enlightened Enchantment").method_27692(class_124.field_1062)));
                essenceItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Choose").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" your enchantments").method_27692(class_124.field_1064))));
                essenceItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Regular Enchantment").method_27692(class_124.field_1078))));
            } else {
                essenceItem = this.bookshelves == 0 ? new GuiElementBuilder(class_1802.field_40215).hideDefaultTooltip().setCount(1) : new GuiElementBuilder(class_1802.field_8536).hideDefaultTooltip().setCount(this.bookshelves);
                essenceItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Regular Enchantment").method_27692(class_124.field_1078)));
                essenceItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("" + this.bookshelves)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" Bookshelves").method_27692(class_124.field_1064))));
                essenceItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Left Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to increase bookshelves").method_27692(class_124.field_1064))));
                essenceItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to decrease bookshelves").method_27692(class_124.field_1064))));
                essenceItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Enlightened Enchantment").method_27692(class_124.field_1062))));
            }
            this.setSlot(7, (GuiElementBuilderInterface)essenceItem);
        }
        if (this.stack.method_7923() && !enchanted && this.bookshelves >= 0) {
            int i;
            for (int i2 = 19; i2 < 26; ++i2) {
                GuiElementBuilder bgPane2 = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918)).hideDefaultTooltip();
                bgPane2.setName((class_2561)class_2561.method_43473()).hideTooltip();
                this.setSlot(i2, (GuiElementBuilderInterface)bgPane2);
                this.setSlot(i2 + 9, (GuiElementBuilderInterface)bgPane2);
                this.setSlot(i2 + 18, (GuiElementBuilderInterface)bgPane2);
            }
            this.setSlot(11, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP_CONNECTOR, (int)color)).hideDefaultTooltip().setName((class_2561)name));
            this.setSlot(20, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_VERTICAL, (int)(this.lapisLevel == 1 ? 51450 : color))).hideDefaultTooltip().setName((class_2561)name));
            this.setSlot(29, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_VERTICAL, (int)(this.lapisLevel == 2 ? 51450 : color))).hideDefaultTooltip().setName((class_2561)name));
            this.setSlot(38, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_VERTICAL, (int)(this.lapisLevel == 3 ? 51450 : color))).hideDefaultTooltip().setName((class_2561)name));
            this.setSlot(47, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_BOTTOM_CONNECTOR, (int)7996617)).hideTooltip());
            class_5819 random = class_5819.method_43047();
            int playerSeed = this.player.method_7278();
            random.method_43052((long)playerSeed);
            int[] enchPowers = new int[3];
            for (i = 0; i < enchPowers.length; ++i) {
                enchPowers[i] = class_1890.method_8227((class_5819)random, (int)i, (int)this.bookshelves, (class_1799)this.stack);
            }
            for (i = 0; i < enchPowers.length; ++i) {
                List<class_1889> list;
                if (enchPowers[i] < i + 1 || (list = this.generateEnchantments(this.stack, i, enchPowers[i], random, playerSeed)) == null || list.isEmpty()) continue;
                GuiElementBuilder lapisItem = new GuiElementBuilder(class_1802.field_8759).hideDefaultTooltip().setCount(i + 1);
                lapisItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Slot " + (i + 1))).method_27692(class_124.field_1078)));
                if (this.lapisLevel == i + 1) {
                    lapisItem.glow();
                    lapisItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Selected").method_27692(class_124.field_1075))));
                    this.setSelectedFromList(list);
                    this.xpCost = enchPowers[i];
                } else {
                    lapisItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to select").method_27692(class_124.field_1064))));
                }
                this.setSlot(19 + i * 9, (GuiElementBuilderInterface)lapisItem);
                for (int j = 0; j < list.size() && j < 5; ++j) {
                    class_1889 entry = list.get(j);
                    GuiElementBuilder enchantBook = new GuiElementBuilder(class_1802.field_8598).hideDefaultTooltip();
                    enchantBook.glow(false);
                    enchantBook.setName((class_2561)class_2561.method_43470((String)"").method_10852(class_1887.method_8179((class_6880)entry.comp_3486(), (int)entry.comp_3487())).method_27692(class_124.field_1075));
                    if (this.lapisLevel == i + 1) {
                        enchantBook.glow();
                        enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Selected").method_27692(class_124.field_1075))));
                    }
                    this.setSlot(21 + i * 9 + j, (GuiElementBuilderInterface)enchantBook);
                }
            }
        } else if (paperUpgrade) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.setSlot(i * 9 + 19 + j, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918)).hideTooltip());
                }
            }
            this.xpCost = 10;
            this.essenceCost = this.stack.method_7947();
        } else {
            List<EnchantEntry> pageItems = this.getPage();
            int k = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 7; ++j) {
                    if (k < pageItems.size()) {
                        EnchantEntry pageItem = pageItems.get(k);
                        GuiElementBuilder enchantBook = new GuiElementBuilder(pageItem.selected ? class_1802.field_8598 : class_1802.field_8360).glow().hideDefaultTooltip();
                        enchantBook.setName((class_2561)class_2561.method_43470((String)"").method_10852(class_1887.method_8179(pageItem.enchantment, (int)pageItem.level)).method_27692(class_124.field_1075));
                        if (pageItem.selected) {
                            enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Selected").method_27692(class_124.field_1054)));
                            enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_27692(class_124.field_1054)));
                        }
                        if (this.isCompatible(pageItem.enchantment, pageItem.level)) {
                            enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to toggle selection").method_27692(class_124.field_1064))));
                        } else {
                            enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Incompatible Enchant").method_27692(class_124.field_1061)));
                        }
                        this.setSlot(i * 9 + 19 + j, (GuiElementBuilderInterface)enchantBook);
                    } else {
                        this.setSlot(i * 9 + 19 + j, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)(this.stack.method_7960() ? 2756918 : 478174))).setName((class_2561)class_2561.method_43473()).hideTooltip());
                    }
                    ++k;
                }
            }
        }
        List<EnchantEntry> selected = this.getSelected();
        GuiElementBuilder enchantItem = new GuiElementBuilder(class_1802.field_8657).hideDefaultTooltip();
        if (paperUpgrade) {
            enchantItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Enchant Exotic Arcane Paper").method_27692(class_124.field_1076)));
            enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to upgrade your Arcane Paper").method_27692(class_124.field_1064))));
        } else {
            enchantItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Enchant ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43471((String)this.stack.method_7909().method_7876()).method_27692(class_124.field_1076)));
            enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to enchant the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43471((String)this.stack.method_7909().method_7876()).method_27692(class_124.field_1064))));
        }
        if (!selected.isEmpty()) {
            enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43473()));
            enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Adding: ").method_27692(class_124.field_1064)));
            for (EnchantEntry entry : selected) {
                enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852(class_1887.method_8179(entry.enchantment, (int)entry.level)).method_27692(class_124.field_1075)));
            }
            enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43473()));
            enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Costs: ").method_27692(class_124.field_1076)));
            if (this.xpCost > 0 && (!selected.isEmpty() || paperUpgrade)) {
                enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.xpCost + " Levels")).method_27692(class_124.field_1077))));
                if (this.stack.method_7923() && !enchanted && this.bookshelves >= 0) {
                    enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.lapisLevel + " Lapis Lazuli")).method_27692(class_124.field_1078))));
                } else {
                    enchantItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.essenceCost + " Nebulous Essence")).method_27692(class_124.field_1064))));
                }
            }
        }
        GuiElementBuilder xpItem = new GuiElementBuilder(class_1802.field_8287).hideDefaultTooltip();
        String costStr = this.bookshelves >= 0 && !paperUpgrade ? "Lapis" : "Essence";
        xpItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("XP & " + costStr + " Cost")).method_27692(class_124.field_1060)));
        if (this.xpCost > 0 && (!selected.isEmpty() || paperUpgrade)) {
            xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.xpCost + " Levels")).method_27692(class_124.field_1077))));
            if (this.stack.method_7923() && !enchanted && this.bookshelves >= 0) {
                xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.lapisLevel + " Lapis Lazuli")).method_27692(class_124.field_1078))));
            } else {
                xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.essenceCost + " Nebulous Essence")).method_27692(class_124.field_1064))));
            }
        } else {
            xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Select Enchantments").method_27692(class_124.field_1077))));
        }
        this.setSlot(49, (GuiElementBuilderInterface)enchantItem);
        this.setSlot(1, (GuiElementBuilderInterface)xpItem);
    }

    private void removeXP(int levels) {
        boolean expertise;
        boolean bl = expertise = ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.ENCHANTING_EXPERTISE.id) > 0;
        if (this.player.method_68878()) {
            return;
        }
        int points = LevelUtils.vanillaLevelToTotalXp(levels);
        if (expertise) {
            this.player.method_7255(-points);
        } else {
            this.player.method_7316(-levels);
        }
    }

    private boolean isCompatible(class_6880<class_1887> enchant, int level) {
        class_9304 comp = class_1890.method_57532((class_1799)this.stack);
        Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
        comp.method_57539().forEach(entry -> enchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
        boolean upgrade = comp.method_57534().contains(enchant) && comp.method_57536(enchant) < level;
        for (EnchantEntry entry2 : this.getSelected()) {
            enchants.addTo(entry2.enchantment(), entry2.level());
            if (entry2.enchantment().comp_349() == enchant.comp_349() && entry2.level() != level && upgrade) {
                return false;
            }
            if (entry2.enchantment().comp_349() != enchant.comp_349() || entry2.level() != level) continue;
            return true;
        }
        if (upgrade) {
            return true;
        }
        return class_1890.method_8201((Collection)enchants.keySet(), enchant);
    }

    private void applyEnchants() {
        this.listener.setUpdating();
        class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_1890.method_57532((class_1799)this.stack));
        for (EnchantEntry entry : this.getSelected()) {
            enchantBuilder.method_57548(e -> e == entry.enchantment());
            enchantBuilder.method_57550(entry.enchantment(), entry.level());
            if (entry.level != 1 || ((class_1887)entry.enchantment().comp_349()).method_8183() <= 1) continue;
            ArcanaAchievements.grant(this.player, ArcanaAchievements.ENCHANTING_OVERKILL.id);
        }
        if (this.stack.method_31574(class_1802.field_8529)) {
            this.stack = this.stack.method_60503((class_1935)class_1802.field_8598);
        }
        class_1890.method_57530((class_1799)this.stack, (class_9304)enchantBuilder.method_57549());
        ((class_1277)this.inventory).method_5447(0, this.stack);
        this.listener.finishUpdate();
    }

    private void disenchantItem() {
        this.listener.setUpdating();
        class_1890.method_57531((class_1799)this.stack, components -> components.method_57548(enchantment -> true));
        if (this.stack.method_31574(class_1802.field_8598)) {
            this.stack = this.stack.method_60503((class_1935)class_1802.field_8529);
        }
        if (ArcanaItemUtils.isArcane(this.stack)) {
            ArcanaItemUtils.identifyItem(this.stack).buildItemLore(this.stack, BorisLib.SERVER);
        }
        ((class_1277)this.inventory).method_5447(0, this.stack);
        this.listener.finishUpdate();
    }

    private class_3545<class_6880<class_1887>, Integer> removeTopEnchant() {
        class_9304 comp = class_1890.method_57532((class_1799)this.stack);
        Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
        comp.method_57539().forEach(entry -> enchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
        if (enchants.size() == 1) {
            this.disenchantItem();
            ObjectIterator objectIterator = enchants.keySet().iterator();
            if (objectIterator.hasNext()) {
                class_6880 entry2 = (class_6880)objectIterator.next();
                return new class_3545((Object)entry2, (Object)enchants.getInt((Object)entry2));
            }
        }
        this.listener.setUpdating();
        class_6885 registryEntryList = null;
        Optional optional = this.player.method_56673().method_30530(class_7924.field_41265).method_46733(class_9636.field_51362);
        if (optional.isPresent()) {
            registryEntryList = (class_6885)optional.get();
        }
        class_6880 registryEntry = null;
        int value = 0;
        int index = Integer.MAX_VALUE;
        ObjectIterator iter = enchants.object2IntEntrySet().fastIterator();
        while (iter.hasNext()) {
            Object2IntMap.Entry entry3 = (Object2IntMap.Entry)iter.next();
            if (registryEntryList == null) {
                registryEntry = (class_6880)entry3.getKey();
                value = entry3.getIntValue();
                iter.remove();
                break;
            }
            for (int i = 0; i < registryEntryList.method_40247(); ++i) {
                if (registryEntryList.method_40240(i).comp_349() != ((class_6880)entry3.getKey()).comp_349() || i >= index) continue;
                index = i;
                registryEntry = (class_6880)entry3.getKey();
                value = entry3.getIntValue();
            }
        }
        if (index != Integer.MAX_VALUE && registryEntry != null) {
            class_6880 finalRegistryEntry = registryEntry;
            int finalValue = value;
            enchants.object2IntEntrySet().removeIf(e -> ((class_6880)e.getKey()).comp_349() == finalRegistryEntry.comp_349() && finalValue == e.getIntValue());
        }
        class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_9304.field_49385);
        enchants.forEach((arg_0, arg_1) -> ((class_9304.class_9305)enchantBuilder).method_57550(arg_0, arg_1));
        class_1890.method_57530((class_1799)this.stack, (class_9304)enchantBuilder.method_57549());
        ((class_1277)this.inventory).method_5447(0, this.stack);
        this.listener.finishUpdate();
        return new class_3545((Object)registryEntry, (Object)value);
    }

    public void setItem(class_1799 stack) {
        this.lapisLevel = -1;
        this.enchants = this.getEnchantsForItem(stack);
        this.page = 1;
        this.maxPages = (int)Math.ceil((double)this.enchants.size() / 21.0);
        this.stack = stack.method_7972();
        this.calculateXPCost();
    }

    private void setSelectedFromList(List<class_1889> entries) {
        this.enchants = new ArrayList<EnchantEntry>();
        class_2378 impl = this.player.method_56673().method_30530(class_7924.field_41265);
        entries.forEach(arg_0 -> this.lambda$setSelectedFromList$6((class_7225.class_7226)impl, arg_0));
    }

    public void calculateXPCost() {
        int rarityMod;
        boolean paperUpgrade = this.stack.method_31574(ArcanaRegistry.EMPOWERED_ARCANE_PAPER);
        int cost = 0;
        int eCost = 0;
        if (paperUpgrade) {
            this.xpCost = 10;
            this.essenceCost = this.stack.method_7947();
            return;
        }
        class_9304 comp = class_1890.method_57532((class_1799)this.stack);
        Object2IntOpenHashMap curEnchants = new Object2IntOpenHashMap();
        comp.method_57539().forEach(entry -> curEnchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
        for (class_6880 class_68802 : curEnchants.keySet()) {
            rarityMod = ((class_1887)class_68802.comp_349()).method_58446();
            if (class_68802.method_40220(class_9636.field_51557)) {
                rarityMod *= 2;
            }
            cost += curEnchants.getInt((Object)class_68802) * rarityMod;
        }
        cost /= 2;
        for (EnchantEntry enchantEntry : this.getSelected()) {
            rarityMod = ((class_1887)enchantEntry.enchantment().comp_349()).method_58446();
            if (enchantEntry.enchantment().method_40220(class_9636.field_51557)) {
                rarityMod *= 2;
            }
            cost += enchantEntry.level() * rarityMod;
            eCost += (int)Math.ceil((double)ArcanaUtils.calcEssenceValue(enchantEntry.enchantment(), enchantEntry.level()) * 1.5);
        }
        this.essenceCost = eCost;
        this.xpCost = cost;
    }

    public void nextPage() {
        if (this.page < this.maxPages) {
            ++this.page;
        }
    }

    public void prevPage() {
        if (this.page > 1) {
            --this.page;
        }
    }

    private List<EnchantEntry> getSelected() {
        return this.enchants.stream().filter(e -> e.selected).toList();
    }

    private List<EnchantEntry> getPage() {
        ArrayList<EnchantEntry> pageItems = new ArrayList<EnchantEntry>();
        for (int i = (this.page - 1) * 21; i < this.page * 21 && i < this.enchants.size(); ++i) {
            pageItems.add(this.enchants.get(i));
        }
        return pageItems;
    }

    private List<EnchantEntry> getEnchantsForItem(class_1799 stack) {
        if (stack.method_7960()) {
            return new ArrayList<EnchantEntry>();
        }
        class_9304 comp = class_1890.method_57532((class_1799)stack);
        Object2IntOpenHashMap curEnchants = new Object2IntOpenHashMap();
        comp.method_57539().forEach(entry -> curEnchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
        ArrayList<EnchantEntry> possibleAdditions = new ArrayList<EnchantEntry>();
        for (class_6880 entry2 : this.player.method_51469().method_30349().method_30530(class_7924.field_41265).method_40295()) {
            class_1887 enchantment = (class_1887)entry2.comp_349();
            if (!class_1890.method_8201((Collection)curEnchants.keySet(), (class_6880)entry2) && !curEnchants.containsKey((Object)entry2) || !stack.method_31574(class_1802.field_8529) && !enchantment.method_60046(stack)) continue;
            if (curEnchants.containsKey((Object)entry2)) {
                int maxLevel;
                int curLevel = curEnchants.getInt((Object)entry2);
                if (curLevel >= (maxLevel = enchantment.method_8183())) continue;
                for (int i = curLevel + 1; i <= maxLevel; ++i) {
                    possibleAdditions.add(new EnchantEntry((class_6880<class_1887>)entry2, i, false));
                }
                continue;
            }
            for (int i = enchantment.method_8187(); i <= enchantment.method_8183(); ++i) {
                possibleAdditions.add(new EnchantEntry((class_6880<class_1887>)entry2, i, false));
            }
        }
        return possibleAdditions;
    }

    private List<class_1889> generateEnchantments(class_1799 stack, int slot, int level, class_5819 random, int playerSeed) {
        random.method_43052((long)(playerSeed + slot));
        Optional optional = this.player.method_51469().method_30349().method_30530(class_7924.field_41265).method_46733(class_9636.field_51547);
        if (optional.isEmpty()) {
            return List.of();
        }
        List list = class_1890.method_8230((class_5819)random, (class_1799)stack, (int)level, (Stream)((class_6885.class_6888)optional.get()).method_40239());
        if (stack.method_31574(class_1802.field_8529) && list.size() > 1) {
            list.remove(random.method_43048(list.size()));
        }
        return list;
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled()) {
            this.close();
        }
        super.onTick();
    }

    @Override
    public void onClose() {
        MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
        super.onClose();
    }

    public void close() {
        super.close();
    }

    private /* synthetic */ void lambda$setSelectedFromList$6(class_7225.class_7226 impl, class_1889 e) {
        this.enchants.add(new EnchantEntry((class_6880<class_1887>)impl.method_46747((class_5321)e.comp_3486().method_40230().get()), e.comp_3487(), true));
    }

    private record EnchantEntry(class_6880<class_1887> enchantment, int level, boolean selected) {
    }
}

