/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.spawnerinfuser;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Arrays;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.SpawnerInfuser;
import net.borisshoes.arcananovum.blocks.SpawnerInfuserBlockEntity;
import net.borisshoes.arcananovum.gui.SoulstoneSlot;
import net.borisshoes.arcananovum.gui.spawnerinfuser.SpawnerInfuserPointsSlot;
import net.borisshoes.arcananovum.items.Soulstone;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class SpawnerInfuserGui
extends SimpleGui {
    private final SpawnerInfuserBlockEntity blockEntity;
    private final class_1937 world;
    private final int[] minSpeedLvls = new int[]{20, 30, 40, 50, 75, 100, 125, 150, 175, 200, 300, 400, 500, 1000, 2000, 3000, 4000, 5000, 10000, 25000};
    private final int[] minSpeedPoints = new int[]{256, 128, 96, 64, 32, 16, 8, 4, 2, 0, 1, 2, 4, 6, 8, 10, 12, 14, 16, 20};
    private final int[] maxSpeedLvls = new int[]{30, 40, 50, 75, 100, 125, 150, 175, 200, 300, 400, 500, 800, 1000, 2000, 3000, 4000, 5000, 10000, 25000};
    private final int[] maxSpeedPoints = new int[]{256, 192, 128, 96, 64, 48, 32, 16, 8, 4, 2, 1, 0, 1, 2, 4, 6, 8, 10, 12};
    private final int[] spawnRangeLvls = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final int[] spawnRangePoints = new int[]{8, 4, 2, 0, 1, 2, 4, 8, 12, 16, 24, 32, 48, 64, 96};
    private final int[] playerRangeLvls;
    private final int[] playerRangePoints = new int[]{16, 8, 6, 4, 2, 1, 0, 1, 2, 4, 8, 16, 24, 32, 48, 64, 96, 128, 192, 256};
    private final int[] spawnCountLvls = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private final int[] spawnCountPoints = new int[]{8, 4, 2, 0, 1, 2, 4, 8, 16, 24, 32, 64, 96, 128, 192, 256};
    private final int[] maxEntitiesLvls = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 20, 25, 30, 40, 50};
    private final int[] maxEntitiesPoints = new int[]{16, 8, 4, 2, 1, 0, 1, 2, 4, 8, 16, 32, 64, 96, 128, 192, 256};

    public SpawnerInfuserGui(class_3222 player, SpawnerInfuserBlockEntity blockEntity, class_1937 world) {
        super(class_3917.field_18667, player, false);
        this.blockEntity = blockEntity;
        this.world = world;
        boolean emulator = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.SPIRIT_EMULATOR.id) >= 1;
        this.playerRangeLvls = emulator ? new int[]{2, 5, 8, 10, 12, 14, 16, 18, 20, 22, 25, 30, 35, 40, 45, 50, 60, 75, 90, 9999} : new int[]{2, 5, 8, 10, 12, 14, 16, 18, 20, 22, 25, 30, 35, 40, 45, 50, 60, 75, 90, 100};
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        int[] pointArr;
        int[] lvlArr;
        String nbtKey;
        int[] clickable = new int[]{10, 11, 12, 14, 15, 16, 28, 29, 30, 32, 33, 34};
        if (!Arrays.stream(clickable).boxed().toList().contains(index)) {
            return true;
        }
        if (this.getSlot(index).getItemStack().method_31574(class_1802.field_8615)) {
            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
            return true;
        }
        int points = this.blockEntity.getPoints();
        int spentPoints = this.blockEntity.getSpentPoints();
        class_2487 stats = this.blockEntity.getSpawnerStats();
        boolean increase = true;
        if (index == 10) {
            nbtKey = "MinSpawnDelay";
            lvlArr = this.minSpeedLvls;
            pointArr = this.minSpeedPoints;
        } else if (index == 11) {
            nbtKey = "MaxSpawnDelay";
            lvlArr = this.maxSpeedLvls;
            pointArr = this.maxSpeedPoints;
        } else if (index == 12) {
            nbtKey = "SpawnRange";
            lvlArr = this.spawnRangeLvls;
            pointArr = this.spawnRangePoints;
        } else if (index == 14) {
            nbtKey = "SpawnCount";
            lvlArr = this.spawnCountLvls;
            pointArr = this.spawnCountPoints;
        } else if (index == 15) {
            nbtKey = "MaxNearbyEntities";
            lvlArr = this.maxEntitiesLvls;
            pointArr = this.maxEntitiesPoints;
        } else if (index == 16) {
            nbtKey = "RequiredPlayerRange";
            lvlArr = this.playerRangeLvls;
            pointArr = this.playerRangePoints;
        } else if (index == 28) {
            nbtKey = "MinSpawnDelay";
            lvlArr = this.minSpeedLvls;
            pointArr = this.minSpeedPoints;
            increase = false;
        } else if (index == 29) {
            nbtKey = "MaxSpawnDelay";
            lvlArr = this.maxSpeedLvls;
            pointArr = this.maxSpeedPoints;
            increase = false;
        } else if (index == 30) {
            nbtKey = "SpawnRange";
            lvlArr = this.spawnRangeLvls;
            pointArr = this.spawnRangePoints;
            increase = false;
        } else if (index == 32) {
            nbtKey = "SpawnCount";
            lvlArr = this.spawnCountLvls;
            pointArr = this.spawnCountPoints;
            increase = false;
        } else if (index == 33) {
            nbtKey = "MaxNearbyEntities";
            lvlArr = this.maxEntitiesLvls;
            pointArr = this.maxEntitiesPoints;
            increase = false;
        } else if (index == 34) {
            nbtKey = "RequiredPlayerRange";
            lvlArr = this.playerRangeLvls;
            pointArr = this.playerRangePoints;
            increase = false;
        } else {
            return true;
        }
        short curVal = stats.method_68565(nbtKey, (short)0);
        int ind = this.indexOf(curVal, lvlArr);
        int newInd = increase ? Math.min(ind + 1, pointArr.length - 1) : Math.max(ind - 1, 0);
        int newVal = lvlArr[newInd];
        int pointDif = pointArr[ind] - pointArr[newInd];
        if (spentPoints - pointDif > points) {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"Not Enough Points").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
            return true;
        }
        SoundUtils.playSongToPlayer((class_3222)this.player, (class_6880.class_6883)class_3417.field_14725, (float)1.0f, (float)(0.5f + (float)newInd / (float)(lvlArr.length - 1)));
        this.blockEntity.setSpentPoints(spentPoints - pointDif);
        stats.method_10575(nbtKey, (short)newVal);
        this.blockEntity.setSpawnerStats(stats);
        if (spentPoints - pointDif >= 1) {
            ArcanaAchievements.grant(this.player, ArcanaAchievements.HUMBLE_NECROMANCER.id);
        }
        if (pointArr[newInd] >= 256) {
            ArcanaAchievements.grant(this.player, ArcanaAchievements.SCULK_HUNGERS.id);
        }
        this.blockEntity.refreshGuis();
        return true;
    }

    public void build() {
        boolean usable;
        int points = this.blockEntity.getPoints();
        class_2487 stats = this.blockEntity.getSpawnerStats();
        int spentPoints = this.blockEntity.getSpentPoints();
        boolean hasStone = !this.blockEntity.getSoulstone().method_7960();
        boolean spawnerDetected = this.detectSpawner();
        boolean bl = usable = hasStone && spawnerDetected;
        if (usable) {
            GuiHelper.outlineGUI((SimpleGui)this, (int)681511, (class_2561)class_2561.method_43470((String)"Use the arrows to configure the Infusion").method_27692(class_124.field_1060), List.of(TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Apply a ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Redstone signal").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" to activate the Infuser").method_27692(class_124.field_1062)))));
        } else if (spawnerDetected) {
            GuiHelper.outlineGUI((SimpleGui)this, (int)2756918, (class_2561)class_2561.method_43470((String)"Insert a Soulstone in the top slot").method_27692(class_124.field_1061));
        } else {
            GuiHelper.outlineGUI((SimpleGui)this, (int)2756918, (class_2561)class_2561.method_43470((String)"A Spawner must be 2 blocks above the Infuser").method_27692(class_124.field_1061));
        }
        this.clearSlot(4);
        this.setSlotRedirect(4, new SoulstoneSlot(this.blockEntity.getInventory(), 0, 0, 0, true, false, null));
        for (int i = 1; i <= 7; ++i) {
            this.clearSlot(i + 9);
            this.clearSlot(i + 18);
            this.clearSlot(i + 27);
        }
        class_1799 stone = this.blockEntity.getSoulstone();
        if (usable) {
            this.setSlotRedirect(40, new SpawnerInfuserPointsSlot(this.blockEntity.getInventory(), 1, 0, 0));
            int bonusCap = (new int[]{0, 64, 128, 192, 256, 352})[ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.SOUL_RESERVOIR.id)];
            int soulstoneTier = Soulstone.soulsToTier(Soulstone.getSouls(stone));
            int maxPoints = SpawnerInfuser.pointsFromTier[soulstoneTier] + bonusCap;
            int pips = (int)Math.ceil((double)points * 3.0 / (double)maxPoints);
            for (int i = 0; i < 3; ++i) {
                GuiElementBuilder pipItem = points == maxPoints ? new GuiElementBuilder(class_1802.field_8305) : (pips > i ? new GuiElementBuilder(class_1802.field_37540) : new GuiElementBuilder(class_1802.field_8281));
                pipItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Upgrade Points: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(points + "/" + maxPoints)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(" (Tier " + soulstoneTier + ")")).method_27692(class_124.field_1075)));
                pipItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Allocated Points: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(spentPoints + "/" + points)).method_27692(class_124.field_1060))));
                pipItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                pipItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Add ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Nether Stars").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to the bottom slot to add ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Upgrade Points").method_27692(class_124.field_1060))));
                pipItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A higher tier ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Soulstone").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" increases your ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Max Upgrade Points").method_27692(class_124.field_1060))));
                this.setSlot(31 - i * 9, (GuiElementBuilderInterface)pipItem);
            }
            GuiElementBuilder maxedOut = new GuiElementBuilder(class_1802.field_8615);
            maxedOut.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Maximum Value").method_27692(class_124.field_1060)));
            maxedOut.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You cannot increase this stat further").method_27692(class_124.field_1062))));
            GuiElementBuilder minedOut = new GuiElementBuilder(class_1802.field_8615);
            minedOut.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Minimum Value").method_27692(class_124.field_1060)));
            minedOut.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You cannot decrease this stat further").method_27692(class_124.field_1062))));
            short minSpeed = stats.method_68565("MinSpawnDelay", (short)0);
            int minSpeedInd = this.indexOf(minSpeed, this.minSpeedLvls);
            int minSpeedPointC = this.minSpeedPoints[minSpeedInd];
            class_1799 minSpeedArrowStack = class_1844.method_57400((class_1792)class_1802.field_8087, (class_6880)class_1847.field_8996);
            GuiElementBuilder minSpeedIncArrow = GuiElementBuilder.from((class_1799)minSpeedArrowStack).hideDefaultTooltip();
            this.makeArrowItem(minSpeedIncArrow, true, "Minimum Spawn Time", "ticks", minSpeedInd, this.minSpeedPoints, this.minSpeedLvls);
            GuiElementBuilder minSpeedDecArrow = GuiElementBuilder.from((class_1799)minSpeedArrowStack).hideDefaultTooltip();
            this.makeArrowItem(minSpeedDecArrow, false, "Minimum Spawn Time", "ticks", minSpeedInd, this.minSpeedPoints, this.minSpeedLvls);
            GuiElementBuilder minSpeedItem = new GuiElementBuilder(class_1802.field_8054);
            this.makeMainItem(minSpeedItem, "Minimum Spawn Time", "The minimum amount of time between mob spawns", "ticks", minSpeed, minSpeedPointC);
            this.setSlot(10, (GuiElementBuilderInterface)(minSpeedInd == this.minSpeedLvls.length - 1 ? maxedOut : minSpeedIncArrow));
            this.setSlot(19, (GuiElementBuilderInterface)minSpeedItem);
            this.setSlot(28, (GuiElementBuilderInterface)(minSpeedInd == 0 ? minedOut : minSpeedDecArrow));
            short maxSpeed = stats.method_68565("MaxSpawnDelay", (short)0);
            int maxSpeedInd = this.indexOf(maxSpeed, this.maxSpeedLvls);
            int maxSpeedPointC = this.maxSpeedPoints[maxSpeedInd];
            class_1799 maxSpeedArrowStack = class_1844.method_57400((class_1792)class_1802.field_8087, (class_6880)class_1847.field_9005);
            GuiElementBuilder maxSpeedIncArrow = GuiElementBuilder.from((class_1799)maxSpeedArrowStack).hideDefaultTooltip();
            this.makeArrowItem(maxSpeedIncArrow, true, "Maximum Spawn Time", "ticks", maxSpeedInd, this.maxSpeedPoints, this.maxSpeedLvls);
            GuiElementBuilder maxSpeedDecArrow = GuiElementBuilder.from((class_1799)maxSpeedArrowStack).hideDefaultTooltip();
            this.makeArrowItem(maxSpeedDecArrow, false, "Maximum Spawn Time", "ticks", maxSpeedInd, this.maxSpeedPoints, this.maxSpeedLvls);
            GuiElementBuilder maxSpeedItem = new GuiElementBuilder(class_1802.field_8479);
            this.makeMainItem(maxSpeedItem, "Maximum Spawn Time", "The maximum amount of time between mob spawns", "ticks", maxSpeed, maxSpeedPointC);
            this.setSlot(11, (GuiElementBuilderInterface)(maxSpeedInd == this.maxSpeedLvls.length - 1 ? maxedOut : maxSpeedIncArrow));
            this.setSlot(20, (GuiElementBuilderInterface)maxSpeedItem);
            this.setSlot(29, (GuiElementBuilderInterface)(maxSpeedInd == 0 ? minedOut : maxSpeedDecArrow));
            short spawnRange = stats.method_68565("SpawnRange", (short)0);
            int spawnRangeInd = this.indexOf(spawnRange, this.spawnRangeLvls);
            int spawnRangePointC = this.spawnRangePoints[spawnRangeInd];
            class_1799 spawnRangeArrowStack = class_1844.method_57400((class_1792)class_1802.field_8087, (class_6880)class_1847.field_8974);
            GuiElementBuilder spawnRangeIncArrow = GuiElementBuilder.from((class_1799)spawnRangeArrowStack).hideDefaultTooltip();
            this.makeArrowItem(spawnRangeIncArrow, true, "Spawn Range", "blocks", spawnRangeInd, this.spawnRangePoints, this.spawnRangeLvls);
            GuiElementBuilder spawnRangeDecArrow = GuiElementBuilder.from((class_1799)spawnRangeArrowStack).hideDefaultTooltip();
            this.makeArrowItem(spawnRangeDecArrow, false, "Spawn Range", "blocks", spawnRangeInd, this.spawnRangePoints, this.spawnRangeLvls);
            GuiElementBuilder spawnRangeItem = new GuiElementBuilder(class_1802.field_8137);
            this.makeMainItem(spawnRangeItem, "Spawn Range", "The range in which mobs can spawn", "blocks", spawnRange, spawnRangePointC);
            this.setSlot(12, (GuiElementBuilderInterface)(spawnRangeInd == this.spawnRangeLvls.length - 1 ? maxedOut : spawnRangeIncArrow));
            this.setSlot(21, (GuiElementBuilderInterface)spawnRangeItem);
            this.setSlot(30, (GuiElementBuilderInterface)(spawnRangeInd == 0 ? minedOut : spawnRangeDecArrow));
            short spawnCount = stats.method_68565("SpawnCount", (short)0);
            int spawnCountInd = this.indexOf(spawnCount, this.spawnCountLvls);
            int spawnCountPointC = this.spawnCountPoints[spawnCountInd];
            class_1799 spawnCountArrowStack = class_1844.method_57400((class_1792)class_1802.field_8087, (class_6880)class_1847.field_8982);
            GuiElementBuilder spawnCountIncArrow = GuiElementBuilder.from((class_1799)spawnCountArrowStack).hideDefaultTooltip();
            this.makeArrowItem(spawnCountIncArrow, true, "Spawn Count", "mobs", spawnCountInd, this.spawnCountPoints, this.spawnCountLvls);
            GuiElementBuilder spawnCountDecArrow = GuiElementBuilder.from((class_1799)spawnCountArrowStack).hideDefaultTooltip();
            this.makeArrowItem(spawnCountDecArrow, false, "Spawn Count", "mobs", spawnCountInd, this.spawnCountPoints, this.spawnCountLvls);
            GuiElementBuilder spawnCountItem = new GuiElementBuilder(class_1802.field_8470);
            this.makeMainItem(spawnCountItem, "Spawn Count", "The amount of spawn attempts each cycle", "mobs", spawnCount, spawnCountPointC);
            this.setSlot(14, (GuiElementBuilderInterface)(spawnCountInd == this.spawnCountLvls.length - 1 ? maxedOut : spawnCountIncArrow));
            this.setSlot(23, (GuiElementBuilderInterface)spawnCountItem);
            this.setSlot(32, (GuiElementBuilderInterface)(spawnCountInd == 0 ? minedOut : spawnCountDecArrow));
            short maxEntities = stats.method_68565("MaxNearbyEntities", (short)0);
            int maxEntitiesInd = this.indexOf(maxEntities, this.maxEntitiesLvls);
            int maxEntitiesPointC = this.maxEntitiesPoints[maxEntitiesInd];
            class_1799 maxEntitiesArrowStack = class_1844.method_57400((class_1792)class_1802.field_8087, (class_6880)class_1847.field_8994);
            GuiElementBuilder maxEntitiesIncArrow = GuiElementBuilder.from((class_1799)maxEntitiesArrowStack).hideDefaultTooltip();
            this.makeArrowItem(maxEntitiesIncArrow, true, "Max Entities", "mobs", maxEntitiesInd, this.maxEntitiesPoints, this.maxEntitiesLvls);
            GuiElementBuilder maxEntitiesDecArrow = GuiElementBuilder.from((class_1799)maxEntitiesArrowStack).hideDefaultTooltip();
            this.makeArrowItem(maxEntitiesDecArrow, false, "Max Entities", "mobs", maxEntitiesInd, this.maxEntitiesPoints, this.maxEntitiesLvls);
            GuiElementBuilder maxEntitiesItem = new GuiElementBuilder(class_1802.field_8791);
            this.makeMainItem(maxEntitiesItem, "Max Entities", "The amount of mobs in range before the spawner is disabled", "mobs", maxEntities, maxEntitiesPointC);
            this.setSlot(15, (GuiElementBuilderInterface)(maxEntitiesInd == this.maxEntitiesLvls.length - 1 ? maxedOut : maxEntitiesIncArrow));
            this.setSlot(24, (GuiElementBuilderInterface)maxEntitiesItem);
            this.setSlot(33, (GuiElementBuilderInterface)(maxEntitiesInd == 0 ? minedOut : maxEntitiesDecArrow));
            short playerRange = stats.method_68565("RequiredPlayerRange", (short)0);
            int playerRangeInd = this.indexOf(playerRange, this.playerRangeLvls);
            int playerRangePointC = this.playerRangePoints[playerRangeInd];
            class_1799 playerRangeArrowStack = class_1844.method_57400((class_1792)class_1802.field_8087, (class_6880)class_1847.field_8990);
            GuiElementBuilder playerRangeIncArrow = GuiElementBuilder.from((class_1799)playerRangeArrowStack).hideDefaultTooltip();
            this.makeArrowItem(playerRangeIncArrow, true, "Player Range", "blocks", playerRangeInd, this.playerRangePoints, this.playerRangeLvls);
            GuiElementBuilder playerRangeDecArrow = GuiElementBuilder.from((class_1799)playerRangeArrowStack).hideDefaultTooltip();
            this.makeArrowItem(playerRangeDecArrow, false, "Player Range", "blocks", playerRangeInd, this.playerRangePoints, this.playerRangeLvls);
            GuiElementBuilder playerRangeItem = new GuiElementBuilder(class_1802.field_8575);
            this.makeMainItem(playerRangeItem, "Player Range", "How close a player has to be for the spawner to work", "blocks", playerRange, playerRangePointC);
            this.setSlot(16, (GuiElementBuilderInterface)(playerRangeInd == this.playerRangeLvls.length - 1 ? maxedOut : playerRangeIncArrow));
            this.setSlot(25, (GuiElementBuilderInterface)playerRangeItem);
            this.setSlot(34, (GuiElementBuilderInterface)(playerRangeInd == 0 ? minedOut : playerRangeDecArrow));
        }
        this.setTitle((class_2561)ArcanaRegistry.SPAWNER_INFUSER.getTranslatedName());
    }

    private boolean detectSpawner() {
        class_2338 pos = this.blockEntity.method_11016().method_10069(0, 2, 0);
        class_2586 blockEntity = this.world.method_8321(pos);
        class_2680 blockState = this.world.method_8320(pos);
        return blockState.method_27852(class_2246.field_10260) && blockEntity instanceof class_2636;
    }

    private int indexOf(int value, int[] arr) {
        for (int i = 1; i < arr.length; ++i) {
            int cur = arr[i];
            if (cur == value) {
                return i;
            }
            if (cur <= value) continue;
            return i - 1;
        }
        return arr.length - 1;
    }

    private void makeMainItem(GuiElementBuilder elem, String title, String description, String units, int value, int points) {
        elem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(title + ": ")).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(value + " " + units)).method_27692(class_124.field_1060)));
        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)description).method_27692(class_124.field_1062))));
        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Current Value: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(value + " " + units)).method_27692(class_124.field_1060))));
        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Point Allocation: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(points + " points")).method_27692(class_124.field_1060))));
    }

    private void makeArrowItem(GuiElementBuilder elem, boolean increase, String title, String units, int ind, int[] pointArr, int[] lvlArr) {
        int newInd = increase ? Math.min(ind + 1, pointArr.length - 1) : Math.max(ind - 1, 0);
        int pointDiff = pointArr[ind] - pointArr[newInd];
        String incDecStr = increase ? "Increase" : "Decrease";
        int newVal = increase ? lvlArr[Math.min(ind + 1, lvlArr.length - 1)] : lvlArr[Math.max(ind - 1, 0)];
        elem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(incDecStr + " " + title)).method_27692(class_124.field_1077)));
        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(incDecStr + ": ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)(lvlArr[ind] + " " + units)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)(newVal + " " + units)).method_27692(class_124.field_1060))));
        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Point Cost: ").method_27692(class_124.field_1062)).method_10852((class_2561)(pointDiff > 0 ? class_2561.method_43470((String)("+" + pointDiff + " points")).method_27692(class_124.field_1060) : class_2561.method_43470((String)(pointDiff + " points")).method_27692(class_124.field_1061)))));
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity) {
            this.close();
        }
        super.onTick();
    }

    public void close() {
        this.blockEntity.removePlayer(this.player);
        super.close();
    }
}

