/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.starlightforge;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import java.util.List;
import java.util.Optional;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.gui.starlightforge.StarlightForgeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;

public class StarlightForgeInventoryListener
implements class_1265 {
    private final StarlightForgeBlockEntity blockEntity;
    private final class_1937 world;
    private final StarlightForgeGui gui;
    private boolean updating = false;

    public StarlightForgeInventoryListener(StarlightForgeGui gui, StarlightForgeBlockEntity blockEntity, class_1937 world, int mode) {
        this.blockEntity = blockEntity;
        this.gui = gui;
        this.world = world;
    }

    public void method_5453(class_1263 inv) {
        if (!this.updating) {
            this.updating = true;
            this.validRecipe(inv);
            this.finishUpdate();
        }
    }

    public void finishUpdate() {
        this.updating = false;
    }

    public void setUpdating() {
        this.updating = true;
    }

    public class_1799 getEnhancedStack(class_1263 inv) {
        class_1937 class_19372 = this.world;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_2371 craftingStacks = class_2371.method_10211();
        boolean hasGold = true;
        boolean hasPaper = true;
        for (int i = 0; i < 9; ++i) {
            craftingStacks.add((Object)inv.method_5438(i));
            if (i == 4) {
                hasGold = inv.method_5438(i).method_31574(class_1802.field_8695);
                continue;
            }
            if (!hasPaper || inv.method_5438(i).method_31574(ArcanaRegistry.EXOTIC_ARCANE_PAPER)) continue;
            hasPaper = false;
        }
        class_9694 input = class_9694.method_59986((int)3, (int)3, (List)craftingStacks);
        Optional optional = serverWorld.method_64577().method_8132(class_3956.field_17545, (class_9695)input, this.world);
        if (optional.isPresent() && EnhancedStatUtils.isItemEnhanceable(((class_3955)((class_8786)optional.get()).comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)this.world.method_30349()))) {
            return ((class_3955)((class_8786)optional.get()).comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)this.world.method_30349()).method_7972();
        }
        return hasGold && hasPaper ? new class_1799((class_1935)ArcanaRegistry.SOVEREIGN_ARCANE_PAPER) : class_1799.field_8037;
    }

    public class_2371<class_1799> getRemainders(class_1263 inv) {
        class_1937 class_19372 = this.world;
        if (!(class_19372 instanceof class_3218)) {
            return class_2371.method_10211();
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_2371 remainders = class_2371.method_10211();
        class_2371 craftingStacks = class_2371.method_10211();
        for (int i = 0; i < 9; ++i) {
            craftingStacks.add((Object)inv.method_5438(i));
        }
        class_9694 input = class_9694.method_59986((int)3, (int)3, (List)craftingStacks);
        Optional optional = serverWorld.method_64577().method_8132(class_3956.field_17545, (class_9695)input, this.world);
        if (optional.isPresent() && EnhancedStatUtils.isItemEnhanceable(((class_3955)((class_8786)optional.get()).comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)this.world.method_30349()))) {
            return ((class_3955)((class_8786)optional.get()).comp_1933()).method_17704(input);
        }
        return remainders;
    }

    public void validRecipe(class_1263 inv) {
        if (this.gui.getMode() == 1) {
            class_1799[][] curItems = new class_1799[5][5];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    curItems[i][j] = inv.method_5438(i * 5 + j);
                }
            }
            ArcanaItem matchedItem = null;
            for (ArcanaItem item : ArcanaRegistry.ARCANA_ITEMS.method_10220().toList()) {
                ArcanaRecipe recipe = item.getRecipe();
                if (recipe == null || !recipe.satisfiesRecipe(curItems, this.blockEntity)) continue;
                matchedItem = item;
                break;
            }
            if (matchedItem == null) {
                GuiElementBuilder table = new GuiElementBuilder(class_1802.field_8465).hideDefaultTooltip();
                table.setName((class_2561)class_2561.method_43470((String)"Forge Item").method_27692(class_124.field_1064));
                table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to forge an Arcana Item once a recipe is loaded!").method_27692(class_124.field_1076))));
                table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"This slot will show an Arcana Item once a valid recipe is loaded.").method_27695(new class_124[]{class_124.field_1056, class_124.field_1075})));
                this.gui.setSlot(25, (GuiElementBuilderInterface)table);
            } else {
                this.gui.setSlot(25, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)matchedItem.getPrefItem()).addLoreLine((class_2561)class_2561.method_43470((String)"")).addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Click to Forge!").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}))).glow());
            }
        } else if (this.gui.getMode() == 2 && this.world != null) {
            class_1799 output = MinecraftUtils.removeLore((class_1799)this.getEnhancedStack(inv).method_7972());
            if (!output.method_7960()) {
                GuiElementBuilder craftingItem = GuiElementBuilder.from((class_1799)output).hideDefaultTooltip();
                craftingItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Forge Item").method_27692(class_124.field_1075)));
                craftingItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to begin forging this ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)output.method_7909().method_7876()).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1062))));
                this.gui.setSlot(15, (GuiElementBuilderInterface)craftingItem);
            } else {
                GuiElementBuilder craftingItem = new GuiElementBuilder(class_1802.field_8465);
                craftingItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Forge Item").method_27692(class_124.field_1075)));
                craftingItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to forge an item once a recipe is loaded!").method_27692(class_124.field_1062))));
                craftingItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1062))));
                craftingItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This slot will show an item once a valid recipe is loaded.").method_27692(class_124.field_1076))));
                this.gui.setSlot(15, (GuiElementBuilderInterface)craftingItem);
            }
        }
    }
}

