/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerCrossbowItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class AlchemicalArbalest
extends ArcanaItem {
    public static final String ID = "alchemical_arbalest";

    public AlchemicalArbalest() {
        this.id = ID;
        this.name = "Alchemical Arbalest";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8399;
        this.item = new AlchemicalArbalestItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.alchemical_arbalest", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1062});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.ADVANCEMENT_OL_BETSY, ResearchTasks.ADVANCEMENT_WHOS_THE_PILLAGER_NOW, ResearchTasks.ADVANCEMENT_ARBALISTIC, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.OBTAIN_TIPPED_ARROW, ResearchTasks.ADVANCEMENT_BREW_POTION, ResearchTasks.ADVANCEMENT_DRAGON_BREATH};
        this.attributions = new class_3545[]{new class_3545((Object)class_2561.method_43471((String)"credits_and_attribution.arcananovum.inspired_by"), (Object)class_2561.method_43470((String)"Sethzilla42"))};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public void finalizePrefItem(MinecraftServer server) {
        super.finalizePrefItem(server);
        class_1799 curPrefItem = this.getPrefItem();
        curPrefItem.method_57379(class_9334.field_49633, (Object)MinecraftUtils.makeEnchantComponent((class_1889[])new class_1889[]{new class_1889(MinecraftUtils.getEnchantment((class_5455)server.method_30611(), (class_5321)class_1893.field_9108), 1)}));
        this.prefItem = this.buildItemLore(curPrefItem, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Crossbow ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"is outfitted with ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"enchanted ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"clockwork mechanisms").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Tipped Arrows").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" fired from the ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"bow ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"create a ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"lingering ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"field").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Spectral Arrows").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" create a zone of ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"damage ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"amplification").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Crossbow ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"is ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Unbreakable ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"and comes with ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Multishot").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_1799 newStack = super.updateItem(stack, server);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public class_1799 onAugment(class_1799 stack, ArcanaAugment augment, int level) {
        if (augment == ArcanaAugments.RUNIC_ARBALEST && stack.method_7942()) {
            class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_9304.field_49385);
            class_9304 comp = stack.method_58657();
            Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
            comp.method_57539().forEach(entry -> enchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
            enchants.forEach((e, num) -> {
                if (!((class_1887)e.comp_349()).comp_2689().method_57832(class_9701.field_51676)) {
                    enchantBuilder.method_57550(e, num.intValue());
                }
            });
            class_1890.method_57530((class_1799)stack, (class_9304)enchantBuilder.method_57549());
        }
        return stack;
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 bowStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        if (bowStack.method_7942()) {
            class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_9304.field_49385);
            class_9304 comp = bowStack.method_58657();
            Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
            comp.method_57539().forEach(entry -> enchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
            enchants.forEach((e, num) -> {
                if (!((class_1887)e.comp_349()).comp_2689().method_57832(class_9701.field_51673)) {
                    enchantBuilder.method_57550(e, num.intValue());
                }
            });
            class_1890.method_57530((class_1799)newArcanaItem, (class_9304)enchantBuilder.method_57549());
        }
        newArcanaItem.method_7978(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9108), 1);
        return newArcanaItem;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8601, 32);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8790, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8613, 32);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8183, 24);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9108), 1));
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22020, 2);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8711, 32);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_8137, 4);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8399, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, a}, {b, g, h, g, d}, {k, l, m, l, k}, {d, g, h, g, b}, {a, d, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withCore().withFletchery().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"     Alchemical\n      Arbalest").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nWhile bows are excellent for sustained damage, crossbows have always been good at bursts of damage and area suppression. I believe I can enhance this niche further\u2026").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"     Alchemical\n      Arbalest").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nThe Arbalest overcharges Tipped Arrows so that their effects cover a wide space and linger. It also comes with the multishot enchantment.\n\nSpectral Arrows are where things get interesting.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"     Alchemical\n      Arbalest").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nThey carry no discrete effect but cause creatures to glow. Tweaking that ability a bit when used in the Arbalest, Spectral Arrows now create a cloud that makes weak spots on enemies easier to see, ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"     Alchemical\n      Arbalest").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\ncausing them to take increased damage from all sources.").method_27692(class_124.field_1074)));
        return list;
    }

    public class AlchemicalArbalestItem
    extends ArcanaPolymerCrossbowItem {
        public AlchemicalArbalestItem() {
            super(AlchemicalArbalest.this.getThis(), AlchemicalArbalest.this.getEquipmentArcanaItemComponents());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            if (ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.RUNIC_ARBALEST.id) > 0) {
                stringList.add("runic");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return AlchemicalArbalest.this.prefItem;
        }

        public void verifyEnchantments(class_1799 stack) {
            boolean hasMulti = class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51676);
            boolean hasPierce = class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51673);
            boolean hasScatter = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SCATTERSHOT.id) > 0;
            boolean hasRunic = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.RUNIC_ARBALEST.id) > 0;
            class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_9304.field_49385);
            class_9304 comp = stack.method_58657();
            Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
            comp.method_57539().forEach(entry -> enchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
            if (hasRunic && hasMulti) {
                enchants.forEach((e, num) -> {
                    if (!((class_1887)e.comp_349()).comp_2689().method_57832(class_9701.field_51676)) {
                        enchantBuilder.method_57550(e, num.intValue());
                    }
                });
                class_1890.method_57530((class_1799)stack, (class_9304)enchantBuilder.method_57549());
                this.verifyEnchantments(stack);
            }
            if (hasScatter && hasPierce) {
                enchants.forEach((e, num) -> {
                    if (!((class_1887)e.comp_349()).comp_2689().method_57832(class_9701.field_51673)) {
                        enchantBuilder.method_57550(e, num.intValue());
                    }
                });
                class_1890.method_57530((class_1799)stack, (class_9304)enchantBuilder.method_57549());
                this.verifyEnchantments(stack);
            }
            if (hasScatter && !hasMulti) {
                stack.method_7978(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9108), 1);
                this.verifyEnchantments(stack);
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
            class_1799 itemStack = user.method_5998(hand);
            this.verifyEnchantments(itemStack);
            return super.method_7836(world, user, hand);
        }
    }
}

