/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import eu.pb4.polymer.core.api.item.PolymerItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1671;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class EverlastingRocket
extends EnergyItem {
    public static final String ID = "everlasting_rocket";
    public static final String FIREWORK_ID_TAG = "fireworkId";

    public EverlastingRocket() {
        this.id = ID;
        this.name = "Everlasting Rocket";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8639;
        this.item = new EverlastingRocketItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.everlasting_rocket", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054});
        this.initEnergy = 16;
        this.researchTasks = new class_5321[]{ResearchTasks.USE_FIREWORK, ResearchTasks.ACTIVATE_MENDING, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Rocket").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" that has near ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"infinite ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"uses.").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Can be used for ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"everything").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"normal rocket").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" is used for.").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Stores ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"charges ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"that slowly ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"recharge ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"over ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"time").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)""));
        int maxCharges = itemStack == null ? 16 : this.getMaxEnergy(itemStack);
        int charges = itemStack == null ? 16 : this.getEnergy(itemStack);
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Charges ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)(charges + " / " + maxCharges)).method_27692(class_124.field_1076)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 rocketStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        class_9284 fireworks = (class_9284)rocketStack.method_58695(class_9334.field_49616, (Object)new class_9284(1, List.of()));
        newArcanaItem.method_57379(class_9334.field_49616, (Object)fireworks);
        return newArcanaItem;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_9284 fireworks = (class_9284)stack.method_58695(class_9334.field_49616, (Object)new class_9284(1, List.of()));
        class_1799 newStack = super.updateItem(stack, server);
        newStack.method_57379(class_9334.field_49616, (Object)fireworks);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        return 16 + 3 * Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.POWDER_PACKING.id));
    }

    public class_1799 getFireworkStack(class_1799 stack) {
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8639, 64);
        class_9284 fireworks = (class_9284)stack.method_58695(class_9334.field_49616, (Object)new class_9284(1, List.of()));
        itemStack.method_57379(class_9334.field_49616, (Object)fireworks);
        EverlastingRocket.putProperty(itemStack, FIREWORK_ID_TAG, EverlastingRocket.getUUID(stack));
        return itemStack;
    }

    public static void decreaseRocket(class_1799 stack, class_3222 player) {
        if (!EverlastingRocket.hasProperty(stack, FIREWORK_ID_TAG)) {
            return;
        }
        String rocketId = EverlastingRocket.getStringProperty(stack, FIREWORK_ID_TAG);
        class_1661 inv = player.method_31548();
        for (int invSlot = 0; invSlot < inv.method_5439(); ++invSlot) {
            ArcanaItem arcanaItem;
            class_1799 item = inv.method_5438(invSlot);
            if (item.method_7960() || !((arcanaItem = ArcanaItemUtils.identifyItem(item)) instanceof EverlastingRocket)) continue;
            EverlastingRocket rocket = (EverlastingRocket)arcanaItem;
            if (!EverlastingRocket.getUUID(item).equals(rocketId)) continue;
            rocket.addEnergy(item, -1);
            rocket.buildItemLore(stack, player.method_5682());
            ArcanaAchievements.progress(player, ArcanaAchievements.MISSILE_LAUNCHER.id, 1);
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.EVERLASTING_ROCKET_USE));
            return;
        }
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8639, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8054, 8);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8407, 24);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9101), 1));
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8450, 8);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9119), 3));
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, i, b}, {c, h, a, h, c}, {b, i, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Everlasting Rocket").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nI have blown through so much gunpowder on rockets. Using a combination of Mending and Unbreaking enchantments, I think I can extend one rocket into thousands.\nThe Everlasting Rocket is used the ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Everlasting Rocket").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nsame way as a normal rocket. However it uses charges instead of being expended.\n\nCharges regenerate over time. The properties of the rocket come from the center item from crafting.").method_27692(class_124.field_1074)));
        return list;
    }

    public class EverlastingRocketItem
    extends ArcanaPolymerItem
    implements PolymerItem {
        public EverlastingRocketItem() {
            super(EverlastingRocket.this.getThis(), EverlastingRocket.this.getArcanaItemComponents().method_57349(class_9334.field_49616, (Object)new class_9284(1, List.of())));
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            boolean adjustable;
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            int percentage = (int)Math.ceil(3.0 * (double)EverlastingRocket.this.getEnergy(itemStack) / (double)EverlastingRocket.this.getMaxEnergy(itemStack));
            boolean bl = adjustable = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.ADJUSTABLE_FUSE.id) >= 1;
            if (adjustable) {
                if (percentage == 0) {
                    stringList.add("0");
                } else {
                    class_9284 fireworks = (class_9284)itemStack.method_58695(class_9334.field_49616, (Object)new class_9284(1, List.of()));
                    int flight = fireworks.comp_2391();
                    if (flight == 3) {
                        stringList.add("3");
                    } else if (flight == 2) {
                        stringList.add("2");
                    } else {
                        stringList.add("1");
                    }
                }
            } else if (percentage == 3) {
                stringList.add("3");
            } else if (percentage == 2) {
                stringList.add("2");
            } else if (percentage == 1) {
                stringList.add("1");
            } else {
                stringList.add("0");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return EverlastingRocket.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            block6: {
                block5: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block5;
                    class_3218 serverWorld = world;
                    if (entity instanceof class_3222) break block6;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            if (player.method_5682().method_3780() % (600 - 100 * Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SULFUR_REPLICATION.id))) == 0) {
                EverlastingRocket.this.addEnergy(stack, 1);
                EverlastingRocket.this.buildItemLore(stack, player.method_5682());
            }
        }

        public class_1269 method_7884(class_1838 context) {
            class_1657 class_16572;
            class_1937 world = context.method_8045();
            if (!world.field_9236 && (class_16572 = context.method_8036()) instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                if (((EnergyItem)EverlastingRocket.this.getThis()).getEnergy(context.method_8041()) > 0) {
                    class_1799 itemStack = context.method_8041();
                    class_243 vec3d = context.method_17698();
                    class_2350 direction = context.method_8038();
                    class_1671 fireworkRocketEntity = new class_1671(world, (class_1297)context.method_8036(), vec3d.field_1352 + (double)direction.method_10148() * 0.15, vec3d.field_1351 + (double)direction.method_10164() * 0.15, vec3d.field_1350 + (double)direction.method_10165() * 0.15, EverlastingRocket.this.getFireworkStack(itemStack));
                    world.method_8649((class_1297)fireworkRocketEntity);
                    ((EnergyItem)EverlastingRocket.this.getThis()).addEnergy(context.method_8041(), -1);
                    EverlastingRocket.this.buildItemLore(itemStack, player.method_5682());
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.EVERLASTING_ROCKET_USE));
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Rocket is out of Charges").method_27692(class_124.field_1054), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
                }
            }
            return class_1269.field_52422;
        }

        public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
            class_1799 itemStack = user.method_5998(hand);
            if (user.method_5715() && ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.ADJUSTABLE_FUSE.id) > 0 && user instanceof class_3222) {
                class_3222 player = (class_3222)user;
                class_9284 fireworks = (class_9284)itemStack.method_58695(class_9334.field_49616, (Object)new class_9284(1, List.of()));
                int flight = fireworks.comp_2391();
                flight = flight % 3 + 1;
                itemStack.method_57379(class_9334.field_49616, (Object)new class_9284(flight, fireworks.comp_2392()));
                player.method_7353((class_2561)class_2561.method_43470((String)("Fuse Adjusted to " + flight)).method_27692(class_124.field_1054), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_6880.class_6883)class_3417.field_14708, (float)1.0f, (float)0.8f);
            } else if (user.method_6128()) {
                if (!world.field_9236 && user instanceof class_3222) {
                    class_3222 player = (class_3222)user;
                    if (((EnergyItem)EverlastingRocket.this.getThis()).getEnergy(itemStack) > 0) {
                        class_1671 fireworkRocketEntity = new class_1671(world, EverlastingRocket.this.getFireworkStack(itemStack), (class_1309)user);
                        world.method_8649((class_1297)fireworkRocketEntity);
                        if (!user.method_68878()) {
                            ((EnergyItem)EverlastingRocket.this.getThis()).addEnergy(itemStack, -1);
                            EverlastingRocket.this.buildItemLore(itemStack, player.method_5682());
                            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.EVERLASTING_ROCKET_USE));
                        }
                        user.method_7259(class_3468.field_15372.method_14956((Object)this));
                        if (player.method_19538().method_10214() > 500.0) {
                            ArcanaAchievements.grant(player, ArcanaAchievements.ROCKETMAN.id);
                        }
                    } else {
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Rocket is out of Charges").method_27692(class_124.field_1054), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
                    }
                }
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }
    }
}

