/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import com.mojang.serialization.DynamicOps;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import io.github.ladysnake.pal.VanillaAbilities;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.levitationharness.LevitationHarnessGui;
import net.borisshoes.arcananovum.gui.levitationharness.LevitationHarnessInventoryListener;
import net.borisshoes.arcananovum.items.ShulkerCore;
import net.borisshoes.arcananovum.items.Soulstone;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.ShulkerCoreIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8051;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class LevitationHarness
extends EnergyItem {
    public static final String ID = "levitation_harness";
    public static final String SOULS_TAG = "souls";
    public static final String GLOWSTONE_TAG = "glowstone";
    public static final String STALL_TAG = "stall";
    public static final String WAS_FLYING_TAG = "wasFlying";
    public static final String STONE_DATA_TAG = "stoneData";
    private static final double[] efficiencyChance = new double[]{0.0, 0.1, 0.25, 0.5};

    public LevitationHarness() {
        this.id = ID;
        this.name = "Levitation Harness";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.initEnergy = 3599;
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_8577;
        this.item = new LevitationHarnessItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.levitation_harness", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1080});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_SHULKER_CORE, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.ADVANCEMENT_ELYTRA, ResearchTasks.UNLOCK_ARCANE_SINGULARITY, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        LevitationHarness.putProperty(stack, SOULS_TAG, 500);
        LevitationHarness.putProperty(stack, GLOWSTONE_TAG, 960);
        LevitationHarness.putProperty(stack, STALL_TAG, -1);
        LevitationHarness.putProperty(stack, WAS_FLYING_TAG, false);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Mastery over the nature of ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Shulkers ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"has yielded the ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Levitation Harness!").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Grants ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"creative flight").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" while consuming ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Shulker ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"souls ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Glowstone").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1068)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Harness ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"is quite ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"fragile ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"and the slightest bump causes it to ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)STALL_TAG).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1068)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Harness ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"also provides ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"no protection").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" against ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"damage").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1068)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right click").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" while ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"holding ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"harness ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"to open the refuelling menu.").method_27692(class_124.field_1068)));
        lore.add(class_2561.method_43470((String)""));
        String duration = itemStack != null ? this.getDuration(itemStack) : "60 Minutes";
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Flight Duration ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)duration).method_27692(class_124.field_1054)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        return Integer.MAX_VALUE;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2487 stoneData = LevitationHarness.getCompoundProperty(stack, STONE_DATA_TAG);
        int souls = LevitationHarness.getIntProperty(stack, SOULS_TAG);
        int stall = LevitationHarness.getIntProperty(stack, STALL_TAG);
        int glowstone = LevitationHarness.getIntProperty(stack, GLOWSTONE_TAG);
        boolean wasFlying = LevitationHarness.getBooleanProperty(stack, WAS_FLYING_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        LevitationHarness.putProperty(newStack, STONE_DATA_TAG, (class_2520)stoneData);
        LevitationHarness.putProperty(newStack, SOULS_TAG, souls);
        LevitationHarness.putProperty(newStack, STALL_TAG, stall);
        LevitationHarness.putProperty(newStack, GLOWSTONE_TAG, glowstone);
        LevitationHarness.putProperty(newStack, WAS_FLYING_TAG, wasFlying);
        return this.buildItemLore(newStack, server);
    }

    public String getDuration(class_1799 item) {
        int energy = this.getEnergy(item);
        String duration = energy >= 6000 ? energy / 3600 + 1 + " Hours" : (energy >= 100 ? energy / 60 + 1 + " Minutes" : energy + " Seconds");
        return duration;
    }

    public void recalculateEnergy(class_1799 stack) {
        int souls = LevitationHarness.getIntProperty(stack, SOULS_TAG);
        int glowstone = LevitationHarness.getIntProperty(stack, GLOWSTONE_TAG) / 16;
        this.setEnergy(stack, 60 * Math.min(souls, glowstone));
        this.buildItemLore(stack, BorisLib.SERVER);
    }

    public int getGlow(class_1799 stack) {
        return LevitationHarness.getIntProperty(stack, GLOWSTONE_TAG);
    }

    public int getSouls(class_1799 stack) {
        return LevitationHarness.getIntProperty(stack, SOULS_TAG);
    }

    public void setStone(class_1799 stack, class_1799 stone) {
        if (stone == null || stone.method_7960()) {
            LevitationHarness.putProperty(stack, STONE_DATA_TAG, (class_2520)new class_2487());
            LevitationHarness.putProperty(stack, SOULS_TAG, -1);
        } else {
            LevitationHarness.putProperty(stack, STONE_DATA_TAG, (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)BorisLib.SERVER.method_30611()), (Object)stone).getOrThrow());
            LevitationHarness.putProperty(stack, SOULS_TAG, Soulstone.getSouls(stone));
        }
    }

    public void addGlow(class_1799 stack, int glow) {
        int newGlow = Math.max(0, LevitationHarness.getIntProperty(stack, GLOWSTONE_TAG) + glow);
        LevitationHarness.putProperty(stack, GLOWSTONE_TAG, newGlow);
    }

    public int getStall(class_1799 stack) {
        return LevitationHarness.getIntProperty(stack, STALL_TAG);
    }

    public void setStall(class_1799 stack, int seconds) {
        LevitationHarness.putProperty(stack, STALL_TAG, seconds);
    }

    public void buildGui(class_1799 stack, LevitationHarnessGui gui) {
        int souls = this.getSouls(stack);
        int glow = this.getGlow(stack);
        int energy = this.getEnergy(stack);
        String soulText = souls > -1 ? LevelUtils.readableInt(souls) + " Shulker Souls" : "No Soulstone Inserted";
        String durationText = energy > 0 ? "Flight Time Remaining: " + this.getDuration(stack) : "No Fuel!";
        String glowText = glow > 0 ? LevelUtils.readableInt(glow) + " Glowstone Left" : "No Glowstone Remaining";
        GuiElementBuilder soulPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)(souls > -1 ? 7996617 : 2756918)));
        GuiElementBuilder durationPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)(energy > 0 ? 0xDBDBDB : 0x880000)));
        GuiElementBuilder glowPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)(glow > 0 ? 0xFFDD00 : 2756918)));
        class_124 soulTextColor = souls > -1 ? class_124.field_1076 : class_124.field_1061;
        class_124 durationTextColor = energy > 0 ? class_124.field_1080 : class_124.field_1061;
        class_124 glowTextColor = glow > 0 ? class_124.field_1065 : class_124.field_1061;
        gui.setSlot(0, (GuiElementBuilderInterface)soulPane.setName((class_2561)class_2561.method_43470((String)soulText).method_27692(soulTextColor)));
        gui.setSlot(2, (GuiElementBuilderInterface)durationPane.setName((class_2561)class_2561.method_43470((String)durationText).method_27692(durationTextColor)));
        gui.setSlot(4, (GuiElementBuilderInterface)glowPane.setName((class_2561)class_2561.method_43470((String)glowText).method_27692(glowTextColor)));
    }

    public void openGui(class_1657 playerEntity, class_1799 stack) {
        if (!(playerEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerEntity;
        LevitationHarnessGui gui = new LevitationHarnessGui(class_3917.field_17337, player, this, stack);
        int souls = this.getSouls(stack);
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.clearSlot(i);
        }
        this.buildGui(stack, gui);
        class_1277 inv = new class_1277(2);
        LevitationHarnessInventoryListener listener = new LevitationHarnessInventoryListener(this, gui, stack);
        inv.method_5489((class_1265)listener);
        listener.setUpdating();
        gui.setSlotRedirect(1, new class_1735((class_1263)inv, 0, 0, 0));
        gui.setSlotRedirect(3, new class_1735((class_1263)inv, 1, 0, 0));
        if (souls > -1) {
            class_2487 stoneData = LevitationHarness.getCompoundProperty(stack, STONE_DATA_TAG);
            class_1799 stone = stoneData == null || stoneData.method_33133() ? Soulstone.setType(ArcanaRegistry.SOULSTONE.getNewItem(), class_1299.field_6109) : class_1799.field_24671.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)player.method_56673()), (Object)stoneData).result().orElse(class_1799.field_8037);
            stone = Soulstone.setSouls(stone, souls);
            inv.method_5447(0, stone);
            gui.validStone(stone);
        } else {
            gui.notValidStone();
        }
        gui.setTitle((class_2561)class_2561.method_43470((String)"Levitation Harness"));
        listener.finishUpdate();
        gui.open();
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 coreStack = inv.method_5438(12);
        class_1799 newArcanaItem = null;
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(coreStack);
        if (arcanaItem instanceof ShulkerCore) {
            ShulkerCore core = (ShulkerCore)arcanaItem;
            newArcanaItem = this.getNewItem();
            this.setStone(newArcanaItem, core.getStone(coreStack));
            this.buildItemLore(newArcanaItem, BorisLib.SERVER);
            ArcanaAugments.copyAugment(coreStack, newArcanaItem, ArcanaAugments.SHULKER_RECYCLER.id, ArcanaAugments.HARNESS_RECYCLER.id);
        }
        return newArcanaItem;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ShulkerCoreIngredient m = new ShulkerCoreIngredient(true, 500);
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8801, 32);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8815, 24);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8833, 1);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8137, 4);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22020, 4);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withEnchanter().withCore().withAnvil().withSingularity());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Levitation Harness").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThe sheer amount of effort and research that has gone into this is incomparable. A crowning achievement to be sure. The ability to fly freely through the sky is at my command, albeit fueled by innocent souls.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Levitation Harness").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nGlowstone was an adequate moderator for the Shulker Core, but now it is an absolute necessity that is consumed in large quantities to stabilize the flight reaction. Even with more Glowstone, the reaction is incredibly sensitive to damage.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Levitation Harness").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nWearing the Harness grants creative flight. The Harness provides no armor value, and taking even the slightest bump while in flight will destabilize the flight process, dealing half my health in damage, and taking a few seconds to restabilize.").method_27692(class_124.field_1074)));
        return list;
    }

    public class LevitationHarnessItem
    extends ArcanaPolymerItem {
        public LevitationHarnessItem() {
            super(LevitationHarness.this.getThis(), LevitationHarness.this.getEquipmentArcanaItemComponents().method_66332(ArcanaRegistry.NON_PROTECTIVE_ARMOR_MATERIAL, class_8051.field_41935).method_57349(class_9334.field_49644, (Object)new class_9282(0x966996)));
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            class_10192 equippableComponent = (class_10192)baseStack.method_58694(class_9334.field_54196);
            class_10192 newComp = class_10192.method_64202((class_1304)equippableComponent.comp_3174()).method_64205(equippableComponent.comp_3175()).method_64204(class_5321.method_29179(ArcanaRegistry.EQUIPMENT_ASSET_REGISTRY_KEY, (class_2960)class_2960.method_60655((String)"arcananovum", (String)LevitationHarness.ID))).method_64203();
            baseStack.method_57379(class_9334.field_54196, (Object)newComp);
            return baseStack;
        }

        public class_1799 method_7854() {
            return LevitationHarness.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            class_3218 serverWorld;
            block33: {
                block32: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block32;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block33;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean chestItem = class_1799.method_31577((class_1799)player.method_6118(class_1304.field_6174), (class_1799)stack);
            boolean riding = player.method_5765();
            boolean survival = !player.method_68878() && !player.method_7325();
            boolean flying = VanillaAbilities.ALLOW_FLYING.getTracker((class_1657)player).isEnabled() && VanillaAbilities.ALLOW_FLYING.getTracker((class_1657)player).isGrantedBy(ArcanaRegistry.LEVITATION_HARNESS_ABILITY) && VanillaAbilities.FLYING.isEnabledFor((class_1657)player) && !riding;
            boolean wasFlying = ArcanaItem.getBooleanProperty(stack, LevitationHarness.WAS_FLYING_TAG);
            int efficiency = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.HARNESS_RECYCLER.id));
            if (world.method_8503().method_3780() % 20 == 0) {
                int stall;
                if (chestItem && flying && survival) {
                    if (Math.random() >= efficiencyChance[efficiency]) {
                        LevitationHarness.this.addEnergy(stack, -1);
                        if (LevitationHarness.this.getEnergy(stack) % 60 == 0) {
                            ArcanaItem.putProperty(stack, LevitationHarness.SOULS_TAG, LevitationHarness.this.getSouls(stack) - 1);
                            ArcanaItem.putProperty(stack, LevitationHarness.GLOWSTONE_TAG, LevitationHarness.this.getGlow(stack) - 16);
                        }
                        LevitationHarness.this.buildItemLore(stack, player.method_5682());
                    }
                    ArcanaAchievements.progress(player, ArcanaAchievements.FREQUENT_FLIER.id, 1);
                    if (player.method_23318() >= 1000.0) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.TO_THE_MOON.id);
                    }
                    boolean hasAllay = false;
                    boolean hasBlaze = false;
                    boolean hasBreeze = false;
                    boolean hasBee = false;
                    boolean hasDragon = false;
                    boolean hasPhantom = false;
                    boolean hasGhast = false;
                    boolean hasHappyGhast = false;
                    boolean hasWither = false;
                    boolean hasParrot = false;
                    boolean hasVex = false;
                    boolean hasBat = false;
                    for (class_1297 other : world.method_8335(entity, entity.method_5829().method_1014(32.0))) {
                        class_1299 type = other.method_5864();
                        if (type == class_1299.field_38384) {
                            hasAllay = true;
                            continue;
                        }
                        if (type == class_1299.field_6099) {
                            hasBlaze = true;
                            continue;
                        }
                        if (type == class_1299.field_47244) {
                            hasBreeze = true;
                            continue;
                        }
                        if (type == class_1299.field_20346) {
                            hasBee = true;
                            continue;
                        }
                        if (type == class_1299.field_6116) {
                            hasDragon = true;
                            continue;
                        }
                        if (type == class_1299.field_6078) {
                            hasPhantom = true;
                            continue;
                        }
                        if (type == class_1299.field_6107) {
                            hasGhast = true;
                            continue;
                        }
                        if (type == class_1299.field_59668) {
                            hasHappyGhast = true;
                            continue;
                        }
                        if (type == class_1299.field_6119) {
                            hasWither = true;
                            continue;
                        }
                        if (type == class_1299.field_6104) {
                            hasParrot = true;
                            continue;
                        }
                        if (type == class_1299.field_6059) {
                            hasVex = true;
                            continue;
                        }
                        if (type != class_1299.field_6108) continue;
                        hasBat = true;
                    }
                    if (hasAllay && hasBlaze && hasBreeze && hasBee && hasDragon && hasPhantom && hasGhast && hasHappyGhast && hasWither && hasParrot && hasVex && hasBat) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.AIR_TRAFFIC_CONTROL.id);
                    }
                    ArcanaEffectUtils.harnessFly(serverWorld, player, 10);
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.LEVITATION_HARNESS_PER_SECOND));
                    if (world.method_8503().method_3780() % 120 == 0) {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15045, (float)1.0f, (float)0.8f);
                    }
                }
                if ((stall = ArcanaItem.getIntProperty(stack, LevitationHarness.STALL_TAG)) > 0) {
                    if (stall == 1) {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14891, (float)0.5f, (float)1.6f);
                        player.method_7353((class_2561)class_2561.method_43470((String)"Your Harness Reboots").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                        ArcanaItem.putProperty(stack, LevitationHarness.STALL_TAG, -1);
                    } else {
                        ArcanaItem.putProperty(stack, LevitationHarness.STALL_TAG, stall - 1);
                    }
                }
            }
            if (!chestItem && wasFlying) {
                ArcanaItem.putProperty(stack, LevitationHarness.WAS_FLYING_TAG, false);
            } else if (chestItem && survival) {
                if (wasFlying && !flying) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_19344, (float)0.5f, (float)0.9f);
                    ArcanaItem.putProperty(stack, LevitationHarness.WAS_FLYING_TAG, false);
                } else if (!wasFlying && flying) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14703, (float)0.5f, (float)1.7f);
                    ArcanaItem.putProperty(stack, LevitationHarness.WAS_FLYING_TAG, true);
                }
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            if (playerEntity.method_5715()) {
                class_1799 item = playerEntity.method_5998(hand);
                LevitationHarness.this.openGui(playerEntity, item);
                if (playerEntity instanceof class_3222) {
                    class_3222 player = (class_3222)playerEntity;
                    class_1661 inv = player.method_31548();
                    player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), hand == class_1268.field_5808 ? 36 + inv.method_67532() : 45, item));
                    player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), 6, player.method_6118(class_1304.field_6174)));
                }
                return class_1269.field_52422;
            }
            return super.method_7836(world, playerEntity, hand);
        }
    }
}

