/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.Waystone;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2334;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class Planeshifter
extends EnergyItem {
    public static final String ID = "planeshifter";
    public static final String NETHER_UNLOCK_TAG = "netherUnlocked";
    public static final String END_UNLOCK_TAG = "endUnlocked";
    public static final String DIMENSIONS_TAG = "dimensions";
    public static final String SELECTED_TAG = "selected";
    public static final String HEAT_TAG = "heat";
    public static final int[] cdReduction = new int[]{0, 60, 120, 240, 360, 480};

    public Planeshifter() {
        this.id = ID;
        this.name = "Planeshifter";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 1;
        this.initEnergy = 600;
        this.vanillaItem = class_1802.field_38747;
        this.item = new PlaneshifterItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.planeshifter", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1064});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_TEMPORAL_MOMENT, ResearchTasks.DIMENSION_TRAVEL, ResearchTasks.OBTAIN_EYE_OF_ENDER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        Planeshifter.putProperty(stack, DIMENSIONS_TAG, (class_2520)new class_2499());
        Planeshifter.putProperty(stack, SELECTED_TAG, "");
        Planeshifter.putProperty(stack, HEAT_TAG, 0);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A handheld ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"End").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Nether ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"Portal").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"shifter ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"must be taken to each ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Dimension ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"to unlock their ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"mode").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"When in ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Nether mode").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)", the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"shifter ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"tries to find the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"nearest portal").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"When in ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"End mode").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)", the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"shifter teleports").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" between ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"world spawns").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It requires the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"flowing of time").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"recharge it.").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"activate ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"shifter").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"switch modes").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)""));
        if (itemStack == null) {
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Charged - ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"100%").method_27695(new class_124[]{class_124.field_1067, class_124.field_1076})));
        } else {
            int charge = this.getEnergy(itemStack) * 100 / this.getMaxEnergy(itemStack);
            String charging = charge == 100 ? "Charged" : "Charging";
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(charging + " - ")).method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)(charge + "%")).method_27695(new class_124[]{class_124.field_1067, class_124.field_1076})));
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean hasNether = Planeshifter.getBooleanProperty(stack, NETHER_UNLOCK_TAG);
        boolean hasEnd = Planeshifter.getBooleanProperty(stack, END_UNLOCK_TAG);
        int heat = Planeshifter.getIntProperty(stack, HEAT_TAG);
        class_2499 dimensions = Planeshifter.getListProperty(stack, DIMENSIONS_TAG);
        String selected = Planeshifter.getStringProperty(stack, SELECTED_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        if (hasNether && !dimensions.contains((Object)class_2519.method_23256((String)class_3218.field_25180.method_29177().toString()))) {
            dimensions.add((Object)class_2519.method_23256((String)class_3218.field_25180.method_29177().toString()));
        }
        if (hasEnd && !dimensions.contains((Object)class_2519.method_23256((String)class_3218.field_25181.method_29177().toString()))) {
            dimensions.add((Object)class_2519.method_23256((String)class_3218.field_25181.method_29177().toString()));
        }
        Planeshifter.putProperty(newStack, DIMENSIONS_TAG, (class_2520)dimensions);
        Planeshifter.putProperty(newStack, SELECTED_TAG, selected);
        Planeshifter.putProperty(newStack, HEAT_TAG, heat);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int cdLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.PLANAR_FLOW.id));
        return 600 - cdReduction[cdLvl];
    }

    private void findPortalAndTeleport(class_3222 player, class_3218 destWorld, boolean destIsNether) {
        double scale = class_2874.method_31109((class_2874)player.method_51469().method_8597(), (class_2874)destWorld.method_8597());
        class_2784 worldBorder = destWorld.method_8621();
        class_243 destPos = worldBorder.method_61769(player.method_23317() * scale, player.method_23318(), player.method_23321() * scale);
        Optional portalRect = destWorld.method_14173().method_30483(class_2338.method_49638((class_2374)destPos), destIsNether, worldBorder);
        if (portalRect.isPresent()) {
            player.method_61275(new class_5454(destWorld, ((class_2338)portalRect.get()).method_46558(), player.method_18798(), player.method_36454(), player.method_36455(), class_5454.field_52246.then(entityx -> entityx.method_60950((class_2338)portalRect.get()))));
            player.method_30229();
            player.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter syncs up with a Nether Portal").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter could not find a Nether Portal").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
            this.directTeleport(player, destWorld);
        }
    }

    private void directTeleport(class_3222 player, class_3218 destWorld) {
        double scale = class_2874.method_31109((class_2874)player.method_51469().method_8597(), (class_2874)destWorld.method_8597());
        class_2784 worldBorder = destWorld.method_8621();
        class_243 destPos = worldBorder.method_61769(player.method_23317() * scale, player.method_23318(), player.method_23321() * scale);
        player.method_61275(new class_5454(destWorld, destPos, class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52247));
        for (int y = player.method_31478(); y >= player.method_31478() - destWorld.method_31605(); --y) {
            class_2338 blockPos = new class_2338(player.method_31477(), y, player.method_31479());
            class_2680 state = destWorld.method_8320(blockPos);
            if (state.method_27852(class_2246.field_10164)) {
                ArcanaAchievements.grant(player, ArcanaAchievements.UNFORTUNATE_MATERIALIZATION.id);
                break;
            }
            if (!state.method_26215() && !state.method_26220((class_1922)destWorld, blockPos).method_1110()) break;
        }
    }

    private void teleport(class_1799 stack, class_3222 player) {
        class_3218 world = player.method_51469();
        class_3218 target = this.getTargetDim(stack, world.method_8503());
        if (target == null) {
            return;
        }
        boolean inOverworld = world.method_27983().method_29177().equals((Object)class_3218.field_25179.method_29177());
        boolean inEnd = world.method_27983().method_29177().equals((Object)class_3218.field_25181.method_29177());
        boolean inNether = world.method_27983().method_29177().equals((Object)class_3218.field_25180.method_29177());
        if (inNether) {
            ArcanaAchievements.setCondition(player, ArcanaAchievements.PLANE_RIDER.id, "From The Nether", true);
        }
        if (inEnd) {
            ArcanaAchievements.setCondition(player, ArcanaAchievements.PLANE_RIDER.id, "From The End", true);
        }
        if (inOverworld) {
            ArcanaAchievements.setCondition(player, ArcanaAchievements.PLANE_RIDER.id, "From The Overworld", true);
        }
        boolean destOverworld = target.method_27983().method_29177().equals((Object)class_3218.field_25179.method_29177());
        boolean destEnd = target.method_27983().method_29177().equals((Object)class_3218.field_25181.method_29177());
        boolean destNether = target.method_27983().method_29177().equals((Object)class_3218.field_25180.method_29177());
        if (destNether) {
            ArcanaAchievements.setCondition(player, ArcanaAchievements.PLANE_RIDER.id, "To The Nether", true);
        }
        if (destEnd) {
            ArcanaAchievements.setCondition(player, ArcanaAchievements.PLANE_RIDER.id, "To The End", true);
        }
        if (destOverworld) {
            ArcanaAchievements.setCondition(player, ArcanaAchievements.PLANE_RIDER.id, "To The Overworld", true);
        }
        if (inNether && destOverworld) {
            this.findPortalAndTeleport(player, target, false);
        } else if (destNether) {
            this.findPortalAndTeleport(player, target, true);
        } else if (destEnd || inEnd && destOverworld) {
            class_2334 endPortalBlock = (class_2334)class_2246.field_10027;
            player.method_61275(endPortalBlock.method_60770(player.method_51469(), (class_1297)player, player.method_24515()));
        } else {
            this.directTeleport(player, target);
        }
        ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.PLANESHIFTER_USE));
        this.setEnergy(stack, 0);
        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14716, (float)1.0f, (float)2.0f);
        ArcanaEffectUtils.recallTeleport(world, player.method_19538());
    }

    private class_3218 getTargetDim(class_1799 stack, MinecraftServer server) {
        String selected = Planeshifter.getStringProperty(stack, SELECTED_TAG);
        for (class_3218 serverWorld : server.method_3738()) {
            if (!serverWorld.method_27983().method_29177().toString().equals(selected)) continue;
            return serverWorld;
        }
        return null;
    }

    public boolean hasDimension(class_1799 stack, class_5321<class_1937> world) {
        return Planeshifter.getListProperty(stack, DIMENSIONS_TAG).contains((Object)class_2519.method_23256((String)world.method_29177().toString()));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8449, 8);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8137, 1);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8301, 8);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.TEMPORAL_MOMENT, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Planeshifter").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nPortals are nice, they create a safe, stable connection between worlds, but they take setup. Safety is not a concern for an Arcanist of my caliber. I can just make an unstable rift long enough to slip ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Planeshifter").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nthrough.\n\nHowever, the Shifter needs some dimensional energy from the destination before it can rip open a rift to the destination.\n\nFor some fraction of safety, if the Shifter \n\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Planeshifter").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nfinds a portal near the destination, it should sync my rift to its location.\n\nSneak Use to switch the Shifter\u2019s target dimension.\n\nUsing the Shifter activates its warmup.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Planeshifter").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nTaking damage prematurely disrupts the rift, causing the Shifter to require time to recalibrate.").method_27692(class_124.field_1074)));
        return list;
    }

    public class PlaneshifterItem
    extends ArcanaPolymerItem {
        public PlaneshifterItem() {
            super(Planeshifter.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            ArrayList<String> stringList = new ArrayList<String>();
            String selected = ArcanaItem.getStringProperty(itemStack, Planeshifter.SELECTED_TAG);
            if (context.getPlayer() != null) {
                if (Planeshifter.this.getEnergy(itemStack) < Planeshifter.this.getMaxEnergy(itemStack) || selected.isBlank()) {
                    stringList.add("none");
                } else if (selected.equals(class_1937.field_25179.method_29177().toString())) {
                    stringList.add("overworld");
                } else if (selected.equals(class_1937.field_25181.method_29177().toString())) {
                    stringList.add("end");
                } else if (selected.equals(class_1937.field_25180.method_29177().toString())) {
                    stringList.add("nether");
                } else {
                    stringList.add("other");
                }
            } else {
                stringList.add("none");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!ArcanaItemUtils.isArcane(stack) || !(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            if (playerEntity.method_5715()) {
                this.rotateDimension(stack, player, true);
            } else {
                int curEnergy = Planeshifter.this.getEnergy(stack);
                String selected = ArcanaItem.getStringProperty(stack, Planeshifter.SELECTED_TAG);
                if (curEnergy < Planeshifter.this.getMaxEnergy(stack)) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Planeshifter Recharging: " + curEnergy * 100 / Planeshifter.this.getMaxEnergy(stack) + "%")).method_27692(class_124.field_1062), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                    return class_1269.field_52422;
                }
                if (selected.isBlank()) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter has not unlocked any other dimensions").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                    return class_1269.field_52422;
                }
                if (selected.equals(world.method_27983().method_29177().toString())) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter cannot teleport within the same dimension").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                    return class_1269.field_52422;
                }
                class_3218 targetWorld = Planeshifter.this.getTargetDim(stack, player.method_5682());
                if (targetWorld == null) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter cannot find its target").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                } else if (!playerEntity.method_5682().method_60671((class_1937)playerEntity.method_5682().method_3847(targetWorld.method_27983()))) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The targeted world is not enabled on this Server").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                } else if (curEnergy >= Planeshifter.this.getMaxEnergy(stack)) {
                    ArcanaItem.putProperty(stack, Planeshifter.HEAT_TAG, 1);
                    SoundUtils.playSound((class_1937)playerEntity.method_37908(), (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_14669, (class_3419)class_3419.field_15248, (float)1.0f, (float)1.0f);
                }
            }
            return class_1269.field_52422;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            class_3218 serverWorld;
            block13: {
                block12: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block12;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block13;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            int heat = ArcanaItem.getIntProperty(stack, Planeshifter.HEAT_TAG);
            String selected = ArcanaItem.getStringProperty(stack, Planeshifter.SELECTED_TAG);
            if (selected.equals(world.method_27983().method_29177().toString())) {
                this.rotateDimension(stack, player, false);
            }
            if (heat == 100) {
                Planeshifter.this.teleport(stack, player);
                ArcanaItem.putProperty(stack, Planeshifter.HEAT_TAG, 0);
            } else if (heat > 0) {
                ArcanaItem.putProperty(stack, Planeshifter.HEAT_TAG, heat + 1);
                ArcanaEffectUtils.recallTeleportCharge(serverWorld, player.method_19538());
            } else if (heat == -1) {
                ArcanaEffectUtils.recallTeleportCancel(serverWorld, player.method_19538());
                SoundUtils.playSound((class_1937)player.method_51469(), (class_2338)player.method_24515(), (class_3414)class_3417.field_14797, (class_3419)class_3419.field_15248, (float)8.0f, (float)0.8f);
                ArcanaItem.putProperty(stack, Planeshifter.HEAT_TAG, 0);
                Planeshifter.this.setEnergy(stack, (int)((double)Planeshifter.this.getMaxEnergy(stack) * 0.75));
            }
            if (world.method_8503().method_3780() % 20 == 0) {
                this.unlockDimension(stack, (class_5321<class_1937>)world.method_27983(), player);
                List<class_1799> waystones = ArcanaUtils.getArcanaItems((class_1657)player, ArcanaRegistry.WAYSTONE);
                for (class_1799 waystone : waystones) {
                    Waystone.WaystoneTarget target = Waystone.getTarget(waystone);
                    if (target == null) continue;
                    this.unlockDimension(stack, target.world(), player);
                }
                Planeshifter.this.addEnergy(stack, 1);
                Planeshifter.this.buildItemLore(stack, world.method_8503());
            }
        }

        private void rotateDimension(class_1799 stack, class_3222 player, boolean announce) {
            class_3218 world2;
            class_2499 dimensions = ArcanaItem.getListProperty(stack, Planeshifter.DIMENSIONS_TAG);
            ArrayList<class_5321> dims = new ArrayList<class_5321>();
            for (class_3218 world2 : player.method_5682().method_3738()) {
                if (!dimensions.contains((Object)class_2519.method_23256((String)world2.method_27983().method_29177().toString())) || player.method_51469().method_27983().method_29177().equals((Object)world2.method_27983().method_29177())) continue;
                dims.add(world2.method_27983());
            }
            dims.sort(Comparator.comparing(s -> s.method_29177().method_12832()));
            String selected = ArcanaItem.getStringProperty(stack, Planeshifter.SELECTED_TAG);
            world2 = null;
            if (dims.isEmpty()) {
                ArcanaItem.putProperty(stack, Planeshifter.SELECTED_TAG, "");
                Planeshifter.this.buildItemLore(stack, player.method_5682());
                return;
            }
            if (selected.isEmpty()) {
                world2 = (class_5321)dims.getFirst();
            } else {
                int ind = -1;
                for (int i = 0; i < dims.size(); ++i) {
                    if (!((class_5321)dims.get(i)).method_29177().toString().equals(selected)) continue;
                    ind = i;
                    break;
                }
                ind = (ind + 1) % dims.size();
                world2 = (class_5321)dims.get(ind);
            }
            if (announce) {
                if (world2.equals(class_1937.field_25179)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Planeshifter set to The Overworld").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                } else if (world2.equals(class_1937.field_25180)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Planeshifter set to The Nether").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                } else if (world2.equals(class_1937.field_25181)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Planeshifter set to The End").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Planeshifter set to " + world2.method_29177().toString())).method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                }
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23199, (float)1.0f, (float)0.7f);
            }
            ArcanaItem.putProperty(stack, Planeshifter.SELECTED_TAG, world2.method_29177().toString());
        }

        private void unlockDimension(class_1799 stack, class_5321<class_1937> world, class_3222 player) {
            if (Planeshifter.this.hasDimension(stack, world)) {
                return;
            }
            class_2499 dimensions = ArcanaItem.getListProperty(stack, Planeshifter.DIMENSIONS_TAG);
            if (world.equals((Object)class_1937.field_25179)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter has Unlocked The Overworld").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
            } else if (world.equals((Object)class_1937.field_25180)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter has Unlocked The Nether").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
            } else if (world.equals((Object)class_1937.field_25181)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Planeshifter has Unlocked The End").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)("The Planeshifter has Unlocked " + world.method_29177().toString())).method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
            }
            dimensions.add((Object)class_2519.method_23256((String)world.method_29177().toString()));
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15195, (float)0.3f, (float)2.0f);
            ArcanaItem.putProperty(stack, Planeshifter.DIMENSIONS_TAG, (class_2520)dimensions);
            Planeshifter.this.buildItemLore(stack, player.method_5682());
        }

        public class_1799 method_7854() {
            return Planeshifter.this.prefItem;
        }
    }
}

