/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItemContainer;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.quivers.QuiverGui;
import net.borisshoes.arcananovum.gui.quivers.QuiverSlot;
import net.borisshoes.arcananovum.items.QuiverItem;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class RunicQuiver
extends QuiverItem
implements ArcanaItemContainer.ArcanaItemContainerHaver {
    public static final String ID = "runic_quiver";
    public static final int size = 9;
    private static final int[] refillReduction = new int[]{0, 100, 200, 400, 600, 900};
    private static final double[] efficiencyChance = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.3};
    private static final class_1792 textureItem = class_1802.field_8107;

    public RunicQuiver() {
        this.id = ID;
        this.name = "Runic Quiver";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.color = class_124.field_1076;
        this.vanillaItem = class_1802.field_8745;
        this.itemVersion = 1;
        this.item = new RunicQuiverItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.runic_quiver", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1076});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_OVERFLOWING_QUIVER, ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.CONCENTRATION_DAMAGE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"runes ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"engraved ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"upon the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"quiver ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"hum in the presence of ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" placed within the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"quiver ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"regenerate ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"over ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"time").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arrows ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"take reduced ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"concentration ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"when in the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"quiver").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to put ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Arrows ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"in the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"quiver").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Left Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" with a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Bow").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to swap which ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrow").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" will be shot.").method_27692(class_124.field_1064)));
        if (itemStack != null) {
            int i;
            class_9288 arrowItems = (class_9288)itemStack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            class_1277 inv = new class_1277(9);
            List streamList = arrowItems.method_59712().toList();
            for (i = 0; i < streamList.size(); ++i) {
                inv.method_5447(i, (class_1799)streamList.get(i));
            }
            if (inv.method_5442()) {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contents: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Empty").method_27692(class_124.field_1064)));
            } else {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contents: ").method_27692(class_124.field_1076)));
                for (i = 0; i < inv.method_5439(); ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (stack.method_7960()) continue;
                    class_2583 style = stack.method_7964().method_10866();
                    boolean keepStyle = style.method_10984() || style.method_10966() || style.method_10987() || style.method_10965() || style.method_10986() || style.method_10973() != null && style.method_10973().method_27716() != class_124.field_1068.method_532().intValue();
                    class_5250 name = stack.method_7964().method_27661();
                    if (!keepStyle) {
                        name = name.method_27692(class_124.field_1064);
                    }
                    if (stack.method_7947() == 1 && stack.method_7914() == 1) {
                        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1076)).method_10852((class_2561)name));
                        continue;
                    }
                    lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(stack.method_7947() + "x ")).method_27692(class_124.field_1062)).method_10852((class_2561)name));
                }
            }
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected int getRefillMod(class_1799 item) {
        int refillLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, "quiver_duplication"));
        return 1200 - refillReduction[refillLvl];
    }

    @Override
    protected double getEfficiencyMod(class_1799 item) {
        int effLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, "runic_bottomless"));
        return efficiencyChance[effLvl];
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 quiverStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        newArcanaItem.method_57379(class_9334.field_49622, (Object)((class_9288)quiverStack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)));
        ArcanaAugments.copyAugment(quiverStack, newArcanaItem, ArcanaAugments.OVERFLOWING_BOTTOMLESS.id, ArcanaAugments.RUNIC_BOTTOMLESS.id);
        ArcanaAugments.copyAugment(quiverStack, newArcanaItem, ArcanaAugments.ABUNDANT_AMMO.id, ArcanaAugments.QUIVER_DUPLICATION.id);
        return newArcanaItem;
    }

    private RunicQuiver getOuter() {
        return this;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8745, 32);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9125), 1));
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8137, 2);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_22020, 1);
        GenericArcanaIngredient h = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.OVERFLOWING_QUIVER, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withCore().withFletchery().withEnchanter().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Runic Quiver").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nMy improvements upon the Overflowing Quiver have been completed and now the quiver is capable of sending some of my Arcana to Runic Arrows within.\nI even managed to make the quiver take a reduced amount of").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Runic Quiver").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nconcentration, allowing for more Runic Arrows to be stored without overburdening my mind.\n\nThe quiver acts the same as its base counterpart, just with its ability to store Runic Arrows and a quicker restock time.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    public ArcanaItemContainer getArcanaItemContainer(class_1799 item) {
        int size = 9;
        class_9288 arrows = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        class_1277 inv = new class_1277(size);
        List streamList = arrows.method_59712().toList();
        for (int i = 0; i < streamList.size(); ++i) {
            inv.method_5447(i, (class_1799)streamList.get(i));
        }
        double concMod = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.SHUNT_RUNES.id) > 0 ? 0.25 : 0.5;
        return new ArcanaItemContainer((class_1263)inv, size, 20, "RQ", "Runic Quiver", concMod);
    }

    public class RunicQuiverItem
    extends ArcanaPolymerItem {
        public RunicQuiverItem() {
            super(RunicQuiver.this.getThis());
        }

        @Override
        public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
            if (PolymerResourcePackUtils.hasMainPack((class_3222)context.getPlayer())) {
                return textureItem;
            }
            return super.getPolymerItem(itemStack, context);
        }

        public class_1799 method_7854() {
            return RunicQuiver.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            if (world.method_8503().method_3780() % RunicQuiver.this.getRefillMod(stack) == 0) {
                RunicQuiver.this.refillArrow(player, stack);
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            if (playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                class_1799 stack = playerEntity.method_5998(hand);
                QuiverGui gui = new QuiverGui(player, RunicQuiver.this.getOuter(), stack, true);
                gui.build();
                gui.open();
            }
            return class_1269.field_52422;
        }

        public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 playerEntity, class_5630 cursorStackReference) {
            if (playerEntity.method_37908().field_9236 || !(playerEntity instanceof class_3222)) {
                return false;
            }
            class_3222 player = (class_3222)playerEntity;
            if (clickType == class_5536.field_27013 && otherStack.method_7960()) {
                return false;
            }
            class_9288 beltItems = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            List beltList = beltItems.method_57489().toList();
            if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
                if (!QuiverSlot.isValidItem(otherStack, true)) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                } else {
                    class_3545 addPair;
                    int size = 9;
                    int count = otherStack.method_7947();
                    if (count == ((class_1799)(addPair = MinecraftUtils.tryAddStackToContainerComp((class_9288)beltItems, (int)size, (class_1799)otherStack)).method_15441()).method_7947()) {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                    } else {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34376, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                        stack.method_57379(class_9334.field_49622, (Object)((class_9288)addPair.method_15442()));
                    }
                }
                RunicQuiver.this.buildItemLore(stack, player.method_5682());
                return true;
            }
            if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
                boolean found = false;
                for (class_1799 itemStack : beltList.reversed()) {
                    if (itemStack.method_7960()) continue;
                    cursorStackReference.method_32332(itemStack.method_51164());
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34377, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                    found = true;
                    break;
                }
                if (found) {
                    stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(beltList));
                    RunicQuiver.this.buildItemLore(stack, player.method_5682());
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

