/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ExplainIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ExplainRecipe;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class Waystone
extends ArcanaItem {
    public static final String LOCATION_TAG = "location";
    public static final String ID = "waystone";

    public Waystone() {
        this.id = ID;
        this.name = "Waystone";
        this.rarity = ArcanaRarity.MUNDANE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_8675;
        this.item = new WaystoneItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.waystone", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1080});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_USE_LODESTONE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        Waystone.putProperty(stack, LOCATION_TAG, (class_2520)Waystone.getUnattunedTag());
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"      Waystone").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThe channels of Arcana that course through the realms, Leylines, as the old texts call them, are quite interesting. My measurements suggest that they are not static, but their ebb and flow mostly").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Waystone").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\naround a path, and on a timescale I would consider to be glacial. It might not be the most precise thing, but I can use the faintly unique Arcana of each Leyline to uniquely mark a location in any dimension.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Waystone").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nIt seems like I can transmute a stone to hold on to this compound Leyline signature, as long as it doesn\u2019t get too hot.\n\nUsing the Waystone marks my current location, rotation and dimension.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Waystone").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nHeating the Waystone on a campfire for a few minutes releases the imbued location.\n\nHolding the Waystone in my offhand turns it into a compass that glows when facing its imbued location.\n").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 stack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"stone ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"engraved ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"with a singular").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" rune").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"rune").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" pulses subtly ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"like the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"ocean").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You feel a slight ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"pull").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" towards a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"far away").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" place").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"imbue").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"stone").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" with a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)LOCATION_TAG).method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        if (stack != null) {
            if (!Waystone.isUnattuned(stack)) {
                String dimensionName;
                class_124 dimColor;
                WaystoneTarget target = Waystone.getTarget(stack);
                if (target.world().method_29177().toString().equals(class_3218.field_25179.method_29177().toString())) {
                    dimColor = class_124.field_1060;
                    dimensionName = "Overworld";
                } else if (target.world().method_29177().toString().equals(class_3218.field_25180.method_29177().toString())) {
                    dimColor = class_124.field_1061;
                    dimensionName = "The Nether";
                } else if (target.world().method_29177().toString().equals(class_3218.field_25181.method_29177().toString())) {
                    dimColor = class_124.field_1064;
                    dimensionName = "The End";
                } else {
                    dimColor = class_124.field_1054;
                    dimensionName = target.world().method_29177().toString();
                }
                String location = dimensionName + " (" + (int)target.position().method_10216() + "," + (int)target.position().method_10214() + "," + (int)target.position().method_10215() + ")";
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)("Location - " + location)).method_27692(dimColor));
            } else {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"Unattuned").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            }
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class_2487 getUnattunedTag() {
        class_2487 newComp = new class_2487();
        newComp.method_10556("unattuned", true);
        return newComp;
    }

    public static void setUnattuned(class_1799 stack) {
        Waystone.putProperty(stack, LOCATION_TAG, (class_2520)Waystone.getUnattunedTag());
    }

    public static boolean isUnattuned(class_1799 stack) {
        if (!stack.method_31574(ArcanaRegistry.WAYSTONE.getItem())) {
            return false;
        }
        class_2487 comp = ArcanaItem.getCompoundProperty(stack, LOCATION_TAG);
        return comp.method_68566("unattuned", true) || Waystone.getTarget(stack) == null;
    }

    public static void saveTarget(class_1799 stack, WaystoneTarget target) {
        if (!stack.method_31574(ArcanaRegistry.WAYSTONE.getItem()) || target == null) {
            return;
        }
        class_2487 newComp = new class_2487();
        newComp.method_10582("dim", target.world().method_29177().toString());
        newComp.method_10549("x", target.position().field_1352);
        newComp.method_10549("y", target.position().field_1351);
        newComp.method_10549("z", target.position().field_1350);
        newComp.method_10548("yaw", target.yaw());
        newComp.method_10548("pitch", target.pitch());
        newComp.method_10556("unattuned", false);
        ArcanaItem.putProperty(stack, LOCATION_TAG, (class_2520)newComp);
        stack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.of(new class_4208(target.world(), class_2338.method_49638((class_2374)target.position()))), false));
    }

    public static WaystoneTarget getTarget(class_1799 stack) {
        if (!stack.method_31574(ArcanaRegistry.WAYSTONE.getItem())) {
            return null;
        }
        class_2487 comp = ArcanaItem.getCompoundProperty(stack, LOCATION_TAG);
        String worldStr = comp.method_68564("dim", "");
        class_5321 worldKey = null;
        for (class_3218 world : BorisLib.SERVER.method_3738()) {
            if (!world.method_27983().method_29177().toString().equals(worldStr)) continue;
            worldKey = world.method_27983();
            break;
        }
        if (worldKey == null) {
            return null;
        }
        double x = comp.method_68563("x", 0.0);
        double y = comp.method_68563("y", 0.0);
        double z = comp.method_68563("z", 0.0);
        float yaw = comp.method_66563("yaw", 0.0f);
        float pitch = comp.method_66563("pitch", 0.0f);
        return new WaystoneTarget((class_5321<class_1937>)worldKey, new class_243(x, y, z), yaw, pitch);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ExplainIngredient b = new ExplainIngredient(GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918), 1, "", false).withName((class_2561)class_2561.method_43470((String)"Transmutation Recipe").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Use a Transmutation Altar").method_27692(class_124.field_1062)));
        ExplainIngredient w = new ExplainIngredient(GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)0xDBDBDB), 1, "", false).withName((class_2561)class_2561.method_43470((String)"Transmutation Recipe").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Use a Transmutation Altar").method_27692(class_124.field_1062)));
        ExplainIngredient c = new ExplainIngredient(class_1802.field_8725, 42, "Redstone Dust").withName((class_2561)class_2561.method_43470((String)"Redstone Dust").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Transmutation Reagent").method_27692(class_124.field_1065)));
        ExplainIngredient t = new ExplainIngredient(ArcanaRegistry.TRANSMUTATION_ALTAR.getItem(), 1, "", false).withName((class_2561)class_2561.method_43470((String)"Transmutation Altar").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Use a Transmutation Altar").method_27692(class_124.field_1062)));
        ExplainIngredient d = new ExplainIngredient(class_1802.field_27063, 16, "Amethyst Shard").withName((class_2561)class_2561.method_43470((String)"Amethyst Shards").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Transmutation Reagent").method_27692(class_124.field_1064)));
        ExplainIngredient p = new ExplainIngredient(class_1802.field_23256, 1, "Lodestone").withName((class_2561)class_2561.method_43470((String)"Lodestone").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Infusion Input").method_27692(class_124.field_1068)));
        ExplainIngredient[][] ingredients = new ExplainIngredient[][]{{b, b, p, b, b}, {b, b, b, b, w}, {c, b, t, w, d}, {b, w, w, w, w}, {w, w, w, w, w}};
        return new ExplainRecipe(ingredients);
    }

    public class WaystoneItem
    extends ArcanaPolymerItem {
        public WaystoneItem() {
            super(Waystone.this.getThis());
        }

        public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
            class_1799 stack = user.method_5998(hand);
            if (Waystone.isUnattuned(stack) && user instanceof class_3222) {
                class_3222 player = (class_3222)user;
                Waystone.saveTarget(stack, new WaystoneTarget((class_5321<class_1937>)user.method_37908().method_27983(), user.method_19538(), user.method_36454(), user.method_36455()));
                Waystone.this.buildItemLore(stack, player.method_5682());
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23199, (float)1.0f, (float)0.7f);
                return class_1269.field_5812;
            }
            return class_1269.field_52423;
        }

        public class_1269 method_7884(class_1838 context) {
            class_2586 class_25862;
            if (context.method_8036() != null && context.method_8036().method_5715() && !Waystone.isUnattuned(context.method_8041()) && (class_25862 = context.method_8045().method_8321(context.method_8037())) instanceof StarpathAltarBlockEntity) {
                StarpathAltarBlockEntity sabe = (StarpathAltarBlockEntity)class_25862;
                WaystoneTarget target = Waystone.getTarget(context.method_8041());
                if (target != null && ArcanaAugments.getAugmentFromMap(sabe.getAugments(), ArcanaAugments.STARGATE.id) > 0 || target.world.method_29177().equals((Object)context.method_8045().method_27983().method_29177())) {
                    sabe.setTarget(new StarpathAltarBlockEntity.TargetEntry(ArcanaUtils.getFormattedDimName(target.world).getString() + " " + class_2338.method_49638((class_2374)target.position()).method_23854(), target.world.method_29177().toString(), (int)target.position().method_10216(), (int)target.position().method_10214(), (int)target.position().method_10215()));
                    SoundUtils.playSound((class_1937)context.method_8036().method_37908(), (class_2338)context.method_8037(), (class_3414)class_3417.field_23116, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.7f);
                }
            }
            return super.method_7884(context);
        }

        @Override
        public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
            if (PolymerResourcePackUtils.hasMainPack((class_3222)context.getPlayer())) {
                return Waystone.this.getThis().getVanillaItem();
            }
            return class_1802.field_23256;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            boolean shouldAdd;
            super.method_7888(stack, world, entity, slot);
            boolean bl = shouldAdd = slot == class_1304.field_6171 && !stack.method_57826(class_9334.field_49614) && Waystone.getTarget(stack) != null;
            if (shouldAdd) {
                WaystoneTarget target = Waystone.getTarget(stack);
                stack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.of(new class_4208(target.world(), class_2338.method_49638((class_2374)target.position()))), false));
            } else if (slot != class_1304.field_6171 && stack.method_57826(class_9334.field_49614)) {
                stack.method_57381(class_9334.field_49614);
            }
        }

        @Override
        @Nullable
        public class_2960 getPolymerItemModel(class_1799 stack, PacketContext context) {
            if (PolymerResourcePackUtils.hasMainPack((PacketContext)context)) {
                if (Waystone.isUnattuned(stack)) {
                    return class_2960.method_60655((String)"arcananovum", (String)"waystone_unattuned");
                }
                WaystoneTarget target = Waystone.getTarget(stack);
                class_5321<class_1937> dim = target.world();
                if (dim.toString().equals(class_3218.field_25179.toString())) {
                    return class_2960.method_60655((String)"arcananovum", (String)"waystone_overworld");
                }
                if (dim.toString().equals(class_3218.field_25180.toString())) {
                    return class_2960.method_60655((String)"arcananovum", (String)"waystone_nether");
                }
                if (dim.toString().equals(class_3218.field_25181.toString())) {
                    return class_2960.method_60655((String)"arcananovum", (String)"waystone_end");
                }
                return class_2960.method_60655((String)"arcananovum", (String)"waystone_unknown");
            }
            return ((class_5321)class_7923.field_41178.method_29113((Object)this.getPolymerItem(stack, context)).get()).method_29177();
        }
    }

    public record WaystoneTarget(class_5321<class_1937> world, class_243 position, float yaw, float pitch) {
    }
}

