/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.lootfunctions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.items.normal.ArcaneNotesItem;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.minecraft.class_120;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public class ArcaneNotesLootFunction
extends class_120 {
    public static final MapCodec<ArcaneNotesLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> ArcaneNotesLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41197).fieldOf("items").forGetter(function -> function.itemTag), (App)Codec.INT.fieldOf("mundane_weight").forGetter(function -> function.mundaneWeight), (App)Codec.INT.fieldOf("empowered_weight").forGetter(function -> function.empoweredWeight), (App)Codec.INT.fieldOf("exotic_weight").forGetter(function -> function.exoticWeight), (App)Codec.INT.fieldOf("sovereign_weight").forGetter(function -> function.sovereignWeight), (App)Codec.INT.fieldOf("divine_weight").forGetter(function -> function.divineWeight))).apply((Applicative)instance, ArcaneNotesLootFunction::new));
    private final class_6885<class_1792> itemTag;
    private final int mundaneWeight;
    private final int empoweredWeight;
    private final int exoticWeight;
    private final int sovereignWeight;
    private final int divineWeight;

    protected ArcaneNotesLootFunction(List<class_5341> conditions, class_6885<class_1792> itemTag, int mundaneWeight, int empoweredWeight, int exoticWeight, int sovereignWeight, int divineWeight) {
        super(conditions);
        this.itemTag = itemTag;
        this.mundaneWeight = mundaneWeight;
        this.empoweredWeight = empoweredWeight;
        this.exoticWeight = exoticWeight;
        this.sovereignWeight = sovereignWeight;
        this.divineWeight = divineWeight;
    }

    public class_5339<? extends class_120> method_29321() {
        return ArcanaRegistry.ARCANE_NOTES_LOOT_FUNCTION;
    }

    protected class_1799 method_522(class_1799 stack, class_47 context) {
        class_5819 random = context.method_294();
        if (!stack.method_31574(ArcanaRegistry.ARCANE_NOTES)) {
            return stack;
        }
        List<class_3545> weights = List.of(new class_3545((Object)ArcanaRarity.MUNDANE, (Object)this.mundaneWeight), new class_3545((Object)ArcanaRarity.EMPOWERED, (Object)this.empoweredWeight), new class_3545((Object)ArcanaRarity.EXOTIC, (Object)this.exoticWeight), new class_3545((Object)ArcanaRarity.SOVEREIGN, (Object)this.sovereignWeight), new class_3545((Object)ArcanaRarity.DIVINE, (Object)this.divineWeight));
        ArcanaRarity rarity = (ArcanaRarity)((Object)AlgoUtils.getWeightedOption(weights, (long)random.method_43055()));
        List<class_6880> items = this.itemTag.method_40239().filter(entry -> {
            ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(entry.method_55840());
            return arcanaItem != null && arcanaItem.getRarity() == rarity;
        }).toList();
        if (items.isEmpty()) {
            return stack;
        }
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(items.get(random.method_43048(items.size())).method_55840());
        String arcanaId = arcanaItem.getId();
        ArcanaItem.putProperty(stack, "research_id", arcanaId);
        ArcaneNotesItem.buildLore(stack);
        return stack;
    }
}

