/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.callbacks.ShieldTimerCallback;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.BinaryBlades;
import net.borisshoes.arcananovum.items.EverlastingRocket;
import net.borisshoes.arcananovum.items.GreavesOfGaialtus;
import net.borisshoes.arcananovum.items.QuiverItem;
import net.borisshoes.arcananovum.items.RunicBow;
import net.borisshoes.arcananovum.items.ShieldOfFortitude;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1935;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin {
    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackKnockbackAgainst(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/damage/DamageSource;)F")})
    private void arcananovum$postDamageEntity(class_1297 target, CallbackInfo ci, @Local(ordinal=2) float atkPercentage) {
        class_1657 player = (class_1657)this;
        class_1799 handStack = player.method_6047();
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(handStack);
        if (arcanaItem instanceof BinaryBlades) {
            BinaryBlades blades = (BinaryBlades)arcanaItem;
            if ((double)atkPercentage > 0.85) {
                ArcanaItem.putProperty(handStack, "last_hit", 12);
                blades.addEnergy(handStack, 10);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    BorisLib.addTickTimerCallback((class_3218)serverPlayer.method_51469(), (TickTimerCallback)new GenericTimer(4, () -> serverPlayer.method_51469().method_14178().method_18751((class_1297)serverPlayer, (class_2596)new class_2616((class_1297)serverPlayer, 3))));
                }
            }
        }
    }

    @ModifyReturnValue(method={"isClimbing"}, at={@At(value="RETURN")})
    private boolean arcananovum$greavesClimbing(boolean original) {
        class_1657 player;
        block6: {
            block5: {
                player = (class_1657)this;
                if (original) {
                    return true;
                }
                class_1799 pants = player.method_6118(class_1304.field_6172);
                ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(pants);
                if (!(arcanaItem instanceof GreavesOfGaialtus)) break block5;
                GreavesOfGaialtus greaves = (GreavesOfGaialtus)arcanaItem;
                if (ArcanaAugments.getAugmentOnItem(pants, ArcanaAugments.EARTHEN_ASCENT) >= 1) break block6;
            }
            return original;
        }
        if (player.field_5976) {
            return true;
        }
        return original;
    }

    @ModifyExpressionValue(method={"getBlockBreakingSpeed"}, at={@At(value="CONSTANT", args={"floatValue=5.0"})})
    private float arcananovum$offGroundBlockBreakingSpeed(float constant) {
        class_1657 player = (class_1657)this;
        List<class_1799> stacks = ArcanaUtils.getArcanaItemsWithAug(player, ArcanaRegistry.CETACEA_CHARM, ArcanaAugments.MARINERS_GRACE, 1);
        int level = 0;
        for (class_1799 stack : stacks) {
            int lvl;
            boolean isActive = ArcanaItem.getBooleanProperty(stack, "active");
            if (!isActive || (lvl = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.MARINERS_GRACE)) <= level) continue;
            level = lvl;
        }
        return level == 0 ? constant : Math.min(constant, Math.max(1.0f, constant - (float)level * 1.34f));
    }

    @ModifyExpressionValue(method={"getBlockBreakingSpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/EntityAttributeInstance;getValue()D")})
    private double arcananovum$underwaterBlockBreakingSpeed(double original) {
        class_1657 player = (class_1657)this;
        List<class_1799> stacks = ArcanaUtils.getArcanaItemsWithAug(player, ArcanaRegistry.CETACEA_CHARM, ArcanaAugments.MARINERS_GRACE, 1);
        int level = 0;
        for (class_1799 stack : stacks) {
            int lvl;
            boolean isActive = ArcanaItem.getBooleanProperty(stack, "active");
            if (!isActive || (lvl = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.MARINERS_GRACE)) <= level) continue;
            level = lvl;
        }
        return level == 0 ? original : Math.max(original, Math.min(1.0, original + (double)level * 0.35));
    }

    @Inject(method={"takeShieldHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/component/type/BlocksAttacksComponent;applyShieldCooldown(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;FLnet/minecraft/item/ItemStack;)V")})
    private void arcananovum$disableFortitudeShield(class_3218 world, class_1309 attacker, CallbackInfo ci, @Local class_1799 shield) {
        if (!(shield.method_7909() instanceof ShieldOfFortitude.ShieldOfFortitudeItem)) {
            return;
        }
        class_1657 player = (class_1657)this;
        ArrayList<ShieldTimerCallback> toRemove = new ArrayList<ShieldTimerCallback>();
        for (int i = 0; i < BorisLib.SERVER_TIMER_CALLBACKS.size(); ++i) {
            ShieldTimerCallback st;
            TickTimerCallback t = (TickTimerCallback)BorisLib.SERVER_TIMER_CALLBACKS.get(i);
            if (!(t instanceof ShieldTimerCallback) || !(st = (ShieldTimerCallback)t).getPlayer().method_5845().equals(player.method_5845())) continue;
            toRemove.add(st);
        }
        toRemove.forEach(ShieldTimerCallback::onTimer);
        BorisLib.SERVER_TIMER_CALLBACKS.removeIf(toRemove::contains);
    }

    @Inject(method={"getProjectileType"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/RangedWeaponItem;getProjectiles()Ljava/util/function/Predicate;", shift=At.Shift.BEFORE)}, cancellable=true)
    private void arcananovum$quiverCheck(class_1799 bow, CallbackInfoReturnable<class_1799> cir) {
        boolean runic;
        boolean runicArbalest;
        class_1657 player = (class_1657)this;
        boolean runicBow = ArcanaItemUtils.identifyItem(bow) instanceof RunicBow;
        boolean bl = runicArbalest = bow.method_31574(ArcanaRegistry.ALCHEMICAL_ARBALEST.getItem()) && ArcanaAugments.getAugmentOnItem(bow, ArcanaAugments.RUNIC_ARBALEST.id) >= 1;
        if (!(bow.method_31574(class_1802.field_8102) || runicBow || bow.method_31574(class_1802.field_8399) || bow.method_31574(ArcanaRegistry.ALCHEMICAL_ARBALEST.getItem()))) {
            return;
        }
        boolean bl2 = runic = runicBow || runicArbalest;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_1799 arrowStack = QuiverItem.getArrowStack(serverPlayer, runic, false);
            class_3545<String, Integer> option = QuiverItem.getArrowOption(serverPlayer, runic, false);
            if (arrowStack != null && option != null) {
                class_1799 returnStack = arrowStack.method_7972();
                ArcanaItem.putProperty(returnStack, "QuiverSlot", (Integer)option.method_15441());
                ArcanaItem.putProperty(returnStack, "QuiverId", (String)option.method_15442());
                cir.setReturnValue((Object)returnStack);
            } else if (runicArbalest) {
                Predicate predicate = ((class_1811)bow.method_7909()).method_19268();
                for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                    class_1799 itemStack2 = player.method_31548().method_5438(i);
                    if (!predicate.test(itemStack2) && !ArcanaItemUtils.isRunicArrow(itemStack2)) continue;
                    cir.setReturnValue((Object)itemStack2);
                }
            }
        }
    }

    @Inject(method={"getProjectileType"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/RangedWeaponItem;getHeldProjectile(Lnet/minecraft/entity/LivingEntity;Ljava/util/function/Predicate;)Lnet/minecraft/item/ItemStack;", shift=At.Shift.BEFORE)}, cancellable=true)
    private void arcananovum$everlastingRocketCheck(class_1799 stack, CallbackInfoReturnable<class_1799> cir, @Local Predicate<class_1799> predicate) {
        class_1657 player = (class_1657)this;
        class_1799 main = player.method_5998(class_1268.field_5808);
        class_1799 off = player.method_5998(class_1268.field_5810);
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(main);
        if (arcanaItem instanceof EverlastingRocket) {
            EverlastingRocket rocket = (EverlastingRocket)arcanaItem;
            fireworkStack = rocket.getFireworkStack(main);
            if (rocket.getEnergy(main) > 0 && predicate.test((class_1799)fireworkStack)) {
                cir.setReturnValue((Object)fireworkStack);
            }
        } else {
            fireworkStack = ArcanaItemUtils.identifyItem(off);
            if (fireworkStack instanceof EverlastingRocket) {
                EverlastingRocket rocket = (EverlastingRocket)fireworkStack;
                fireworkStack = rocket.getFireworkStack(off);
                if (rocket.getEnergy(off) > 0 && predicate.test((class_1799)fireworkStack)) {
                    cir.setReturnValue((Object)fireworkStack);
                }
            }
        }
    }

    @Inject(method={"getProjectileType"}, at={@At(value="RETURN")}, cancellable=true)
    private void arcananovum$stopRunicUsage(class_1799 bow, CallbackInfoReturnable<class_1799> cir) {
        class_1657 player = (class_1657)this;
        if (!bow.method_31574(class_1802.field_8102) || bow.method_31574(class_1802.field_8399) || bow.method_31574(ArcanaRegistry.ALCHEMICAL_ARBALEST.getItem())) {
            return;
        }
        boolean runicArbalest = ArcanaAugments.getAugmentOnItem(bow, ArcanaAugments.RUNIC_ARBALEST.id) >= 1;
        class_1799 curReturn = (class_1799)cir.getReturnValue();
        if (ArcanaItemUtils.isRunicArrow(curReturn) && !runicArbalest) {
            cir.setReturnValue((Object)(player.method_68878() ? new class_1799((class_1935)class_1802.field_8107) : class_1799.field_8037));
        }
    }

    @Inject(method={"addExperience"}, at={@At(value="RETURN")})
    private void arcananovum$addExperience(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (player.field_7520 >= 100) {
                ArcanaNovum.data((class_1657)serverPlayer).setResearchTask(ResearchTasks.LEVEL_100, true);
            }
        }
    }

    @Inject(method={"useRiptide"}, at={@At(value="HEAD")})
    private void arcananovum$useRiptide(int riptideTicks, float riptideAttackDamage, class_1799 stack, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (stack.method_31574(class_1802.field_8547)) {
                ArcanaNovum.data((class_1657)serverPlayer).setResearchTask(ResearchTasks.RIPTIDE_TRIDENT, true);
            }
        }
    }
}

