/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.Map;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.MagmaticEversource;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;

public class MagmaticEversourceFillRecipe
extends class_1852 {
    private static final Map<class_1792, class_1799> FILLABLE = Map.ofEntries(Map.entry(class_1802.field_8550, class_1802.field_8187.method_7854()));

    public MagmaticEversourceFillRecipe(class_7710 craftingRecipeCategory) {
        super(class_7710.field_40251);
    }

    public boolean matches(class_9694 input, class_1937 world) {
        boolean hasEversource = false;
        boolean hasFillable = false;
        int eversourceSlot = -1;
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 rStack = input.method_59984(i);
            if (rStack.method_7960()) continue;
            if (!hasEversource && rStack.method_7909() instanceof MagmaticEversource.MagmaticEversourceItem) {
                hasEversource = true;
                eversourceSlot = i;
                continue;
            }
            if (!hasFillable && FILLABLE.containsKey(rStack.method_7909())) {
                hasFillable = true;
                continue;
            }
            return false;
        }
        if (!hasEversource || !hasFillable) {
            return false;
        }
        class_1799 eversource = input.method_59984(eversourceSlot);
        int charges = ArcanaItem.getIntProperty(eversource, "charges");
        return charges >= 1;
    }

    public class_1799 craft(class_9694 input, class_7225.class_7874 registries) {
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 rStack = input.method_59984(i);
            if (!FILLABLE.containsKey(rStack.method_7909())) continue;
            return FILLABLE.get(rStack.method_7909()).method_46651(1);
        }
        return class_1799.field_8037;
    }

    public class_2371<class_1799> method_17704(class_9694 input) {
        class_2371 stacks = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 rStack = input.method_59984(i);
            if (rStack.method_7960() || !(rStack.method_7909() instanceof MagmaticEversource.MagmaticEversourceItem)) continue;
            class_1799 source = rStack.method_7972();
            ArcanaItem.putProperty(source, "charges", ArcanaItem.getIntProperty(source, "charges") - 1);
            stacks.set(i, (Object)source);
        }
        return stacks;
    }

    public class_1865<? extends class_1852> method_8119() {
        return ArcanaRegistry.MAGMATIC_EVERSOURCE_FILL_RECIPE_SERIALIZER;
    }

    public static class MagmaticEversourceRecipeSerializer
    extends class_1852.class_1866
    implements PolymerObject {
        public MagmaticEversourceRecipeSerializer(class_1852.class_1866.class_7711 factory) {
            super(factory);
        }
    }
}

