/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.arcana;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class ArcanaIngredient {
    protected final class_1792 itemType;
    protected final int count;
    protected Predicate<class_1799> itemPredicate;
    protected final class_1799 exampleStack;
    protected final boolean ignoresResourceful;
    public static final ArcanaIngredient EMPTY = new ArcanaIngredient(class_1802.field_8162, 0, true, class_1799.field_8037, class_1799::method_7960);

    public ArcanaIngredient(class_1792 itemType, int count, boolean ignoresResourceful) {
        this.count = count;
        this.itemType = itemType;
        this.ignoresResourceful = ignoresResourceful;
        this.exampleStack = new class_1799((class_1935)itemType, count);
        this.itemPredicate = stack -> stack.method_31574(itemType);
    }

    public ArcanaIngredient(class_1792 itemType, int count) {
        this.count = count;
        this.itemType = itemType;
        this.exampleStack = new class_1799((class_1935)itemType, count);
        this.itemPredicate = stack -> stack.method_31574(itemType);
        this.ignoresResourceful = false;
    }

    private ArcanaIngredient(class_1792 itemType, int count, boolean ignoresResourceful, class_1799 exampleStack, Predicate<class_1799> itemPredicate) {
        this.count = count;
        this.itemType = itemType;
        this.exampleStack = exampleStack.method_46651(count);
        this.itemPredicate = itemPredicate;
        this.ignoresResourceful = ignoresResourceful;
    }

    public ArcanaIngredient copyWithCount(int newCount) {
        return new ArcanaIngredient(this.itemType, newCount, this.ignoresResourceful, this.exampleStack, this.itemPredicate);
    }

    public ArcanaIngredient withEnchantments(class_1889 ... enchantments) {
        this.itemPredicate = this.itemPredicate.and(stack -> {
            class_9304 enchants = class_1890.method_57532((class_1799)stack);
            for (class_1889 enchantment : enchantments) {
                if (enchants.method_57536(enchantment.comp_3486()) >= enchantment.comp_3487()) continue;
                return false;
            }
            return true;
        });
        for (class_1889 enchantment : enchantments) {
            this.exampleStack.method_7978(enchantment.comp_3486(), enchantment.comp_3487());
        }
        return this;
    }

    public ArcanaIngredient withPotions(class_6880<class_1842> ... potions) {
        ArrayList effects = new ArrayList();
        Arrays.stream(potions).forEach(potion -> effects.addAll(((class_1842)potion.comp_349()).method_8049()));
        return this.withEffects(effects.toArray(new class_1293[0]));
    }

    public ArcanaIngredient withEffects(class_1293 ... effects) {
        this.itemPredicate = this.itemPredicate.and(stack -> {
            class_1844 pots = (class_1844)stack.method_58694(class_9334.field_49651);
            for (class_1293 reqEffect : effects) {
                boolean found = false;
                for (class_1293 effect : pots.method_57397()) {
                    if (!((class_1291)reqEffect.method_5579().comp_349()).equals(effect.method_5579().comp_349()) || effect.method_5578() < reqEffect.method_5578() || effect.method_5584() < reqEffect.method_5584()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        });
        OptionalInt colorOpt = class_1844.method_58111(List.of(effects));
        class_1844 newComp = new class_1844(Optional.empty(), colorOpt.isPresent() ? Optional.of(colorOpt.getAsInt()) : Optional.empty(), List.of(effects), Optional.empty());
        this.exampleStack.method_57379(class_9334.field_49651, (Object)newComp);
        if (this.exampleStack.method_31574(class_1802.field_8574)) {
            this.exampleStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Potion").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        } else if (this.exampleStack.method_31574(class_1802.field_8436)) {
            this.exampleStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Splash Potion").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        } else if (this.exampleStack.method_31574(class_1802.field_8150)) {
            this.exampleStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Lingering Potion").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        }
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public class_1792 getItemType() {
        return this.itemType;
    }

    public boolean validStack(class_1799 stack) {
        return this.itemPredicate.test(stack) && stack.method_7947() >= this.count;
    }

    public boolean validStackIgnoreCount(class_1799 stack) {
        return this.itemPredicate.test(stack);
    }

    public class_1799 getRemainder(class_1799 stack, int resourceLvl) {
        int newCount;
        int saved = 0;
        if (!this.ignoresResourceful) {
            for (int i = 0; i < this.count; ++i) {
                if (!(Math.random() < 0.05 * (double)resourceLvl)) continue;
                ++saved;
            }
        }
        int n = newCount = ArcanaItemUtils.isArcane(stack) ? this.count : this.count - saved;
        if (stack.method_7947() <= newCount) {
            return class_1799.field_8037;
        }
        class_1799 stackCopy = stack.method_7972();
        stackCopy.method_7934(newCount);
        return stackCopy;
    }

    public class_1799 ingredientAsStack() {
        return this.exampleStack.method_7972();
    }

    public String getName() {
        return this.ingredientAsStack().method_7964().getString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArcanaIngredient)) {
            return false;
        }
        ArcanaIngredient o = (ArcanaIngredient)other;
        return o.itemPredicate.test(this.exampleStack) && this.itemPredicate.test(o.exampleStack);
    }
}

