/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.transmutation;

import java.util.ArrayList;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.AequalisScientia;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipe;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class AequalisUnattuneTransmutationRecipe
extends TransmutationRecipe {
    protected AequalisUnattuneTransmutationRecipe(String name) {
        super(name, new class_1799((class_1935)ArcanaRegistry.NEBULOUS_ESSENCE, 48), new class_1799((class_1935)class_1802.field_27063, 48));
    }

    @Override
    public List<class_1799> doTransmutation(class_1799 positiveInput, class_1799 negativeInput, class_1799 reagent1, class_1799 reagent2, class_1799 aequalisInput, class_3222 player) {
        ArrayList<class_1799> returnItems = new ArrayList<class_1799>();
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(positiveInput);
        if (arcanaItem instanceof AequalisScientia) {
            AequalisScientia aeq = (AequalisScientia)arcanaItem;
            ArcanaItem.putProperty(positiveInput, "transmutation_id", "");
            aeq.buildItemLore(positiveInput, player.method_5682());
        }
        returnItems.add(positiveInput);
        returnItems.add(aequalisInput);
        return returnItems;
    }

    @Override
    public List<class_3545<class_1799, String>> doTransmutation(class_1542 input1Entity, class_1542 input2Entity, class_1542 reagent1Entity, class_1542 reagent2Entity, class_1542 aequalisEntity, TransmutationAltarBlockEntity altar, class_3222 player) {
        int take;
        class_1799 reagent2;
        boolean cross;
        String outputPos;
        class_1542 inputEntity;
        class_1799 inputStack;
        class_1799 reagent2Stack;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        class_1799 reagent1Stack = reagent1Entity != null ? reagent1Entity.method_6983() : class_1799.field_8037;
        class_1799 class_17992 = reagent2Stack = reagent2Entity != null ? reagent2Entity.method_6983() : class_1799.field_8037;
        if (input1Entity != null && this.validStack(ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItem(), input1Entity.method_6983())) {
            inputStack = input1Entity.method_6983();
            inputEntity = input1Entity;
            outputPos = "negative";
        } else if (input2Entity != null && this.validStack(ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItem(), input2Entity.method_6983())) {
            inputStack = input2Entity.method_6983();
            inputEntity = input2Entity;
            outputPos = "positive";
        } else {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        if (!this.canTransmute(inputStack, class_1799.field_8037, reagent1Stack, reagent2Stack, class_1799.field_8037, altar)) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        ArrayList<class_3545<class_1799, String>> outputs = new ArrayList<class_3545<class_1799, String>>();
        int consumedInput = 1;
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(inputStack);
        if (arcanaItem instanceof AequalisScientia) {
            AequalisScientia aeq = (AequalisScientia)arcanaItem;
            ArcanaItem.putProperty(inputStack, "transmutation_id", "");
            aeq.buildItemLore(inputStack, altar.method_10997().method_8503());
        }
        outputs.add(new class_3545((Object)inputStack, (Object)outputPos));
        if (inputStack.method_7947() == consumedInput) {
            inputEntity.method_31472();
        } else {
            inputStack.method_7934(consumedInput);
            inputEntity.method_6979(inputStack);
        }
        boolean m11 = this.validStack(re1, reagent1Stack);
        boolean m22 = this.validStack(re2, reagent2Stack);
        boolean m12 = this.validStack(re1, reagent2Stack);
        boolean m21 = this.validStack(re2, reagent1Stack);
        boolean straight = m11 && m22;
        boolean bl = cross = !straight && m12 && m21;
        if (!straight && !cross) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        class_1799 reagent1 = straight ? re1 : re2;
        class_1799 class_17993 = reagent2 = straight ? re2 : re1;
        if (reagent1Entity != null) {
            int n = take = reagent1.method_7960() ? 0 : reagent1.method_7947();
            if (take > 0) {
                if (reagent1Stack.method_7947() == take) {
                    reagent1Entity.method_31472();
                } else {
                    reagent1Stack.method_7934(take);
                    reagent1Entity.method_6979(reagent1Stack);
                }
            }
        }
        if (reagent2Entity != null) {
            int n = take = reagent2.method_7960() ? 0 : reagent2.method_7947();
            if (take > 0) {
                if (reagent2Stack.method_7947() == take) {
                    reagent2Entity.method_31472();
                } else {
                    reagent2Stack.method_7934(take);
                    reagent2Entity.method_6979(reagent2Stack);
                }
            }
        }
        return outputs;
    }

    @Override
    public boolean canTransmute(class_1799 input1, class_1799 input2, class_1799 reagent1Input, class_1799 reagent2Input, class_1799 aequalisInput, TransmutationAltarBlockEntity altar) {
        class_1937 class_19372;
        boolean hasAugmentAndAttuned;
        class_1799 inputStack;
        boolean reagentCheck2;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        boolean reagentCheck1 = this.validStack(re1, reagent1Input) && this.validStack(re2, reagent2Input);
        boolean bl = reagentCheck2 = this.validStack(re1, reagent2Input) && this.validStack(re2, reagent1Input);
        if (!reagentCheck1 && !reagentCheck2) {
            return false;
        }
        if (this.validStack(ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItem(), input1)) {
            inputStack = input1;
        } else if (this.validStack(ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItem(), input2)) {
            inputStack = input2;
        } else {
            return false;
        }
        boolean bl2 = hasAugmentAndAttuned = ArcanaAugments.getAugmentOnItem(inputStack, ArcanaAugments.IMPERMANENT_PERMUTATION.id) > 0 && !ArcanaItem.getStringProperty(inputStack, "transmutation_id").isEmpty();
        if (!hasAugmentAndAttuned) {
            return false;
        }
        if (ArcanaItemUtils.isArcane(inputStack) && (class_19372 = altar.method_10997()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ArcanaItem arcanaInputItem = ArcanaItemUtils.identifyItem(inputStack);
            class_3222 player = serverWorld.method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)arcanaInputItem.getCrafter(inputStack)));
            return player == null || ArcanaNovum.data((class_1657)player).hasResearched(arcanaInputItem) && ArcanaNovum.data((class_1657)player).getAugmentLevel(ArcanaAugments.IMPERMANENT_PERMUTATION.id) > 0;
        }
        return true;
    }

    @Override
    public class_1799 getViewStack() {
        return MinecraftUtils.removeLore((class_1799)ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItemNoLore().method_46651(1));
    }
}

