/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.achievements;

import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.achievements.ArcanaAchievement;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class TimedAchievement
extends ArcanaAchievement {
    private int goal;
    private int progress = 0;
    private int timeFrame;
    private boolean active;
    private class_2487 data;

    public TimedAchievement(String name, String id, class_1799 displayItem, ArcanaItem arcanaItem, int xpReward, int pointsReward, String[] description, int goal, int timeFrame) {
        super(name, id, 1, displayItem, arcanaItem, xpReward, pointsReward, description);
        this.goal = goal;
        this.timeFrame = timeFrame;
        this.active = false;
        this.data = new class_2487();
        this.setAcquired(false);
    }

    public int getTimeFrame() {
        return this.timeFrame;
    }

    protected int getProgress() {
        return this.progress;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setData(class_2487 data) {
        this.data = data;
    }

    public class_2487 getData() {
        return this.data;
    }

    private boolean setProgress(int progress) {
        boolean had = this.isAcquired();
        this.progress = class_3532.method_15340((int)progress, (int)0, (int)this.goal);
        this.setAcquired(this.progress >= this.goal);
        return this.isAcquired() && !had;
    }

    protected boolean addProgress(int progress) {
        boolean had = this.isAcquired();
        if (!had && this.progress == 0 && !this.active) {
            this.active = true;
            BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(this.timeFrame, this::reset));
        }
        if (this.active) {
            this.progress = class_3532.method_15340((int)(this.progress + progress), (int)0, (int)this.goal);
            this.setAcquired(this.progress >= this.goal);
        }
        return this.isAcquired() && !had;
    }

    protected void reset() {
        if (!this.isAcquired()) {
            this.progress = 0;
            this.active = false;
            this.data = new class_2487();
        }
    }

    public int getGoal() {
        return this.goal;
    }

    @Override
    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("acquired", this.isAcquired());
        nbt.method_10582("name", this.name);
        nbt.method_10569("type", this.type);
        nbt.method_10569("progress", this.progress);
        nbt.method_10569("goal", this.goal);
        nbt.method_10556("active", this.active);
        nbt.method_10569("timeFrame", this.timeFrame);
        nbt.method_10566("data", (class_2520)this.data);
        return nbt;
    }

    @Override
    public TimedAchievement fromNbt(String id, class_2487 nbt) {
        TimedAchievement ach = (TimedAchievement)ArcanaAchievements.registry.get(id).makeNew();
        ach.setProgress(nbt.method_68083("progress", 0));
        ach.setActive(nbt.method_68566("active", false));
        ach.setAcquired(nbt.method_68566("acquired", false));
        ach.setData(nbt.method_68568("data"));
        return ach;
    }

    @Override
    public class_5250[] getStatusDisplay(class_3222 player) {
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        TimedAchievement achievement = (TimedAchievement)profile.getAchievement(this.getArcanaItem().getId(), this.id);
        if (achievement == null) {
            return null;
        }
        if (achievement.isAcquired()) {
            return new class_5250[]{class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Achieved!").method_27692(class_124.field_1075))};
        }
        return null;
    }

    @Override
    public TimedAchievement makeNew() {
        return new TimedAchievement(this.name, this.id, this.getDisplayItem(), this.getArcanaItem(), this.xpReward, this.pointsReward, this.getDescription(), this.goal, this.timeFrame);
    }
}

