/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.areaeffects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.borisshoes.arcananovum.areaeffects.AreaEffectSource;
import net.borisshoes.arcananovum.areaeffects.AreaEffectTracker;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AftershockAreaEffectTracker
extends AreaEffectTracker {
    private final List<AftershockSource> sources = new ArrayList<AftershockSource>();

    public AftershockAreaEffectTracker() {
        super("aftershock");
    }

    @Override
    public void onTick(MinecraftServer server) {
        if (this.sources.isEmpty()) {
            return;
        }
        for (class_3218 world : server.method_3738()) {
            ArrayList<class_2338> affectedBlocks = new ArrayList<class_2338>();
            HashMap<class_1297, AftershockSource> affectedEntities = new HashMap<class_1297, AftershockSource>();
            for (AftershockSource aftershockSource : this.sources) {
                affectedBlocks.addAll(aftershockSource.getAffectedBlocks(world).stream().filter(blockPos -> affectedBlocks.stream().noneMatch(block -> block.equals(blockPos))).toList());
                for (class_1297 affectedEntity : aftershockSource.getAffectedEntities(world)) {
                    if (affectedEntities.containsKey(affectedEntity)) {
                        if (aftershockSource.getLevel() <= ((AftershockSource)affectedEntities.get(affectedEntity)).getLevel()) continue;
                        affectedEntities.put(affectedEntity, aftershockSource);
                        continue;
                    }
                    affectedEntities.put(affectedEntity, aftershockSource);
                }
            }
            if (server.method_3780() % 5 == 0) {
                for (Map.Entry entry : affectedEntities.entrySet()) {
                    ((AftershockSource)entry.getValue()).affectEntity(world, (class_1297)entry.getKey());
                }
            }
            for (class_2338 class_23382 : affectedBlocks) {
                boolean aboveFloor = world.method_8320(class_23382).method_26220((class_1922)world, class_23382).method_1110() && (world.method_8320(class_23382.method_10074()).method_26234((class_1922)world, class_23382.method_10074()) || !world.method_8320(class_23382.method_10074()).method_26220((class_1922)world, class_23382.method_10074()).method_1110());
                if (!aboveFloor || !(Math.random() < 0.15)) continue;
                world.method_65096((class_2394)class_2398.field_29643, (double)class_23382.method_10263(), (double)class_23382.method_10264(), (double)class_23382.method_10260(), 1, 0.5, 0.5, 0.5, 0.1);
            }
        }
        this.sources.removeIf(AftershockSource::age);
    }

    @Override
    public void addSource(AreaEffectSource source) {
        if (source instanceof AftershockSource) {
            AftershockSource shockSource = (AftershockSource)source;
            this.sources.add(shockSource);
        }
    }

    public static AftershockSource source(@Nullable class_1297 contributor, class_2338 sourceBlock, class_3218 blockWorld, int level) {
        return new AftershockSource(sourceBlock, blockWorld, level, contributor);
    }

    public static class AftershockSource
    extends AreaEffectSource {
        private final class_2338 sourceBlock;
        private final class_3218 blockWorld;
        private final double range;
        private final float damage;
        private final int level;
        private int age;
        private final int duration;
        private final class_1297 contributor;

        private AftershockSource(class_2338 sourceBlock, class_3218 blockWorld, int level, @Nullable class_1297 contributor) {
            this.sourceBlock = sourceBlock;
            this.blockWorld = blockWorld;
            this.range = level >= 4 ? 4.0 : 2.5;
            this.damage = level >= 4 ? 4.0f : 2.0f;
            this.level = level;
            this.contributor = contributor;
            this.age = 0;
            this.duration = 30 + 20 * level;
        }

        public class_1937 getSourceWorld() {
            return this.blockWorld;
        }

        public class_2338 getBlockPos() {
            return this.sourceBlock;
        }

        public boolean age() {
            if (this.age % 2 == 0) {
                SoundUtils.playSound((class_1937)this.blockWorld, (class_2338)this.sourceBlock, (class_3414)class_3417.field_14865, (class_3419)class_3419.field_15248, (float)0.07f, (float)2.0f);
            }
            ++this.age;
            return this.age >= this.duration;
        }

        public int getLevel() {
            return this.level;
        }

        public class_1297 getContributor() {
            return this.contributor;
        }

        public void affectEntity(class_3218 world, class_1297 entity) {
            if (entity instanceof class_1309) {
                class_1309 e = (class_1309)entity;
                class_1282 source = ArcanaDamageTypes.of((class_1937)world, ArcanaDamageTypes.ARCANE_LIGHTNING, this.contributor);
                e.method_64397(world, source, this.damage);
            }
        }

        @Override
        public List<class_2338> getAffectedBlocks(class_3218 world) {
            class_3218 thisWorld;
            class_1937 class_19372 = this.getSourceWorld();
            if (class_19372 instanceof class_3218 && (thisWorld = (class_3218)class_19372).method_27983().toString().equals(world.method_27983().toString())) {
                ArrayList<class_2338> blocks = new ArrayList<class_2338>();
                for (class_2338 block : class_2338.method_25996((class_2338)this.getBlockPos(), (int)((int)this.range + 4), (int)((int)this.range + 4), (int)((int)this.range + 4))) {
                    if (!(block.method_46558().method_1022(this.getBlockPos().method_46558()) <= this.range + 1.0)) continue;
                    blocks.add((class_2338)block.method_25503());
                }
                return blocks;
            }
            return new ArrayList<class_2338>();
        }

        @Override
        public List<class_1297> getAffectedEntities(class_3218 world) {
            class_3218 thisWorld;
            class_1937 class_19372 = this.getSourceWorld();
            if (class_19372 instanceof class_3218 && (thisWorld = (class_3218)class_19372).method_27983().toString().equals(world.method_27983().toString())) {
                class_2338 blockPos = this.getBlockPos();
                class_238 rangeBox = class_238.method_29968((class_243)blockPos.method_46558()).method_1014(this.range + 4.0);
                return world.method_8333(null, rangeBox, e -> !e.method_7325() && e.method_5707(blockPos.method_46558()) < 1.25 * this.range * this.range && e instanceof class_1309);
            }
            return new ArrayList<class_1297>();
        }

        @Override
        public int getDuration() {
            return this.duration;
        }
    }
}

