/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.FractalSpongeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class FractalSponge
extends ArcanaBlock {
    public static final String ID = "fractal_sponge";

    public FractalSponge() {
        this.id = ID;
        this.name = "Fractal Sponge";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS};
        this.vanillaItem = class_1802.field_8535;
        this.block = new FractalSpongeBlock(class_4970.class_2251.method_9637().method_9629(0.6f, 1200.0f).method_9626(class_2498.field_11535));
        this.item = new FractalSpongeItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.fractal_sponge", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_SPONGE, ResearchTasks.OBTAIN_END_CRYSTAL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Fractals ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"are known for having ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"infinite ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"surface area").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"effectiveness").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" of a ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"sponge ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"is based on said ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"surface area").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"combination ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"of the two seems only ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"natural").method_27695(new class_124[]{class_124.field_1056, class_124.field_1062})).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The resulting ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"sponge ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"is ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"much more effective").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" than most ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"sponges").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It even works on ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1062})).method_10852((class_2561)class_2561.method_43470((String)"lava").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1062)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    private int absorb(class_1799 item, class_1937 world, class_2338 pos) {
        int depthLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.MANDELBROT.id));
        int absorbLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.SIERPINSKI.id));
        int maxDepth = 16 + depthLevel * 2;
        int maxBlocks = 512 + 256 * absorbLevel;
        LinkedList queue = Lists.newLinkedList();
        queue.add(new class_3545((Object)pos, (Object)0));
        int blocksAbsorbed = 0;
        while (!queue.isEmpty()) {
            class_3545 pair = (class_3545)queue.poll();
            class_2338 blockPos = (class_2338)pair.method_15442();
            int depth = (Integer)pair.method_15441();
            for (class_2350 direction : class_2350.values()) {
                class_2338 blockPos2 = blockPos.method_10093(direction);
                class_2680 blockState = world.method_8320(blockPos2);
                class_3610 fluidState = world.method_8316(blockPos2);
                if (fluidState.method_15767(class_3486.field_15517)) {
                    if (blockState.method_26204() instanceof class_2263 && !((class_2263)blockState.method_26204()).method_9700(null, (class_1936)world, blockPos2, blockState).method_7960()) {
                        ++blocksAbsorbed;
                        if (depth >= maxDepth) continue;
                        queue.add(new class_3545((Object)blockPos2, (Object)(depth + 1)));
                        continue;
                    }
                    if (blockState.method_26204() instanceof class_2404) {
                        world.method_8652(blockPos2, class_2246.field_10124.method_9564(), 3);
                        ++blocksAbsorbed;
                        if (depth >= maxDepth) continue;
                        queue.add(new class_3545((Object)blockPos2, (Object)(depth + 1)));
                        continue;
                    }
                    if (!blockState.method_27852(class_2246.field_9993) && !blockState.method_27852(class_2246.field_10463) && !blockState.method_27852(class_2246.field_10376) && !blockState.method_27852(class_2246.field_10238)) continue;
                    class_2586 blockEntity = blockState.method_31709() ? world.method_8321(blockPos2) : null;
                    class_2248.method_9610((class_2680)blockState, (class_1936)world, (class_2338)blockPos2, (class_2586)blockEntity);
                    world.method_8652(blockPos2, class_2246.field_10124.method_9564(), 3);
                    ++blocksAbsorbed;
                    if (depth >= maxDepth) continue;
                    queue.add(new class_3545((Object)blockPos2, (Object)(depth + 1)));
                    continue;
                }
                if (!fluidState.method_15767(class_3486.field_15518)) continue;
                if (blockState.method_26204() instanceof class_2263 && !((class_2263)blockState.method_26204()).method_9700(null, (class_1936)world, blockPos2, blockState).method_7960()) {
                    ++blocksAbsorbed;
                    if (depth >= maxDepth) continue;
                    queue.add(new class_3545((Object)blockPos2, (Object)(depth + 1)));
                    continue;
                }
                if (!(blockState.method_26204() instanceof class_2404)) continue;
                world.method_8652(blockPos2, class_2246.field_10124.method_9564(), 3);
                ++blocksAbsorbed;
                if (depth >= maxDepth) continue;
                queue.add(new class_3545((Object)blockPos2, (Object)(depth + 1)));
            }
            if (blocksAbsorbed <= maxBlocks) continue;
            break;
        }
        return blocksAbsorbed;
    }

    private int absorbHelper(@Nullable class_1309 placer, class_1937 world, class_1799 item, class_2338 pos, boolean doCheck) {
        if (doCheck && !world.method_8320(pos).method_27852(this.getBlock())) {
            return 0;
        }
        int absorbed = this.absorb(item, world, pos);
        if (absorbed > 0) {
            SoundUtils.playSound((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_14868, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.8f);
            if (placer instanceof class_3222) {
                class_3222 player = (class_3222)placer;
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.FRACTAL_SPONGE_ABSORB_BLOCK) * absorbed);
                ArcanaAchievements.progress(player, ArcanaAchievements.OCEAN_CLEANUP.id, absorbed);
            }
        }
        return absorbed;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8281, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8354, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8535, 6);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8178, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8301, 4);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8137, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, a}, {b, g, c, g, d}, {c, c, m, c, c}, {d, g, c, g, b}, {a, d, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Fractal Sponge").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nHave you ever heard of the coastline paradox? I thought about it while staring at an ocean monument offshore, and now I\u2019m off to shove as many sponges into a fractal as I can.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Fractal Sponge").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nThe Fractal Sponge in practice is only 8 times better than a regular sponge due to it taking time for fluid to soak into the fractal. But, it never gets fully soaked and the reinforced frame lets it contain hotter fluids like lava.").method_27692(class_124.field_1074)));
        return list;
    }

    public class FractalSpongeBlock
    extends ArcanaPolymerBlockEntity {
        public FractalSpongeBlock(class_4970.class_2251 settings) {
            super(FractalSponge.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_10258.method_9564();
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return FractalSpongeBlock.method_31618(type, ArcanaRegistry.FRACTAL_SPONGE_BLOCK_ENTITY, FractalSpongeBlockEntity::ticker);
        }

        @Nullable
        public static FractalSpongeBlockEntity getEntity(class_1937 world, class_2338 pos) {
            FractalSpongeBlockEntity sponge;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof FractalSpongeBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof FractalSpongeBlockEntity ? (sponge = (FractalSpongeBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new FractalSpongeBlockEntity(pos, state);
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                if (entity instanceof FractalSpongeBlockEntity) {
                    FractalSpongeBlockEntity sponge = (FractalSpongeBlockEntity)entity;
                    FractalSpongeBlock.initializeArcanaBlock(stack, sponge);
                    try {
                        boolean cantor;
                        int absorbed = FractalSponge.this.absorbHelper(placer, world, stack, pos, false);
                        boolean bl = cantor = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.CANTOR.id)) >= 1;
                        if (cantor && absorbed > 0) {
                            BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(50, () -> FractalSponge.this.absorbHelper(placer, world, stack, pos, true)));
                            BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(100, () -> FractalSponge.this.absorbHelper(placer, world, stack, pos, true)));
                            BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(150, () -> FractalSponge.this.absorbHelper(placer, world, stack, pos, true)));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public class FractalSpongeItem
    extends ArcanaPolymerBlockItem {
        public FractalSpongeItem(class_2248 block) {
            super(FractalSponge.this.getThis(), block, FractalSponge.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return FractalSponge.this.prefItem;
        }
    }
}

