/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.callbacks.XPLoginCallback;
import net.borisshoes.arcananovum.callbacks.login.ColliderLoginCallback;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.callbacks.LoginCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3954;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class IgneousColliderBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private int cooldown;
    private String crafterId;
    private String uuid;
    private boolean synthetic;
    private String customName;

    public IgneousColliderBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.IGNEOUS_COLLIDER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, boolean synthetic, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.synthetic = synthetic;
        this.customName = customName == null ? "" : customName;
        int injectionLvl = ArcanaAugments.getAugmentFromMap(augments, ArcanaAugments.MAGMATIC_INJECTION.id);
        this.cooldown = 20 * (14 - 2 * injectionLvl);
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof IgneousColliderBlockEntity) {
            IgneousColliderBlockEntity collider = (IgneousColliderBlockEntity)e;
            collider.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
        if (this.cooldown <= 0 && serverWorld.method_8503().method_3780() % 2 == 0) {
            class_2338 hasLava = null;
            class_2338 hasWater = null;
            class_2338 hasInventory = null;
            class_2338 hasNetherite = null;
            class_1278 output = null;
            boolean canUseIce = ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.CRYOGENIC_COOLING.id) >= 1;
            for (class_2350 direction : class_2350.values()) {
                class_2338 pos2 = this.field_11867.method_10093(direction);
                class_2680 state2 = serverWorld.method_8320(pos2);
                class_2248 block2 = state2.method_26204();
                if (direction.method_10166() != class_2350.class_2351.field_11052) {
                    if (block2 == class_2246.field_10164 && state2.method_26227().method_15771()) {
                        hasLava = pos2;
                        continue;
                    }
                    if (block2 == class_2246.field_10382 && state2.method_26227().method_15771()) {
                        hasWater = pos2;
                        continue;
                    }
                    if (block2 == class_2246.field_27098) {
                        hasLava = pos2;
                        continue;
                    }
                    if (block2 == class_2246.field_27097) {
                        hasWater = pos2;
                        continue;
                    }
                    if (!canUseIce || block2 != class_2246.field_10384) continue;
                    hasWater = pos2;
                    continue;
                }
                if (direction == class_2350.field_11036) {
                    class_2586 blockEntity;
                    if (block2 instanceof class_3954) {
                        output = ((class_3954)block2).method_17680(state2, (class_1936)serverWorld, pos2);
                    } else if (state2.method_31709() && (blockEntity = serverWorld.method_8321(pos2)) instanceof class_1263 && (output = (class_1263)blockEntity) instanceof class_2595 && block2 instanceof class_2281) {
                        output = class_2281.method_17458((class_2281)((class_2281)block2), (class_2680)state2, (class_1937)serverWorld, (class_2338)pos2, (boolean)true);
                    }
                    if (output == null) continue;
                    hasInventory = pos2;
                    continue;
                }
                if (direction != class_2350.field_11033 || block2 != class_2246.field_22108) continue;
                hasNetherite = pos2;
            }
            if (hasLava != null && hasWater != null) {
                class_1799 obby = hasNetherite == null ? new class_1799((class_1935)class_1802.field_8281) : new class_1799((class_1935)class_1802.field_22421);
                if (hasInventory == null) {
                    serverWorld.method_8649((class_1297)new class_1542((class_1937)serverWorld, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.25, (double)this.field_11867.method_10260() + 0.5, obby, 0.0, 0.2, 0.0));
                } else {
                    try {
                        Transaction transaction = Transaction.openOuter();
                        int inserted = (int)StorageUtil.tryInsertStacking((Storage)InventoryStorage.of(output, (class_2350)class_2350.field_11033), (Object)ItemVariant.of((class_1799)obby), (long)obby.method_7947(), (TransactionContext)transaction);
                        if (inserted < obby.method_7947()) {
                            obby.method_7939(obby.method_7947() - inserted);
                            serverWorld.method_8649((class_1297)new class_1542((class_1937)serverWorld, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 2.5, (double)this.field_11867.method_10260() + 0.5, obby, 0.0, 0.2, 0.0));
                        }
                        if (inserted > 0) {
                            output.method_5431();
                        }
                        transaction.commit();
                    }
                    catch (Exception e) {
                        ArcanaNovum.log(2, "Exception in Igneous Collider inventory insertion at " + this.field_11867.method_23854());
                        e.printStackTrace();
                    }
                }
                int efficiencyLvl = ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.THERMAL_EXPANSION.id);
                if (Math.random() >= 0.1 * (double)efficiencyLvl) {
                    if (serverWorld.method_8320(hasLava).method_26204() == class_2246.field_10164) {
                        serverWorld.method_8652(hasLava, class_2246.field_10124.method_9564(), 3);
                    } else if (serverWorld.method_8320(hasLava).method_26204() == class_2246.field_27098) {
                        serverWorld.method_8652(hasLava, class_2246.field_10593.method_9564(), 3);
                    }
                    if (serverWorld.method_8320(hasWater).method_26204() == class_2246.field_10382) {
                        serverWorld.method_8652(hasWater, class_2246.field_10124.method_9564(), 3);
                    } else if (serverWorld.method_8320(hasWater).method_26204() == class_2246.field_27097) {
                        serverWorld.method_8652(hasWater, class_2246.field_10593.method_9564(), 3);
                    }
                }
                if (this.crafterId != null && !this.crafterId.isEmpty()) {
                    class_3222 player = serverWorld.method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)this.crafterId));
                    if (player == null) {
                        BorisLib.addLoginCallback((LoginCallback)new ColliderLoginCallback(serverWorld.method_8503(), this.crafterId, 1));
                        BorisLib.addLoginCallback((LoginCallback)new XPLoginCallback(serverWorld.method_8503(), this.crafterId, ArcanaConfig.getInt(ArcanaRegistry.IGNEOUS_COLLIDER_PRODUCE)));
                    } else {
                        ArcanaAchievements.progress(player, ArcanaAchievements.ENDLESS_EXTRUSION.id, 1);
                        ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.IGNEOUS_COLLIDER_PRODUCE));
                        if (obby.method_31574(class_1802.field_22421)) {
                            ArcanaAchievements.grant(player, ArcanaAchievements.EXPENSIVE_INFUSION.id);
                        }
                    }
                }
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.field_11867, (class_3414)class_3417.field_14905, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.6f);
                this.field_11863.method_43276((class_6880)class_5712.field_28174, this.field_11867, class_5712.class_7397.method_43287((class_2680)this.method_11010()));
                int injectionLvl = ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.MAGMATIC_INJECTION.id);
                this.cooldown = 20 * (14 - 2 * injectionLvl);
            }
        }
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.IGNEOUS_COLLIDER;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.synthetic = view.method_71433("synthetic", false);
        this.cooldown = view.method_71424("cooldown", 0);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71472("synthetic", this.synthetic);
        view.method_71465("cooldown", this.cooldown);
    }
}

