/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.ArcaneSingularityBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class ArcaneSingularity
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "arcane_singularity";
    public static final String BOOKS_TAG = "books";
    public static final String SINGULARITY_TAG = "singularityId";
    private Multiblock multiblock;

    public ArcaneSingularity() {
        this.id = ID;
        this.name = "Arcane Singularity";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.FORGE};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_16312;
        this.block = new ArcaneSingularityBlock(class_4970.class_2251.method_9637().method_9629(2.5f, 1200.0f).method_9626(class_2498.field_11547));
        this.item = new ArcaneSingularityItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.arcane_singularity", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1076});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.OBTAIN_STARDUST, ResearchTasks.OBTAIN_NEBULOUS_ESSENCE, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.OBTAIN_NETHER_STAR, ResearchTasks.UNLOCK_STARLIGHT_FORGE, ResearchTasks.ADVANCEMENT_OBTAIN_CRYING_OBSIDIAN};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        ArcaneSingularity.putProperty(stack, BOOKS_TAG, (class_2520)new class_2499());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        int size;
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structure").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" addon to the ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Starlight Forge").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Storing ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"enchantments").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" on books is ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"crude").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"primitive.").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Condensing ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"their ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"essence ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"into a ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"singularity ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"is much more ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"modern").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Allows for the ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"storing of ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"enchantments").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" in a ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"virtual library.").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Works well").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" with the ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Midnight Enchanter").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        if (itemStack != null && (size = ArcaneSingularity.getListProperty(itemStack, BOOKS_TAG).size()) > 0) {
            lore.add(class_2561.method_43470((String)""));
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contains ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)("" + size)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" Enchanted Books").method_27692(class_124.field_1076)));
        }
        this.addForgeLore(lore);
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2499 targetsList = ArcaneSingularity.getListProperty(stack, BOOKS_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        ArcaneSingularity.putProperty(newStack, BOOKS_TAG, (class_2520)targetsList);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-1, -1, -2);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_22421, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8449, 24);
        ArcanaIngredient g = new ArcanaIngredient(ArcanaRegistry.NEBULOUS_ESSENCE, 32);
        ArcanaIngredient h = new ArcanaIngredient(ArcanaRegistry.STARDUST, 32);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8137, 4);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withEnchanter().withCore().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Arcane Singularity").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThe Midnight Enchanter has proven more useful than I imagined. Now I have more Enchanted Books than I can possibly store in a library. I need a new method of book-keeping.\nBy condensing raw ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Arcane Singularity").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nNebulous Essence down over and over, it forms a self-sustaining singularity. An Arcane black hole. Containing it was no easy feat, but now I have a massive storage space for my books\u2026\n\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Arcane Singularity").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nThe Singularity is a single purpose, high density storage unit for Enchanted Books. Books can be sorted and filtered, and can be extracted at any time. \nBooks are bound to the Singularity, so they are kept with the block when moved.").method_27692(class_124.field_1074)));
        return list;
    }

    public class ArcaneSingularityBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;

        public ArcaneSingularityBlock(class_4970.class_2251 settings) {
            super(ArcaneSingularity.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return (class_2680)class_2246.field_16330.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)this.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)ctx.method_8042().method_10153());
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{HORIZONTAL_FACING});
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657(HORIZONTAL_FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return state.method_26186(mirror.method_10345((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return ArcaneSingularityBlock.method_31618(type, ArcanaRegistry.ARCANE_SINGULARITY_BLOCK_ENTITY, ArcaneSingularityBlockEntity::ticker);
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            ArcaneSingularityBlockEntity singularity = (ArcaneSingularityBlockEntity)world.method_8321(pos);
            if (singularity != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (singularity.isAssembled()) {
                    if (StarlightForge.findActiveForge(player.method_51469(), pos) == null) {
                        player.method_64398((class_2561)class_2561.method_43470((String)"The Enchanter must be within the range of an active Starlight Forge"));
                    } else {
                        singularity.openGui(player);
                    }
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    ArcaneSingularity.this.multiblock.displayStructure(singularity.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        @Nullable
        public static ArcaneSingularityBlockEntity getEntity(class_1937 world, class_2338 pos) {
            ArcaneSingularityBlockEntity singularity;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof ArcaneSingularityBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof ArcaneSingularityBlockEntity ? (singularity = (ArcaneSingularityBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new ArcaneSingularityBlockEntity(pos, state);
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof ArcaneSingularityBlockEntity) {
                ArcaneSingularityBlockEntity singularity = (ArcaneSingularityBlockEntity)entity;
                ArcaneSingularityBlock.initializeArcanaBlock(stack, singularity);
                singularity.initializeBooks(ArcanaItem.getListProperty(stack, ArcaneSingularity.BOOKS_TAG), (class_7225.class_7874)world.method_30349());
            }
        }
    }

    public class ArcaneSingularityItem
    extends ArcanaPolymerBlockItem {
        public ArcaneSingularityItem(class_2248 block) {
            super(ArcaneSingularity.this.getThis(), block, ArcaneSingularity.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return ArcaneSingularity.this.prefItem;
        }
    }
}

