/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import com.mojang.serialization.DynamicOps;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.ArcaneSingularity;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.blocks.forge.StellarCore;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.arcanesingularity.ArcaneSingularityGui;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class ArcaneSingularityBlockEntity
extends class_2621
implements class_1278,
PolymerObject,
class_1265,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private boolean synthetic;
    private String customName;
    private final Multiblock multiblock;
    private boolean assembled;
    private class_1277 inventory = new class_1277(this.method_5439());
    private boolean seenForge;
    private boolean updating;
    private final HashMap<class_3222, ArcaneSingularityGui> watchingPlayers = new HashMap();

    public ArcaneSingularityBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.ARCANE_SINGULARITY_BLOCK_ENTITY, pos, state);
        this.multiblock = ((MultiblockCore)((Object)ArcanaRegistry.ARCANE_SINGULARITY)).getMultiblock();
        this.inventory.method_5489((class_1265)this);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, boolean synthetic, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.synthetic = synthetic;
        this.customName = customName == null ? "" : customName;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof ArcaneSingularityBlockEntity) {
            ArcaneSingularityBlockEntity singularity = (ArcaneSingularityBlockEntity)e;
            singularity.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        int ticks = serverWorld.method_8503().method_3780();
        if (ticks % 10 == 0) {
            this.assembled = this.multiblock.matches(this.getMultiblockCheck());
            boolean bl = this.seenForge = StarlightForge.findActiveForge(serverWorld, this.field_11867) != null;
        }
        if (this.assembled && this.seenForge) {
            class_2350 dir = (class_2350)serverWorld.method_8320(this.field_11867).method_11654(ArcaneSingularity.ArcaneSingularityBlock.HORIZONTAL_FACING);
            class_243 center = this.field_11867.method_10081(dir.method_62675().method_35862(-1)).method_46558().method_1031(0.0, 2.5, 0.0);
            double fillPercent = (0.75 + 0.05 * (double)ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.SUPERMASSIVE.id)) * ((double)this.getNumBooks() / (double)this.getCapacity());
            ArcanaEffectUtils.arcaneSingularityAnim(serverWorld, center, ticks % 300, dir, fillPercent);
            if (Math.random() < 0.001) {
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14802, (class_3419)class_3419.field_15245, (float)0.3f, (float)(1.0f + (float)Math.random()));
            }
            if (Math.random() < 5.0E-4) {
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14891, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.5f);
            }
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.assembled && this.seenForge) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
        this.watchingPlayers.entrySet().removeIf(entry -> ((class_3222)entry.getKey()).field_7512 == ((class_3222)entry.getKey()).field_7498);
    }

    public void removePlayer(class_3222 player) {
        this.watchingPlayers.remove(player);
    }

    public int getNumBooks() {
        int count = 0;
        for (int i = 0; i < this.method_5439(); ++i) {
            if (this.inventory.method_5438(i).method_7960()) continue;
            ++count;
        }
        return count;
    }

    public SingularityResult addBook(class_1799 book) {
        if (this.getNumBooks() >= this.getCapacity() || !this.inventory.method_27070(book)) {
            return SingularityResult.FULL;
        }
        ArcanaItem.putProperty(book, "singularityId", (class_2520)class_2519.method_23256((String)UUID.randomUUID().toString()));
        this.inventory.method_5491(book);
        this.method_5431();
        return SingularityResult.SUCCESS;
    }

    public SingularityResult mergeBooks(class_1799 book1, class_1799 book2) {
        int i;
        boolean book1Found = this.inventory.method_54454().contains((Object)book1);
        boolean book2Found = this.inventory.method_54454().contains((Object)book2);
        if (!book1Found || !book2Found) {
            return SingularityResult.NOT_FOUND;
        }
        class_9304 comp1 = class_1890.method_57532((class_1799)book1);
        class_9304 comp2 = class_1890.method_57532((class_1799)book2);
        class_9304.class_9305 enchantBuilder = new class_9304.class_9305(comp2);
        boolean hasCompatibleEnchant = false;
        boolean hasIncompatibleEnchant = false;
        for (Object2IntMap.Entry entry1 : comp1.method_57539()) {
            int combinedLvl = entry1.getIntValue();
            boolean canCombine = true;
            for (Object2IntMap.Entry entry2 : comp2.method_57539()) {
                if (((class_6880)entry1.getKey()).comp_349() == ((class_6880)entry2.getKey()).comp_349()) {
                    int n = combinedLvl = entry1.getIntValue() == entry2.getIntValue() ? combinedLvl + 1 : Math.max(entry1.getIntValue(), entry2.getIntValue());
                }
                if (((class_6880)entry1.getKey()).comp_349() == ((class_6880)entry2.getKey()).comp_349() || class_1887.method_60033((class_6880)((class_6880)entry1.getKey()), (class_6880)((class_6880)entry2.getKey()))) continue;
                canCombine = false;
            }
            if (!canCombine) {
                hasIncompatibleEnchant = true;
                continue;
            }
            hasCompatibleEnchant = true;
            if (combinedLvl > ((class_1887)((class_6880)entry1.getKey()).comp_349()).method_8183()) {
                combinedLvl = ((class_1887)((class_6880)entry1.getKey()).comp_349()).method_8183();
            }
            enchantBuilder.method_57550((class_6880)entry1.getKey(), combinedLvl);
        }
        if (hasIncompatibleEnchant && !hasCompatibleEnchant) {
            return SingularityResult.FAIL;
        }
        for (i = 0; i < this.inventory.method_54454().size(); ++i) {
            if (!this.inventory.method_5438(i).equals(book1)) continue;
            this.inventory.method_5441(i);
            break;
        }
        for (i = 0; i < this.inventory.method_54454().size(); ++i) {
            if (!this.inventory.method_5438(i).equals(book2)) continue;
            this.inventory.method_5441(i);
            break;
        }
        class_1799 newBook = new class_1799((class_1935)class_1802.field_8598);
        class_1890.method_57530((class_1799)newBook, (class_9304)enchantBuilder.method_57549());
        ArcanaItem.putProperty(newBook, "singularityId", (class_2520)class_2519.method_23256((String)UUID.randomUUID().toString()));
        this.inventory.method_5491(newBook);
        this.method_5431();
        return SingularityResult.SUCCESS;
    }

    public SingularityResult removeBook(class_1799 book) {
        boolean bookFound = this.inventory.method_54454().contains((Object)book);
        if (!bookFound) {
            return SingularityResult.NOT_FOUND;
        }
        for (int i = 0; i < this.inventory.method_54454().size(); ++i) {
            if (!this.inventory.method_5438(i).equals(book)) continue;
            this.inventory.method_5441(i);
            break;
        }
        this.method_5431();
        return SingularityResult.SUCCESS;
    }

    public SingularityResult splitBook(class_1799 book) {
        boolean bookFound = this.inventory.method_54454().contains((Object)book);
        if (!bookFound) {
            return SingularityResult.NOT_FOUND;
        }
        if (this.getNumBooks() >= this.getCapacity() || !this.inventory.method_27070(book)) {
            return SingularityResult.FULL;
        }
        if (this.method_10997() == null) {
            return SingularityResult.FAIL;
        }
        class_9304 comp = class_1890.method_57532((class_1799)book);
        Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
        comp.method_57539().forEach(entry -> enchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
        if (enchants.size() == 1) {
            ObjectIterator iter = enchants.object2IntEntrySet().fastIterator();
            Object2IntMap.Entry entry2 = (Object2IntMap.Entry)iter.next();
            if (entry2.getIntValue() <= ((class_1887)((class_6880)entry2.getKey()).comp_349()).method_8187()) {
                return SingularityResult.FAIL;
            }
            for (int i = 0; i < this.inventory.method_54454().size(); ++i) {
                if (!this.inventory.method_5438(i).equals(book)) continue;
                this.inventory.method_5441(i);
                break;
            }
            class_1799 newBook = class_1890.method_61711((class_1889)new class_1889((class_6880)entry2.getKey(), entry2.getIntValue() - 1));
            ArcanaItem.putProperty(newBook, "singularityId", (class_2520)class_2519.method_23256((String)UUID.randomUUID().toString()));
            this.inventory.method_5491(newBook.method_7972());
            ArcanaItem.putProperty(newBook, "singularityId", (class_2520)class_2519.method_23256((String)UUID.randomUUID().toString()));
            this.inventory.method_5491(newBook.method_7972());
        } else {
            class_6885 registryEntryList = null;
            Optional optional = this.method_10997().method_30349().method_30530(class_7924.field_41265).method_46733(class_9636.field_51362);
            if (optional.isPresent()) {
                registryEntryList = (class_6885)optional.get();
            }
            class_6880 registryEntry = null;
            int value = 0;
            int index = Integer.MAX_VALUE;
            ObjectIterator iter = enchants.object2IntEntrySet().fastIterator();
            while (iter.hasNext()) {
                Object2IntMap.Entry entry3 = (Object2IntMap.Entry)iter.next();
                if (registryEntryList == null) {
                    registryEntry = (class_6880)entry3.getKey();
                    value = entry3.getIntValue();
                    iter.remove();
                    break;
                }
                for (int i = 0; i < registryEntryList.method_40247(); ++i) {
                    if (registryEntryList.method_40240(i).comp_349() != ((class_6880)entry3.getKey()).comp_349() || i >= index) continue;
                    index = i;
                    registryEntry = (class_6880)entry3.getKey();
                    value = entry3.getIntValue();
                }
            }
            if (index != Integer.MAX_VALUE && registryEntry != null) {
                class_6880 finalRegistryEntry = registryEntry;
                int finalValue = value;
                enchants.object2IntEntrySet().removeIf(e -> ((class_6880)e.getKey()).comp_349() == finalRegistryEntry.comp_349() && finalValue == e.getIntValue());
                for (int i = 0; i < this.inventory.method_54454().size(); ++i) {
                    if (!this.inventory.method_5438(i).equals(book)) continue;
                    this.inventory.method_5441(i);
                    break;
                }
                class_1799 newBook1 = class_1890.method_61711((class_1889)new class_1889(registryEntry, value));
                ArcanaItem.putProperty(newBook1, "singularityId", (class_2520)class_2519.method_23256((String)UUID.randomUUID().toString()));
                this.inventory.method_5491(newBook1.method_7972());
            }
            class_1799 newBook2 = new class_1799((class_1935)class_1802.field_8598);
            class_9304.class_9305 enchantBuilder = new class_9304.class_9305(class_9304.field_49385);
            enchants.forEach((arg_0, arg_1) -> ((class_9304.class_9305)enchantBuilder).method_57550(arg_0, arg_1));
            class_1890.method_57530((class_1799)newBook2, (class_9304)enchantBuilder.method_57549());
            ArcanaItem.putProperty(newBook2, "singularityId", (class_2520)class_2519.method_23256((String)UUID.randomUUID().toString()));
            this.inventory.method_5491(newBook2.method_7972());
        }
        this.method_5431();
        return SingularityResult.SUCCESS;
    }

    public List<class_1799> getBooks() {
        return this.inventory.method_54454().stream().filter(stack -> !stack.method_7960()).toList();
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public int getCapacity() {
        return 112 * (1 + ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.SUPERMASSIVE.id));
    }

    public void openGui(class_3222 player) {
        ArcaneSingularityGui gui = new ArcaneSingularityGui(player, this, this.getCapacity());
        gui.buildGui();
        gui.open();
        this.watchingPlayers.put(player, gui);
    }

    private void sendRefresh() {
        this.watchingPlayers.forEach((player, gui) -> gui.buildGui());
    }

    @Override
    public boolean isAssembled() {
        return this.assembled;
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.ARCANE_SINGULARITY)).getCheckOffset()), (class_2350)serverWorld.method_8320(this.field_11867).method_11654(StellarCore.StellarCoreBlock.HORIZONTAL_FACING));
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.ARCANE_SINGULARITY;
    }

    public class_2499 saveBooks(class_7225.class_7874 registryLookup) {
        if (this.inventory != null) {
            class_2499 bookList = new class_2499();
            for (class_1799 book : this.inventory.method_54454()) {
                if (book.method_7960()) continue;
                bookList.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)book).getOrThrow()));
            }
            return bookList;
        }
        return new class_2499();
    }

    public void initializeBooks(class_2499 bookList, class_7225.class_7874 registryLookup) {
        this.inventory = new class_1277(this.method_5439());
        this.inventory.method_5489((class_1265)this);
        for (class_2520 e : bookList) {
            this.inventory.method_5491(class_1799.field_24671.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)e).result().orElse(class_1799.field_8037));
        }
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.synthetic = view.method_71433("synthetic", false);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
        this.inventory = new class_1277(this.method_5439());
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, (class_2371)this.inventory.method_54454());
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71472("synthetic", this.synthetic);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, (class_2371)this.inventory.method_54454());
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43470((String)"Arcane Singularity");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory.method_54454();
    }

    protected void method_11281(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.inventory.method_5447(i, (class_1799)list.get(i));
        }
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public int method_5439() {
        return 1024;
    }

    public void method_5453(class_1263 sender) {
        this.sendRefresh();
    }

    public static enum SingularityResult {
        SUCCESS,
        NOT_FOUND,
        FULL,
        FAIL;

    }
}

