/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.blocks.forge.StellarCore;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.stellarcore.StellarCoreGui;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_8060;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9890;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class StellarCoreBlockEntity
extends class_2621
implements PolymerObject,
class_1278,
class_1265,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private boolean synthetic;
    private String customName;
    private final Multiblock multiblock;
    private boolean assembled;
    private boolean seenForge;
    private boolean updating;
    private class_1277 inventory = new class_1277(this.method_5439());
    private final Set<class_3222> watchingPlayers = new HashSet<class_3222>();

    public StellarCoreBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.STELLAR_CORE_BLOCK_ENTITY, pos, state);
        this.multiblock = ((MultiblockCore)((Object)ArcanaRegistry.STELLAR_CORE)).getMultiblock();
        this.inventory.method_5489((class_1265)this);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, boolean synthetic, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.synthetic = synthetic;
        this.customName = customName == null ? "" : customName;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof StellarCoreBlockEntity) {
            StellarCoreBlockEntity core = (StellarCoreBlockEntity)e;
            core.tick();
        }
    }

    private void tick() {
        boolean lit;
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        int ticks = serverWorld.method_8503().method_3780();
        class_2680 blockState = serverWorld.method_8320(this.field_11867);
        if (ticks % 10 == 0) {
            this.assembled = this.multiblock.matches(this.getMultiblockCheck());
            boolean bl = this.seenForge = StarlightForge.findActiveForge(serverWorld, this.field_11867) != null;
        }
        if (this.assembled && this.seenForge) {
            class_2350 dir = (class_2350)blockState.method_11654(StellarCore.StellarCoreBlock.HORIZONTAL_FACING);
            ArcanaEffectUtils.stellarCoreAnim(serverWorld, this.field_11867.method_10081(dir.method_62675().method_35862(-2)).method_46558().method_1031(0.0, 1.0, 0.0), ticks % 300, dir);
        }
        if ((lit = ((Boolean)blockState.method_11654((class_2769)StellarCore.StellarCoreBlock.LIT)).booleanValue()) ^ this.assembled) {
            blockState = (class_2680)blockState.method_11657((class_2769)StellarCore.StellarCoreBlock.LIT, (Comparable)Boolean.valueOf(this.assembled));
            this.field_11863.method_8652(this.field_11867, blockState, 3);
        }
        this.watchingPlayers.removeIf(player -> player.field_7512 == player.field_7498);
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.assembled && this.seenForge) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Map<class_1792, Integer> getCraftingSalvageIngredients(class_1799 stack, MinecraftServer server) {
        void var3_4;
        block7: {
            HashMap hashMap = new HashMap();
            if (!stack.method_57826(class_9334.field_53696)) break block7;
            class_9890 repairComp = (class_9890)stack.method_58694(class_9334.field_53696);
            List<class_1799> repairItems = repairComp.comp_2939().method_40239().map(entry -> ((class_1792)entry.comp_349()).method_7854()).toList();
            Collection craftingRecipes = server.method_3772().getAllOfType(class_3956.field_17545);
            for (class_8786 entry2 : craftingRecipes) {
                ArrayList<Object> ingredients;
                block10: {
                    Optional ingredient;
                    Iterator iterator;
                    block11: {
                        Iterator iterator2;
                        block9: {
                            class_3955 recipe;
                            block8: {
                                recipe = (class_3955)entry2.comp_1933();
                                ingredients = new ArrayList<Object>();
                                if (!(recipe instanceof class_1869)) break block8;
                                class_1869 shaped = (class_1869)recipe;
                                if (!shaped.field_9053.method_31574(stack.method_7909())) break block8;
                                iterator2 = shaped.method_61693().iterator();
                                break block9;
                            }
                            if (!(recipe instanceof class_1867)) break block10;
                            class_1867 shapeless = (class_1867)recipe;
                            if (!shapeless.field_9050.method_31574(stack.method_7909())) break block10;
                            iterator = shapeless.field_9047.iterator();
                            break block11;
                        }
                        while (iterator2.hasNext()) {
                            ingredient = (Optional)iterator2.next();
                            if (ingredient.isEmpty() || ((class_1856)ingredient.get()).method_65799()) continue;
                            ingredients.add((class_1856)ingredient.get());
                        }
                        break block10;
                    }
                    while (iterator.hasNext()) {
                        ingredient = (class_1856)iterator.next();
                        if (ingredient.method_65799()) continue;
                        ingredients.add(ingredient);
                    }
                }
                HashMap<class_1792, Integer> ingreds = new HashMap<class_1792, Integer>();
                block3: for (class_1856 class_18562 : ingredients) {
                    for (class_6880 ientry : class_18562.method_8105().toList()) {
                        for (class_1799 repairItem : repairItems) {
                            if (!repairItem.method_31574((class_1792)ientry.comp_349())) continue;
                            ingreds.merge((class_1792)ientry.comp_349(), 1, Integer::sum);
                            continue block3;
                        }
                    }
                }
                if (var3_4.isEmpty()) {
                    HashMap<class_1792, Integer> hashMap2 = ingreds;
                    continue;
                }
                int curCount = var3_4.values().stream().mapToInt(Integer::intValue).sum();
                int n = ingreds.values().stream().mapToInt(Integer::intValue).sum();
                if (n <= 0 || n >= curCount) continue;
                HashMap<class_1792, Integer> hashMap3 = ingreds;
            }
        }
        return var3_4;
    }

    public List<class_1799> salvageItem(class_1799 stack, MinecraftServer server) {
        int stardust;
        ArrayList<class_1799> salvage = new ArrayList<class_1799>();
        double salvageLvl = 0.25 * (double)(1 + ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.DYSON_SPHERE.id));
        class_1792 item = stack.method_7909();
        if (ArcanaItemUtils.isArcane(stack)) {
            return salvage;
        }
        if (stack.method_57826(class_9334.field_53696)) {
            Map<class_1792, Integer> finalSalv;
            class_9890 repairComp = (class_9890)stack.method_58694(class_9334.field_53696);
            List<class_1799> repairItems = repairComp.comp_2939().method_40239().map(entry -> ((class_1792)entry.comp_349()).method_7854()).toList();
            Collection craftingRecipes = server.method_3772().getAllOfType(class_3956.field_17545);
            Collection smithingRecipes = server.method_3772().getAllOfType(class_3956.field_25388);
            class_1792 precursor = class_1802.field_8162;
            Map<class_1792, Integer> precursorSalvage = new HashMap<class_1792, Integer>();
            for (class_8786 entry2 : smithingRecipes) {
                class_1860 class_18602 = entry2.comp_1933();
                if (!(class_18602 instanceof class_8060)) continue;
                class_8060 smithingRecipe = (class_8060)class_18602;
                if (!stack.method_31574((class_1792)smithingRecipe.field_42033.comp_3483().comp_349()) || smithingRecipe.method_64722().isEmpty() || !((class_1856)smithingRecipe.method_64722().get()).method_8093(class_1802.field_41946.method_7854()) || smithingRecipe.method_64724().isEmpty() || repairItems.stream().noneMatch(repair -> ((class_1856)smithingRecipe.method_64724().get()).method_8093(repair))) continue;
                for (class_6880 ientry : smithingRecipe.method_64723().method_8105().toList()) {
                    Map<class_1792, Integer> salv = this.getCraftingSalvageIngredients(((class_1792)ientry.comp_349()).method_7854(), server);
                    if (precursorSalvage.isEmpty()) {
                        precursorSalvage = salv;
                        precursor = (class_1792)ientry.comp_349();
                        continue;
                    }
                    int curCount = precursorSalvage.values().stream().mapToInt(Integer::intValue).sum();
                    int newCount = salv.values().stream().mapToInt(Integer::intValue).sum();
                    if (newCount <= 0 || newCount >= curCount) continue;
                    precursorSalvage = salv;
                    precursor = (class_1792)ientry.comp_349();
                }
            }
            if (precursor != class_1802.field_8162 && !precursorSalvage.isEmpty()) {
                precursorSalvage.merge(class_1802.field_22021, 4, Integer::sum);
                finalSalv = precursorSalvage;
            } else {
                finalSalv = this.getCraftingSalvageIngredients(stack, server);
            }
            finalSalv.forEach((salvItem, count) -> {
                double baseCount = Math.round((double)count.intValue() * salvageLvl);
                int salvCount = (int)baseCount;
                if (this.method_10997().field_9229.method_43058() < baseCount - (double)salvCount - 1.0E-9) {
                    ++salvCount;
                }
                salvage.add(new class_1799((class_1935)salvItem, salvCount));
            });
        }
        if ((stardust = (int)((double)ArcanaUtils.calcEssenceFromEnchants(stack) * (1.0 + 0.15 * (double)ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.FUSION_INJECTORS.id)))) > 0) {
            while (stardust > 64) {
                salvage.add(ArcanaRegistry.STARDUST.method_7854().method_46651(64));
                stardust -= 64;
            }
            if (stardust > 0) {
                salvage.add(ArcanaRegistry.STARDUST.method_7854().method_46651(stardust));
            }
        }
        ArrayList<class_1799> salvageReturn = new ArrayList<class_1799>();
        for (int i = 0; i < stack.method_7947(); ++i) {
            salvageReturn.addAll(salvage);
        }
        return salvageReturn;
    }

    public void openGui(class_3222 player) {
        StellarCoreGui gui = new StellarCoreGui(player, this);
        gui.buildGui();
        gui.open();
        this.watchingPlayers.add(player);
    }

    public void removePlayer(class_3222 player) {
        this.watchingPlayers.remove(player);
    }

    @Override
    public boolean isAssembled() {
        return this.assembled;
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.STELLAR_CORE)).getCheckOffset()), (class_2350)serverWorld.method_8320(this.field_11867).method_11654(StellarCore.StellarCoreBlock.HORIZONTAL_FACING));
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.STELLAR_CORE;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.synthetic = view.method_71433("synthetic", false);
        this.inventory = new class_1277(this.method_5439());
        this.inventory.method_5489((class_1265)this);
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, (class_2371)this.inventory.method_54454());
        }
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71472("synthetic", this.synthetic);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, (class_2371)this.inventory.method_54454());
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43470((String)"Stellar Core");
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory.method_54454();
    }

    protected void method_11281(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.inventory.method_5447(i, (class_1799)list.get(i));
        }
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public int method_5439() {
        return 1;
    }

    public void method_5453(class_1263 inv) {
        if (!this.updating) {
            class_1799 moltenItem;
            this.updating = true;
            class_1937 class_19372 = this.method_10997();
            if (!(class_19372 instanceof class_3218)) {
                this.updating = false;
                return;
            }
            class_3218 serverWorld = (class_3218)class_19372;
            boolean moltenCore = ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.MOLTEN_CORE.id) >= 1;
            class_2680 blockState = serverWorld.method_8320(this.field_11867);
            class_2350 dir = (class_2350)blockState.method_11654(StellarCore.StellarCoreBlock.HORIZONTAL_FACING);
            class_243 itemSpawnPos = this.field_11867.method_10081(dir.method_62675()).method_46558();
            class_1799 stack = inv.method_5438(0);
            List<class_1799> salvage = this.salvageItem(stack, serverWorld.method_8503());
            if (!salvage.isEmpty()) {
                salvage = salvage.stream().filter(s -> !s.method_7960() && s.method_7947() > 0).toList();
                this.watchingPlayers.forEach(player -> ArcanaAchievements.progress(player, ArcanaAchievements.RECLAMATION.id, stack.method_7947()));
                if (salvage.stream().anyMatch(s -> s.method_31574(class_1802.field_22021))) {
                    this.watchingPlayers.forEach(player -> ArcanaAchievements.grant(player, ArcanaAchievements.SCRAP_TO_SCRAP.id));
                }
                inv.method_5447(0, class_1799.field_8037);
                for (class_1799 itemStack : salvage) {
                    class_1264.method_5449((class_1937)this.method_10997(), (double)itemSpawnPos.method_10216(), (double)itemSpawnPos.method_10214(), (double)itemSpawnPos.method_10215(), (class_1799)itemStack);
                }
                this.watchingPlayers.forEach(player -> ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.STELLAR_CORE_SALVAGE)));
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.method_11016(), (class_3414)class_3417.field_14580, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.8f);
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.method_11016(), (class_3414)class_3417.field_14959, (class_3419)class_3419.field_15245, (float)1.0f, (float)1.2f);
            } else if (moltenCore && (moltenItem = StellarCore.MOLTEN_CORE_ITEMS.get(stack.method_7909())) != null) {
                int returnCount;
                inv.method_5447(0, class_1799.field_8037);
                int finalReturnCount = returnCount;
                int xpPerSmelt = ArcanaConfig.getInt(ArcanaRegistry.STELLAR_CORE_SMELT) * (stack.method_7909().method_7876().contains("raw") && stack.method_7909().method_7876().contains("block") ? 9 : 1);
                this.watchingPlayers.forEach(player -> ArcanaNovum.data((class_1657)player).addXP(xpPerSmelt * finalReturnCount));
                ArrayList<class_1799> items = new ArrayList<class_1799>();
                for (returnCount = stack.method_7947() * moltenItem.method_7947(); returnCount > 64; returnCount -= 64) {
                    items.add(moltenItem.method_46651(64));
                }
                if (returnCount > 0) {
                    items.add(moltenItem.method_46651(returnCount));
                }
                for (class_1799 itemStack : items) {
                    class_1264.method_5449((class_1937)serverWorld, (double)itemSpawnPos.method_10216(), (double)itemSpawnPos.method_10214(), (double)itemSpawnPos.method_10215(), (class_1799)itemStack);
                }
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.method_11016(), (class_3414)class_3417.field_14580, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.8f);
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.method_11016(), (class_3414)class_3417.field_14959, (class_3419)class_3419.field_15245, (float)1.0f, (float)1.2f);
            }
            this.updating = false;
        }
    }
}

