/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.bosses.dragon;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.bosses.BossFight;
import net.borisshoes.arcananovum.bosses.BossFights;
import net.borisshoes.arcananovum.bosses.dragon.DragonAbilities;
import net.borisshoes.arcananovum.bosses.dragon.DragonDialog;
import net.borisshoes.arcananovum.bosses.dragon.DragonGoonHelper;
import net.borisshoes.arcananovum.bosses.dragon.DragonLairActions;
import net.borisshoes.arcananovum.bosses.dragon.guis.PuzzleGui;
import net.borisshoes.arcananovum.bosses.dragon.guis.TowerGui;
import net.borisshoes.arcananovum.callbacks.DragonRespawnTimerCallback;
import net.borisshoes.arcananovum.cardinalcomponents.IBossFightComponent;
import net.borisshoes.arcananovum.cardinalcomponents.WorldDataComponentInitializer;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.entities.DragonPhantomEntity;
import net.borisshoes.arcananovum.entities.DragonWizardEntity;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.SpawnPile;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.callbacks.ItemReturnTimerCallback;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.MathUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1678;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_274;
import net.minecraft.class_2743;
import net.minecraft.class_2881;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3002;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3666;
import net.minecraft.class_3917;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5281;
import net.minecraft.class_5454;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_8113;
import net.minecraft.class_9011;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;

public class DragonBossFight {
    private static boolean prepNotif = false;
    private static boolean phase1Notif = false;
    private static boolean startTimeAnnounced = false;
    private static boolean halfHPNotif = false;
    private static boolean quarterHPNotif = false;
    private static boolean endNotif = false;
    private static int numPlayers = 0;
    private static int forcedPlayerCount = -1;
    private static class_1510 dragon = null;
    private static class_3222 gameMaster = null;
    private static boolean keepInventoryBefore = false;
    private static List<class_1511> crystals = null;
    private static DragonPhantomEntity[] guardianPhantoms = null;
    private static DragonWizardEntity[] wizards = null;
    private static class_3002[] phantomBossBars = null;
    private static List<class_3222> hasDied = null;
    private static DragonAbilities dragonAbilities = null;
    private static DragonLairActions lairActions = null;
    private static int phase = 0;
    private static int age = 0;
    private static int lastGoonSpawn = 0;
    private static int lastDragonAction = 0;
    private static int lastLairAction = 0;
    private static List<ReclaimState> reclaimStates = null;

    public static void resetVariables() {
        prepNotif = false;
        phase1Notif = false;
        halfHPNotif = false;
        quarterHPNotif = false;
        startTimeAnnounced = false;
        endNotif = false;
        numPlayers = 0;
        forcedPlayerCount = -1;
        dragon = null;
        gameMaster = null;
        crystals = null;
        guardianPhantoms = null;
        wizards = null;
        phantomBossBars = null;
        hasDied = null;
        dragonAbilities = null;
        lairActions = null;
        phase = 0;
        age = 0;
        lastGoonSpawn = 0;
        lastDragonAction = 0;
        lastLairAction = 0;
        reclaimStates = null;
    }

    public static void tick(MinecraftServer server, class_2487 fightData) {
        try {
            States state = States.fromLabel(fightData.method_68564("State", ""));
            class_3222 gm = server.method_3760().method_14602(AlgoUtils.getUUID((String)fightData.method_68564("GameMaster", "")));
            ArrayList<class_5250> gmNotifs = new ArrayList<class_5250>();
            class_3218 endWorld = server.method_3847(class_1937.field_25181);
            assert (endWorld != null);
            if (state == States.WAITING_START) {
                if (!prepNotif) {
                    if (endWorld.method_18776().isEmpty()) {
                        ArcanaNovum.log(3, "Attempted to start Enderia fight without a dragon, cancelling boss fight");
                        DragonBossFight.abortBoss(server);
                    }
                    numPlayers = DragonBossFight.calcPlayers(server, false);
                    fightData.method_10569("numPlayers", numPlayers);
                    gameMaster = gm;
                    hasDied = new ArrayList<class_3222>();
                    dragon = (class_1510)endWorld.method_18776().getFirst();
                    dragon.method_5996(class_5134.field_23716).method_6192(1024.0);
                    dragon.method_6033(1024.0f);
                    reclaimStates = new ArrayList<ReclaimState>();
                    class_5250 dragonName = class_2561.method_43470((String)"").method_27692(class_124.field_1067).method_10852((class_2561)class_2561.method_43470((String)"|").method_27695(new class_124[]{class_124.field_1076, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)"|").method_27695(new class_124[]{class_124.field_1064, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)"|").method_27695(new class_124[]{class_124.field_1076, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)"Empress").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067, class_124.field_1073, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067, class_124.field_1073, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"The End").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067, class_124.field_1073, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"|").method_27695(new class_124[]{class_124.field_1076, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)"|").method_27695(new class_124[]{class_124.field_1064, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)"|").method_27695(new class_124[]{class_124.field_1076, class_124.field_1051}));
                    dragon.method_5665((class_2561)dragonName);
                    class_1928 rules = server.method_3767();
                    class_1928.class_4310 rule = (class_1928.class_4310)rules.method_20746(class_1928.field_19389);
                    keepInventoryBefore = rule.method_20753();
                    rule.method_20758(true, server);
                    DragonBossFight.makeScoreboards(server);
                    crystals = endWorld.method_18023((class_5575)class_1299.field_6110, new class_238(new class_2338(-50, 25, -50).method_46558(), new class_2338(50, 115, 50).method_46558()), class_1511::method_6836);
                    for (class_1511 crystal : crystals) {
                        crystal.method_5684(true);
                    }
                    class_5250 notif = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Dragon Prepped, Awaiting Announcement & Start Commands. ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" [Announce]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10610("/arcana boss announce 5 Minutes")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to announce the Fight!"))).method_10977(class_124.field_1075).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)" [Start]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10610("/arcana boss begin")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to begin the Fight!"))).method_10977(class_124.field_1075).method_10982(Boolean.valueOf(true))));
                    gmNotifs.add(notif);
                    prepNotif = true;
                }
            } else if (state == States.WAITING_ONE) {
                if (!phase1Notif) {
                    numPlayers = DragonBossFight.calcPlayers(server, false);
                    fightData.method_10569("numPlayers", numPlayers);
                    DragonDialog.announce(DragonDialog.Announcements.EVENT_START, server, null);
                    BorisLib.addTickTimerCallback((class_3218)endWorld, (TickTimerCallback)new GenericTimer(100, () -> {
                        List players = server.method_3760().method_14571();
                        for (class_3222 player : players) {
                            if (player.method_68878() || player.method_7325()) continue;
                            player.method_61275(new class_5454(endWorld, new class_243(100.5 + (Math.random() * 3.0 - 1.5), 51.0, 0.5 + (Math.random() * 3.0 - 1.5)), class_243.field_1353, 90.0f, 0.0f, class_5454.field_52247));
                        }
                        guardianPhantoms = new DragonPhantomEntity[4];
                        phantomBossBars = new class_3002[4];
                        class_2499 phantomData = new class_2499();
                        for (int i = 0; i < guardianPhantoms.length; ++i) {
                            DragonBossFight.guardianPhantoms[i] = DragonGoonHelper.makeGuardianPhantom(endWorld, numPlayers);
                            DragonBossFight.phantomBossBars[i] = endWorld.method_8503().method_3837().method_12970(class_2960.method_60654((String)("guardianphantom-" + guardianPhantoms[i].method_5845())), guardianPhantoms[i].method_5797());
                            phantomBossBars[i].method_5416(class_1259.class_1260.field_5783);
                            guardianPhantoms[i].method_6092(new class_1293(class_1294.field_5907, 100, 4));
                            endWorld.method_30771((class_1297)guardianPhantoms[i]);
                            phantomData.add((Object)class_2519.method_23256((String)guardianPhantoms[i].method_5845()));
                        }
                        wizards = new DragonWizardEntity[crystals.size()];
                        class_2499 wizardData = new class_2499();
                        for (int i = 0; i < wizards.length; ++i) {
                            class_1511 crystal = crystals.get(i);
                            DragonBossFight.wizards[i] = DragonGoonHelper.makeWizard(endWorld, numPlayers);
                            wizards[i].method_33574(crystal.method_19538().method_1031(0.0, 2.0, 0.0));
                            wizards[i].method_5684(true);
                            wizards[i].setCrystalId(crystal.method_5667());
                            wizards[i].method_6092(new class_1293(class_1294.field_5907, 100, 4));
                            endWorld.method_30771((class_1297)wizards[i]);
                            wizardData.add((Object)class_2519.method_23256((String)wizards[i].method_5845()));
                        }
                        fightData.method_10566("phantoms", (class_2520)phantomData);
                        fightData.method_10566("wizards", (class_2520)wizardData);
                        States.updateState(States.PHASE_ONE, server);
                        DragonDialog.announce(DragonDialog.Announcements.PHASE_ONE_START, server, null);
                        phase = 1;
                    }));
                    dragonAbilities = new DragonAbilities(server, endWorld, dragon, crystals);
                    lairActions = new DragonLairActions(server, endWorld, dragon);
                    phase1Notif = true;
                }
            } else if (state == States.PHASE_ONE) {
                nearbyPlayers300 = endWorld.method_18766(p -> p.method_5707(new class_243(0.0, 100.0, 0.0)) <= 90000.0);
                List endermen = endWorld.method_18023((class_5575)class_1299.field_6091, new class_238(new class_2338(-100, 25, -100).method_46558(), new class_2338(100, 115, 100).method_46558()), e -> true);
                for (class_1560 enderman : endermen) {
                    if (!(enderman.method_5968() instanceof class_1559) && !(endWorld.method_66347(enderman.method_29508()) instanceof class_1559)) continue;
                    enderman.method_5980(null);
                    enderman.method_29513(null);
                }
                int aliveCount = 0;
                if (guardianPhantoms != null) {
                    for (int i = 0; i < guardianPhantoms.length; ++i) {
                        if (guardianPhantoms[i] == null) continue;
                        if (guardianPhantoms[i].method_5805()) {
                            ++aliveCount;
                            float percent = guardianPhantoms[i].method_6032() / guardianPhantoms[i].method_6063();
                            phantomBossBars[i].method_5408(percent);
                            Iterator iterator = nearbyPlayers300.iterator();
                            while (iterator.hasNext()) {
                                class_3222 player = (class_3222)iterator.next();
                                phantomBossBars[i].method_14088(player);
                            }
                            continue;
                        }
                        phantomBossBars[i].method_14094();
                        server.method_3837().method_12973(phantomBossBars[i]);
                        guardianPhantoms[i].method_31472();
                        DragonBossFight.guardianPhantoms[i] = null;
                        DragonDialog.announce(DragonDialog.Announcements.PHANTOM_DEATH, server, null);
                    }
                }
                dragon.method_6025((float)(50 + 25 * numPlayers));
                if (aliveCount == 0) {
                    gmNotifs.add(class_2561.method_43470((String)"All Phantoms Dead, progressing to Phase 2"));
                    States.updateState(States.WAITING_TWO, server);
                }
            } else if (state == States.WAITING_TWO) {
                numPlayers = Math.max(1, DragonBossFight.calcPlayers(server, false));
                fightData.method_10569("numPlayers", numPlayers);
                for (DragonWizardEntity wizard : wizards) {
                    wizard.method_5684(false);
                }
                DragonDialog.announce(DragonDialog.Announcements.PHASE_TWO_START, server, null);
                States.updateState(States.PHASE_TWO, server);
                phase = 2;
            } else if (state == States.PHASE_TWO) {
                nearbyPlayers300 = endWorld.method_18766(p -> p.method_5707(new class_243(0.0, 100.0, 0.0)) <= 90000.0);
                if (wizards != null) {
                    for (int i = 0; i < wizards.length; ++i) {
                        class_1297 entity;
                        class_1511 crystal;
                        if (wizards[i] == null) continue;
                        if (wizards[i].method_5805()) {
                            class_1297 entity2;
                            if (age % 130 != 0 || wizards[i].getCrystalId() == null || !((entity2 = endWorld.method_66347(wizards[i].getCrystalId())) instanceof class_1511)) continue;
                            crystal = (class_1511)entity2;
                            class_243 crystalPos = crystal.method_19538().method_1031(0.0, -1.0, 0.0);
                            ArcanaEffectUtils.dragonBossTowerCircleInvuln(endWorld, crystalPos, 6000, 0);
                            continue;
                        }
                        if (wizards[i].getCrystalId() != null && (entity = endWorld.method_66347(wizards[i].getCrystalId())) instanceof class_1511) {
                            crystal = (class_1511)entity;
                            crystal.method_5684(false);
                        }
                        int finalI = i;
                        List nearbyPlayers = endWorld.method_18766(p -> p.method_5707(wizards[finalI].method_19538()) <= 400.0);
                        for (class_3222 player : nearbyPlayers) {
                            player.method_7353((class_2561)class_2561.method_43470((String)"The Crystal's Shield Fades!").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), true);
                        }
                        wizards[i].method_31472();
                        DragonBossFight.wizards[i] = null;
                    }
                }
                int aliveCount = 0;
                boolean crystalDestroyed = false;
                for (int i = 0; i < crystals.size(); ++i) {
                    class_1511 crystal = crystals.get(i);
                    if (crystal == null) continue;
                    if (crystal.method_5805()) {
                        ++aliveCount;
                        continue;
                    }
                    ReclaimState newRecState = new ReclaimState(crystal.method_19538(), endWorld);
                    newRecState.hologramVisible = false;
                    reclaimStates.add(newRecState);
                    crystals.set(i, null);
                    crystalDestroyed = true;
                }
                if (crystalDestroyed) {
                    if (aliveCount == 9) {
                        DragonDialog.announce(DragonDialog.Announcements.FIRST_CRYSTAL_DESTROYED, server, null);
                    } else if (aliveCount == 5) {
                        DragonDialog.announce(DragonDialog.Announcements.HALF_CRYSTALS_DESTROYED, server, null);
                    } else {
                        DragonDialog.announce(DragonDialog.Announcements.CRYSTAL_DESTROYED, server, null);
                    }
                }
                dragon.method_6025((float)(50 + 25 * numPlayers));
                if (aliveCount == 0) {
                    gmNotifs.add(class_2561.method_43470((String)"All Crystals Dead, progressing to Phase 3"));
                    States.updateState(States.WAITING_THREE, server);
                }
            } else if (state == States.WAITING_THREE) {
                numPlayers = Math.max(1, DragonBossFight.calcPlayers(server, false));
                fightData.method_10569("numPlayers", numPlayers);
                for (ReclaimState reclaimState : reclaimStates) {
                    reclaimState.hologramVisible = true;
                }
                DragonDialog.announce(DragonDialog.Announcements.PHASE_THREE_START, server, null);
                States.updateState(States.PHASE_THREE, server);
                phase = 3;
            } else if (state == States.PHASE_THREE) {
                class_1560 enderman;
                List endermen = endWorld.method_18023((class_5575)class_1299.field_6091, new class_238(new class_2338(-100, 25, -100).method_46558(), new class_2338(100, 115, 100).method_46558()), e -> true);
                float dragonHP = dragon.method_6032();
                float dragonMax = dragon.method_6063();
                Iterator<Object> iterator = endermen.iterator();
                while (iterator.hasNext()) {
                    class_1657 closestPlayer;
                    enderman = (class_1560)iterator.next();
                    if ((double)(dragonHP / dragonMax) <= 0.5) {
                        int amp = (double)(dragonHP / dragonMax) <= 0.25 ? 1 : 0;
                        class_1293 strength = new class_1293(class_1294.field_5910, 120, amp, false, false, false);
                        enderman.method_6092(strength);
                        class_1293 resist = new class_1293(class_1294.field_5907, 120, amp, false, false, false);
                        enderman.method_6092(resist);
                    }
                    if (!enderman.method_7028() || (closestPlayer = endWorld.method_18460((class_1297)enderman, 4.0)) == null) continue;
                    class_1293 slow = new class_1293(class_1294.field_5909, 60, 2, false, false, false);
                    closestPlayer.method_6092(slow);
                }
                if (age % 300 == 0) {
                    iterator = endermen.iterator();
                    while (iterator.hasNext()) {
                        enderman = (class_1560)iterator.next();
                        class_1657 closestPlayer = endWorld.method_18460((class_1297)enderman, 30.0);
                        if (closestPlayer != null) {
                            enderman.method_22331();
                            enderman.method_5980((class_1309)closestPlayer);
                            enderman.method_29513(closestPlayer.method_5667());
                            enderman.method_29514(1200);
                            continue;
                        }
                        class_3222 randomPlayer = endWorld.method_18779();
                        if (randomPlayer == null || !(Math.random() < 0.1 * (double)numPlayers)) continue;
                        enderman.method_22331();
                        enderman.method_5980((class_1309)randomPlayer);
                        enderman.method_29513(randomPlayer.method_5667());
                        enderman.method_29514(1200);
                    }
                }
                for (ReclaimState reclaimState : reclaimStates) {
                    reclaimState.tick();
                }
                if (!halfHPNotif && (double)(dragonHP / dragonMax) <= 0.5) {
                    DragonDialog.announce(DragonDialog.Announcements.DRAGON_HALF_HP, server, null);
                    halfHPNotif = true;
                }
                if (!quarterHPNotif && (double)(dragonHP / dragonMax) <= 0.25) {
                    DragonDialog.announce(DragonDialog.Announcements.DRAGON_QUARTER_HP, server, null);
                    quarterHPNotif = true;
                }
                if (dragonHP <= 0.0f || !dragon.method_5805()) {
                    DragonDialog.announce(DragonDialog.Announcements.DRAGON_DEATH, server, null);
                    gmNotifs.add(class_2561.method_43470((String)"Dragon Dead, Concluding Fight"));
                    States.updateState(States.WAITING_DEATH, server);
                }
            } else if (state == States.WAITING_DEATH && !endNotif) {
                for (ReclaimState reclaimState : reclaimStates) {
                    reclaimState.fightEnd();
                }
                BorisLib.addTickTimerCallback((class_3218)endWorld, (TickTimerCallback)new GenericTimer(100, () -> DragonBossFight.endFight(server, endWorld)));
                endNotif = true;
            }
            if (fightData.method_68083("numPlayers", 0) != numPlayers) {
                fightData.method_10569("numPlayers", numPlayers);
            }
            if (state == States.PHASE_ONE || state == States.PHASE_TWO || state == States.PHASE_THREE) {
                crystals.forEach(c -> DragonBossFight.tickCrystal(endWorld, c, phase));
                if (lastGoonSpawn > 900) {
                    DragonBossFight.spawnGoons(endWorld, phase);
                }
                if (lastLairAction > 700 && lairActions.startAction(phase)) {
                    lastLairAction = 0;
                }
                if (lastDragonAction > 500 && dragonAbilities.doAbility(phase)) {
                    lastDragonAction = 0;
                }
            }
            if (gm != null) {
                gmNotifs.forEach(arg_0 -> ((class_3222)gm).method_64398(arg_0));
            }
            if (state != States.WAITING_RESPAWN && state != States.WAITING_START && state != States.WAITING_ONE) {
                if (age % 3000 == 0) {
                    List bullets = endWorld.method_18023((class_5575)class_1299.field_6100, new class_238(new class_2338(-400, 0, -400).method_46558(), new class_2338(400, 256, 400).method_46558()), e -> true);
                    for (class_1678 bullet : bullets) {
                        bullet.method_5768(endWorld);
                    }
                }
                ++age;
                ++lastGoonSpawn;
                ++lastLairAction;
                ++lastDragonAction;
                if (dragonAbilities != null) {
                    dragonAbilities.tick();
                }
                if (lairActions != null) {
                    lairActions.tick();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static void spawnGoons(class_3218 endWorld, int phase) {
        if (phase == 1) {
            double chance;
            List curGoons = endWorld.method_18023((class_5575)class_1299.field_6128, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
            if (curGoons.size() > 35) {
                return;
            }
            double d = chance = curGoons.size() < 5 ? 0.005 : 0.002;
            if (Math.random() > chance) {
                return;
            }
            class_1559[] goons = new class_1559[class_3532.method_15340((int)((int)(Math.random() * 3.0 * (double)numPlayers + 2.0 + (double)numPlayers)), (int)10, (int)35)];
            ArrayList<class_2338> poses = SpawnPile.makeSpawnLocations(goons.length, 50, endWorld);
            float endermiteHP = class_3532.method_15340((int)(10 + 3 * numPlayers), (int)10, (int)40);
            for (int i = 0; i < goons.length; ++i) {
                goons[i] = new class_1559(class_1299.field_6128, (class_1937)endWorld);
                goons[i].method_5996(class_5134.field_23716).method_6192((double)endermiteHP);
                goons[i].method_6033(endermiteHP);
                goons[i].method_5971();
                goons[i].method_5996(class_5134.field_23721).method_6192(8.0);
                class_2338 pos = poses.get(i);
                goons[i].method_23327((double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260());
                endWorld.method_30771((class_1297)goons[i]);
            }
            DragonDialog.announce(DragonDialog.Announcements.PHASE_ONE_GOONS, endWorld.method_8503(), null);
        } else if (phase == 2) {
            double chance;
            List curGoons = endWorld.method_18023((class_5575)class_1299.field_6109, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
            if (curGoons.size() > 35) {
                return;
            }
            double d = chance = curGoons.size() < 5 ? 0.005 : 0.002;
            if (Math.random() > chance) {
                return;
            }
            class_1606[] goons = new class_1606[class_3532.method_15340((int)((int)(Math.random() * 2.0 * (double)numPlayers + 2.0 + (double)numPlayers)), (int)10, (int)35)];
            ArrayList<class_2338> poses = SpawnPile.makeSpawnLocations(goons.length, 50, endWorld);
            float shulkerHP = class_3532.method_15340((int)(20 + 4 * numPlayers), (int)20, (int)80);
            for (int i = 0; i < goons.length; ++i) {
                goons[i] = new class_1606(class_1299.field_6109, (class_1937)endWorld);
                goons[i].method_5996(class_5134.field_23716).method_6192((double)shulkerHP);
                goons[i].method_6033(shulkerHP);
                goons[i].method_5971();
                class_2338 pos = poses.get(i);
                goons[i].method_23327((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                endWorld.method_30771((class_1297)goons[i]);
            }
            DragonDialog.announce(DragonDialog.Announcements.PHASE_TWO_GOONS, endWorld.method_8503(), null);
        } else if (phase == 3) {
            double chance;
            List curGoons = endWorld.method_18023((class_5575)class_1299.field_6091, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
            if (curGoons.size() > 50) {
                return;
            }
            double d = chance = curGoons.size() < 5 ? 0.005 : 0.002;
            if (Math.random() > chance) {
                return;
            }
            class_1560[] goons = new class_1560[class_3532.method_15340((int)((int)(Math.random() * 3.0 * (double)numPlayers + 2.0 + (double)(numPlayers * 2))), (int)20, (int)50)];
            ArrayList<class_2338> poses = SpawnPile.makeSpawnLocations(goons.length, 50, endWorld);
            float endermanHP = class_3532.method_15340((int)(20 + 4 * numPlayers), (int)20, (int)80);
            for (int i = 0; i < goons.length; ++i) {
                goons[i] = new class_1560(class_1299.field_6091, (class_1937)endWorld);
                goons[i].method_5996(class_5134.field_23716).method_6192((double)endermanHP);
                goons[i].method_6033(endermanHP);
                goons[i].method_5996(class_5134.field_23721).method_6192(8.0);
                class_2338 pos = poses.get(i);
                goons[i].method_23327((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                endWorld.method_30771((class_1297)goons[i]);
            }
            DragonDialog.announce(DragonDialog.Announcements.PHASE_THREE_GOONS, endWorld.method_8503(), null);
        }
        lastGoonSpawn = 0;
    }

    private static void endFight(MinecraftServer server, class_3218 endWorld) {
        try {
            DragonDialog.announce(DragonDialog.Announcements.EVENT_END, server, null);
            ArcanaItem arcanaWings = ArcanaRegistry.WINGS_OF_ENDERIA;
            List players = endWorld.method_8503().method_3760().method_14571();
            for (class_3222 player : players) {
                class_1799 wings = arcanaWings.addCrafter(arcanaWings.getNewItem(), player.method_5845(), false, player.method_5682());
                wings.method_7978(MinecraftUtils.getEnchantment(ArcanaRegistry.FATE_ANCHOR), 1);
                ArcanaNovum.data((class_1657)player).addCraftedSilent(wings);
                BorisLib.addTickTimerCallback((TickTimerCallback)new ItemReturnTimerCallback(wings, player, 0));
                BorisLib.addTickTimerCallback((TickTimerCallback)new ItemReturnTimerCallback(new class_1799((class_1935)class_1802.field_8840, 1), player, 0));
                player.method_7255(5500);
            }
            List<class_9011> scores = DragonBossFight.getLeaderboard(server);
            ArrayList<class_5250> message = new ArrayList<class_5250>();
            message.add(class_2561.method_43470((String)""));
            message.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"-----------------------------------").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})));
            message.add(class_2561.method_43470((String)""));
            message.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"                      ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Leaderboard").method_27695(new class_124[]{class_124.field_1060, class_124.field_1073})));
            message.add(class_2561.method_43470((String)""));
            message.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"  <> ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Most Bloodthirsty").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)scores.get(0).comp_2127()).method_27695(new class_124[]{class_124.field_1065, class_124.field_1073, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(scores.get(0).comp_2128())).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" damage points dealt!").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})));
            message.add(class_2561.method_43470((String)""));
            message.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"  <> ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Tankiest Fighter").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)scores.get(1).comp_2127()).method_27695(new class_124[]{class_124.field_1065, class_124.field_1073, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(scores.get(1).comp_2128())).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" damage points taken!").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})));
            message.add(class_2561.method_43470((String)""));
            message.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"  <> ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Most Death Prone").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)scores.get(2).comp_2127()).method_27695(new class_124[]{class_124.field_1065, class_124.field_1073, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(scores.get(2).comp_2128())).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" deaths!").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})));
            message.add(class_2561.method_43470((String)""));
            message.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"  <> ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Goon Slayer").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)scores.get(3).comp_2127()).method_27695(new class_124[]{class_124.field_1065, class_124.field_1073, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(scores.get(3).comp_2128())).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" mob kills!").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})));
            message.add(class_2561.method_43470((String)""));
            message.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"-----------------------------------").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})));
            BorisLib.addTickTimerCallback((class_3218)endWorld, (TickTimerCallback)new GenericTimer(400, () -> {
                for (class_5250 msg : message) {
                    endWorld.method_8503().method_3760().method_43514((class_2561)msg, false);
                }
            }));
            class_1928 rules = server.method_3767();
            class_1928.class_4310 rule = (class_1928.class_4310)rules.method_20746(class_1928.field_19389);
            rule.method_20758(keepInventoryBefore, server);
            if (gameMaster != null) {
                gameMaster.method_64398((class_2561)class_2561.method_43470((String)"Fight Ended, Thanks For Playing!"));
            }
            DragonBossFight.resetVariables();
            DragonBossFight.removeScoreboards(server);
            BossFight.cleanBoss(server);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void tickCrystal(class_3218 endWorld, class_1511 crystal, int phase) {
        if (crystal == null) {
            return;
        }
        class_243 pos = crystal.method_19538().method_1031(0.0, -1.0, 0.0);
        if (phase == 1) {
            if (age % 260 == 0) {
                ArcanaEffectUtils.dragonBossTowerCirclePush(endWorld, pos, 12000, 0);
            }
            List inRangePlayers = endWorld.method_18766(p -> p.method_5707(new class_243(pos.method_10216() + 0.5, pos.method_10214() - 1.0, pos.method_10215() + 0.5)) <= 30.25);
            for (class_3222 player : inRangePlayers) {
                class_2338 target = class_2338.method_49637((double)(pos.method_10216() + 0.5), (double)(pos.method_10214() - 1.0), (double)(pos.method_10215() + 0.5));
                class_2338 playerPos = player.method_24515();
                class_243 vec = new class_243((double)(target.method_10263() - playerPos.method_10263()), 0.0, (double)(target.method_10260() - playerPos.method_10260()));
                vec = vec.method_1029().method_1021(3.0);
                player.method_18800(-vec.field_1352, 1.0, -vec.field_1350);
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                player.method_7353((class_2561)class_2561.method_43470((String)"The Crystal Tower is Shielded!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}), true);
            }
        }
    }

    private static void makeScoreboards(MinecraftServer server) {
        try {
            class_2995 scoreboard = server.method_3845();
            class_274 dmgDealt = (class_274)class_274.method_1224((String)"minecraft.custom:minecraft.damage_dealt").orElseThrow();
            class_274 dmgTaken = (class_274)class_274.method_1224((String)"minecraft.custom:minecraft.damage_taken").orElseThrow();
            class_274 deaths = class_274.field_1456;
            class_274 mobKills = (class_274)class_274.method_1224((String)"minecraft.custom:minecraft.mob_kills").orElseThrow();
            scoreboard.method_1168("arcananovum_boss_dmg_dealt", dmgDealt, (class_2561)class_2561.method_43470((String)"Event Damage Dealt"), dmgDealt.method_1227(), false, null);
            scoreboard.method_1168("arcananovum_boss_dmg_taken", dmgTaken, (class_2561)class_2561.method_43470((String)"Event Damage Taken"), dmgTaken.method_1227(), false, null);
            scoreboard.method_1168("arcananovum_boss_deaths", deaths, (class_2561)class_2561.method_43470((String)"Event Deaths"), deaths.method_1227(), false, null);
            scoreboard.method_1168("arcananovum_boss_mob_kills", mobKills, (class_2561)class_2561.method_43470((String)"Event Mob Kills"), mobKills.method_1227(), false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeScoreboards(MinecraftServer server) {
        try {
            class_2995 scoreboard = server.method_3845();
            class_266 dmgDealt = scoreboard.method_1170("arcananovum_boss_dmg_dealt");
            class_266 dmgTaken = scoreboard.method_1170("arcananovum_boss_dmg_taken");
            class_266 deaths = scoreboard.method_1170("arcananovum_boss_deaths");
            class_266 mobKills = scoreboard.method_1170("arcananovum_boss_mob_kills");
            scoreboard.method_1194(dmgDealt);
            scoreboard.method_1194(dmgTaken);
            scoreboard.method_1194(deaths);
            scoreboard.method_1194(mobKills);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<class_9011> getLeaderboard(MinecraftServer server) {
        ArrayList<class_9011> list = new ArrayList<class_9011>();
        try {
            class_9011 dummyScore;
            class_2995 scoreboard = server.method_3845();
            class_266 dmgDealt = scoreboard.method_1170("arcananovum_boss_dmg_dealt");
            class_266 dmgTaken = scoreboard.method_1170("arcananovum_boss_dmg_taken");
            class_266 deaths = scoreboard.method_1170("arcananovum_boss_deaths");
            class_266 mobKills = scoreboard.method_1170("arcananovum_boss_mob_kills");
            ArrayList<class_9011> dmgDealtScores = new ArrayList<class_9011>(scoreboard.method_1184(dmgDealt));
            ArrayList<class_9011> dmgTakenScores = new ArrayList<class_9011>(scoreboard.method_1184(dmgTaken));
            ArrayList<class_9011> deathsScores = new ArrayList<class_9011>(scoreboard.method_1184(deaths));
            ArrayList<class_9011> mobKillsScores = new ArrayList<class_9011>(scoreboard.method_1184(mobKills));
            Comparator<class_9011> scoreComparator = Comparator.comparingInt(class_9011::comp_2128);
            dmgDealtScores.sort(scoreComparator);
            dmgTakenScores.sort(scoreComparator);
            deathsScores.sort(scoreComparator);
            mobKillsScores.sort(scoreComparator);
            if (dmgDealtScores.isEmpty()) {
                dummyScore = new class_9011("-", 0, (class_2561)class_2561.method_43470((String)"-"), null);
                list.add(dummyScore);
            } else {
                list.add((class_9011)dmgDealtScores.get(dmgDealtScores.size() - 1));
            }
            if (dmgTakenScores.isEmpty()) {
                dummyScore = new class_9011("-", 0, (class_2561)class_2561.method_43470((String)"-"), null);
                list.add(dummyScore);
            } else {
                list.add((class_9011)dmgTakenScores.get(dmgTakenScores.size() - 1));
            }
            if (deathsScores.isEmpty()) {
                dummyScore = new class_9011("-", 0, (class_2561)class_2561.method_43470((String)"-"), null);
                list.add(dummyScore);
            } else {
                list.add((class_9011)deathsScores.get(deathsScores.size() - 1));
            }
            if (mobKillsScores.isEmpty()) {
                dummyScore = new class_9011("-", 0, (class_2561)class_2561.method_43470((String)"-"), null);
                list.add(dummyScore);
            } else {
                list.add((class_9011)mobKillsScores.get(mobKillsScores.size() - 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void resetTowers(class_3218 endWorld) {
        List list = class_3310.method_14506((class_5281)endWorld);
        for (class_3310.class_3181 spike : list) {
            List nearCrystals = endWorld.method_18023((class_5575)class_1299.field_6110, new class_238(class_2338.method_49637((double)(spike.method_13966() - 10), (double)0.0, (double)(spike.method_13967() - 10)).method_46558(), class_2338.method_49637((double)(spike.method_13966() + 10), (double)255.0, (double)(spike.method_13967() + 10)).method_46558()), class_1511::method_6836);
            for (class_1511 nearCrystal : nearCrystals) {
                nearCrystal.method_5768(endWorld);
            }
            for (class_2338 blockPos : class_2338.method_10097((class_2338)class_2338.method_49637((double)(spike.method_13966() - 10), (double)(spike.method_13964() - 10), (double)(spike.method_13967() - 10)), (class_2338)class_2338.method_49637((double)(spike.method_13966() + 10), (double)(spike.method_13964() + 10), (double)(spike.method_13967() + 10)))) {
                endWorld.method_8650(blockPos, false);
            }
            endWorld.method_8437((class_1297)null, (double)((float)spike.method_13966() + 0.5f), (double)spike.method_13964(), (double)((float)spike.method_13967() + 0.5f), 5.0f, class_1937.class_7867.field_40888);
            class_3666 endSpikeFeatureConfig = new class_3666(false, (List)ImmutableList.of((Object)spike), (class_2338)null);
            class_3031.field_13522.method_40163((class_3037)endSpikeFeatureConfig, (class_5281)endWorld, endWorld.method_14178().method_12129(), class_5819.method_43047(), class_2338.method_49637((double)spike.method_13966(), (double)45.0, (double)spike.method_13967()));
        }
    }

    public static int prepBoss(class_3222 player) {
        if (player.method_51469().method_27983() != class_1937.field_25181) {
            player.method_7353((class_2561)class_2561.method_43470((String)"The Dragon boss must take place in The End"), false);
            return -1;
        }
        class_3218 endWorld = player.method_51469();
        class_2487 dragonData = (class_2487)class_2881.class_8576.field_44945.encodeStart((DynamicOps)class_2509.field_11560, (Object)endWorld.method_29198().method_12530()).getOrThrow();
        class_2487 fightData = new class_2487();
        if (dragonData.method_68566("DragonKilled", false)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Dragon is Dead, Commencing Respawn"), false);
            int[] exitList = (int[])dragonData.method_10561("ExitPortalLocation").get();
            class_2338 portalPos = new class_2338(exitList[0], exitList[1], exitList[2]);
            class_2338 blockPos2 = portalPos.method_10086(1);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_1511 crystal = new class_1511(class_1299.field_6110, (class_1937)endWorld);
                crystal.method_33574(class_243.method_24955((class_2382)blockPos2.method_10079(direction, 3)));
                endWorld.method_30771((class_1297)crystal);
            }
            endWorld.method_29198().method_12522();
            fightData.method_10582("State", States.WAITING_RESPAWN.name());
            BorisLib.addTickTimerCallback((TickTimerCallback)new DragonRespawnTimerCallback(player.method_5682()));
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"Co-opting Dragon"), false);
            if (endWorld.method_18023((class_5575)class_1299.field_6110, new class_238(new class_2338(-50, 25, -50).method_46558(), new class_2338(50, 115, 50).method_46558()), class_1511::method_6836).size() != 10) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Tower Anomaly Detected, Resetting").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
                DragonBossFight.resetTowers(endWorld);
            }
            fightData.method_10582("State", States.WAITING_START.name());
        }
        fightData.method_10582("GameMaster", player.method_5845());
        fightData.method_10569("numPlayers", 0);
        player.method_7353((class_2561)class_2561.method_43470((String)""), false);
        player.method_7353((class_2561)class_2561.method_43470((String)"You are now the Game Master, please stay in The End for the duration of the fight. All errors and updates will be sent to you.").method_27692(class_124.field_1075), false);
        player.method_7353((class_2561)class_2561.method_43470((String)""), false);
        ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)endWorld)).setBossFight(BossFights.DRAGON, fightData);
        return 0;
    }

    public static int abortBoss(MinecraftServer server) {
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)server.method_3847(class_1937.field_25181))).getBossFight();
        class_2487 data = (class_2487)bossFight.method_15441();
        States state = States.valueOf(data.method_68564("State", ""));
        class_3222 gm = server.method_3760().method_14602(AlgoUtils.getUUID((String)data.method_68564("GameMaster", "")));
        class_3218 endWorld = server.method_3847(class_1937.field_25181);
        if (gm != null) {
            gm.method_64398((class_2561)class_2561.method_43470((String)"Boss Has Been Aborted :(").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
        }
        for (class_1510 dragon : endWorld.method_18776()) {
            dragon.method_5996(class_5134.field_23716).method_6192(200.0);
            dragon.method_6033(200.0f);
            dragon.method_5665((class_2561)class_2561.method_43470((String)"Ender Dragon"));
        }
        if (reclaimStates != null) {
            for (ReclaimState reclaimState : reclaimStates) {
                reclaimState.hologramVisible = false;
            }
        }
        if (guardianPhantoms != null && phase == 1) {
            for (Iterator<Object> iterator : guardianPhantoms) {
                if (iterator == null || !iterator.method_5805()) continue;
                iterator.method_5768(endWorld);
            }
            for (Iterator<Object> iterator : phantomBossBars) {
                if (iterator == null) continue;
                iterator.method_14094();
                server.method_3837().method_12973(iterator);
            }
        }
        if (wizards != null && (phase == 1 || phase == 2)) {
            for (Iterator<Object> iterator : wizards) {
                if (iterator == null || !iterator.method_5805()) continue;
                iterator.method_5768(endWorld);
            }
        }
        for (class_1511 crystal : crystals) {
            if (crystal == null) continue;
            crystal.method_5684(false);
        }
        List mites = endWorld.method_18023((class_5575)class_1299.field_6128, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
        List shulkers = endWorld.method_18023((class_5575)class_1299.field_6109, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
        List skeletons = endWorld.method_18023((class_5575)class_1299.field_6137, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
        List list = endWorld.method_18023((class_5575)class_1299.field_6078, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
        List illusioners = endWorld.method_18023((class_5575)class_1299.field_6065, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 255, 300).method_46558()), e -> true);
        mites.forEach(e -> e.method_5768(endWorld));
        shulkers.forEach(e -> e.method_5768(endWorld));
        skeletons.forEach(e -> e.method_5768(endWorld));
        list.forEach(e -> e.method_5768(endWorld));
        illusioners.forEach(e -> e.method_5768(endWorld));
        class_1928 rules = server.method_3767();
        class_1928.class_4310 rule = (class_1928.class_4310)rules.method_20746(class_1928.field_19389);
        rule.method_20758(keepInventoryBefore, server);
        DragonBossFight.resetVariables();
        DragonBossFight.removeScoreboards(server);
        BossFight.cleanBoss(server);
        return 0;
    }

    public static int beginBoss(MinecraftServer server, class_2487 data) {
        States state = States.valueOf(data.method_68564("State", ""));
        class_3222 gm = server.method_3760().method_14602(AlgoUtils.getUUID((String)data.method_68564("GameMaster", "")));
        if (state == States.WAITING_START) {
            if (startTimeAnnounced) {
                States.updateState(States.WAITING_ONE, server);
                if (gm != null) {
                    gm.method_64398((class_2561)class_2561.method_43470((String)"Beginning Boss Fight. Good Luck, Have Fun!"));
                }
                return 0;
            }
            if (gm != null) {
                gm.method_64398((class_2561)class_2561.method_43470((String)"Make sure you have run /arcana boss announce <time> so your players know to get ready first!"));
            }
        } else if (gm != null) {
            gm.method_64398((class_2561)class_2561.method_43470((String)"The Event State is incompatible with this command. Have you run /arcana boss start dragon?"));
        }
        return -1;
    }

    public static int announceBoss(MinecraftServer server, class_2487 data, String time) {
        States state = States.valueOf(data.method_68564("State", ""));
        if (state == States.WAITING_START) {
            DragonDialog.announce(DragonDialog.Announcements.EVENT_PREP, server, time);
            startTimeAnnounced = true;
            return 0;
        }
        class_3222 gm = server.method_3760().method_14602(AlgoUtils.getUUID((String)data.method_68564("GameMaster", "")));
        if (gm != null) {
            gm.method_64398((class_2561)class_2561.method_43470((String)"The Event State is incompatible with this command. Have you run /arcana boss start dragon?"));
        }
        return -1;
    }

    public static int calcPlayers(MinecraftServer server, boolean inEnd) {
        if (forcedPlayerCount > 0) {
            return forcedPlayerCount;
        }
        List playerList = server.method_3760().method_14571();
        int count = 0;
        if (!inEnd) {
            return playerList.size();
        }
        for (class_3222 player : playerList) {
            if (player.method_7325() || player.method_68878() || player.method_51469() != server.method_3847(class_1937.field_25181)) continue;
            ++count;
        }
        return count;
    }

    public static int resetDragonAbilities(MinecraftServer server, class_2168 source, boolean doAbility) {
        if (dragonAbilities == null) {
            return -1;
        }
        dragonAbilities.resetCooldowns();
        if (doAbility && dragonAbilities.doAbility(phase)) {
            lastDragonAction = 0;
        }
        return 1;
    }

    public static int forceLairAction(MinecraftServer server, class_2168 source) {
        if (lairActions == null) {
            return -1;
        }
        if (lairActions.startAction(phase)) {
            lastLairAction = 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int bossStatus(MinecraftServer server, class_2168 source) {
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)server.method_3847(class_1937.field_25181))).getBossFight();
        class_2487 data = (class_2487)bossFight.method_15441();
        States state = States.valueOf(data.method_68564("State", ""));
        class_3222 gm = server.method_3760().method_14602(AlgoUtils.getUUID((String)data.method_68564("GameMaster", "")));
        ArrayList<class_5250> msgs = new ArrayList<class_5250>();
        msgs.add(class_2561.method_43470((String)""));
        msgs.add(class_2561.method_43470((String)"Dragon Boss Data: "));
        msgs.add(class_2561.method_43470((String)("Game Master: " + gm.method_5477().getString())));
        msgs.add(class_2561.method_43470((String)("State: " + state.name())));
        if (state != States.WAITING_RESPAWN) {
            msgs.add(class_2561.method_43470((String)("Num Players: " + numPlayers)));
            msgs.add(class_2561.method_43470((String)("Dragon HP: (" + dragon.method_6032() + "/" + dragon.method_6063() + ")")));
            msgs.add(class_2561.method_43470((String)("Last Goon Spawn: " + lastGoonSpawn / 20 + " seconds ago.")));
            msgs.add(class_2561.method_43470((String)""));
        }
        if (state == States.PHASE_ONE) {
            for (DragonPhantomEntity guardianPhantom : guardianPhantoms) {
                if (guardianPhantom == null) continue;
                msgs.add(class_2561.method_43470((String)("Guardian Phantom HP: (" + guardianPhantom.method_6032() + "/" + guardianPhantom.method_6063() + ")")));
            }
        } else if (state == States.PHASE_TWO) {
            void var8_11;
            int wizardCount = 0;
            boolean bl = false;
            for (DragonWizardEntity wizard : wizards) {
                if (wizard == null || !wizard.method_5805()) continue;
                ++wizardCount;
            }
            for (class_1511 crystal : crystals) {
                if (crystal == null || !crystal.method_5805()) continue;
                ++var8_11;
            }
            msgs.add(class_2561.method_43470((String)("Wizards Alive: " + wizardCount + "/10")));
            msgs.add(class_2561.method_43470((String)("Crystals Alive: " + (int)var8_11 + "/10")));
        }
        msgs.add(class_2561.method_43470((String)""));
        if (state == States.PHASE_ONE || state == States.PHASE_TWO || state == States.PHASE_THREE) {
            if (dragonAbilities != null) {
                msgs.add(class_2561.method_43470((String)("Dragon Ability Cooldowns: Next Check in " + (600 - lastDragonAction) / 20 + " Seconds")));
                for (class_3545 class_35452 : dragonAbilities.getCooldowns(phase)) {
                    msgs.add(class_2561.method_43470((String)(" - " + ((DragonAbilities.DragonAbilityTypes)((Object)class_35452.method_15442())).name() + ": " + (Integer)class_35452.method_15441() / 20 + " Seconds")));
                }
            }
            msgs.add(class_2561.method_43470((String)""));
            msgs.add(class_2561.method_43470((String)("Lair Action: Next Check in " + (1100 - lastLairAction) / 20 + " Seconds")));
        }
        for (class_5250 class_52502 : msgs) {
            source.method_9226(() -> msg, false);
        }
        return 0;
    }

    public static void playerDied(class_3222 player) {
        if (hasDied != null) {
            hasDied.add(player);
        }
    }

    public static void teleportPlayer(class_3222 player, boolean override) {
        class_3218 endWorld = player.method_5682().method_3847(class_1937.field_25181);
        if (hasDied.contains(player) || override) {
            player.method_61275(new class_5454(endWorld, new class_243(100.5, 51.0, 0.5), class_243.field_1353, 90.0f, 0.0f, class_5454.field_52247));
            class_1293 res = new class_1293(class_1294.field_5907, 600, 4, false, false, true);
            player.method_6092(res);
            class_5250 msg = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You are ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"protected").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" from damage for 30 seconds!").method_27692(class_124.field_1075));
            player.method_7353((class_2561)msg, false);
            hasDied.remove(player);
        } else {
            class_5250 msg = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You only get to teleport after dying.").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            player.method_7353((class_2561)msg, false);
        }
    }

    public static void setForcedPlayerCount(MinecraftServer server, int pc) {
        forcedPlayerCount = pc;
        numPlayers = DragonBossFight.calcPlayers(server, false);
    }

    public static List<ReclaimState> getReclaimStates() {
        return reclaimStates;
    }

    public static enum States {
        WAITING_RESPAWN,
        WAITING_START,
        WAITING_ONE,
        PHASE_ONE,
        WAITING_TWO,
        PHASE_TWO,
        WAITING_THREE,
        PHASE_THREE,
        WAITING_DEATH;


        public static States fromLabel(String id) {
            return States.valueOf(id);
        }

        public static void updateState(States state, MinecraftServer server) {
            class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)server.method_3847(class_1937.field_25181))).getBossFight();
            if (bossFight.method_15442() == BossFights.DRAGON) {
                ((class_2487)bossFight.method_15441()).method_10582("State", state.name());
            } else {
                ArcanaNovum.devPrint("Boss fight not valid");
            }
        }
    }

    public static class ReclaimState {
        private final ElementHolder hologram;
        private final HolderAttachment attachment;
        private class_243 pos;
        private class_3218 endWorld;
        private class_3222 player;
        private int solveCooldown;
        private class_243 shieldPos;
        private int shieldTicks;
        private long ticks;
        private TowerGui towerGui;
        private long animTicks = 0L;
        private boolean hologramVisible = false;
        private int state;

        public ReclaimState(class_243 pos, class_3218 endWorld) {
            this.pos = pos;
            this.endWorld = endWorld;
            this.player = null;
            this.solveCooldown = 0;
            this.state = 0;
            this.shieldPos = null;
            this.shieldTicks = 0;
            this.hologram = this.getNewHologram();
            this.attachment = ChunkAttachment.ofTicking((ElementHolder)this.hologram, (class_3218)this.endWorld, (class_243)this.pos);
            this.ticks = 0L;
            this.animTicks = 0L;
        }

        private ElementHolder getNewHologram() {
            final ReclaimState reclaimState = this;
            final TextDisplayElement line1 = new TextDisplayElement((class_2561)class_2561.method_43470((String)"Click to Attempt").method_27692(class_124.field_1054));
            final TextDisplayElement line2 = new TextDisplayElement((class_2561)class_2561.method_43470((String)"Tower Reclamation").method_27695(new class_124[]{class_124.field_1067, class_124.field_1076, class_124.field_1073}));
            final ItemDisplayElement icon = new ItemDisplayElement(class_1802.field_8301);
            final InteractionElement click = new InteractionElement(new VirtualElement.InteractionHandler(){

                public void click(class_3222 player) {
                    if (reclaimState.getSolveCooldown() == 0 && reclaimState.hologramVisible) {
                        PuzzleGui gui = new PuzzleGui(class_3917.field_17327, player, reclaimState);
                        gui.buildPuzzle();
                        gui.open();
                        reclaimState.setPlayer(player);
                        reclaimState.setSolveCooldown(1200);
                    }
                }

                public void interact(class_3222 player, class_1268 hand) {
                    this.click(player);
                }

                public void interactAt(class_3222 player, class_1268 hand, class_243 pos) {
                    this.click(player);
                }

                public void attack(class_3222 player) {
                    this.click(player);
                }
            });
            click.setSize(3.0f, 3.0f);
            final TextDisplayElement cooldownText = new TextDisplayElement((class_2561)class_2561.method_43470((String)("On Cooldown - " + (this.solveCooldown / 20 + 1) + " Seconds")).method_27692(class_124.field_1075));
            ElementHolder holder = new ElementHolder(this){
                private final ReclaimState state;
                private final TextDisplayElement cdText;
                private final TextDisplayElement line1Text;
                private final TextDisplayElement line2Text;
                private final ItemDisplayElement iconElem;
                private final InteractionElement clickElem;
                {
                    this.state = reclaimState;
                    this.cdText = cooldownText;
                    this.line1Text = line1;
                    this.line2Text = line2;
                    this.iconElem = icon;
                    this.clickElem = click;
                }

                protected void onTick() {
                    super.onTick();
                    if (!this.state.hologramVisible) {
                        this.line1Text.setInvisible(true);
                        this.removeElement((VirtualElement)this.line1Text);
                        this.line2Text.setInvisible(true);
                        this.removeElement((VirtualElement)this.line2Text);
                        this.iconElem.setInvisible(true);
                        this.removeElement((VirtualElement)this.iconElem);
                    } else {
                        this.line1Text.setInvisible(false);
                        this.addElement((VirtualElement)this.line1Text);
                        this.line2Text.setInvisible(false);
                        this.addElement((VirtualElement)this.line2Text);
                        this.iconElem.setInvisible(false);
                        this.addElement((VirtualElement)this.iconElem);
                    }
                    if (this.state.hologramVisible) {
                        if (this.state.solveCooldown == 0) {
                            this.removeElement((VirtualElement)this.cdText);
                            this.cdText.setInvisible(true);
                        } else {
                            this.addElement((VirtualElement)this.cdText);
                            this.cdText.setText((class_2561)class_2561.method_43470((String)("On Cooldown - " + (this.state.solveCooldown / 20 + 1) + " Seconds")).method_27692(class_124.field_1075));
                            this.cdText.setInvisible(false);
                        }
                    } else {
                        this.cdText.setInvisible(true);
                        this.removeElement((VirtualElement)this.cdText);
                    }
                }
            };
            line1.setOffset(new class_243(0.0, 1.75, 0.0));
            line2.setOffset(new class_243(0.0, 1.5, 0.0));
            icon.setOffset(new class_243(0.0, 1.0, 0.0));
            cooldownText.setOffset(new class_243(0.0, 0.25, 0.0));
            click.setOffset(new class_243(0.0, 1.0, 0.0));
            line1.setBillboardMode(class_8113.class_8114.field_42407);
            line2.setBillboardMode(class_8113.class_8114.field_42407);
            icon.setBillboardMode(class_8113.class_8114.field_42407);
            cooldownText.setBillboardMode(class_8113.class_8114.field_42407);
            holder.addElement((VirtualElement)line1);
            holder.addElement((VirtualElement)line2);
            holder.addElement((VirtualElement)icon);
            holder.addElement((VirtualElement)click);
            holder.addElement((VirtualElement)cooldownText);
            return holder;
        }

        public void tick() {
            try {
                ++this.ticks;
                if (this.solveCooldown > 0) {
                    --this.solveCooldown;
                    if (this.solveCooldown == 0 && this.state == 1) {
                        this.state = 0;
                    }
                }
                if (this.shieldTicks > 0) {
                    --this.shieldTicks;
                }
                if (this.state == 2) {
                    ++this.animTicks;
                    if (this.player != null && this.player.method_5649(this.pos.field_1352, this.pos.field_1351 + 1.0, this.pos.field_1350) > 25.0) {
                        this.player.method_5859(this.pos.field_1352, this.pos.field_1351 + 1.0, this.pos.field_1350);
                        this.player.method_18800(0.0, 0.0, 0.0);
                        this.player.field_13987.method_14364((class_2596)new class_2743((class_1297)this.player));
                    }
                    if (this.player != null && this.ticks % 5L == 0L) {
                        class_1293 res = new class_1293(class_1294.field_5907, 25, 4, false, true, true);
                        this.player.method_6092(res);
                        this.endWorld.method_65096((class_2394)class_2398.field_11204, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), 5, 0.25, 0.25, 0.25, 0.0);
                    }
                    if (this.animTicks % 150L == 0L) {
                        ArcanaEffectUtils.dragonReclaimTowerCircle(this.endWorld, this.pos.method_1031(0.0, -1.0, 0.0), 8000, 1);
                    }
                }
                if (this.shieldPos != null && this.shieldTicks > 0) {
                    if (this.shieldTicks % 5 == 0) {
                        List entities = this.endWorld.method_8333((class_1297)this.player, new class_238(this.shieldPos.field_1352 + 5.0, this.shieldPos.field_1351 + 5.0, this.shieldPos.field_1350 + 5.0, this.shieldPos.field_1352 - 5.0, this.shieldPos.field_1351 - 5.0, this.shieldPos.field_1350 - 5.0), e -> e instanceof class_1309 && !(e instanceof class_3222));
                        for (class_1297 entity : entities) {
                            if (!(entity instanceof class_1309)) continue;
                            class_1309 living = (class_1309)entity;
                            class_243 vec = new class_243(this.shieldPos.method_10216() - entity.method_23317(), 0.0, this.shieldPos.method_10215() - entity.method_23321());
                            vec = vec.method_1029().method_1021(3.0);
                            living.method_18800(-vec.field_1352, 1.0, -vec.field_1350);
                        }
                    }
                    if (this.shieldTicks % 20 == 0) {
                        List inRangePlayers = this.endWorld.method_18766(p -> p.method_5707(this.shieldPos) <= 25.0);
                        for (class_3222 plyr : inRangePlayers) {
                            class_1293 res = new class_1293(class_1294.field_5907, 105, 0, false, true, true);
                            class_1293 regen = new class_1293(class_1294.field_5924, 105, 2, false, true, true);
                            plyr.method_6092(res);
                            plyr.method_6092(regen);
                        }
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        public void playerSolved() {
            this.state = 2;
            this.player.method_5859(this.pos.field_1352, this.pos.field_1351 + 1.0, this.pos.field_1350);
            this.player.method_18800(0.0, 0.0, 0.0);
            this.player.field_13987.method_14364((class_2596)new class_2743((class_1297)this.player));
            this.hologramVisible = false;
            this.towerGui = new TowerGui(this.player, this);
            this.towerGui.buildGui();
            this.towerGui.open();
            this.animTicks = 0L;
            ArcanaEffectUtils.dragonReclaimTowerCircle(this.endWorld, this.pos.method_1031(0.0, -1.0, 0.0), 8000, 1);
        }

        public void playerExits() {
            this.setSolveCooldown(2400);
            this.state = 1;
            this.hologramVisible = true;
            this.player = null;
        }

        public void fightEnd() {
            if (this.towerGui != null) {
                this.towerGui.close();
            }
            this.hologramVisible = false;
            this.hologram.destroy();
        }

        public void destroyTower() {
            this.towerGui.close();
            List inRangePlayers = this.endWorld.method_18766(p -> p.method_5707(new class_243(this.pos.method_10216() + 0.5, this.pos.method_10214() - 1.0, this.pos.method_10215() + 0.5)) <= 72.25);
            for (class_3222 player : inRangePlayers) {
                class_2338 target = class_2338.method_49637((double)(this.pos.method_10216() + 0.5), (double)(this.pos.method_10214() - 1.0), (double)(this.pos.method_10215() + 0.5));
                class_2338 playerPos = player.method_24515();
                class_243 vec = new class_243((double)(target.method_10263() - playerPos.method_10263()), 0.0, (double)(target.method_10260() - playerPos.method_10260()));
                vec = vec.method_1029().method_1021(5.0);
                player.method_18800(-vec.field_1352, 1.0, -vec.field_1350);
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                player.method_7353((class_2561)class_2561.method_43470((String)"The Tower's Explosion Launches You!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}), true);
            }
            this.endWorld.method_65096((class_2394)class_2398.field_11221, this.pos.method_10216() + 0.5, this.pos.method_10214() - 1.0, this.pos.method_10215() + 0.5, 20, 2.0, 2.0, 2.0, 0.5);
            for (class_2338 block : class_2338.method_25996((class_2338)class_2338.method_49638((class_2374)this.pos), (int)12, (int)12, (int)12)) {
                boolean destroy = true;
                double dist = Math.sqrt(block.method_19770((class_2374)this.pos));
                if (!block.method_19769((class_2374)this.pos, 5.0)) {
                    boolean bl = destroy = Math.random() < -0.01 * ((dist - 5.0) * (dist - 5.0)) + 1.0;
                }
                if (!destroy) continue;
                this.endWorld.method_22352(block, false);
            }
            this.endWorld.method_55117((class_1297)dragon, null, null, this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), 10.0f, true, class_1937.class_7867.field_40888);
            this.hologramVisible = false;
            this.hologram.destroy();
            this.state = 3;
        }

        public void castShield() {
            class_243 end = this.player.method_33571().method_1019(this.player.method_5720().method_1029().method_1021(100.0));
            class_3965 result = this.endWorld.method_17742(new class_3959(this.player.method_33571(), end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.player));
            this.shieldPos = result.method_17784();
            this.shieldTicks = 300;
            ArcanaEffectUtils.dragonReclaimTowerShield(this.endWorld, this.shieldPos, 0);
        }

        public void castLaser() {
            class_243 end = this.player.method_33571().method_1019(this.player.method_5720().method_1029().method_1021(75.0));
            class_3965 result = this.endWorld.method_17742(new class_3959(this.player.method_33571(), end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.player));
            class_243 hit = result.method_17784();
            ArcanaEffectUtils.longDistLine((class_3218)this.endWorld, (class_243)this.player.method_19538().method_1031(0.0, 0.7, 0.0), (class_243)hit, (class_2394)class_2398.field_28479, (int)((int)(2.0 * hit.method_1033())), (int)1, (double)0.1, (double)0.0);
            List entities = this.endWorld.method_8333((class_1297)this.player, new class_238(hit.field_1352 + 2.0, hit.field_1351 + 2.0, hit.field_1350 + 2.0, hit.field_1352 - 2.0, hit.field_1351 - 2.0, hit.field_1350 - 2.0), e -> e instanceof class_1309 && !(e instanceof class_3222));
            class_2995 scoreboard = this.endWorld.method_8503().method_3845();
            class_9014 scoreboardPlayerScore = scoreboard.method_1180(class_9015.method_55420((GameProfile)this.player.method_7334()), scoreboard.method_1170("arcananovum_boss_dmg_dealt"));
            for (class_1297 entity : entities) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                if (scoreboardPlayerScore != null) {
                    scoreboardPlayerScore.method_55410(scoreboardPlayerScore.method_55409() + 50);
                }
                living.method_64397(this.endWorld, this.endWorld.method_48963().method_48802((class_1657)this.player), 5.0f);
            }
            if (MathUtils.distToLine((class_243)dragon.method_19538(), (class_243)this.player.method_19538(), (class_243)hit) < 10.0) {
                float damage = Math.min(100, 15 + numPlayers * 3);
                if (scoreboardPlayerScore != null) {
                    scoreboardPlayerScore.method_55410(scoreboardPlayerScore.method_55409() + (int)(damage * 10.0f));
                }
                dragon.method_64397(this.endWorld, this.endWorld.method_48963().method_48802((class_1657)this.player), damage);
            }
        }

        public class_3222 getPlayer() {
            return this.player;
        }

        public int getSolveCooldown() {
            return this.solveCooldown;
        }

        public int getState() {
            return this.state;
        }

        public class_243 getPos() {
            return this.pos;
        }

        public void setPlayer(class_3222 player) {
            this.player = player;
        }

        public void setSolveCooldown(int solveCooldown) {
            if (this.solveCooldown == 0 && solveCooldown > 0) {
                this.state = 1;
            } else if (this.solveCooldown > 0 && solveCooldown == 0 && this.state == 1) {
                this.state = 0;
            }
            this.solveCooldown = solveCooldown;
        }

        public void setState(int state) {
            this.state = state;
        }
    }
}

