/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.core;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.research.ResearchTask;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10215;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9282;
import net.minecraft.class_9288;
import net.minecraft.class_9290;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArcanaItem
implements Comparable<ArcanaItem> {
    public static final String SYNTHETIC_TAG = "synthetic";
    public static final String CRAFTER_TAG = "crafter";
    public static final String UUID_TAG = "uuid";
    public static final String RARITY_TAG = "Rarity";
    public static final String VERSION_TAG = "Version";
    public static final String ID_TAG = "id";
    public static final String CATALYSTS_TAG = "catalysts";
    public static final String AUGMENTS_TAG = "augments";
    public static final String UNINITIALIZED_TAG = "uninitialized";
    public static final String MODE_TAG = "mode";
    public static final String ACTIVE_TAG = "active";
    public static final String COOLDOWN_TAG = "cooldown";
    protected String name;
    protected String id;
    protected ArcanaRarity rarity;
    protected class_1799 prefItem;
    protected ArcanaRecipe recipe;
    protected TomeGui.TomeFilter[] categories;
    public static final int VERSION = 12;
    public int itemVersion;
    protected class_1792 item;
    protected class_1792 vanillaItem;
    protected class_2561 displayName;
    protected class_5321<ResearchTask>[] researchTasks = new class_5321[0];
    protected class_3545<class_5250, class_5250>[] attributions = new class_3545[0];

    public class_3545<class_5250, class_5250>[] getAttributions() {
        return this.attributions;
    }

    public boolean blocksHandInteractions(class_1799 item) {
        return false;
    }

    public int getItemVersion() {
        return this.itemVersion;
    }

    public String getNameString() {
        return this.name;
    }

    public class_5250 getTranslatedName() {
        return class_2561.method_48321((String)this.item.method_7876(), (String)this.getNameString());
    }

    public String getId() {
        return this.id;
    }

    public ArcanaRarity getRarity() {
        return this.rarity;
    }

    public abstract List<List<class_2561>> getBookLore();

    public ArcanaRecipe getRecipe() {
        return this.recipe;
    }

    public TomeGui.TomeFilter[] getCategories() {
        return this.categories;
    }

    public abstract List<class_2561> getItemLore(@Nullable class_1799 var1);

    public class_5321<ResearchTask>[] getResearchTasks() {
        return this.researchTasks;
    }

    public boolean hasCategory(TomeGui.TomeFilter category) {
        for (TomeGui.TomeFilter tomeFilter : this.categories) {
            if (category != tomeFilter) continue;
            return true;
        }
        return false;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public class_1792 getItem() {
        return this.item;
    }

    public class_1792 getVanillaItem() {
        return this.vanillaItem;
    }

    protected ArcanaItem getThis() {
        return this;
    }

    public class_1799 getPrefItem() {
        return this.prefItem.method_7972();
    }

    public class_1799 getPrefItemNoLore() {
        class_1799 stack = this.prefItem.method_7972();
        stack.method_57381(class_9334.field_49632);
        return stack;
    }

    public static class_2487 getArcanaTag(class_1799 stack) {
        return ArcanaNovum.ITEM_DATA.getDataTag(stack);
    }

    public static int getIntProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getIntProperty(stack, key);
    }

    public static String getStringProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getStringProperty(stack, key);
    }

    public static boolean getBooleanProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getBooleanProperty(stack, key);
    }

    public static double getDoubleProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getDoubleProperty(stack, key);
    }

    public static float getFloatProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getFloatProperty(stack, key);
    }

    public static long getLongProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getLongProperty(stack, key);
    }

    public static class_2499 getListProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getListProperty(stack, key);
    }

    public static class_2487 getCompoundProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.getCompoundProperty(stack, key);
    }

    public static void putProperty(class_1799 stack, String key, int property) {
        ArcanaNovum.ITEM_DATA.putProperty(stack, key, (class_2520)class_2497.method_23247((int)property));
    }

    public static void putProperty(class_1799 stack, String key, boolean property) {
        ArcanaNovum.ITEM_DATA.putProperty(stack, key, (class_2520)class_2481.method_23234((boolean)property));
    }

    public static void putProperty(class_1799 stack, String key, double property) {
        ArcanaNovum.ITEM_DATA.putProperty(stack, key, (class_2520)class_2489.method_23241((double)property));
    }

    public static void putProperty(class_1799 stack, String key, float property) {
        ArcanaNovum.ITEM_DATA.putProperty(stack, key, (class_2520)class_2494.method_23244((float)property));
    }

    public static void putProperty(class_1799 stack, String key, String property) {
        ArcanaNovum.ITEM_DATA.putProperty(stack, key, (class_2520)class_2519.method_23256((String)property));
    }

    public static void putProperty(class_1799 stack, String key, class_2520 property) {
        ArcanaNovum.ITEM_DATA.putProperty(stack, key, property);
    }

    public static boolean hasProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.hasProperty(stack, key);
    }

    public static boolean removeProperty(class_1799 stack, String key) {
        return ArcanaNovum.ITEM_DATA.removeProperty(stack, key);
    }

    public class_1799 getNewItem() {
        class_1799 stack = this.getPrefItem();
        ArcanaItem.putProperty(stack, UUID_TAG, UUID.randomUUID().toString());
        ArcanaItem.removeProperty(stack, UNINITIALIZED_TAG);
        return stack;
    }

    public class_1799 addCrafter(class_1799 stack, String player, boolean synthetic, MinecraftServer server) {
        player = player == null ? "" : player;
        ArcanaItem.putProperty(stack, CRAFTER_TAG, player);
        ArcanaItem.putProperty(stack, SYNTHETIC_TAG, synthetic);
        return this.buildItemLore(stack, server);
    }

    public String getCrafter(class_1799 item) {
        if (!ArcanaItemUtils.isArcane(item)) {
            return null;
        }
        return ArcanaItem.getStringProperty(item, CRAFTER_TAG);
    }

    public boolean isSynthetic(class_1799 item) {
        if (!ArcanaItemUtils.isArcane(item)) {
            return false;
        }
        return ArcanaItem.getBooleanProperty(item, SYNTHETIC_TAG);
    }

    protected void setPrefStack(class_1799 stack) {
        this.prefItem = stack.method_7972();
    }

    public void initializePrefItem() {
        this.prefItem = this.buildItemLore(this.prefItem, ArcanaNovum.SERVER);
    }

    public void finalizePrefItem(MinecraftServer server) {
        this.setRecipe(this.makeRecipe());
    }

    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_9282 dye;
        class_1799 newStack = this.getNewItem();
        String uuid = ArcanaItem.getStringProperty(stack, UUID_TAG);
        if (uuid.isEmpty() || uuid.equals("-") || uuid.equals("00000000-0000-4000-8000-000000000000")) {
            ArcanaItem.putProperty(newStack, UUID_TAG, UUID.randomUUID().toString());
        } else {
            ArcanaItem.putProperty(newStack, UUID_TAG, uuid);
        }
        class_2487 augments = ArcanaItem.getCompoundProperty(stack, AUGMENTS_TAG);
        class_2499 catalysts = ArcanaItem.getListProperty(stack, CATALYSTS_TAG);
        if (!augments.method_33133()) {
            ArcanaItem.putProperty(newStack, AUGMENTS_TAG, (class_2520)augments);
        }
        if (!catalysts.isEmpty()) {
            ArcanaItem.putProperty(newStack, CATALYSTS_TAG, (class_2520)catalysts);
        }
        this.addCrafter(newStack, this.getCrafter(stack), this.isSynthetic(stack), server);
        class_1890.method_57530((class_1799)newStack, (class_9304)stack.method_58657());
        class_8053 trim = (class_8053)stack.method_58694(class_9334.field_49607);
        if (trim != null) {
            newStack.method_57379(class_9334.field_49607, (Object)trim);
        }
        if ((dye = (class_9282)stack.method_58694(class_9334.field_49644)) != null) {
            newStack.method_57379(class_9334.field_49644, (Object)dye);
        }
        if (ArcanaItem.hasProperty(stack, EnhancedStatUtils.ENHANCED_STAT_TAG)) {
            EnhancedStatUtils.enhanceItem(newStack, ArcanaItem.getDoubleProperty(stack, EnhancedStatUtils.ENHANCED_STAT_TAG));
        }
        if (stack.method_57826(class_9334.field_49631)) {
            newStack.method_57379(class_9334.field_49631, (Object)((class_2561)stack.method_58694(class_9334.field_49631)));
        }
        if (stack.method_57826(class_9334.field_49622)) {
            newStack.method_57379(class_9334.field_49622, (Object)((class_9288)stack.method_58694(class_9334.field_49622)));
        }
        return this.buildItemLore(newStack, server);
    }

    public class_1799 initializeArcanaTag(class_1799 stack, boolean creativeMenuItem) {
        ArcanaItem.putProperty(stack, ID_TAG, this.id);
        ArcanaItem.putProperty(stack, RARITY_TAG, ArcanaRarity.getRarityInt(this.rarity));
        ArcanaItem.putProperty(stack, VERSION_TAG, 12 + this.getItemVersion());
        ArcanaItem.putProperty(stack, UUID_TAG, "00000000-0000-4000-8000-000000000000");
        ArcanaItem.putProperty(stack, AUGMENTS_TAG, (class_2520)new class_2487());
        ArcanaItem.putProperty(stack, CATALYSTS_TAG, (class_2520)new class_2499());
        if (creativeMenuItem) {
            ArcanaItem.putProperty(stack, UNINITIALIZED_TAG, true);
        } else {
            ArcanaItem.removeProperty(stack, UNINITIALIZED_TAG);
        }
        if (this.displayName != null) {
            stack.method_57379(class_9334.field_50239, (Object)this.displayName);
        }
        return stack;
    }

    public class_1799 initializeArcanaTag(class_1799 stack) {
        return this.initializeArcanaTag(stack, true);
    }

    public class_1799 onAugment(class_1799 stack, ArcanaAugment augment, int level) {
        return stack;
    }

    public class_1792.class_1793 getArcanaItemComponents() {
        return new class_1792.class_1793().method_7889(1).method_57349(class_9334.field_49632, (Object)new class_9290(this.getItemLore(null))).method_57349(class_9334.field_49641, (Object)true).method_57349(class_9334.field_54273, (Object)new class_10215(ArcanaRegistry.ARCANA_ITEM_IMMUNE_TO)).method_57349(class_9334.field_56400, (Object)ArcanaItem.getTooltipDisplayComponent());
    }

    public class_1792.class_1793 getArcanaArrowItemComponents(int color) {
        return this.getArcanaItemComponents().method_7889(64).method_57349(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.of(color), new ArrayList(), Optional.empty()));
    }

    public class_1792.class_1793 getEquipmentArcanaItemComponents() {
        return this.getArcanaItemComponents().method_7895(8192).method_57349(class_9334.field_49630, (Object)class_3902.field_17274);
    }

    public static String getUUID(class_1799 item) {
        if (!ArcanaItemUtils.isArcane(item)) {
            return null;
        }
        return ArcanaItem.getStringProperty(item, UUID_TAG);
    }

    @Override
    public int compareTo(@NotNull ArcanaItem otherItem) {
        int rarityCompare = this.rarity.rarity - otherItem.rarity.rarity;
        if (rarityCompare == 0) {
            return this.name.compareTo(otherItem.name);
        }
        return rarityCompare;
    }

    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        return this.getNewItem();
    }

    protected void addRunicArrowLore(List<class_5250> loreList) {
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" make use of the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Matrix").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to create ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"unique effects").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" will ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"only ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1062})).method_10852((class_2561)class_2561.method_43470((String)"activate their effect when fired from a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Bow").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" can be refilled inside a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Quiver").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        loreList.add(class_2561.method_43470((String)""));
    }

    protected void addAltarLore(List<class_5250> loreList) {
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altars ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"are ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"multiblock structures").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" that must be ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"built ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"in the world.").method_27692(class_124.field_1078)));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Left click a block").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" with an ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"to see a ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"hologram ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"of the ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"structure").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"completed ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Altar ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"setup to ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"activate ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Altar").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        loreList.add(class_2561.method_43470((String)""));
    }

    protected void addForgeLore(List<class_5250> loreList) {
        loreList.add(class_2561.method_43470((String)""));
        loreList.add(class_2561.method_43470((String)"Forge Structures:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1076}));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Are ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"multiblock structures").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" that must be ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"built").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" in the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"world").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Must ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"be ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"placed ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"within a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"17x11x17").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" cube around a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Starlight Forge").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"completed ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structure").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"use").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" it.").method_27692(class_124.field_1064)));
        loreList.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structure").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to see a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"hologram ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"of the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"structure").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
    }

    public class_1799 buildItemLore(class_1799 item, @Nullable MinecraftServer server) {
        class_2487 augmentTag;
        if (!ArcanaItemUtils.isArcane(item)) {
            return item;
        }
        List<class_2561> loreList = this.getItemLore(item);
        String player = this.getCrafter(item);
        player = player == null ? "" : player;
        boolean synthetic = this.isSynthetic(item);
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
        ArcanaRarity rarity = arcanaItem == null ? ArcanaRarity.MUNDANE : arcanaItem.getRarity();
        loreList.add((class_2561)class_2561.method_43470((String)""));
        if (!player.isBlank() && server != null) {
            String crafterName = server.method_3793().method_14512(AlgoUtils.getUUID((String)player)).orElse(new GameProfile(AlgoUtils.getUUID((String)player), "???")).getName();
            String crafted = synthetic ? "Synthesized by" : (rarity == ArcanaRarity.DIVINE ? "Earned by" : "Crafted by");
            loreList.add((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(crafted + " ")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1064})).method_10852((class_2561)class_2561.method_43470((String)crafterName).method_27692(class_124.field_1076))));
        }
        loreList.add((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852(ArcanaRarity.getColoredLabel(rarity, true)).method_10852((class_2561)class_2561.method_43470((String)" Arcana Item").method_27692(class_124.field_1064))));
        if (EnhancedStatUtils.isEnhanced(item)) {
            loreList.add((class_2561)class_2561.method_43470((String)""));
            double percentile = ArcanaItem.getDoubleProperty(item, EnhancedStatUtils.ENHANCED_STAT_TAG);
            DecimalFormat df = new DecimalFormat("#0.00");
            df.setRoundingMode(RoundingMode.DOWN);
            loreList.add((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Stardust Infusion: ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(df.format(percentile * 100.0) + "%")).method_27692(class_124.field_1065))));
        }
        class_9304 enchantComp = class_1890.method_57532((class_1799)item);
        Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
        enchantComp.method_57539().forEach(entry -> enchants.addTo((Object)((class_6880)entry.getKey()), entry.getIntValue()));
        if (!enchants.isEmpty()) {
            Object optional;
            loreList.add((class_2561)class_2561.method_43470((String)""));
            loreList.add((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Enchantments:").method_27692(class_124.field_1075)));
            class_6885 registryEntryList = null;
            if (server != null && ((Optional)(optional = server.method_30611().method_30530(class_7924.field_41265).method_46733(class_9636.field_51362))).isPresent()) {
                registryEntryList = (class_6885)((Optional)optional).get();
            }
            if (registryEntryList == null) {
                for (Object2IntMap.Entry entry2 : enchants.object2IntEntrySet()) {
                    class_6880 registryEntry = (class_6880)entry2.getKey();
                    int level = entry2.getIntValue();
                    loreList.add((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)class_1887.method_8179((class_6880)registryEntry, (int)level).getString()).method_27692(class_124.field_1078)));
                }
            } else {
                for (int i = 0; i < registryEntryList.method_40247(); ++i) {
                    class_6880 enchantment = registryEntryList.method_40240(i);
                    if (!enchants.containsKey((Object)enchantment)) continue;
                    int level = enchants.getInt((Object)enchantment);
                    loreList.add((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)class_1887.method_8179((class_6880)enchantment, (int)level).getString()).method_27692(class_124.field_1078)));
                }
            }
        }
        if (!(augmentTag = ArcanaItem.getCompoundProperty(item, AUGMENTS_TAG)).method_10541().isEmpty()) {
            loreList.add((class_2561)class_2561.method_43470((String)""));
            loreList.add((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Augmentations:").method_27692(class_124.field_1062)));
            for (String key : augmentTag.method_10541()) {
                ArcanaAugment augment = ArcanaAugments.registry.get(key);
                class_5250 txt = augment.getTranslatedName();
                if (augment.getTiers().length > 1) {
                    txt.method_10852((class_2561)class_2561.method_43470((String)(" " + LevelUtils.intToRoman(augmentTag.method_68083(key, 0)))));
                }
                loreList.add((class_2561)TextUtils.removeItalics((class_5250)txt.method_27692(class_124.field_1078)));
            }
        }
        item.method_57379(class_9334.field_49632, (Object)new class_9290(loreList, loreList));
        return item;
    }

    protected void setRecipe(ArcanaRecipe recipe) {
        this.recipe = recipe;
    }

    protected ArcanaRecipe makeRecipe() {
        return null;
    }

    public static class_10712 getTooltipDisplayComponent() {
        return class_10712.field_56318.method_67215(class_9334.field_49630, true).method_67215(class_9334.field_49633, true).method_67215(class_9334.field_49650, true).method_67215(class_9334.field_49622, true).method_67215(class_9334.field_49636, true).method_67215(class_9334.field_49615, true).method_67215(class_9334.field_49651, true).method_67215(class_9334.field_49620, true).method_67215(class_9334.field_49644, true);
    }
}

