/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.entities;

import eu.pb4.polymer.core.api.entity.PolymerEntity;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.mixins.EntityAccessor;
import net.borisshoes.arcananovum.mixins.ThrownItemEntityAccessor;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1684;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.packettweaker.PacketContext;

public class StasisPearlEntity
extends class_1684
implements PolymerEntity {
    private final class_1799 pearlStack = ArcanaRegistry.STASIS_PEARL.getPrefItem();
    private String itemStackId;
    private int stasisTime;
    private boolean inStasis;
    private class_243 savedVelocity;
    private class_2487 augments;

    public StasisPearlEntity(class_1299<? extends StasisPearlEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public StasisPearlEntity(class_1937 world, class_1309 owner, String itemUuid, class_2487 augments) {
        this(ArcanaRegistry.STASIS_PEARL_ENTITY, world);
        this.method_5814(owner.method_23317(), owner.method_23320() - (double)0.1f, owner.method_23321());
        this.method_7432((class_1297)owner);
        this.itemStackId = itemUuid;
        this.augments = augments;
        this.savedVelocity = this.method_18798();
    }

    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        data.add(new class_2945.class_7834(ThrownItemEntityAccessor.getITEM().comp_2327(), ThrownItemEntityAccessor.getITEM().comp_2328(), (Object)this.pearlStack.method_7972()));
        data.add(new class_2945.class_7834(EntityAccessor.getNO_GRAVITY().comp_2327(), EntityAccessor.getNO_GRAVITY().comp_2328(), (Object)this.inStasis));
    }

    public class_1299<?> getPolymerEntityType(PacketContext context) {
        return class_1299.field_6082;
    }

    public void setStasis(boolean stasis) {
        this.inStasis = stasis;
        ArcanaItem.putProperty(this.pearlStack, "active", stasis);
        ArcanaItem.putProperty(this.pearlStack, "pearlID", stasis ? "-" : "");
        if (this.inStasis) {
            this.savedVelocity = this.method_18798();
            this.method_18800(0.0, 0.0, 0.0);
            this.method_5875(true);
        } else {
            class_1297 class_12972;
            if (this.stasisTime >= 6000 && (class_12972 = this.method_24921()) instanceof class_3222) {
                class_3222 player = (class_3222)class_12972;
                ArcanaAchievements.grant(player, ArcanaAchievements.PEARL_HANG.id);
            }
            this.method_18799(this.savedVelocity);
            this.method_5875(false);
            this.stasisTime = 0;
        }
    }

    public void killNextTick() {
        this.stasisTime = 0x7FFFFFFE;
    }

    public void method_5773() {
        MinecraftServer server;
        super.method_5773();
        if (this.stasisTime > 36000) {
            this.method_31472();
        }
        if (this.inStasis) {
            ++this.stasisTime;
            if (this.method_18798().method_1033() > 0.001) {
                this.method_18800(0.0, 0.0, 0.0);
            }
        }
        if ((server = this.method_5682()) != null) {
            class_1937 class_19372;
            if (server.method_3780() % 20 == 0) {
                this.resyncHolder();
            }
            if ((class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                ArcanaEffectUtils.stasisPearl(serverWorld, this.method_19538());
            }
        }
    }

    public void resyncHolder() {
        class_3222 holder = ArcanaItemUtils.findHolder(this.method_5682(), this.itemStackId);
        if (holder != null && holder.field_13987.method_48106()) {
            this.method_7432((class_1297)holder);
            class_1799 stack = ArcanaItemUtils.getHolderStack(holder, this.itemStackId);
            ArcanaItem.putProperty(stack, "pearlID", this.method_5845());
            ArcanaItem.putProperty(stack, "active", this.inStasis);
        }
    }

    protected void method_7488(class_239 hitResult) {
        if (this.inStasis) {
            return;
        }
        class_3222 holder = null;
        if (this.itemStackId != null && this.method_5682() != null && (holder = ArcanaItemUtils.findHolder(this.method_5682(), this.itemStackId)) != null && holder.field_13987.method_48106() && holder.method_51469() == this.method_37908() && !holder.method_6113()) {
            int reconstructLvl;
            this.method_7432((class_1297)holder);
            if (holder.method_19538().method_1022(this.method_19538()) >= 1000.0) {
                ArcanaAchievements.grant(holder, ArcanaAchievements.INSTANT_TRANSMISSION.id);
            }
            if ((reconstructLvl = this.augments.method_68083(ArcanaAugments.STASIS_RECONSTRUCTION.id, 0)) > 0) {
                class_1293 regen = new class_1293(class_1294.field_5924, 100, reconstructLvl, false, true, true);
                class_1293 resist = new class_1293(class_1294.field_5907, 60, reconstructLvl - 1, false, true, true);
                holder.method_6092(regen);
                holder.method_6092(resist);
                holder.method_51469().method_65096((class_2394)class_2398.field_11211, this.method_23317(), this.method_23318() + (double)(holder.method_17682() / 2.0f), this.method_23321(), 10 * reconstructLvl, 0.5, 0.5, 0.5, 1.0);
            }
        }
        super.method_7488(hitResult);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (this.augments != null) {
            view.method_71468("augments", class_2487.field_25128, (Object)this.augments);
        }
        view.method_71472("inStasis", this.inStasis);
        view.method_71465("stasisTime", this.stasisTime);
        view.method_71469("stackUuid", this.itemStackId);
        view.method_71463("savedDX", this.savedVelocity.field_1352);
        view.method_71463("savedDY", this.savedVelocity.field_1351);
        view.method_71463("savedDZ", this.savedVelocity.field_1350);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.augments = view.method_71426("augments", class_2487.field_25128).orElse(new class_2487());
        this.inStasis = view.method_71433("inStasis", false);
        this.stasisTime = view.method_71424("stasisTime", 0);
        this.itemStackId = view.method_71428("stackUuid", "");
        this.savedVelocity = new class_243(view.method_71422("savedDX", 0.0), view.method_71422("savedDY", 0.0), view.method_71422("savedDZ", 0.0));
    }
}

