/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.CelestialAltarBlockEntity;
import net.borisshoes.arcananovum.blocks.altars.StormcallerAltarBlockEntity;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_9275;
import net.minecraft.class_9334;

public class CelestialAltarGui
extends SimpleGui {
    private final CelestialAltarBlockEntity blockEntity;
    private final boolean control;
    private final int[] lightLvl = new int[]{15, 11, 7, 3, 0, 3, 7, 11};

    public CelestialAltarGui(class_3222 player, CelestialAltarBlockEntity blockEntity) {
        super(class_3917.field_17337, player, false);
        this.blockEntity = blockEntity;
        this.setTitle((class_2561)class_2561.method_43470((String)"Celestial Altar"));
        this.control = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.STELLAR_CONTROL.id) >= 1;
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        int phase = this.blockEntity.getPhase();
        int mode = this.blockEntity.getMode();
        if (index == 2) {
            if (!this.control) {
                this.blockEntity.setPhase(phase == 4 ? 0 : 4);
            } else {
                this.blockEntity.setPhase((phase + 1) % 8);
            }
        } else if (index == 4) {
            class_1937 class_19372;
            if (type == ClickType.MOUSE_RIGHT || type == ClickType.MOUSE_RIGHT_SHIFT) {
                this.blockEntity.setMode((mode + 1) % 2);
            } else if (this.blockEntity.getCooldown() <= 0 && (class_19372 = this.blockEntity.method_10997()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)((class_1792)CelestialAltarBlockEntity.COST.method_15442()), (int)((Integer)CelestialAltarBlockEntity.COST.method_15441()))) {
                    this.blockEntity.startStarChange(this.player);
                    this.close();
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)("You do not have " + String.valueOf(StormcallerAltarBlockEntity.COST.method_15441()) + " ")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)((class_1792)CelestialAltarBlockEntity.COST.method_15442()).method_7876()).method_27695(new class_124[]{class_124.field_1054, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" to power the Altar").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056})), false);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                    this.close();
                }
            } else {
                this.player.method_7353((class_2561)class_2561.method_43470((String)"The Altar is on Cooldown").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                this.close();
            }
        }
        return true;
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled() || this.blockEntity.isActive()) {
            this.close();
        }
        this.build();
    }

    public void build() {
        int phase = this.blockEntity.getPhase();
        int mode = this.blockEntity.getMode();
        for (int i = 0; i < this.getSize(); ++i) {
            this.clearSlot(i);
            GuiElementBuilder menuItem = mode == 0 ? GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)16240911)) : GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)3562157));
            this.setSlot(i, (GuiElementBuilderInterface)menuItem.setName((class_2561)class_2561.method_43470((String)"Celestial Altar").method_27692(mode == 0 ? class_124.field_1054 : class_124.field_1075)));
        }
        GuiElementBuilder cooldownItem = new GuiElementBuilder(class_1802.field_8557).hideDefaultTooltip();
        if (this.blockEntity.getCooldown() <= 0) {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Ready").method_27692(class_124.field_1054)));
        } else {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Recharging").method_27692(class_124.field_1078)));
            cooldownItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.blockEntity.getCooldown() / 20 + " Seconds")).method_27692(class_124.field_1065))));
        }
        this.setSlot(0, (GuiElementBuilderInterface)cooldownItem);
        class_1799 lightItem = new class_1799((class_1935)class_1802.field_30904);
        lightItem.method_57379(class_9334.field_49623, (Object)class_9275.field_49284.method_57420((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(this.lightLvl[phase])));
        GuiElementBuilder phaseItem = GuiElementBuilder.from((class_1799)lightItem).hideDefaultTooltip();
        if (mode == 0) {
            phaseStr = switch (phase) {
                case 0 -> "Zenith";
                case 1 -> "Undern";
                case 2 -> "Twilight";
                case 3 -> "Dusk";
                case 4 -> "Nadir";
                case 5 -> "Witches' Hour";
                case 6 -> "Aurora";
                case 7 -> "Morn";
                default -> "-";
            };
            phaseItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Time of Day").method_27692(class_124.field_1065)));
            phaseItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Selected: " + phaseStr)).method_27692(class_124.field_1054))));
            phaseItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
            phaseItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click to change the time").method_27692(class_124.field_1080))));
        } else {
            phaseStr = switch (phase) {
                case 0 -> "Full Moon";
                case 1 -> "Waning Gibbous";
                case 2 -> "Last Quarter";
                case 3 -> "Waning Crescent";
                case 4 -> "New Moon";
                case 5 -> "Waxing Crescent";
                case 6 -> "First Quarter";
                case 7 -> "Waxing Gibbous";
                default -> "-";
            };
            phaseItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Moon Phase").method_27692(class_124.field_1065)));
            phaseItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Selected: " + phaseStr)).method_27692(class_124.field_1054))));
            phaseItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
            phaseItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click to change the phase").method_27692(class_124.field_1080))));
        }
        this.setSlot(2, (GuiElementBuilderInterface)phaseItem);
        GuiElementBuilder activateItem = new GuiElementBuilder(mode == 0 ? class_1802.field_8801 : class_1802.field_8305);
        activateItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Activate Altar").method_27692(mode == 0 ? class_124.field_1065 : class_124.field_1078)));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click to move the sky").method_27692(class_124.field_1075))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Current Mode: " + (mode == 0 ? "Solar" : "Lunar"))).method_27692(class_124.field_1054))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click to switch modes").method_27692(class_124.field_1063))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("The Altar Requires " + String.valueOf(CelestialAltarBlockEntity.COST.method_15441()) + " ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43471((String)((class_1792)CelestialAltarBlockEntity.COST.method_15442()).method_7876()).method_27692(class_124.field_1075))));
        this.setSlot(4, (GuiElementBuilderInterface)activateItem);
    }

    public void close() {
        super.close();
    }
}

