/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.arcananovum.gui.altars.StarpathTargetGui;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class StarpathAltarChartsGui
extends SimpleGui {
    private final StarpathAltarBlockEntity blockEntity;
    private final SimpleGui returnGui;
    private final Map<String, class_2338> destinationMap;
    private List<class_3545<String, class_2338>> destinations;
    private DestinationSort sort = DestinationSort.ALPHABETICAL;
    private int page = 1;

    public StarpathAltarChartsGui(class_3222 player, SimpleGui returnGui, StarpathAltarBlockEntity blockEntity) {
        super(class_3917.field_17327, player, false);
        this.blockEntity = blockEntity;
        this.returnGui = returnGui;
        this.destinationMap = blockEntity.getSavedTargets();
        this.loadDestinations();
        this.setTitle((class_2561)class_2561.method_43470((String)"Star Charts"));
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean indexInCenter = index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8;
        int numPages = (int)Math.ceil((double)this.destinations.size() / 28.0);
        if (index == 0) {
            boolean backwards = type == ClickType.MOUSE_RIGHT;
            boolean shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
            this.sort = shiftLeft ? DestinationSort.ALPHABETICAL : DestinationSort.cycleSort(this.sort, backwards);
            this.buildGui();
        } else if (index == 45) {
            if (this.page > 1) {
                --this.page;
                this.buildGui();
            }
        } else if (index == 53) {
            if (this.page < numPages) {
                ++this.page;
                this.buildGui();
            }
        } else if (index == 49) {
            AtomicReference newDest = new AtomicReference();
            StarpathTargetGui nameGui = new StarpathTargetGui(this.player, this.blockEntity, false, this, obj -> {
                this.destinationMap.put((String)obj, (class_2338)newDest.get());
                this.buildGui();
            });
            StarpathTargetGui targetGui = new StarpathTargetGui(this.player, this.blockEntity, true, (SimpleGui)nameGui, obj -> newDest.set((class_2338)obj));
            targetGui.open();
        } else if (index == 4) {
            this.close();
        } else if (indexInCenter) {
            int ind = 7 * (index / 9 - 1) + (index % 9 - 1) + 28 * (this.page - 1);
            if (ind >= this.destinations.size()) {
                return true;
            }
            if (type == ClickType.MOUSE_RIGHT) {
                StarpathTargetGui gui = new StarpathTargetGui(this.player, this.blockEntity, false, this, obj -> {
                    String newName = (String)obj;
                    this.destinationMap.remove(this.destinations.get(ind).method_15442());
                    this.destinationMap.put(newName, (class_2338)this.destinations.get(ind).method_15441());
                    this.buildGui();
                });
                gui.open();
            } else if (type == ClickType.MOUSE_LEFT_SHIFT) {
                this.blockEntity.getSavedTargets().remove(this.destinations.get(ind).method_15442());
                this.buildGui();
            } else {
                this.blockEntity.setTargetCoords((class_2338)this.destinations.get(ind).method_15441());
                this.close();
            }
        }
        return true;
    }

    public void loadDestinations() {
        this.destinations = new ArrayList<class_3545<String, class_2338>>();
        for (Map.Entry<String, class_2338> entry : this.destinationMap.entrySet()) {
            this.destinations.add((class_3545<String, class_2338>)new class_3545((Object)entry.getKey(), (Object)entry.getValue()));
        }
        switch (this.sort.ordinal()) {
            case 0: {
                this.destinations.sort(Comparator.comparingInt(pair -> (int)((class_2338)pair.method_15441()).method_10262((class_2382)this.blockEntity.method_11016())));
                break;
            }
            case 1: {
                this.destinations.sort(Comparator.comparingInt(pair -> (int)(-((class_2338)pair.method_15441()).method_10262((class_2382)this.blockEntity.method_11016()))));
                break;
            }
            case 2: {
                this.destinations.sort(Comparator.comparing(class_3545::method_15442));
            }
        }
    }

    public void buildGui() {
        GuiHelper.outlineGUI((SimpleGui)this, (int)1704246, (class_2561)class_2561.method_43470((String)"Saved Locations").method_27692(class_124.field_1078));
        this.loadDestinations();
        int numPages = (int)Math.ceil((double)this.destinations.size() / 28.0);
        GuiElementBuilder labelItem = new GuiElementBuilder(class_1802.field_8449).hideDefaultTooltip();
        labelItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Starpath Altar Destinations").method_27692(class_124.field_1062)));
        labelItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to return to the altar").method_27692(class_124.field_1078))));
        this.setSlot(4, (GuiElementBuilderInterface)labelItem);
        GuiElementBuilder newItem = new GuiElementBuilder(class_1802.field_8674).hideDefaultTooltip();
        newItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"New Destination").method_27692(class_124.field_1062)));
        newItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to add a new destination").method_27692(class_124.field_1078))));
        this.setSlot(49, (GuiElementBuilderInterface)newItem);
        if (numPages > 1) {
            GuiElementBuilder nextArrow = new GuiElementBuilder(class_1802.field_8236).hideDefaultTooltip();
            nextArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Page").method_27692(class_124.field_1065)));
            nextArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + numPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(53, (GuiElementBuilderInterface)nextArrow);
            GuiElementBuilder prevArrow = new GuiElementBuilder(class_1802.field_8236).hideDefaultTooltip();
            prevArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Prev Page").method_27692(class_124.field_1065)));
            prevArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + numPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(45, (GuiElementBuilderInterface)prevArrow);
        }
        GuiElementBuilder sortBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.SORT)).hideDefaultTooltip();
        sortBuilt.setName((class_2561)class_2561.method_43470((String)"Sort Destinations").method_27692(class_124.field_1064));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current sort type.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle sort backwards.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset sort.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sorting By: ").method_27692(class_124.field_1075)).method_10852(DestinationSort.getColoredLabel(this.sort))));
        this.setSlot(0, (GuiElementBuilderInterface)sortBuilt);
        int k = (this.page - 1) * 28;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < this.destinations.size()) {
                    GuiElementBuilder destItem = new GuiElementBuilder(class_1802.field_8204).hideDefaultTooltip();
                    destItem.setName((class_2561)class_2561.method_43470((String)((String)this.destinations.get(k).method_15442())).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)((class_2338)this.destinations.get(k).method_15441()).method_23854()).method_27692(class_124.field_1054)));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to select this destination").method_27692(class_124.field_1078))));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to rename this destination").method_27692(class_124.field_1078))));
                    destItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" to delete this destination").method_27692(class_124.field_1078))));
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)destItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
    }

    public void onTick() {
        class_1937 world;
        if (this.blockEntity != null && ((world = this.blockEntity.method_10997()) == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled() || this.blockEntity.isActive())) {
            this.close();
        }
    }

    public void onClose() {
        if (this.returnGui != null) {
            this.returnGui.open();
        }
    }

    public static enum DestinationSort {
        CLOSEST("Closest"),
        FURTHEST("Furthest"),
        ALPHABETICAL("Alphabetical");

        public final String label;

        private DestinationSort(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(DestinationSort sort) {
            class_5250 text = class_2561.method_43470((String)sort.label);
            return switch (sort.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1076);
                case 1 -> text.method_27692(class_124.field_1064);
                case 2 -> text.method_27692(class_124.field_1060);
            };
        }

        public static DestinationSort cycleSort(DestinationSort sort, boolean backwards) {
            DestinationSort[] sorts = DestinationSort.values();
            int ind = -1;
            for (int i = 0; i < sorts.length; ++i) {
                if (sort != sorts[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= sorts.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = sorts.length - 1;
            }
            return sorts[ind];
        }
    }
}

