/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.arcanetome;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievement;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.altars.TransmutationAltarRecipeGui;
import net.borisshoes.arcananovum.gui.arcanetome.ArcanaItemCompendiumEntry;
import net.borisshoes.arcananovum.gui.arcanetome.CompendiumEntry;
import net.borisshoes.arcananovum.gui.arcanetome.IngredientCompendiumEntry;
import net.borisshoes.arcananovum.gui.arcanetome.LoreGui;
import net.borisshoes.arcananovum.gui.arcanetome.TransmutationRecipesCompendiumEntry;
import net.borisshoes.arcananovum.gui.twilightanvil.TwilightAnvilGui;
import net.borisshoes.arcananovum.items.ArcaneTome;
import net.borisshoes.arcananovum.items.normal.ArcaneNotesItem;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ExplainIngredient;
import net.borisshoes.arcananovum.research.ResearchTask;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5285;
import net.minecraft.class_6880;
import net.minecraft.class_7417;

public class TomeGui
extends SimpleGui {
    private TomeMode mode;
    private ArcaneTome tome;
    private CompendiumSettings settings;
    public static final int[][] DYNAMIC_SLOTS = new int[][]{new int[0], {3}, {1, 5}, {1, 3, 5}, {0, 2, 4, 6}, {1, 2, 3, 4, 5}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};
    public static final int[] CRAFTING_SLOTS = new int[]{1, 2, 3, 4, 5, 10, 11, 12, 13, 14, 19, 20, 21, 22, 23, 28, 29, 30, 31, 32, 37, 38, 39, 40, 41};
    private ArcanaRecipe selectedRecipe;
    private boolean permaCloseFlag = false;

    public TomeGui(class_3917<?> type, class_3222 player, TomeMode mode, ArcaneTome tome, CompendiumSettings settings) {
        super(type, player, false);
        this.mode = mode;
        this.tome = tome;
        this.settings = settings;
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        if (this.mode == TomeMode.PROFILE) {
            if (index == 49) {
                this.tome.openGui((class_1657)this.player, TomeMode.COMPENDIUM, this.settings);
            } else if (index == 4) {
                BookElementBuilder bookBuilder = TomeGui.getGuideBook();
                LoreGui loreGui = new LoreGui(this.player, bookBuilder, this.tome, TomeMode.PROFILE, this.settings);
                loreGui.open();
            } else if (index == 10) {
                this.tome.openGui((class_1657)this.player, TomeMode.LEADERBOARD, this.settings);
            } else if (index == 19) {
                this.tome.openGui((class_1657)this.player, TomeMode.ACHIEVEMENTS, this.settings);
            }
        } else {
            boolean indexInCenter;
            boolean bl = indexInCenter = index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8;
            if (this.mode == TomeMode.COMPENDIUM) {
                if (index == 4) {
                    this.buildProfileGui(this.player);
                } else if (indexInCenter) {
                    List<CompendiumEntry> items = TomeGui.sortedFilteredEntryList(this.settings, this.player);
                    int ind = 7 * (index / 9 - 1) + (index % 9 - 1) + 28 * (this.settings.getPage() - 1);
                    if (ind >= items.size()) {
                        return true;
                    }
                    CompendiumEntry entry2 = items.get(ind);
                    if (entry2 instanceof ArcanaItemCompendiumEntry) {
                        ArcanaItemCompendiumEntry arcanaEntry = (ArcanaItemCompendiumEntry)entry2;
                        ArcanaItem arcanaItem = arcanaEntry.getArcanaItem();
                        if (!ArcanaNovum.data((class_1657)this.player).hasResearched(arcanaItem)) {
                            this.tome.openResearchGui(this.player, this.settings, arcanaItem.getId());
                        } else if (type == ClickType.MOUSE_RIGHT) {
                            if (arcanaItem.getRecipe() != null) {
                                this.tome.openRecipeGui(this.player, this.settings, arcanaItem);
                            } else {
                                this.player.method_7353((class_2561)class_2561.method_43470((String)"You Cannot Craft This Item").method_27692(class_124.field_1061), false);
                            }
                        } else {
                            this.tome.openItemGui(this.player, this.settings, arcanaItem.getId());
                        }
                    } else if (entry2 instanceof IngredientCompendiumEntry) {
                        IngredientCompendiumEntry ingredientEntry = (IngredientCompendiumEntry)entry2;
                        this.tome.openRecipeGui(this.player, this.settings, (class_2561)ingredientEntry.getName(), ingredientEntry.getRecipe(), ingredientEntry.getDisplayStack());
                    } else if (entry2 instanceof TransmutationRecipesCompendiumEntry) {
                        TransmutationAltarRecipeGui transmutationGui = new TransmutationAltarRecipeGui(this.player, this, Optional.empty());
                        transmutationGui.buildRecipeListGui();
                        transmutationGui.open();
                    }
                } else if (index == 0) {
                    boolean shiftLeft;
                    boolean backwards = type == ClickType.MOUSE_RIGHT;
                    boolean bl2 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                    if (shiftLeft) {
                        this.settings.setSortType(TomeSort.RECOMMENDED);
                    } else {
                        this.settings.setSortType(TomeSort.cycleSort(this.settings.getSortType(), backwards));
                    }
                    TomeGui.buildCompendiumGui(this, this.player, this.settings);
                } else if (index == 8) {
                    boolean shiftLeft;
                    boolean backwards = type == ClickType.MOUSE_RIGHT;
                    boolean bl3 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                    if (shiftLeft) {
                        this.settings.setFilterType(TomeFilter.NONE);
                    } else {
                        this.settings.setFilterType(TomeFilter.cycleFilter(this.settings.getFilterType(), backwards));
                    }
                    List<CompendiumEntry> items = TomeGui.sortedFilteredEntryList(this.settings, this.player);
                    int numPages = (int)Math.ceil((double)items.size() / 28.0);
                    if (this.settings.getPage() > numPages) {
                        this.settings.setPage(numPages);
                    }
                    TomeGui.buildCompendiumGui(this, this.player, this.settings);
                } else if (index == 45) {
                    if (this.settings.getPage() > 1) {
                        this.settings.setPage(this.settings.getPage() - 1);
                        TomeGui.buildCompendiumGui(this, this.player, this.settings);
                    }
                } else if (index == 53) {
                    List<CompendiumEntry> items = TomeGui.sortedFilteredEntryList(this.settings, this.player);
                    int numPages = (int)Math.ceil((double)items.size() / 28.0);
                    if (this.settings.getPage() < numPages) {
                        this.settings.setPage(this.settings.getPage() + 1);
                        TomeGui.buildCompendiumGui(this, this.player, this.settings);
                    }
                }
            } else if (this.mode == TomeMode.ACHIEVEMENTS) {
                if (index == 4) {
                    if (type == ClickType.MOUSE_RIGHT) {
                        this.tome.openGui((class_1657)this.player, TomeMode.COMPENDIUM, this.settings);
                    } else {
                        this.buildProfileGui(this.player);
                    }
                } else if (indexInCenter) {
                    String itemId;
                    ArcanaItem arcanaItem;
                    class_1799 item = this.getSlot(index).getItemStack();
                    if (!item.method_7960() && (arcanaItem = ArcanaItemUtils.getItemFromId(itemId = ArcanaItem.getStringProperty(item, "arcanaItemId"))) != null) {
                        if (ArcanaNovum.data((class_1657)this.player).hasResearched(arcanaItem)) {
                            this.tome.openItemGui(this.player, this.settings, itemId);
                        } else {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"You Have Not Researched This Item").method_27692(class_124.field_1061), false);
                        }
                    }
                } else if (index == 0) {
                    boolean shiftLeft;
                    boolean backwards = type == ClickType.MOUSE_RIGHT;
                    boolean bl4 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                    if (shiftLeft) {
                        this.settings.setSortType(AchievementSort.RECOMMENDED);
                    } else {
                        this.settings.setSortType(AchievementSort.cycleSort(this.settings.getAchSortType(), backwards));
                    }
                    this.buildAchievementsGui(this.player, this.settings);
                } else if (index == 8) {
                    boolean shiftLeft;
                    boolean backwards = type == ClickType.MOUSE_RIGHT;
                    boolean bl5 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                    if (shiftLeft) {
                        this.settings.setFilterType(AchievementFilter.NONE);
                    } else {
                        this.settings.setFilterType(AchievementFilter.cycleFilter(this.settings.getAchFilterType(), backwards));
                    }
                    List<ArcanaAchievement> achs = TomeGui.sortedFilteredAchievementList(this.player, this.settings);
                    int numPages = (int)Math.ceil((double)achs.size() / 28.0);
                    if (this.settings.getAchPage() > numPages) {
                        this.settings.setAchPage(numPages);
                    }
                    this.buildAchievementsGui(this.player, this.settings);
                } else if (index == 45) {
                    if (this.settings.getAchPage() > 1) {
                        this.settings.setAchPage(this.settings.getAchPage() - 1);
                        this.buildAchievementsGui(this.player, this.settings);
                    }
                } else if (index == 53) {
                    List<ArcanaAchievement> achs = TomeGui.sortedFilteredAchievementList(this.player, this.settings);
                    int numPages = (int)Math.ceil((double)achs.size() / 28.0);
                    if (this.settings.getAchPage() < numPages) {
                        this.settings.setAchPage(this.settings.getAchPage() + 1);
                        this.buildAchievementsGui(this.player, this.settings);
                    }
                }
            } else if (this.mode == TomeMode.LEADERBOARD) {
                if (index == 4) {
                    this.buildProfileGui(this.player);
                } else if (index == 0) {
                    boolean shiftLeft;
                    boolean backwards = type == ClickType.MOUSE_RIGHT;
                    boolean bl6 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                    if (shiftLeft) {
                        this.settings.setLeaderSortType(LeaderboardSort.XP_DESC);
                    } else {
                        this.settings.setLeaderSortType(LeaderboardSort.cycleSort(this.settings.getLeaderSortType(), backwards));
                    }
                    this.buildLeaderboardGui(this.player, this.settings);
                } else if (index == 8) {
                    boolean shiftLeft;
                    boolean backwards = type == ClickType.MOUSE_RIGHT;
                    boolean bl7 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                    if (shiftLeft) {
                        this.settings.setLeaderFilterType(LeaderboardFilter.NONE);
                    } else {
                        this.settings.setLeaderFilterType(LeaderboardFilter.cycleFilter(this.settings.getLeaderFilterType(), backwards));
                    }
                    List<UUID> players = TomeGui.sortedFilteredLeaderboardList(this.settings);
                    int numPages = (int)Math.ceil((double)players.size() / 28.0);
                    if (this.settings.getLeaderboardPage() > numPages) {
                        this.settings.setLeaderboardPage(Math.max(1, numPages));
                    }
                    this.buildLeaderboardGui(this.player, this.settings);
                } else if (index == 45) {
                    if (this.settings.getLeaderboardPage() > 1) {
                        this.settings.setLeaderboardPage(this.settings.getLeaderboardPage() - 1);
                        this.buildLeaderboardGui(this.player, this.settings);
                    }
                } else if (index == 53) {
                    List<UUID> players = TomeGui.sortedFilteredLeaderboardList(this.settings);
                    int numPages = (int)Math.ceil((double)players.size() / 28.0);
                    if (this.settings.getLeaderboardPage() < numPages) {
                        this.settings.setLeaderboardPage(this.settings.getLeaderboardPage() + 1);
                        this.buildLeaderboardGui(this.player, this.settings);
                    }
                }
            } else if (this.mode == TomeMode.RECIPE) {
                class_1799 ingredStack;
                ArcanaItem arcanaItem1;
                class_1799 item = this.getSlot(25).getItemStack();
                if (index == 7) {
                    ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
                    if (arcanaItem != null) {
                        List<List<class_2561>> loreData = arcanaItem.getBookLore();
                        if (loreData != null) {
                            BookElementBuilder bookBuilder = new BookElementBuilder();
                            loreData.forEach(list -> bookBuilder.addPage(list.toArray(new class_2561[0])));
                            LoreGui loreGui = new LoreGui(this.player, bookBuilder, this.tome, TomeMode.RECIPE, this.settings, arcanaItem.getId());
                            loreGui.open();
                        } else {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"No Lore Found For That Item").method_27692(class_124.field_1061), false);
                        }
                    }
                } else if (index == 25 || index == 26) {
                    this.tome.openGui((class_1657)this.player, TomeMode.COMPENDIUM, this.settings);
                } else if (index == 43) {
                    if (this.selectedRecipe != null) {
                        StringBuilder copyString = new StringBuilder();
                        HashMap<String, class_3545<Integer, class_1799>> ingredList = this.selectedRecipe.getIngredientList();
                        for (Map.Entry<String, class_3545<Integer, class_1799>> ingred : ingredList.entrySet()) {
                            copyString.append(TomeGui.getIngredStr(ingred).getString()).append("\n");
                        }
                        this.player.method_64398((class_2561)class_2561.method_43471((String)"text.arcananovum.materials_copy_message").method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"text.arcananovum.materials_copy_message"))).method_10958((class_2558)new class_2558.class_10606(copyString.toString()))));
                        this.permaCloseFlag = true;
                        this.close();
                    }
                } else if (index > 9 && index < 36 && (index % 9 == 1 || index % 9 == 2 || index % 9 == 3 || index % 9 == 4 || index % 9 == 5) && (arcanaItem1 = ArcanaItemUtils.identifyItem(ingredStack = this.getSlot(index).getItemStack())) != null) {
                    this.tome.openRecipeGui(this.player, this.settings, arcanaItem1);
                }
            } else if (this.mode == TomeMode.ITEM) {
                class_1799 item = this.getSlot(4).getItemStack();
                ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
                if (index == 0) {
                    if (arcanaItem instanceof MultiblockCore) {
                        MultiblockCore multicore = (MultiblockCore)((Object)arcanaItem);
                        if (type == ClickType.MOUSE_RIGHT) {
                            LinkedHashMap mbMats = new LinkedHashMap();
                            StringBuilder copyString = new StringBuilder();
                            multicore.getMultiblock().getMaterialList().entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(entry -> mbMats.put((class_1792)entry.getKey(), (Integer)entry.getValue()));
                            for (Map.Entry entry3 : mbMats.entrySet()) {
                                class_1792 matItem = (class_1792)entry3.getKey();
                                int num = (Integer)entry3.getValue();
                                int stacks = num / matItem.method_7882();
                                int rem = num % matItem.method_7882();
                                copyString.append(matItem.method_63680().getString()).append(" - ").append(num);
                                if (num > matItem.method_7882()) {
                                    copyString.append(" - ");
                                    if (rem > 0) {
                                        copyString.append("(").append(stacks).append(" Stacks + ").append(rem).append(")");
                                    } else {
                                        copyString.append("(").append(stacks).append(" Stacks)");
                                    }
                                }
                                copyString.append("\n");
                            }
                            this.player.method_64398((class_2561)class_2561.method_43471((String)"text.arcananovum.materials_copy_message").method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"text.arcananovum.materials_copy_message"))).method_10958((class_2558)new class_2558.class_10606(copyString.toString()))));
                            this.permaCloseFlag = true;
                            this.close();
                        } else {
                            multicore.getMultiblock().displayStructure(new Multiblock.MultiblockCheck(this.player.method_51469(), this.player.method_24515(), this.player.method_51469().method_8320(this.player.method_24515()), new class_2338(multicore.getCheckOffset()), null), this.player);
                            this.permaCloseFlag = true;
                            this.close();
                        }
                    }
                } else if (index == 2) {
                    if (arcanaItem.getRecipe() != null) {
                        this.tome.openRecipeGui(this.player, this.settings, arcanaItem);
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You Cannot Craft This Item").method_27692(class_124.field_1061), false);
                    }
                } else if (index == 4) {
                    this.tome.openGui((class_1657)this.player, TomeMode.COMPENDIUM, this.settings);
                } else if (index == 6) {
                    List<List<class_2561>> loreData = arcanaItem.getBookLore();
                    if (loreData != null) {
                        BookElementBuilder bookBuilder = new BookElementBuilder();
                        loreData.forEach(list -> bookBuilder.addPage(list.toArray(new class_2561[0])));
                        LoreGui loreGui = new LoreGui(this.player, bookBuilder, this.tome, TomeMode.ITEM, this.settings, arcanaItem.getId());
                        loreGui.open();
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"No Lore Found For That Item").method_27692(class_124.field_1061), false);
                    }
                } else if (index == 8) {
                    if (type == ClickType.MOUSE_RIGHT) {
                        this.tome.openResearchGui(this.player, this.settings, arcanaItem.getId());
                    } else {
                        int cost;
                        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.player);
                        ArcanaRarity rarity = arcanaItem.getRarity();
                        class_1792 paperType = ArcanaRarity.getArcanePaper(rarity);
                        if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)paperType, (int)(cost = profile.getArcanePaperRequirement(rarity)))) {
                            class_1799 newNotes = new class_1799((class_1935)ArcanaRegistry.ARCANE_NOTES);
                            ArcanaItem.putProperty(newNotes, "research_id", arcanaItem.getId());
                            ArcanaItem.putProperty(newNotes, "paper_cost", cost);
                            ArcanaItem.putProperty(newNotes, "author", this.player.method_7334().getName());
                            ArcaneNotesItem.buildLore(newNotes);
                            MinecraftUtils.returnItems((class_1263)new class_1277(new class_1799[]{newNotes}), (class_1657)this.player);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_17481, (float)2.0f, (float)0.75f);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_17484, (float)2.0f, (float)0.9f);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15119, (float)1.0f, (float)2.0f);
                        } else {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)paperType.method_7876()).method_27695(new class_124[]{class_124.field_1056, ArcanaRarity.getColor(rarity)})), false);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                        }
                    }
                } else if (index >= 28 && index <= 35) {
                    List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
                    int[] augmentSlots = DYNAMIC_SLOTS[augments.size()];
                    ArcanaAugment augment = null;
                    for (int i = 0; i < augmentSlots.length; ++i) {
                        if (index != 28 + augmentSlots[i]) continue;
                        augment = augments.get(i);
                        break;
                    }
                    if (augment != null) {
                        ArcanaRarity[] tiers;
                        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.player);
                        int augmentLvl = profile.getAugmentLevel(augment.id);
                        if (augmentLvl >= (tiers = augment.getTiers()).length) {
                            return true;
                        }
                        int cost = tiers[augmentLvl].rarity + 1;
                        int unallocated = profile.getTotalSkillPoints() - profile.getSpentSkillPoints();
                        if (cost <= unallocated) {
                            profile.setAugmentLevel(augment.id, augmentLvl + 1);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_6880.class_6883)class_3417.field_14622, (float)1.0f, (float)(0.5f + (float)(augmentLvl + 1) / (float)(tiers.length - 1)));
                            this.tome.openItemGui(this.player, this.settings, arcanaItem.getId());
                        } else {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"Not Enough Skill Points").method_27692(class_124.field_1061), false);
                        }
                    }
                }
            } else if (this.mode == TomeMode.RESEARCH) {
                class_1799 item = this.getSlot(4).getItemStack();
                ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
                if (index == 4) {
                    this.tome.openGui((class_1657)this.player, TomeMode.COMPENDIUM, this.settings);
                } else if (index == 8) {
                    this.settings.setHideCompletedResearch(!this.settings.hideCompletedResearch());
                    List<Object> tasks = ResearchTasks.getUniqueTasks(arcanaItem.getResearchTasks()).stream().toList();
                    if (this.settings.hideCompletedResearch()) {
                        tasks = tasks.stream().filter(task -> !task.isAcquired(this.player)).toList();
                    }
                    int numPages = Math.max(1, (int)Math.ceil((double)tasks.size() / 28.0));
                    if (this.settings.getResearchPage() > numPages) {
                        this.settings.setResearchPage(numPages);
                    }
                    this.buildResearchGui(this.player, this.settings, arcanaItem.getId());
                } else if (index == 45) {
                    if (this.settings.getResearchPage() > 1) {
                        this.settings.setResearchPage(this.settings.getResearchPage() - 1);
                        this.buildResearchGui(this.player, this.settings, arcanaItem.getId());
                    }
                } else if (index == 53) {
                    List<Object> tasks = ResearchTasks.getUniqueTasks(arcanaItem.getResearchTasks()).stream().toList();
                    if (this.settings.hideCompletedResearch()) {
                        tasks = tasks.stream().filter(task -> !task.isAcquired(this.player)).toList();
                    }
                    int numPages = (int)Math.ceil((double)tasks.size() / 28.0);
                    if (this.settings.getResearchPage() < numPages) {
                        this.settings.setResearchPage(this.settings.getResearchPage() + 1);
                        this.buildResearchGui(this.player, this.settings, arcanaItem.getId());
                    }
                } else if (index == 49) {
                    List tasks = ResearchTasks.getUniqueTasks(arcanaItem.getResearchTasks()).stream().toList();
                    IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.player);
                    ArcanaRarity rarity = arcanaItem.getRarity();
                    boolean allAcquired = tasks.stream().allMatch(task -> task.isAcquired(this.player));
                    class_1792 paperType = ArcanaRarity.getArcanePaper(rarity);
                    int cost = profile.getArcanePaperRequirement(rarity);
                    if (allAcquired) {
                        if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)paperType, (int)cost)) {
                            class_1799 newNotes = new class_1799((class_1935)ArcanaRegistry.ARCANE_NOTES);
                            ArcanaItem.putProperty(newNotes, "research_id", arcanaItem.getId());
                            ArcanaItem.putProperty(newNotes, "paper_cost", cost);
                            ArcanaItem.putProperty(newNotes, "author", this.player.method_7334().getName());
                            ArcaneNotesItem.buildLore(newNotes);
                            MinecraftUtils.returnItems((class_1263)new class_1277(new class_1799[]{newNotes}), (class_1657)this.player);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_17481, (float)2.0f, (float)0.75f);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_17484, (float)2.0f, (float)0.9f);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15119, (float)1.0f, (float)2.0f);
                        } else {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)paperType.method_7876()).method_27695(new class_124[]{class_124.field_1056, ArcanaRarity.getColor(rarity)})), false);
                            SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                        }
                    }
                }
            }
        }
        return true;
    }

    public void buildProfileGui(class_3222 player) {
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        this.setMode(TomeMode.PROFILE);
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        this.setSlot(27, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(35, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        GameProfile gameProfile = player.method_7334();
        GuiElementBuilder head = new GuiElementBuilder(class_1802.field_8575).setSkullOwner(gameProfile, player.method_5682());
        head.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(player.method_5820() + "'s ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"Arcane Profile").method_27692(class_124.field_1064)));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" for a brief overview of Arcana Novum!").method_27692(class_124.field_1076))));
        this.setSlot(4, (GuiElementBuilderInterface)head);
        GuiElementBuilder book = new GuiElementBuilder(class_1802.field_8360);
        book.setName((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064));
        book.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"to go to the Arcana Items Page").method_27692(class_124.field_1076))));
        this.setSlot(49, (GuiElementBuilderInterface)book);
        int level = profile.getLevel();
        String readableXP = LevelUtils.readableInt(LevelUtils.getCurLevelXp(profile.getXP()));
        GuiElementBuilder lectern = new GuiElementBuilder(class_1802.field_16312);
        lectern.setName((class_2561)class_2561.method_43470((String)"Arcana Level").method_27692(class_124.field_1077));
        lectern.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Arcana Level: " + level)).method_27692(class_124.field_1060)));
        if (level == 100) {
            lectern.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Total Experience: " + LevelUtils.readableInt(profile.getXP()))).method_27692(class_124.field_1060)));
        } else {
            lectern.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Experience: " + readableXP + "/" + LevelUtils.readableInt(LevelUtils.nextLevelNewXp(level)))).method_27692(class_124.field_1060)));
        }
        lectern.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        lectern.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"You can increase your arcana by crafting and using Arcana items!").method_27692(class_124.field_1076)));
        lectern.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        lectern.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to see the Leaderboard").method_27692(class_124.field_1062))));
        this.setSlot(10, (GuiElementBuilderInterface)lectern);
        if (level == 100) {
            for (int i = 11; i <= 16; ++i) {
                this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8287).setName((class_2561)class_2561.method_43470((String)("XP: " + LevelUtils.readableInt(profile.getXP()))).method_27692(class_124.field_1060)));
            }
        } else {
            int filled = (int)Math.round((double)LevelUtils.getCurLevelXp(profile.getXP()) / (double)LevelUtils.nextLevelNewXp(profile.getLevel()) * 6.0);
            for (int i = 11; i <= 16; ++i) {
                if (i >= filled + 11) {
                    this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8469).setName((class_2561)class_2561.method_43470((String)("XP: " + readableXP + "/" + LevelUtils.readableInt(LevelUtils.nextLevelNewXp(profile.getLevel())))).method_27692(class_124.field_1060)));
                    continue;
                }
                this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8287).setName((class_2561)class_2561.method_43470((String)("XP: " + readableXP + "/" + LevelUtils.readableInt(LevelUtils.nextLevelNewXp(profile.getLevel())))).method_27692(class_124.field_1060)));
            }
        }
        int totalSkillPoints = profile.getTotalSkillPoints();
        int spentSkillPoints = profile.getSpentSkillPoints();
        int bonusSkillPoints = profile.getBonusSkillPoints();
        GuiElementBuilder shelf = new GuiElementBuilder(class_1802.field_8536);
        shelf.setName((class_2561)class_2561.method_43470((String)"Skill Points").method_27692(class_124.field_1062));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Total Skill Points: " + totalSkillPoints)).method_27692(class_124.field_1075)));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Available Points: " + (totalSkillPoints - spentSkillPoints))).method_27692(class_124.field_1075)));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Points From Leveling: " + LevelUtils.getLevelSkillPoints(level))).method_27692(class_124.field_1078)));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Points From Achievements: " + profile.getAchievementSkillPoints())).method_27692(class_124.field_1078)));
        if (bonusSkillPoints != 0) {
            shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Bonus Skill Points: " + bonusSkillPoints)).method_27692(class_124.field_1078)));
        }
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Allocate Skill Points to Augment Items!").method_27692(class_124.field_1064)));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Earn Skill Points From Leveling Up or From Achievements!").method_27692(class_124.field_1076)));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        shelf.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" to see all Achievements").method_27692(class_124.field_1076))));
        this.setSlot(19, (GuiElementBuilderInterface)shelf);
        int books = (int)((double)spentSkillPoints / (double)totalSkillPoints * 6.0);
        for (int i = 20; i <= 25; ++i) {
            if (i >= books + 20) {
                this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8529).setName((class_2561)class_2561.method_43470((String)("Allocated Skill Points: " + spentSkillPoints + "/" + totalSkillPoints)).method_27692(class_124.field_1062)));
                continue;
            }
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8598).setName((class_2561)class_2561.method_43470((String)("Allocated Skill Points: " + spentSkillPoints + "/" + totalSkillPoints)).method_27692(class_124.field_1062)));
        }
        int resolve = profile.getAugmentLevel(ArcanaAugments.RESOLVE.id);
        int maxConc = LevelUtils.concFromLevel(profile.getLevel(), resolve);
        GuiElementBuilder crystal = new GuiElementBuilder(class_1802.field_8301);
        crystal.setName((class_2561)class_2561.method_43470((String)"Arcane Concentration").method_27692(class_124.field_1078));
        crystal.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Concentration: " + ArcanaItemUtils.getUsedConcentration(player) + "/" + maxConc)).method_27692(class_124.field_1075)));
        crystal.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        crystal.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Your max concentration increases with your level!").method_27692(class_124.field_1076)));
        List<class_5250> concBreakdown = ArcanaItemUtils.getConcBreakdown(player);
        if (!concBreakdown.isEmpty()) {
            crystal.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
            crystal.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Items Taking Concentration:").method_27692(class_124.field_1062)));
            for (class_5250 item : concBreakdown) {
                crystal.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)item));
            }
        }
        this.setSlot(37, (GuiElementBuilderInterface)crystal);
        int used = (int)Math.ceil((double)ArcanaItemUtils.getUsedConcentration(player) / (double)maxConc * 6.0);
        boolean overConc = ArcanaItemUtils.getUsedConcentration(player) > maxConc;
        for (int i = 38; i <= 43; ++i) {
            if (overConc) {
                this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8814).setName((class_2561)class_2561.method_43470((String)("Concentration: " + ArcanaItemUtils.getUsedConcentration(player) + "/" + maxConc)).method_27692(class_124.field_1061)));
                continue;
            }
            if (i >= used + 38) {
                this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8777).setName((class_2561)class_2561.method_43470((String)("Concentration: " + ArcanaItemUtils.getUsedConcentration(player) + "/" + maxConc)).method_27692(class_124.field_1075)));
                continue;
            }
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8135).setName((class_2561)class_2561.method_43470((String)("Concentration: " + ArcanaItemUtils.getUsedConcentration(player) + "/" + maxConc)).method_27692(class_124.field_1075)));
        }
        this.setTitle((class_2561)class_2561.method_43470((String)"Arcane Profile"));
    }

    public static void buildCompendiumGui(SimpleGui gui, class_3222 player, CompendiumSettings settings) {
        List<CompendiumEntry> items = TomeGui.sortedFilteredEntryList(settings, player);
        if (gui instanceof TomeGui) {
            TomeGui tomeGui = (TomeGui)gui;
            tomeGui.setMode(TomeMode.COMPENDIUM);
        } else {
            items = items.stream().filter(entry -> entry instanceof ArcanaItemCompendiumEntry).toList();
        }
        int numPages = (int)Math.ceil((double)items.size() / 28.0);
        settings.setPage(class_3532.method_15340((int)settings.getPage(), (int)1, (int)Math.max(1, numPages)));
        List pageItems = AlgoUtils.listToPage(items, (int)settings.getPage(), (int)28);
        GuiHelper.outlineGUI((SimpleGui)gui, (int)7996617, (class_2561)class_2561.method_43473());
        GameProfile gameProfile = player.method_7334();
        GuiElementBuilder head = new GuiElementBuilder(class_1802.field_8575).setSkullOwner(gameProfile, player.method_5682());
        head.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)));
        if (gui instanceof TomeGui) {
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click here").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to return to the Profile Page").method_27692(class_124.field_1076))));
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click an item").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to view its page or research").method_27692(class_124.field_1076))));
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click an item").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to see its recipe or research").method_27692(class_124.field_1076))));
        } else {
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click an item").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to see its recipe").method_27692(class_124.field_1076))));
        }
        gui.setSlot(4, (GuiElementBuilderInterface)head);
        GuiElementBuilder filterBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.FILTER)).hideDefaultTooltip();
        filterBuilt.setName((class_2561)class_2561.method_43470((String)"Filter Arcana Items").method_27692(class_124.field_1064));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle filter backwards.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Current Filter: ").method_27692(class_124.field_1075)).method_10852(TomeFilter.getColoredLabel(settings.getFilterType()))));
        gui.setSlot(8, (GuiElementBuilderInterface)filterBuilt);
        GuiElementBuilder sortBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.SORT)).hideDefaultTooltip();
        sortBuilt.setName((class_2561)class_2561.method_43470((String)"Sort Arcana Items").method_27692(class_124.field_1064));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current sort type.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle sort backwards.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset sort.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sorting By: ").method_27692(class_124.field_1075)).method_10852(TomeSort.getColoredLabel(settings.getSortType()))));
        gui.setSlot(0, (GuiElementBuilderInterface)sortBuilt);
        if (numPages > 1) {
            GuiElementBuilder nextPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW)).hideDefaultTooltip();
            nextPage.setName((class_2561)class_2561.method_43470((String)("Next Page (" + settings.getPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            nextPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Next Page").method_27692(class_124.field_1076))));
            gui.setSlot(53, (GuiElementBuilderInterface)nextPage);
            GuiElementBuilder prevPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW)).hideDefaultTooltip();
            prevPage.setName((class_2561)class_2561.method_43470((String)("Previous Page (" + settings.getPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            prevPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Previous Page").method_27692(class_124.field_1076))));
            gui.setSlot(45, (GuiElementBuilderInterface)prevPage);
        }
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < pageItems.size()) {
                    gui.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)((CompendiumEntry)pageItems.get(k)).getDisplayStack()).glow());
                } else {
                    gui.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
        gui.setTitle((class_2561)class_2561.method_43470((String)"Item Compendium"));
    }

    public void buildAchievementsGui(class_3222 player, CompendiumSettings settings) {
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        this.setMode(TomeMode.ACHIEVEMENTS);
        List<ArcanaAchievement> items = TomeGui.sortedFilteredAchievementList(player, settings);
        List pageItems = AlgoUtils.listToPage(items, (int)settings.getAchPage(), (int)28);
        int numPages = (int)Math.ceil((double)items.size() / 28.0);
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        GameProfile gameProfile = player.method_7334();
        GuiElementBuilder head = new GuiElementBuilder(class_1802.field_8575).setSkullOwner(gameProfile, player.method_5682());
        head.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click here").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to return to the Profile Page").method_27692(class_124.field_1076))));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click here").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Items Page").method_27692(class_124.field_1076))));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click an item").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to view its page").method_27692(class_124.field_1076))));
        this.setSlot(4, (GuiElementBuilderInterface)head);
        GuiElementBuilder filterBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.FILTER)).hideDefaultTooltip();
        filterBuilt.setName((class_2561)class_2561.method_43470((String)"Filter Achievements").method_27692(class_124.field_1064));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle filter backwards.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Current Filter: ").method_27692(class_124.field_1075)).method_10852(AchievementFilter.getColoredLabel(settings.getAchFilterType()))));
        this.setSlot(8, (GuiElementBuilderInterface)filterBuilt);
        GuiElementBuilder sortBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.SORT)).hideDefaultTooltip();
        sortBuilt.setName((class_2561)class_2561.method_43470((String)"Sort Achievements").method_27692(class_124.field_1064));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current sort type.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle sort backwards.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset sort.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sorting By: ").method_27692(class_124.field_1075)).method_10852(AchievementSort.getColoredLabel(settings.getAchSortType()))));
        this.setSlot(0, (GuiElementBuilderInterface)sortBuilt);
        if (numPages > 1) {
            GuiElementBuilder nextPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW)).hideDefaultTooltip();
            nextPage.setName((class_2561)class_2561.method_43470((String)("Next Page (" + settings.getAchPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            nextPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Next Page").method_27692(class_124.field_1076))));
            this.setSlot(53, (GuiElementBuilderInterface)nextPage);
            GuiElementBuilder prevPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW)).hideDefaultTooltip();
            prevPage.setName((class_2561)class_2561.method_43470((String)("Previous Page (" + settings.getAchPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            prevPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Previous Page").method_27692(class_124.field_1076))));
            this.setSlot(45, (GuiElementBuilderInterface)prevPage);
        }
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < pageItems.size()) {
                    List<UUID> achPlayers;
                    ArcanaAchievement baseAch = (ArcanaAchievement)pageItems.get(k);
                    ArcanaAchievement profileAchievement = profile.getAchievement(baseAch.getArcanaItem().getId(), baseAch.id);
                    ArcanaAchievement achievement = profileAchievement != null ? profileAchievement : baseAch;
                    class_1799 displayItem = achievement.getDisplayItem();
                    ArcanaItem.putProperty(displayItem, "arcanaItemId", achievement.getArcanaItem().getId());
                    GuiElementBuilder achievementItem = GuiElementBuilder.from((class_1799)displayItem);
                    achievementItem.hideDefaultTooltip().setName((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1076).method_10852((class_2561)achievement.getTranslatedName()).method_27693(" - ").method_10852((class_2561)achievement.getArcanaItem().getTranslatedName())).addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(achievement.xpReward)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" XP").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"  |  ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)("" + achievement.pointsReward)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(achievement.pointsReward != 1 ? " Skill Points" : " Skill Point")).method_27692(class_124.field_1062))));
                    for (String s : achievement.getDescription()) {
                        achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)s).method_27692(class_124.field_1080)));
                    }
                    class_5250[] statusText = achievement.getStatusDisplay(player);
                    if (statusText != null) {
                        for (class_5250 mutableText : statusText) {
                            achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)mutableText));
                        }
                    }
                    if ((achPlayers = ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.get(achievement.id)) == null || achPlayers.isEmpty()) {
                        achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"No Arcanists have achieved this").method_27692(class_124.field_1064))));
                    } else {
                        int allArcanists = (int)ArcanaNovum.PLAYER_XP_TRACKER.values().stream().filter(xp -> xp > 1).count();
                        int acquiredCount = achPlayers.size();
                        DecimalFormat df = new DecimalFormat("#0.00");
                        achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Acquired by ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)("" + acquiredCount)).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" Arcanists (").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)(df.format(100.0 * (double)acquiredCount / (double)allArcanists) + "%")).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1064))));
                    }
                    if (profile.hasAcheivement(achievement.getArcanaItem().getId(), achievement.id)) {
                        achievementItem.glow();
                    }
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)achievementItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
        this.setTitle((class_2561)class_2561.method_43470((String)"All Arcana Achievements"));
    }

    public void buildLeaderboardGui(class_3222 player, CompendiumSettings settings) {
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        this.setMode(TomeMode.LEADERBOARD);
        List<UUID> items = TomeGui.sortedFilteredLeaderboardList(settings);
        List pageItems = AlgoUtils.listToPage(items, (int)settings.getLeaderboardPage(), (int)28);
        HashMap<UUID, List<String>> achievementMap = ArcanaAchievements.getInvertedTracker();
        int numPages = (int)Math.ceil((double)items.size() / 28.0);
        int numAchievements = ArcanaAchievements.registry.size();
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        GameProfile gameProfile = player.method_7334();
        GuiElementBuilder head = new GuiElementBuilder(class_1802.field_8575).setSkullOwner(gameProfile, player.method_5682());
        head.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)player.method_5820()).method_27692(class_124.field_1075)));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Level: ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)("" + profile.getLevel())).method_27692(class_124.field_1076))));
        if (profile.getLevel() == 100) {
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Total Experience: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(profile.getXP())).method_27692(class_124.field_1060))));
        } else {
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Experience: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(LevelUtils.getCurLevelXp(profile.getXP()))).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(LevelUtils.nextLevelNewXp(profile.getLevel()))).method_27692(class_124.field_1060))));
        }
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Achievements: ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(profile.totalAcquiredAchievements())).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(numAchievements)).method_27692(class_124.field_1075))));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to return to the profile page").method_27692(class_124.field_1076))));
        this.setSlot(4, (GuiElementBuilderInterface)head);
        GuiElementBuilder filterBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.FILTER)).hideDefaultTooltip();
        filterBuilt.setName((class_2561)class_2561.method_43470((String)"Filter Arcanists").method_27692(class_124.field_1064));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle filter backwards.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Current Filter: ").method_27692(class_124.field_1075)).method_10852(LeaderboardFilter.getColoredLabel(settings.getLeaderFilterType()))));
        this.setSlot(8, (GuiElementBuilderInterface)filterBuilt);
        GuiElementBuilder sortBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.SORT)).hideDefaultTooltip();
        sortBuilt.setName((class_2561)class_2561.method_43470((String)"Sort Arcanists").method_27692(class_124.field_1064));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current sort type.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle sort backwards.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset sort.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sorting By: ").method_27692(class_124.field_1075)).method_10852(LeaderboardSort.getColoredLabel(settings.getLeaderSortType()))));
        this.setSlot(0, (GuiElementBuilderInterface)sortBuilt);
        if (numPages > 1) {
            GuiElementBuilder nextPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW));
            nextPage.setName((class_2561)class_2561.method_43470((String)("Next Page (" + settings.getLeaderboardPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            nextPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Next Page").method_27692(class_124.field_1076))));
            this.setSlot(53, (GuiElementBuilderInterface)nextPage);
            GuiElementBuilder prevPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW));
            prevPage.setName((class_2561)class_2561.method_43470((String)("Previous Page (" + settings.getLeaderboardPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            prevPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Previous Page").method_27692(class_124.field_1076))));
            this.setSlot(45, (GuiElementBuilderInterface)prevPage);
        }
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < pageItems.size()) {
                    GuiElementBuilder playerItem;
                    UUID playerId = (UUID)pageItems.get(k);
                    int playerXp = ArcanaNovum.PLAYER_XP_TRACKER.get(playerId);
                    int playerLevel = LevelUtils.levelFromXp(playerXp);
                    try {
                        GameProfile playerGameProf = (GameProfile)player.method_5682().method_3793().method_14512(playerId).orElseThrow();
                        playerItem = new GuiElementBuilder(class_1802.field_8575).setSkullOwner(playerGameProf, player.method_5682());
                        playerItem.setName((class_2561)class_2561.method_43470((String)playerGameProf.getName()).method_27692(class_124.field_1076));
                    }
                    catch (Exception e) {
                        playerItem = new GuiElementBuilder(class_1802.field_8077);
                        playerItem.setName((class_2561)class_2561.method_43470((String)"<UNKNOWN>").method_27692(class_124.field_1076));
                    }
                    playerItem.hideDefaultTooltip();
                    playerItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Level: ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)("" + playerLevel)).method_27692(class_124.field_1076))));
                    if (playerLevel == 100) {
                        playerItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Total Experience: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(playerXp)).method_27692(class_124.field_1060))));
                    } else {
                        playerItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Experience: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(LevelUtils.getCurLevelXp(playerXp))).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(LevelUtils.nextLevelNewXp(playerLevel))).method_27692(class_124.field_1060))));
                    }
                    int playerAchievements = achievementMap.containsKey(playerId) ? achievementMap.get(playerId).size() : 0;
                    playerItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Achievements: ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(playerAchievements)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(numAchievements)).method_27692(class_124.field_1075))));
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)playerItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
        this.setTitle((class_2561)class_2561.method_43470((String)"Arcana Leaderboard"));
    }

    /*
     * WARNING - void declaration
     */
    public static void buildItemGui(SimpleGui gui, class_3222 player, String id) {
        int i;
        if (gui instanceof TomeGui) {
            TomeGui tomeGui = (TomeGui)gui;
            tomeGui.setMode(TomeMode.ITEM);
        }
        boolean isTwilightAnvil = gui instanceof TwilightAnvilGui;
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
        if (arcanaItem == null) {
            gui.close();
            return;
        }
        for (int i3 = 0; i3 < gui.getSize(); ++i3) {
            if (i3 / 9 == 1) {
                gui.setSlot(i3, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)7996617)).hideTooltip());
                continue;
            }
            if (i3 % 9 == 0) {
                gui.setSlot(i3, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i3 % 9 == 8) {
                gui.setSlot(i3, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i3 / 9 != 4) continue;
            gui.setSlot(i3, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_HORIZONTAL, (int)7996617)).hideTooltip());
        }
        gui.setSlot(9, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP_LEFT, (int)7996617)).hideTooltip());
        gui.setSlot(17, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP_RIGHT, (int)7996617)).hideTooltip());
        gui.setSlot(36, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        gui.setSlot(44, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        for (int i2 = 0; i2 < 9; ++i2) {
            gui.setSlot(i2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)15129998)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        }
        if (arcanaItem instanceof MultiblockCore) {
            MultiblockCore multicore = (MultiblockCore)((Object)arcanaItem);
            class_3545<class_5250, class_5250>[] mbMats = new LinkedHashMap();
            multicore.getMultiblock().getMaterialList().entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(entry -> mbMats.put((class_1792)entry.getKey(), (Integer)entry.getValue()));
            GuiElementBuilder structure = new GuiElementBuilder(class_1802.field_20390).hideDefaultTooltip();
            structure.setName((class_2561)class_2561.method_43470((String)"Multi-Block Structure").method_27692(class_124.field_1064));
            structure.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"to view this block's Structure").method_27692(class_124.field_1076))));
            structure.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to copy the materials list to your clipboard").method_27692(class_124.field_1076))));
            structure.addLoreLine((class_2561)class_2561.method_43470((String)""));
            structure.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Materials ").method_27692(class_124.field_1064))));
            structure.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"-----------------------").method_27692(class_124.field_1076)));
            for (Map.Entry entry2 : mbMats.entrySet()) {
                class_1792 matItem = (class_1792)entry2.getKey();
                int num = (Integer)entry2.getValue();
                int stacks = num / matItem.method_7882();
                int rem = num % matItem.method_7882();
                class_5250 text = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)matItem.method_7876()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)("" + num)).method_27692(class_124.field_1060));
                if (num > matItem.method_7882()) {
                    text.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1064));
                    if (rem > 0) {
                        text.method_27693("(" + stacks + " Stacks + " + rem + ")").method_27692(class_124.field_1054);
                    } else {
                        text.method_27693("(" + stacks + " Stacks)").method_27692(class_124.field_1054);
                    }
                }
                structure.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)text));
            }
            if (!isTwilightAnvil) {
                gui.setSlot(0, (GuiElementBuilderInterface)structure);
            }
        }
        GuiElementBuilder book = new GuiElementBuilder(class_1802.field_8360).hideDefaultTooltip();
        book.setName((class_2561)class_2561.method_43470((String)"Item Lore").method_27692(class_124.field_1064));
        book.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"to read about this Arcana Item").method_27692(class_124.field_1076))));
        if (arcanaItem.getAttributions().length > 0) {
            book.addLoreLine((class_2561)class_2561.method_43470((String)""));
            for (class_3545<class_5250, class_5250> attribution : arcanaItem.getAttributions()) {
                book.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)((class_5250)attribution.method_15442()).method_27692(class_124.field_1064)).method_10852((class_2561)((class_5250)attribution.method_15441()).method_27692(class_124.field_1076))));
            }
        }
        if (!isTwilightAnvil) {
            gui.setSlot(6, (GuiElementBuilderInterface)book);
        }
        GuiElementBuilder table = new GuiElementBuilder(class_1802.field_8465).hideDefaultTooltip();
        table.setName((class_2561)class_2561.method_43470((String)"Item Recipe").method_27692(class_124.field_1064));
        table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to view this item's recipe!").method_27692(class_124.field_1076))));
        if (!isTwilightAnvil) {
            gui.setSlot(2, (GuiElementBuilderInterface)table);
        }
        gui.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)arcanaItem.getPrefItem()).glow());
        int paperCost = profile.getArcanePaperRequirement(arcanaItem.getRarity());
        GuiElementBuilder notes = new GuiElementBuilder(ArcanaRegistry.ARCANE_NOTES).glow().hideDefaultTooltip();
        notes.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Research Notes").method_27692(class_124.field_1064)));
        notes.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Left Click ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"to scribe a spare set of Arcane Notes").method_27692(class_124.field_1076))));
        notes.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"(Costs ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)(paperCost + " ")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43471((String)ArcanaRarity.getArcanePaper(arcanaItem.getRarity()).method_7876()).method_27692(ArcanaRarity.getColor(arcanaItem.getRarity()))).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1064))));
        notes.addLoreLine((class_2561)class_2561.method_43470((String)""));
        notes.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to view the research for this item").method_27692(class_124.field_1076))));
        gui.setSlot(8, (GuiElementBuilderInterface)notes);
        GuiElementBuilder augmentPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)15129998)).hideDefaultTooltip();
        augmentPane.setName((class_2561)class_2561.method_43470((String)"Augments:").method_27692(class_124.field_1064));
        augmentPane.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Unlocked augments can be applied to enhance Arcana Items!").method_27692(class_124.field_1076)));
        List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
        int[] augmentSlots = DYNAMIC_SLOTS[augments.size()];
        for (int i2 = 0; i2 < 7; ++i2) {
            gui.setSlot(19 + i2, (GuiElementBuilderInterface)augmentPane);
            gui.setSlot(28 + i2, (GuiElementBuilderInterface)augmentPane);
        }
        for (int i3 = 0; i3 < augmentSlots.length; ++i3) {
            void var19_37;
            ArcanaAugment augment = augments.get(i3);
            gui.clearSlot(19 + augmentSlots[i3]);
            gui.clearSlot(28 + augmentSlots[i3]);
            int augmentLvl = profile.getAugmentLevel(augment.id);
            GuiElementBuilder augmentItem1 = GuiElementBuilder.from((class_1799)augment.getDisplayItem());
            augmentItem1.hideDefaultTooltip().setName((class_2561)augment.getTranslatedName().method_27692(class_124.field_1064)).addLoreLine((class_2561)TextUtils.removeItalics((class_5250)augment.getTierDisplay()));
            String[] stringArray = augment.getDescription();
            int n = stringArray.length;
            boolean bl = false;
            while (var19_37 < n) {
                String s = stringArray[var19_37];
                augmentItem1.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)s).method_27692(class_124.field_1080)));
                ++var19_37;
            }
            if (augmentLvl > 0) {
                augmentItem1.glow();
            }
            int unallocated = profile.getTotalSkillPoints() - profile.getSpentSkillPoints();
            class_5250 titleText = augmentLvl == 0 ? class_2561.method_43470((String)"Unlock Level 1").method_27692(class_124.field_1076) : class_2561.method_43470((String)"Current Level: ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43470((String)("" + augmentLvl)).method_27692(class_124.field_1076));
            ArcanaRarity[] arcanaRarityArray = augment.getTiers();
            class_1792 concrete = augmentLvl == arcanaRarityArray.length ? class_1802.field_8341 : ArcanaRarity.getColoredConcrete(arcanaRarityArray[augmentLvl]);
            GuiElementBuilder augmentItem2 = new GuiElementBuilder(concrete);
            if (augmentLvl == arcanaRarityArray.length) {
                augmentItem2.hideDefaultTooltip().setName((class_2561)class_2561.method_43470((String)"Level ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43470((String)("" + augmentLvl)).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" Unlocked").method_27692(class_124.field_1064)));
                augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Max Level").method_27692(class_124.field_1075))));
                augmentItem2.glow();
            } else {
                augmentItem2.hideDefaultTooltip().setName((class_2561)titleText);
                augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Level: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)("" + (augmentLvl + 1))).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1078)).method_10852(ArcanaRarity.getColoredLabel(arcanaRarityArray[augmentLvl], false)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1078))));
                augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Skill Point Cost: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)("" + (arcanaRarityArray[augmentLvl].rarity + 1))).method_27692(class_124.field_1062))));
                augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"(").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)("" + unallocated)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Unallocated Points)").method_27692(class_124.field_1078))));
                augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click To Unlock").method_27692(class_124.field_1075))));
            }
            gui.setSlot(19 + augmentSlots[i3], (GuiElementBuilderInterface)augmentItem1);
            gui.setSlot(28 + augmentSlots[i3], (GuiElementBuilderInterface)augmentItem2);
        }
        GuiElementBuilder achievePane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)15129998)).hideDefaultTooltip();
        achievePane.setName((class_2561)class_2561.method_43470((String)"Achievements:").method_27692(class_124.field_1064));
        achievePane.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Earning Achievements Grants Skill Points and XP!").method_27692(class_124.field_1076)));
        List<ArcanaAchievement> achievements = ArcanaAchievements.getItemAchievements(arcanaItem);
        int[] achieveSlots = DYNAMIC_SLOTS[achievements.size()];
        for (i = 0; i < 7; ++i) {
            gui.setSlot(46 + i, (GuiElementBuilderInterface)achievePane);
        }
        for (i = 0; i < achievements.size(); ++i) {
            List<UUID> achPlayers;
            ArcanaAchievement achievement = achievements.get(i);
            gui.clearSlot(46 + achieveSlots[i]);
            GuiElementBuilder achievementItem = GuiElementBuilder.from((class_1799)achievement.getDisplayItem());
            achievementItem.hideDefaultTooltip().setName((class_2561)achievement.getTranslatedName().method_27692(class_124.field_1076)).addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(achievement.xpReward)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" XP").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"  |  ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)("" + achievement.pointsReward)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(achievement.pointsReward != 1 ? " Skill Points" : " Skill Point")).method_27692(class_124.field_1062))));
            for (String string : achievement.getDescription()) {
                achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)string).method_27692(class_124.field_1080)));
            }
            class_5250[] class_5250Array = achievement.getStatusDisplay(player);
            if (class_5250Array != null) {
                void var22_49;
                class_5250[] concrete = class_5250Array;
                int augmentItem2 = concrete.length;
                boolean bl = false;
                while (var22_49 < augmentItem2) {
                    class_5250 mutableText = concrete[var22_49];
                    achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)mutableText));
                    ++var22_49;
                }
            }
            if ((achPlayers = ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.get(achievement.id)) == null || achPlayers.isEmpty()) {
                achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"No Arcanists have achieved this").method_27692(class_124.field_1064))));
            } else {
                int allArcanists = (int)ArcanaNovum.PLAYER_XP_TRACKER.values().stream().filter(xp -> xp > 1).count();
                int n = achPlayers.size();
                DecimalFormat df = new DecimalFormat("#0.00");
                achievementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Acquired by ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)("" + n)).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" Arcanists (").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)(df.format(100.0 * (double)n / (double)allArcanists) + "%")).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1064))));
            }
            if (profile.hasAcheivement(arcanaItem.getId(), achievement.id)) {
                achievementItem.glow();
            }
            gui.setSlot(46 + achieveSlots[i], (GuiElementBuilderInterface)achievementItem);
        }
        gui.setTitle((class_2561)arcanaItem.getTranslatedName());
    }

    public void buildRecipeGui(SimpleGui gui, class_2561 name, ArcanaRecipe recipe, class_1799 output) {
        if (gui instanceof TomeGui) {
            TomeGui tomeGui = (TomeGui)gui;
            tomeGui.setMode(TomeMode.RECIPE);
            this.selectedRecipe = recipe;
        }
        for (int i = 0; i < gui.getSize(); ++i) {
            if (i % 9 == 0 || i % 9 == 6) {
                gui.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i % 9 == 8) {
                gui.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i % 9 != 7) continue;
            gui.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_HORIZONTAL, (int)7996617)).hideTooltip());
        }
        gui.setSlot(17, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        gui.setSlot(35, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        gui.setSlot(15, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        gui.setSlot(33, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        gui.setSlot(7, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)7996617)).hideTooltip());
        gui.setSlot(43, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)7996617)).hideTooltip());
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(output);
        if (arcanaItem != null) {
            GuiElementBuilder book = new GuiElementBuilder(class_1802.field_8360).hideDefaultTooltip();
            book.setName((class_2561)class_2561.method_43470((String)"Item Lore").method_27692(class_124.field_1064));
            book.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"to read about this Arcana Item.").method_27692(class_124.field_1076))));
            if (arcanaItem.getAttributions().length > 0) {
                book.addLoreLine((class_2561)class_2561.method_43470((String)""));
                for (class_3545<class_5250, class_5250> attribution : arcanaItem.getAttributions()) {
                    book.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)((class_5250)attribution.method_15442()).method_27692(class_124.field_1064)).method_10852((class_2561)((class_5250)attribution.method_15441()).method_27692(class_124.field_1076))));
                }
            }
            gui.setSlot(7, (GuiElementBuilderInterface)book);
        }
        gui.setSlot(25, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)output));
        GuiElementBuilder returnBook = new GuiElementBuilder(class_1802.field_8361);
        returnBook.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)));
        returnBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to return to the Arcana Items Page").method_27692(class_124.field_1076))));
        gui.setSlot(26, (GuiElementBuilderInterface)returnBook);
        ArcanaIngredient[][] ingredients = recipe.getIngredients();
        for (int i = 0; i < 25; ++i) {
            class_1799 ingredient = ingredients[i / 5][i % 5].ingredientAsStack();
            GuiElementBuilder craftingElement = GuiElementBuilder.from((class_1799)ingredient);
            if (ingredients[i / 5][i % 5] instanceof ExplainIngredient) {
                craftingElement.hideDefaultTooltip();
            }
            if (ArcanaItemUtils.isArcane(ingredient)) {
                craftingElement.glow();
            }
            gui.setSlot(CRAFTING_SLOTS[i], (GuiElementBuilderInterface)craftingElement);
        }
        GuiElementBuilder recipeItem = new GuiElementBuilder(class_1802.field_8407).hideDefaultTooltip();
        HashMap<String, class_3545<Integer, class_1799>> ingredList = recipe.getIngredientList();
        recipeItem.setName((class_2561)class_2561.method_43470((String)"Total Ingredients").method_27692(class_124.field_1064));
        recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"-----------------------").method_27692(class_124.field_1076)));
        for (Map.Entry entry : ingredList.entrySet()) {
            recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)TomeGui.getIngredStr(entry)));
        }
        recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        int slotCount = 0;
        for (ArcanaItem item : recipe.getForgeRequirementList()) {
            GuiElementBuilder reqItem = GuiElementBuilder.from((class_1799)item.getPrefItemNoLore()).hideDefaultTooltip().glow();
            class_5250 requiresText = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Requires").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1064)).method_10852((class_2561)item.getTranslatedName().method_27692(class_124.field_1075));
            recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)requiresText));
            reqItem.setName((class_2561)requiresText);
            gui.setSlot(slotCount, (GuiElementBuilderInterface)reqItem);
            slotCount += 9;
        }
        if (!recipe.getForgeRequirementList().isEmpty()) {
            recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        }
        recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Does not include item data").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})));
        recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to copy the materials list to your clipboard").method_27692(class_124.field_1076))));
        gui.setSlot(43, (GuiElementBuilderInterface)recipeItem);
        gui.setTitle((class_2561)class_2561.method_43470((String)"Recipe for ").method_10852(name));
    }

    public void buildResearchGui(class_3222 player, CompendiumSettings settings, String id) {
        List<class_3545> taskPair;
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        this.setMode(TomeMode.RESEARCH);
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
        if (arcanaItem == null) {
            this.close();
            return;
        }
        List allTasks = ResearchTasks.getUniqueTasks(arcanaItem.getResearchTasks()).stream().toList();
        List<ResearchTask> uncompletedOnly = allTasks.stream().filter(task -> !task.isAcquired(player)).toList();
        boolean allAcquired = allTasks.stream().allMatch(task -> task.isAcquired(player));
        int allTaskPages = (int)Math.ceil((double)allTasks.size() / 28.0);
        int uncompletedPages = (int)Math.ceil((double)uncompletedOnly.size() / 28.0);
        List<ResearchTask> tasks = settings.hideCompletedResearch() ? uncompletedOnly : allTasks;
        int numPages = (int)Math.ceil((double)tasks.size() / 28.0);
        if (allTaskPages == uncompletedPages) {
            taskPair = AlgoUtils.randomlySpace(allTasks, (int)(allTaskPages * 28), (long)class_5285.method_46720((String)arcanaItem.getId()).orElse(class_5285.method_46721()));
            if (settings.hideCompletedResearch()) {
                taskPair = taskPair.stream().filter(pair -> !((ResearchTask)pair.method_15442()).isAcquired(player)).toList();
            }
        } else {
            taskPair = AlgoUtils.randomlySpace(tasks, (int)(numPages * 28), (long)class_5285.method_46720((String)arcanaItem.getId()).orElse(class_5285.method_46721()));
        }
        int paperCost = profile.getArcanePaperRequirement(arcanaItem.getRarity());
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        this.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)arcanaItem.getPrefItem()).glow());
        GuiElementBuilder filterBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.FILTER)).hideDefaultTooltip();
        String filterStr = settings.hideCompletedResearch() ? " to show all research." : " to hide completed research.";
        filterBuilt.setName((class_2561)class_2561.method_43470((String)"Filter Research Tasks").method_27692(class_124.field_1064));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)filterStr).method_27692(class_124.field_1076))));
        this.setSlot(8, (GuiElementBuilderInterface)filterBuilt);
        if (numPages > 1) {
            GuiElementBuilder nextPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW));
            nextPage.setName((class_2561)class_2561.method_43470((String)("Next Page (" + settings.getResearchPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            nextPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Next Page").method_27692(class_124.field_1076))));
            this.setSlot(53, (GuiElementBuilderInterface)nextPage);
            GuiElementBuilder prevPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW));
            prevPage.setName((class_2561)class_2561.method_43470((String)("Previous Page (" + settings.getResearchPage() + "/" + numPages + ")")).method_27692(class_124.field_1064));
            prevPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Previous Page").method_27692(class_124.field_1076))));
            this.setSlot(45, (GuiElementBuilderInterface)prevPage);
        }
        int pageLower = (settings.getResearchPage() - 1) * 28;
        int pageUpper = settings.getResearchPage() * 28;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)(allAcquired ? 11136417 : 15129998))).hideTooltip());
            }
        }
        for (class_3545 pair2 : taskPair) {
            int index = (Integer)pair2.method_15441();
            ResearchTask task2 = (ResearchTask)pair2.method_15442();
            if (index >= pageUpper || index < pageLower) continue;
            boolean acquired = task2.isAcquired(player);
            boolean hasPreReqs = task2.satisfiedPreReqs(player);
            boolean hasPrePreReqs = task2.satisfiedPrePreReqs(player);
            int guiIndex = index % 28 + 10 + 2 * (index % 28 / 7);
            GuiElementBuilder taskItem = GuiElementBuilder.from((class_1799)task2.getDisplayItem()).hideDefaultTooltip().setCount(1).glow(acquired);
            taskItem.setName((class_2561)class_5250.method_43477((class_7417)task2.getName().method_10851()).method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
            if (acquired) {
                taskItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Completed").method_27692(class_124.field_1075)));
            } else if (hasPreReqs) {
                boolean colorSwitch = false;
                for (class_2561 text : task2.getDescription()) {
                    if (!text.getString().isEmpty() && text.getString().charAt(0) != ' ') {
                        colorSwitch = !colorSwitch;
                    }
                    taskItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_5250.method_43477((class_7417)text.method_10851())).method_54663(colorSwitch ? 15129020 : 11904644));
                }
            } else {
                taskItem.setName((class_2561)class_2561.method_43470((String)"???").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}));
            }
            if (!hasPrePreReqs) continue;
            this.setSlot(guiIndex, (GuiElementBuilderInterface)taskItem);
        }
        GuiElementBuilder notes = new GuiElementBuilder(ArcanaRegistry.ARCANE_NOTES).glow(allAcquired).hideDefaultTooltip();
        notes.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Scribe Notes").method_27692(class_124.field_1064)));
        if (allAcquired) {
            notes.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"to complete your research").method_27692(class_124.field_1076))));
            notes.addLoreLine((class_2561)class_2561.method_43470((String)""));
            notes.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Costs ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)(paperCost + " ")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43471((String)ArcanaRarity.getArcanePaper(arcanaItem.getRarity()).method_7876()).method_27692(ArcanaRarity.getColor(arcanaItem.getRarity())))));
        } else {
            notes.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Complete all research tasks to unlock this item.").method_27692(class_124.field_1076)));
        }
        this.setSlot(49, (GuiElementBuilderInterface)notes);
        this.setTitle((class_2561)arcanaItem.getTranslatedName().method_10852((class_2561)class_2561.method_43470((String)" Research")));
    }

    public static class_5250 getIngredStr(Map.Entry<String, class_3545<Integer, class_1799>> ingred) {
        class_1799 ingredStack = (class_1799)ingred.getValue().method_15441();
        int maxCount = ingredStack.method_7914();
        int num = (Integer)ingred.getValue().method_15442();
        int stacks = num / maxCount;
        int rem = num % maxCount;
        class_5250 text = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)ingred.getKey()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)("" + num)).method_27692(class_124.field_1060));
        if (num > maxCount) {
            text.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1064));
            if (rem > 0) {
                text.method_27693("(" + stacks + " Stacks + " + rem + ")").method_27692(class_124.field_1054);
            } else {
                text.method_27693("(" + stacks + " Stacks)").method_27692(class_124.field_1054);
            }
        }
        return text;
    }

    public void onClose() {
        if (this.permaCloseFlag) {
            return;
        }
        if (this.mode == TomeMode.RECIPE) {
            this.tome.openGui((class_1657)this.player, TomeMode.COMPENDIUM, this.settings);
        } else if (this.mode == TomeMode.ITEM || this.mode == TomeMode.RESEARCH) {
            this.tome.openGui((class_1657)this.player, TomeMode.COMPENDIUM, this.settings);
        }
    }

    public TomeMode getMode() {
        return this.mode;
    }

    public void setMode(TomeMode mode) {
        this.mode = mode;
    }

    public static BookElementBuilder getGuideBook() {
        BookElementBuilder book = new BookElementBuilder();
        ArrayList<class_5250> pages = new ArrayList<class_5250>();
        pages.add(class_2561.method_43470((String)"       Welcome to\n     Arcana Novum!\n\nArcana Novum is a server-sided fabric Magic mod that adds various power Arcana Items to the game. It also includes new game mechanics and multiblocks!").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Introduction\n\nYou are probably reading this in your Tome, which will be your guidebook for the entirety of the mod.\n\nThe first page of the tome is your profile.\nThe profile has 3 main sections to it.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Arcane Level\n\nYour level decides how many Arcana Items you can carry through Concentration\n\nYou gain XP by using and crafting items.\nCrafting an item for the first time gives additional XP.\nArcana Achievements also grant XP.   ").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Concentration\n\nArcana Items each take a certain amount of focus to channel Arcana into. Each rarity tier of item takes a different amount of concentration to use.\nIf you go over your concentration limit, your mind will collapse and you will die.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Concentration\n\nItems take full concentration while in your inventory, but half concentration in your Ender Chest or Shulker Boxes.\n\nBlocks that are placed down take a quarter of the concentration when loaded in the world.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"       Skill Points\n\nYou get 3 skill points per Arcana level.\nYou also earn skill points by completing Arcana Achievements.\n\nYou can use these points to unlock Augments for items, which can be applied to enhance or change their abilities.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Item Rarities\n\nThere are 5 rarities:\nMundane, Empowered, Exotic, Sovereign, and Divine.\n\nAll Arcana Items above Mundane are immensely powerful, but some are more demanding to wield, which is reflected by their rarity.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Mundane Items\n\nConcentration: 0\n\nMundane Items only faintly emit Arcana and are mostly used in conjunction with other Arcana Items, such as being an ingredient in more powerful items, or as a fuel source.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"   Empowered Items\n\nConcentration: 1\n\nEmpowered Items are mostly utility items that offer conveniences in common situations.\n\nThey take a minimal toll to keep in your inventory so feel free to stock up on them!").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Exotic Items\n\nConcentration: 5\n\nExotic Items are more powerful items that can offer unique abilities not gained elsewhere, or provide a significant advantage in troubling situations. They are much more demanding to use.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"    Sovereign Items\n\nConcentration: 20\n\nSovereign Items are Arcanists' best attempts at recreating the power found in Divine Artifacts. However, unlike Divine Items, they lack the presence of Divine Arcana that makes wielding them trivial.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"    Sovereign Items\n\nAs a result, these items take an extraordinary amount of focus to wield.\n\nFortunately, they successfully replicate the incredible abilities of Divine Items in a form craftable by mere mortals.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"       Divine Items\n\nConcentration: 0\n\nDivine Items are made by godlike entities, such as the Aspect of Death. As previously mentioned, they use Divine Arcana, which uses the raw energy of the world itself to power them with no effort by the user.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"       Divine Items\n\nThere is no way to craft them in your forge, which means the only way of getting them is by interacting with these powerful entities.\nThis can be a very dangerous door to be knocking on, but the reward could be worth the risk...").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"    Item Compendium\n\nNow that you are caught up on the types of Arcana Items, you can use your Tome to look through all of the available items and how to use and craft them.\nThe Compendium is accessed by clicking the book in the Profile").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"  Researching Items\n\nBefore crafting an item you need to research it. This is done by completing various tasks, which can be in the form of obtaining an item, or  an Advancement.\n\nCompleting research requires Arcane Paper.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Forging Items\n\nIn order to craft Arcana Items you need a Starlight Forge. The recipe for which is viewable in the Compendium after researching it.\n\nThe Starlight Forge will require a structure beneath it which is shown by").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Forging Items\n\nright clicking the Forge.\n\nOnce completed, the Forge will allow you to craft better gear, and Arcana Items, by researching and following the recipes in your Tome.\n\nSome recipes may\n").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Forging Items\n\nrequire your Forge to be upgraded by crafting Forge Additions and placing them around your Forge.\n\nEach Forge Addon will unlock new recipes along with providing their own unique functionalities. ").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Augmentation\n\nAugments give your items enhanced capabilities or provide their own unique twist on their original purpose.\n\nEvery item has its own Augments you can unlock with Skill Points.\nHowever, there are not enough Skill Points").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Augmentation\n\nto unlock every augment so you much choose carefully.\n\nAugments follow the same rarity as items.\nRarity defines how many skill points they take to unlock and the type of catalyst needed to apply them.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Augmentation\n\nUnlocking an Augment does NOT immediately provide their benefits.\n\nAugments must be applied to an individual item by using an Augmentation Catalyst in the Twilight Anvil Forge Addition.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Augmentation\n\nItems that possess augments that you do not have unlocked will cost additional concentration to wield, so borrowing items from other players may cause you to use more concentration than expected.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"       Conclusion\n\nThose are the basics of the Arcana Novum mod!\n\nIf you have any questions, ideas, or find any bugs with the mod, please make an issue on the GitHub!\n\nEnjoy unlocking the secrets of Arcana!").method_27692(class_124.field_1074));
        pages.forEach(arg_0 -> ((BookElementBuilder)book).addPage(arg_0));
        book.setAuthor("Arcana Novum");
        book.setTitle("Arcana Guide");
        return book;
    }

    public static List<CompendiumEntry> sortedFilteredEntryList(CompendiumSettings settings, class_3222 player) {
        ArrayList<CompendiumEntry> items;
        TomeFilter filterType = settings.getFilterType();
        TomeSort sortType = settings.getSortType();
        if (filterType != null) {
            items = new ArrayList();
            for (CompendiumEntry entry2 : ArcanaRegistry.RECOMMENDED_LIST) {
                if (!TomeFilter.matchesFilter(filterType, entry2, player)) continue;
                items.add(entry2);
            }
        } else {
            items = ArcanaRegistry.RECOMMENDED_LIST;
        }
        switch (sortType.ordinal()) {
            case 0: {
                items.sort(Comparator.comparingInt(ArcanaRegistry.RECOMMENDED_LIST::indexOf));
                break;
            }
            case 3: {
                Comparator<CompendiumEntry> nameComparator = Comparator.comparing(entry -> entry.getName().getString());
                items.sort(nameComparator);
                break;
            }
            case 2: {
                Comparator rarityDescComparator = (i1, i2) -> {
                    int rarityCompare = i2.getRarityValue() - i1.getRarityValue();
                    if (rarityCompare == 0) {
                        return i1.getName().getString().compareTo(i2.getName().getString());
                    }
                    return rarityCompare;
                };
                items.sort(rarityDescComparator);
                break;
            }
            default: {
                Comparator rarityAscComparator = (i1, i2) -> {
                    int rarityCompare = i1.getRarityValue() - i2.getRarityValue();
                    if (rarityCompare == 0) {
                        return i1.getName().getString().compareTo(i2.getName().getString());
                    }
                    return rarityCompare;
                };
                items.sort(rarityAscComparator);
            }
        }
        return items;
    }

    public static List<ArcanaAchievement> sortedFilteredAchievementList(class_3222 player, CompendiumSettings settings) {
        ArrayList<ArcanaAchievement> achs;
        AchievementFilter filterType = settings.getAchFilterType();
        AchievementSort sortType = settings.getAchSortType();
        if (filterType != null) {
            achs = new ArrayList();
            for (ArcanaAchievement achievement : ArcanaAchievements.registry.values().stream().toList()) {
                if (!AchievementFilter.matchesFilter(player, filterType, achievement)) continue;
                achs.add(achievement);
            }
        } else {
            achs = new ArrayList<ArcanaAchievement>(ArcanaAchievements.registry.values().stream().toList());
        }
        switch (sortType.ordinal()) {
            case 0: {
                achs.sort(Comparator.comparingInt(ach -> ArcanaRegistry.RECOMMENDED_LIST.stream().map(entry -> {
                    ArcanaItem arcanaItem;
                    if (entry instanceof ArcanaItemCompendiumEntry) {
                        ArcanaItemCompendiumEntry arcanaEntry = (ArcanaItemCompendiumEntry)entry;
                        arcanaItem = arcanaEntry.getArcanaItem();
                    } else {
                        arcanaItem = null;
                    }
                    return arcanaItem;
                }).toList().indexOf(ach.getArcanaItem())));
                break;
            }
            case 3: {
                Comparator<ArcanaAchievement> nameComparator = Comparator.comparing(ArcanaAchievement::getName);
                achs.sort(nameComparator);
                break;
            }
            case 2: {
                Comparator rarityDescComparator = (i1, i2) -> {
                    int rarityCompare = i2.xpReward - i1.xpReward;
                    if (rarityCompare == 0) {
                        return i1.getName().compareTo(i2.getName());
                    }
                    return rarityCompare;
                };
                achs.sort(rarityDescComparator);
                break;
            }
            case 1: {
                Comparator rarityAscComparator = (i1, i2) -> {
                    int rarityCompare = i1.xpReward - i2.xpReward;
                    if (rarityCompare == 0) {
                        return i1.getName().compareTo(i2.getName());
                    }
                    return rarityCompare;
                };
                achs.sort(rarityAscComparator);
            }
        }
        return achs;
    }

    public static List<UUID> sortedFilteredLeaderboardList(CompendiumSettings settings) {
        LeaderboardFilter filterType = settings.getLeaderFilterType();
        LeaderboardSort sortType = settings.getLeaderSortType();
        List players = ArcanaNovum.PLAYER_XP_TRACKER.keySet().stream().toList();
        ArrayList<UUID> filteredSortedPlayers = new ArrayList<UUID>();
        if (filterType != null) {
            for (UUID player : players) {
                if (!LeaderboardFilter.matchesFilter(player, filterType)) continue;
                filteredSortedPlayers.add(player);
            }
        } else {
            filteredSortedPlayers = new ArrayList(players.stream().toList());
        }
        HashMap<UUID, List<String>> invertedAchList = ArcanaAchievements.getInvertedTracker();
        switch (sortType.ordinal()) {
            case 0: {
                filteredSortedPlayers.sort(Comparator.comparingInt(id -> -ArcanaNovum.PLAYER_XP_TRACKER.get(id).intValue()));
                break;
            }
            case 1: {
                filteredSortedPlayers.sort(Comparator.comparingInt(ArcanaNovum.PLAYER_XP_TRACKER::get));
                break;
            }
            case 2: {
                Comparator achieveCountComparator = (i1, i2) -> {
                    int achCount1 = invertedAchList.containsKey(i1) ? ((List)invertedAchList.get(i1)).size() : 0;
                    int achCount2 = invertedAchList.containsKey(i2) ? ((List)invertedAchList.get(i2)).size() : 0;
                    int countCompare = achCount2 - achCount1;
                    if (countCompare == 0) {
                        return ArcanaNovum.PLAYER_XP_TRACKER.get(i2) - ArcanaNovum.PLAYER_XP_TRACKER.get(i1);
                    }
                    return countCompare;
                };
                filteredSortedPlayers.sort(achieveCountComparator);
                break;
            }
            case 3: {
                Comparator achieveCountComparator = (i1, i2) -> {
                    int countCompare;
                    ArcanaAchievement ach;
                    int skillCount1 = 0;
                    int skillCount2 = 0;
                    if (invertedAchList.containsKey(i1)) {
                        for (String achId : (List)invertedAchList.get(i1)) {
                            ach = ArcanaAchievements.registry.get(achId);
                            skillCount1 += ach == null ? 0 : ach.pointsReward;
                        }
                    }
                    if (invertedAchList.containsKey(i2)) {
                        for (String achId : (List)invertedAchList.get(i2)) {
                            ach = ArcanaAchievements.registry.get(achId);
                            skillCount2 += ach == null ? 0 : ach.pointsReward;
                        }
                    }
                    if ((countCompare = skillCount2 - skillCount1) == 0) {
                        return ArcanaNovum.PLAYER_XP_TRACKER.get(i2) - ArcanaNovum.PLAYER_XP_TRACKER.get(i1);
                    }
                    return countCompare;
                };
                filteredSortedPlayers.sort(achieveCountComparator);
                break;
            }
            case 4: {
                Comparator<UUID> nameComparator = Comparator.comparing(playerID -> {
                    GameProfile profile = ArcanaNovum.SERVER.method_3793().method_14512(playerID).orElse(null);
                    return profile == null ? "" : profile.getName();
                });
                filteredSortedPlayers.sort(nameComparator);
            }
        }
        return filteredSortedPlayers;
    }

    public static enum TomeMode {
        PROFILE,
        COMPENDIUM,
        ITEM,
        RECIPE,
        NONE,
        ACHIEVEMENTS,
        LEADERBOARD,
        RESEARCH;

    }

    public static class CompendiumSettings {
        private TomeSort sortType = TomeSort.RECOMMENDED;
        private TomeFilter filterType = TomeFilter.NONE;
        private AchievementSort achSortType = AchievementSort.RECOMMENDED;
        private AchievementFilter achFilterType = AchievementFilter.NONE;
        private LeaderboardSort leaderSortType = LeaderboardSort.XP_DESC;
        private LeaderboardFilter leaderFilterType = LeaderboardFilter.NONE;
        private int page = 1;
        private int achPage = 1;
        private int leaderboardPage = 1;
        private int researchPage = 1;
        private boolean hideCompletedResearch = false;
        public final int skillLvl;
        public final int resourceLvl;

        public CompendiumSettings(int skillLvl, int resourceLvl) {
            this.skillLvl = skillLvl;
            this.resourceLvl = resourceLvl;
        }

        public TomeFilter getFilterType() {
            return this.filterType;
        }

        public TomeSort getSortType() {
            return this.sortType;
        }

        public AchievementSort getAchSortType() {
            return this.achSortType;
        }

        public AchievementFilter getAchFilterType() {
            return this.achFilterType;
        }

        public int getPage() {
            return this.page;
        }

        public int getAchPage() {
            return this.achPage;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void setAchPage(int achPage) {
            this.achPage = achPage;
        }

        public void setFilterType(TomeFilter filterType) {
            this.filterType = filterType;
        }

        public void setFilterType(AchievementFilter filterType) {
            this.achFilterType = filterType;
        }

        public void setSortType(TomeSort sortType) {
            this.sortType = sortType;
        }

        public void setSortType(AchievementSort sortType) {
            this.achSortType = sortType;
        }

        public int getLeaderboardPage() {
            return this.leaderboardPage;
        }

        public void setLeaderboardPage(int leaderboardPage) {
            this.leaderboardPage = leaderboardPage;
        }

        public LeaderboardSort getLeaderSortType() {
            return this.leaderSortType;
        }

        public void setLeaderSortType(LeaderboardSort leaderSortType) {
            this.leaderSortType = leaderSortType;
        }

        public LeaderboardFilter getLeaderFilterType() {
            return this.leaderFilterType;
        }

        public void setLeaderFilterType(LeaderboardFilter leaderFilterType) {
            this.leaderFilterType = leaderFilterType;
        }

        public boolean hideCompletedResearch() {
            return this.hideCompletedResearch;
        }

        public void setHideCompletedResearch(boolean hideCompletedResearch) {
            this.hideCompletedResearch = hideCompletedResearch;
        }

        public int getResearchPage() {
            return this.researchPage;
        }

        public void setResearchPage(int researchPage) {
            this.researchPage = researchPage;
        }
    }

    public static enum TomeSort {
        RECOMMENDED("Recommended"),
        RARITY_ASC("Rarity Ascending"),
        RARITY_DESC("Rarity Descending"),
        NAME("Alphabetical");

        public final String label;

        private TomeSort(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(TomeSort sort) {
            class_5250 text = class_2561.method_43470((String)sort.label);
            return switch (sort.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> text.method_27692(class_124.field_1076);
                case 2 -> text.method_27692(class_124.field_1064);
                case 3 -> text.method_27692(class_124.field_1060);
                case 0 -> text.method_27692(class_124.field_1054);
            };
        }

        public static TomeSort cycleSort(TomeSort sort, boolean backwards) {
            TomeSort[] sorts = TomeSort.values();
            int ind = -1;
            for (int i = 0; i < sorts.length; ++i) {
                if (sort != sorts[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= sorts.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = sorts.length - 1;
            }
            return sorts[ind];
        }
    }

    public static enum TomeFilter {
        NONE("None"),
        RESEARCHED("Researched"),
        NOT_RESEARCHED("Not Researched"),
        MUNDANE("Mundane"),
        EMPOWERED("Empowered"),
        EXOTIC("Exotic"),
        SOVEREIGN("Sovereign"),
        DIVINE("Divine"),
        ITEMS("Items"),
        BLOCKS("Blocks"),
        FORGE("Forge"),
        ARROWS("Arrows"),
        ALTARS("Altars"),
        EQUIPMENT("Equipment"),
        CHARMS("Charms"),
        CATALYSTS("Catalysts"),
        INGREDIENT("Ingredient");

        public final String label;

        private TomeFilter(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(TomeFilter filter) {
            class_5250 text = class_2561.method_43470((String)filter.label);
            return switch (filter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1068);
                case 1 -> text.method_27692(class_124.field_1076);
                case 2 -> text.method_27692(class_124.field_1063);
                case 3 -> text.method_27692(class_124.field_1080);
                case 4 -> text.method_27692(class_124.field_1060);
                case 5 -> text.method_27692(class_124.field_1075);
                case 6 -> text.method_27692(class_124.field_1065);
                case 7 -> text.method_27692(class_124.field_1076);
                case 8 -> text.method_27692(class_124.field_1062);
                case 9 -> text.method_27692(class_124.field_1064);
                case 10 -> text.method_27692(class_124.field_1077);
                case 11 -> text.method_27692(class_124.field_1061);
                case 12 -> text.method_27692(class_124.field_1078);
                case 13 -> text.method_27692(class_124.field_1079);
                case 14 -> text.method_27692(class_124.field_1054);
                case 15 -> text.method_27692(class_124.field_1058);
                case 16 -> text.method_27692(class_124.field_1063);
            };
        }

        public static TomeFilter cycleFilter(TomeFilter filter, boolean backwards) {
            TomeFilter[] filters = TomeFilter.values();
            int ind = -1;
            for (int i = 0; i < filters.length; ++i) {
                if (filter != filters[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= filters.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = filters.length - 1;
            }
            return filters[ind];
        }

        public static boolean matchesFilter(TomeFilter filter, CompendiumEntry entry, class_3222 player) {
            if (filter == NONE) {
                return true;
            }
            if (filter == RESEARCHED || filter == NOT_RESEARCHED) {
                if (entry instanceof ArcanaItemCompendiumEntry) {
                    ArcanaItemCompendiumEntry arcanaEntry = (ArcanaItemCompendiumEntry)entry;
                    if (filter == RESEARCHED) {
                        return ArcanaNovum.data((class_1657)player).hasResearched(arcanaEntry.getArcanaItem());
                    }
                    return !ArcanaNovum.data((class_1657)player).hasResearched(arcanaEntry.getArcanaItem());
                }
                return false;
            }
            TomeFilter[] cats = entry.getCategories();
            if (cats == null) {
                ArcanaNovum.log(2, "No categories found for: " + String.valueOf(entry.getName()));
                return false;
            }
            for (TomeFilter category : cats) {
                if (filter != category) continue;
                return true;
            }
            return false;
        }
    }

    public static enum AchievementSort {
        RECOMMENDED("Item (Recommended)"),
        RARITY_ASC("XP/SP Ascending"),
        RARITY_DESC("XP/SP Descending"),
        NAME("Alphabetical");

        public final String label;

        private AchievementSort(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(AchievementSort sort) {
            class_5250 text = class_2561.method_43470((String)sort.label);
            return switch (sort.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> text.method_27692(class_124.field_1076);
                case 2 -> text.method_27692(class_124.field_1064);
                case 3 -> text.method_27692(class_124.field_1060);
                case 0 -> text.method_27692(class_124.field_1054);
            };
        }

        public static AchievementSort cycleSort(AchievementSort sort, boolean backwards) {
            AchievementSort[] sorts = AchievementSort.values();
            int ind = -1;
            for (int i = 0; i < sorts.length; ++i) {
                if (sort != sorts[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= sorts.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = sorts.length - 1;
            }
            return sorts[ind];
        }
    }

    public static enum AchievementFilter {
        NONE("None"),
        ACQUIRED("Acquired"),
        NOT_ACQUIRED("Not Acquired");

        public final String label;

        private AchievementFilter(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(AchievementFilter filter) {
            class_5250 text = class_2561.method_43470((String)filter.label);
            return switch (filter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1068);
                case 1 -> text.method_27692(class_124.field_1075);
                case 2 -> text.method_27692(class_124.field_1061);
            };
        }

        public static AchievementFilter cycleFilter(AchievementFilter filter, boolean backwards) {
            AchievementFilter[] filters = AchievementFilter.values();
            int ind = -1;
            for (int i = 0; i < filters.length; ++i) {
                if (filter != filters[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= filters.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = filters.length - 1;
            }
            return filters[ind];
        }

        public static boolean matchesFilter(class_3222 player, AchievementFilter filter, ArcanaAchievement ach) {
            if (filter == NONE) {
                return true;
            }
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
            boolean acquired = profile.hasAcheivement(ach.getArcanaItem().getId(), ach.id);
            if (filter == ACQUIRED) {
                return acquired;
            }
            if (filter == NOT_ACQUIRED) {
                return !acquired;
            }
            return false;
        }
    }

    public static enum LeaderboardSort {
        XP_DESC("XP Descending (Recommended)"),
        XP_ASC("XP Ascending"),
        ACHIEVES_DESC("Achievements Descending"),
        SKILL_POINTS_DESC("Skill Points Descending"),
        NAME("Alphabetical");

        public final String label;

        private LeaderboardSort(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(LeaderboardSort sort) {
            class_5250 text = class_2561.method_43470((String)sort.label);
            return switch (sort.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1076);
                case 1 -> text.method_27692(class_124.field_1064);
                case 2 -> text.method_27692(class_124.field_1060);
                case 3 -> text.method_27692(class_124.field_1077);
                case 4 -> text.method_27692(class_124.field_1075);
            };
        }

        public static LeaderboardSort cycleSort(LeaderboardSort sort, boolean backwards) {
            LeaderboardSort[] sorts = LeaderboardSort.values();
            int ind = -1;
            for (int i = 0; i < sorts.length; ++i) {
                if (sort != sorts[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= sorts.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = sorts.length - 1;
            }
            return sorts[ind];
        }
    }

    public static enum LeaderboardFilter {
        NONE("None"),
        ARCANIST("Arcanist"),
        MAX_LVL("Max Level"),
        ABYSS("Abyssal Arcanist");

        public final String label;

        private LeaderboardFilter(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(LeaderboardFilter filter) {
            class_5250 text = class_2561.method_43470((String)filter.label);
            return switch (filter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1068);
                case 1 -> text.method_27692(class_124.field_1076);
                case 2 -> text.method_27692(class_124.field_1060);
                case 3 -> text.method_27692(class_124.field_1064);
            };
        }

        public static LeaderboardFilter cycleFilter(LeaderboardFilter filter, boolean backwards) {
            LeaderboardFilter[] filters = LeaderboardFilter.values();
            int ind = -1;
            for (int i = 0; i < filters.length; ++i) {
                if (filter != filters[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= filters.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = filters.length - 1;
            }
            return filters[ind];
        }

        public static boolean matchesFilter(UUID playerID, LeaderboardFilter filter) {
            if (filter == NONE) {
                return true;
            }
            int xp = ArcanaNovum.PLAYER_XP_TRACKER.get(playerID);
            int level = LevelUtils.levelFromXp(xp);
            if (filter == ARCANIST) {
                return xp > 1;
            }
            if (filter == MAX_LVL) {
                return level >= 100;
            }
            if (filter == ABYSS) {
                return ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.get(ArcanaAchievements.ALL_ACHIEVEMENTS.id).contains(playerID);
            }
            return false;
        }
    }
}

