/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.twilightanvil;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.TwilightAnvilBlockEntity;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.gui.VirtualInventoryGui;
import net.borisshoes.arcananovum.gui.twilightanvil.TinkerInventoryListener;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class TwilightAnvilGui
extends VirtualInventoryGui<class_1277> {
    private final TwilightAnvilBlockEntity blockEntity;
    private class_1277 inventory;
    private TinkerInventoryListener listener;
    private final int mode;
    private final int[][] dynamicSlots = new int[][]{new int[0], {3}, {1, 5}, {1, 3, 5}, {0, 2, 4, 6}, {1, 2, 3, 4, 5}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};
    private int tinkerSlotType = 0;

    public TwilightAnvilGui(class_3917<?> type, class_3222 player, TwilightAnvilBlockEntity blockEntity, int mode) {
        super(type, player, false);
        this.blockEntity = blockEntity;
        this.mode = mode;
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        if (this.mode == 0) {
            if (index == 0) {
                this.blockEntity.openGui(3, this.player, "");
            } else if (index == 2) {
                this.blockEntity.openGui(2, this.player, "");
            } else if (index == 4) {
                this.blockEntity.openGui(1, this.player, "");
            }
        } else if (this.mode == 1 && this.inventory != null) {
            if (index == 14) {
                boolean input2MaxEnhanced;
                class_1799 input2;
                class_1799 input1 = this.inventory.method_5438(0);
                TwilightAnvilBlockEntity.AnvilOutputSet outputSet = this.blockEntity.calculateOutput(input1, input2 = this.inventory.method_5438(1));
                if (outputSet.output().method_7960()) {
                    return true;
                }
                int points = LevelUtils.vanillaLevelToTotalXp(outputSet.levelCost());
                if (!this.player.method_68878()) {
                    if (ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.ANVIL_EXPERTISE.id) > 0) {
                        if (this.player.field_7495 < points) {
                            this.player.method_64398((class_2561)class_2561.method_43470((String)"Not Enough Experience").method_27692(class_124.field_1061));
                            return true;
                        }
                        this.player.method_7255(-points);
                    } else {
                        if (this.player.field_7520 < outputSet.levelCost()) {
                            this.player.method_64398((class_2561)class_2561.method_43470((String)"Not Enough Experience").method_27692(class_124.field_1061));
                            return true;
                        }
                        this.player.method_7316(-outputSet.levelCost());
                    }
                }
                if (outputSet.levelCost() > 40) {
                    ArcanaAchievements.grant(this.player, ArcanaAchievements.BEYOND_IRONS_LIMIT.id);
                }
                boolean finalMaxEnhanced = EnhancedStatUtils.isEnhanced(outputSet.output()) && ArcanaItem.getDoubleProperty(outputSet.output(), EnhancedStatUtils.ENHANCED_STAT_TAG) >= 1.0;
                boolean input1MaxEnhanced = EnhancedStatUtils.isEnhanced(input1) && ArcanaItem.getDoubleProperty(input1, EnhancedStatUtils.ENHANCED_STAT_TAG) >= 1.0;
                boolean bl = input2MaxEnhanced = EnhancedStatUtils.isEnhanced(input2) && ArcanaItem.getDoubleProperty(input2, EnhancedStatUtils.ENHANCED_STAT_TAG) >= 1.0;
                if (finalMaxEnhanced && !input1MaxEnhanced && !input2MaxEnhanced) {
                    ArcanaAchievements.grant(this.player, ArcanaAchievements.TINKER_TO_THE_TOP.id);
                }
                ArcanaNovum.data((class_1657)this.player).addXP((int)Math.min((double)ArcanaConfig.getInt(ArcanaRegistry.TWILIGHT_ANVIL_CAP), (double)(ArcanaConfig.getInt(ArcanaRegistry.TWILIGHT_ANVIL_PER_10) * points) / 10.0));
                this.listener.setUpdating();
                this.inventory.method_5447(0, class_1799.field_8037);
                if (outputSet.itemRepairUsage() > 0) {
                    class_1799 itemStack = this.inventory.method_5438(1);
                    if (!itemStack.method_7960() && itemStack.method_7947() > outputSet.itemRepairUsage()) {
                        itemStack.method_7934(outputSet.itemRepairUsage());
                        this.inventory.method_5447(1, itemStack);
                    } else {
                        this.inventory.method_5447(1, class_1799.field_8037);
                    }
                } else {
                    this.inventory.method_5447(1, class_1799.field_8037);
                }
                this.setSlot(14, class_1799.field_8037);
                GuiElementBuilder xpItem = new GuiElementBuilder(class_1802.field_8287).hideDefaultTooltip();
                xpItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"XP Cost").method_27692(class_124.field_1060)));
                xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"XP Cost will be shown here").method_27692(class_124.field_1077))));
                this.setSlot(16, (GuiElementBuilderInterface)xpItem);
                boolean bl2 = this.player.method_31548().method_7394(outputSet.output());
                if (!bl2 || !outputSet.output().method_7960()) {
                    class_1542 itemEntity = this.player.method_7328(outputSet.output(), false);
                    if (itemEntity != null) {
                        itemEntity.method_6975();
                        itemEntity.method_48349(this.player.method_5667());
                    }
                } else {
                    outputSet.output().method_7939(1);
                    class_1542 itemEntity = this.player.method_7328(outputSet.output(), false);
                    if (itemEntity != null) {
                        itemEntity.method_6987();
                    }
                }
                SoundUtils.playSound((class_1937)this.player.method_51469(), (class_2338)this.blockEntity.method_11016(), (class_3414)class_3417.field_14559, (class_3419)class_3419.field_15245, (float)1.0f, (float)((float)(0.375 * Math.random())));
                this.listener.finishUpdate();
            }
        } else if (this.mode == 2 && this.inventory != null) {
            class_1799 item = this.inventory.method_5438(0);
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
            if (this.tinkerSlotType == 1) {
                StarlightForgeBlockEntity forge = StarlightForge.findActiveForge(this.player.method_51469(), this.blockEntity.method_11016());
                if (forge != null) {
                    item = ArcanaBlockEntity.getBlockEntityAsItem(forge, forge.method_10997());
                    arcanaItem = ArcanaItemUtils.identifyItem(item);
                    this.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)item));
                } else {
                    this.close();
                }
            } else if (this.tinkerSlotType == 2) {
                item = ArcanaBlockEntity.getBlockEntityAsItem(this.blockEntity, this.blockEntity.method_10997());
                arcanaItem = ArcanaItemUtils.identifyItem(item);
                this.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)item));
            }
            if (index == 0 && this.tinkerSlotType != 2) {
                MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                this.clearSlot(4);
                this.tinkerSlotType = 2;
                this.redrawGui((class_1263)this.inventory);
            } else if (index == 8 && this.tinkerSlotType != 1) {
                MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                this.clearSlot(4);
                this.tinkerSlotType = 1;
                this.redrawGui((class_1263)this.inventory);
            } else if (index == 4 && this.tinkerSlotType != 0) {
                this.setSlotRedirect(4, new class_1735((class_1263)this.inventory, 0, 0, 0));
                this.tinkerSlotType = 0;
                this.redrawGui((class_1263)this.inventory);
            } else if (index == 31) {
                if (arcanaItem != null) {
                    if (ArcanaNovum.data((class_1657)this.player).hasResearched(arcanaItem)) {
                        MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                        this.blockEntity.openGui(4, this.player, arcanaItem.getId());
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You must research this item first!").method_27692(class_124.field_1061), false);
                    }
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"Insert an Item to Tinker").method_27692(class_124.field_1061), false);
                }
            } else if (index >= 10 && index <= 25 && arcanaItem != null) {
                List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
                int[] augmentSlots = this.dynamicSlots[augments.size()];
                ArcanaAugment augment = null;
                for (int i = 0; i < augmentSlots.length; ++i) {
                    if (index != 19 + augmentSlots[i]) continue;
                    augment = augments.get(i);
                    break;
                }
                if (augment != null) {
                    boolean generic;
                    IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.player);
                    int augmentLvl = profile.getAugmentLevel(augment.id);
                    ArcanaRarity[] tiers = augment.getTiers();
                    int curItemLevel = ArcanaAugments.getAugmentOnItem(item, augment.id);
                    if (curItemLevel == -1) {
                        curItemLevel = 0;
                    }
                    if (generic = arcanaItem.getId().equals("arcane_tome")) {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"These augments are active by default").method_27692(class_124.field_1075), false);
                    } else if (curItemLevel >= tiers.length) {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You have already maxed this augment").method_27692(class_124.field_1075), false);
                    } else if (augmentLvl == 0 && curItemLevel == 0) {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You must unlock this augment first").method_27692(class_124.field_1061), false);
                    } else if (curItemLevel >= augmentLvl) {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You must unlock higher levels to augment further").method_27692(class_124.field_1061), false);
                    } else if (ArcanaAugments.isIncompatible(item, augment.id)) {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"This augment is incompatible with existing augments").method_27692(class_124.field_1061), false);
                    } else if (this.attemptAugment(item, augment, curItemLevel + 1)) {
                        ArcanaNovum.data((class_1657)this.player).addXP(tiers[curItemLevel] == ArcanaRarity.DIVINE ? 10000 : ArcanaRarity.getCraftXp(tiers[curItemLevel]) / 10);
                        SoundUtils.playSongToPlayer((class_3222)this.player, (class_6880.class_6883)class_3417.field_14622, (float)1.0f, (float)(0.5f + (float)(curItemLevel + 1) / (float)(tiers.length - 1)));
                    }
                }
            }
        } else if (this.mode == 4) {
            class_1799 item = this.getSlot(4).getItemStack();
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
            if (index == 4) {
                this.close();
            } else if (index >= 28 && index <= 35) {
                List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
                int[] augmentSlots = this.dynamicSlots[augments.size()];
                ArcanaAugment augment = null;
                for (int i = 0; i < augmentSlots.length; ++i) {
                    if (index != 28 + augmentSlots[i]) continue;
                    augment = augments.get(i);
                    break;
                }
                if (augment != null) {
                    ArcanaRarity[] tiers;
                    IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.player);
                    int augmentLvl = profile.getAugmentLevel(augment.id);
                    if (augmentLvl >= (tiers = augment.getTiers()).length) {
                        return true;
                    }
                    int cost = tiers[augmentLvl].rarity + 1;
                    int unallocated = profile.getTotalSkillPoints() - profile.getSpentSkillPoints();
                    if (cost <= unallocated) {
                        profile.setAugmentLevel(augment.id, augmentLvl + 1);
                        SoundUtils.playSongToPlayer((class_3222)this.player, (class_6880.class_6883)class_3417.field_14622, (float)1.0f, (float)(0.5f + (float)(augmentLvl + 1) / (float)(tiers.length - 1)));
                        this.blockEntity.openGui(4, this.player, arcanaItem.getId());
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"Not Enough Skill Points").method_27692(class_124.field_1061), false);
                    }
                }
            }
        }
        return true;
    }

    public void buildMenuGui() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clearSlot(i);
            this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)478174)).setName((class_2561)class_2561.method_43470((String)"Twilight Anvil").method_27692(class_124.field_1064)));
        }
        GuiElementBuilder equipmentItem = new GuiElementBuilder(class_1802.field_8448).hideDefaultTooltip();
        equipmentItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Rename Items").method_27692(class_124.field_1075)));
        this.setSlot(0, (GuiElementBuilderInterface)equipmentItem);
        GuiElementBuilder arcanaItem = new GuiElementBuilder(class_1802.field_8301).hideDefaultTooltip();
        arcanaItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Augment Arcana Items").method_27692(class_124.field_1076)));
        this.setSlot(2, (GuiElementBuilderInterface)arcanaItem);
        GuiElementBuilder anvilItem = new GuiElementBuilder(class_1802.field_8782);
        anvilItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Enhanced Anvil").method_27692(class_124.field_1054)));
        this.setSlot(4, (GuiElementBuilderInterface)anvilItem);
        this.setTitle((class_2561)class_2561.method_43470((String)"Twilight Anvil"));
    }

    public void buildAnvilGui() {
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        GuiElementBuilder itemsPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_HORIZONTAL, (int)478174)).hideDefaultTooltip();
        itemsPane.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"<- Place Items Here ->").method_27692(class_124.field_1076)));
        this.setSlot(11, (GuiElementBuilderInterface)itemsPane);
        this.setSlot(13, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_VERTICAL, (int)7996617)).hideTooltip());
        this.setSlot(15, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_VERTICAL, (int)7996617)).hideTooltip());
        this.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(6, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(22, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_BOTTOM_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(24, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_BOTTOM_CONNECTOR, (int)7996617)).hideTooltip());
        GuiElementBuilder xpItem = new GuiElementBuilder(class_1802.field_8287).hideDefaultTooltip();
        xpItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"XP Cost").method_27692(class_124.field_1060)));
        xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"XP Cost will be shown here").method_27692(class_124.field_1077))));
        this.setSlot(16, (GuiElementBuilderInterface)xpItem);
        this.inventory = new class_1277(2);
        this.listener = new TinkerInventoryListener(this, 2, this.blockEntity);
        this.inventory.method_5489((class_1265)this.listener);
        this.setSlotRedirect(10, new class_1735((class_1263)this.inventory, 0, 0, 0));
        this.setSlotRedirect(12, new class_1735((class_1263)this.inventory, 1, 0, 0));
        this.clearSlot(14);
        this.setTitle((class_2561)class_2561.method_43470((String)"Tinker Items"));
    }

    public void buildTinkerGui() {
        this.tinkerSlotType = 0;
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43470((String)"Insert an Arcana Item to Augment it").method_27692(class_124.field_1064));
        GuiElementBuilder itemPage = new GuiElementBuilder(class_1802.field_8782).hideDefaultTooltip();
        itemPage.setName((class_2561)class_2561.method_43470((String)"Item Page").method_27692(class_124.field_1064));
        itemPage.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to go to the Item Page and unlock Augments!").method_27692(class_124.field_1076))));
        this.setSlot(31, (GuiElementBuilderInterface)itemPage);
        GuiElementBuilder augmentPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918)).hideDefaultTooltip();
        augmentPane.setName((class_2561)class_2561.method_43470((String)"Augments:").method_27692(class_124.field_1064));
        augmentPane.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Unlocked augments can be applied to enhance Arcana Items!").method_27692(class_124.field_1076)));
        GuiElementBuilder tinkerAnvil = GuiElementBuilder.from((class_1799)ArcanaRegistry.TWILIGHT_ANVIL.getPrefItemNoLore()).hideDefaultTooltip();
        tinkerAnvil.setName((class_2561)class_2561.method_43470((String)"Augment This Twilight Anvil").method_27692(class_124.field_1078));
        tinkerAnvil.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to augment this Twilight Anvil").method_27692(class_124.field_1064))));
        this.setSlot(0, (GuiElementBuilderInterface)tinkerAnvil);
        GuiElementBuilder tinkerForge = GuiElementBuilder.from((class_1799)ArcanaRegistry.STARLIGHT_FORGE.getPrefItemNoLore()).hideDefaultTooltip();
        tinkerForge.setName((class_2561)class_2561.method_43470((String)"Augment This Starlight Forge").method_27692(class_124.field_1078));
        tinkerForge.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to augment this Starlight Forge").method_27692(class_124.field_1064))));
        this.setSlot(8, (GuiElementBuilderInterface)tinkerForge);
        for (int i = 0; i < 7; ++i) {
            this.setSlot(10 + i, (GuiElementBuilderInterface)augmentPane);
            this.setSlot(19 + i, (GuiElementBuilderInterface)augmentPane);
        }
        this.inventory = new class_1277(2);
        this.listener = new TinkerInventoryListener(this, 0, this.blockEntity);
        this.inventory.method_5489((class_1265)this.listener);
        this.setSlotRedirect(4, new class_1735((class_1263)this.inventory, 0, 0, 0));
        this.setTitle((class_2561)class_2561.method_43470((String)"Augment Arcana Items"));
    }

    private boolean attemptAugment(class_1799 item, ArcanaAugment augment, int level) {
        class_1661 playerInv = this.player.method_31548();
        ArcanaRarity tier = augment.getTiers()[level - 1];
        int catalystSlot = -1;
        boolean creative = this.player.method_68878();
        for (int i = 0; i < playerInv.method_5439(); ++i) {
            class_1799 cata = playerInv.method_5438(i);
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(cata);
            if (arcanaItem == null || !arcanaItem.getId().equals(ArcanaRarity.getAugmentCatalyst(tier).getId())) continue;
            catalystSlot = i;
            break;
        }
        if (catalystSlot == -1 && !creative) {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"No Augment Catalyst Found").method_27692(class_124.field_1061), false);
        } else {
            if (this.tinkerSlotType == 0) {
                if (ArcanaAugments.applyAugment(item, augment.id, level, true)) {
                    if (!creative) {
                        playerInv.method_5441(catalystSlot);
                    }
                    this.inventory.method_5447(0, item);
                    return true;
                }
                ArcanaNovum.log(3, "Error applying augment " + augment.id + " to " + ArcanaItemUtils.identifyItem(item).getId());
            }
            if (this.tinkerSlotType == 1) {
                StarlightForgeBlockEntity forge = StarlightForge.findActiveForge(this.player.method_51469(), this.blockEntity.method_11016());
                if (forge == null) {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"No Starlight Forge Found").method_27692(class_124.field_1061), false);
                    return false;
                }
                TreeMap<ArcanaAugment, Integer> forgeAugments = forge.getAugments();
                forgeAugments.put(augment, level);
                if (!creative) {
                    playerInv.method_5441(catalystSlot);
                }
                this.redrawGui((class_1263)this.inventory);
                return true;
            }
            if (this.tinkerSlotType == 2) {
                TreeMap<ArcanaAugment, Integer> anvilAugments = this.blockEntity.getAugments();
                anvilAugments.put(augment, level);
                if (!creative) {
                    playerInv.method_5441(catalystSlot);
                }
                this.redrawGui((class_1263)this.inventory);
                return true;
            }
        }
        return false;
    }

    public void redrawGui(class_1263 inv) {
        class_1799 item = inv.method_5438(0);
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
        if (this.mode == 2) {
            if (this.tinkerSlotType == 1) {
                StarlightForgeBlockEntity forge = StarlightForge.findActiveForge(this.player.method_51469(), this.blockEntity.method_11016());
                if (forge != null) {
                    item = ArcanaBlockEntity.getBlockEntityAsItem(forge, forge.method_10997());
                    arcanaItem = ArcanaItemUtils.identifyItem(item);
                    this.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)item));
                } else {
                    this.close();
                }
            } else if (this.tinkerSlotType == 2) {
                item = ArcanaBlockEntity.getBlockEntityAsItem(this.blockEntity, this.blockEntity.method_10997());
                arcanaItem = ArcanaItemUtils.identifyItem(item);
                this.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)item));
            }
            GuiElementBuilder augmentPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)(arcanaItem == null ? 2756918 : 0xDBDBDB))).hideDefaultTooltip();
            augmentPane.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Unlocked augments can be applied to enhance Arcana Items!").method_27692(class_124.field_1076)));
            for (int i = 0; i < 7; ++i) {
                this.setSlot(10 + i, (GuiElementBuilderInterface)augmentPane);
                this.setSlot(19 + i, (GuiElementBuilderInterface)augmentPane);
            }
            if (arcanaItem != null) {
                IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.player);
                boolean unlockedItem = profile.hasResearched(arcanaItem);
                if (!unlockedItem) {
                    GuiElementBuilder lockedPane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)12517890)).hideDefaultTooltip();
                    lockedPane.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You must first research this Arcana Item!").method_27692(class_124.field_1061)));
                    for (int i = 0; i < 7; ++i) {
                        this.setSlot(10 + i, (GuiElementBuilderInterface)lockedPane);
                        this.setSlot(19 + i, (GuiElementBuilderInterface)lockedPane);
                    }
                } else {
                    boolean generic = arcanaItem.getId().equals("arcane_tome");
                    List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
                    int[] augmentSlots = this.dynamicSlots[augments.size()];
                    for (int i = 0; i < augmentSlots.length; ++i) {
                        GuiElementBuilder augmentItem2;
                        int curItemLevel;
                        ArcanaAugment augment = augments.get(i);
                        this.clearSlot(10 + augmentSlots[i]);
                        this.clearSlot(19 + augmentSlots[i]);
                        int augmentLvl = profile.getAugmentLevel(augment.id);
                        ArcanaRarity[] tiers = augment.getTiers();
                        GuiElementBuilder augmentItem1 = GuiElementBuilder.from((class_1799)augment.getDisplayItem());
                        augmentItem1.hideDefaultTooltip().setName((class_2561)augment.getTranslatedName().method_27692(class_124.field_1064)).addLoreLine((class_2561)TextUtils.removeItalics((class_5250)augment.getTierDisplay()));
                        for (String s : augment.getDescription()) {
                            augmentItem1.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)s).method_27692(class_124.field_1080)));
                        }
                        if (augmentLvl > 0) {
                            augmentItem1.glow();
                        }
                        if ((curItemLevel = ArcanaAugments.getAugmentOnItem(item, augment.id)) == -1) {
                            curItemLevel = 0;
                        }
                        if (generic) {
                            augmentItem2 = new GuiElementBuilder(class_1802.field_27019);
                            augmentItem2.hideDefaultTooltip().glow().setName((class_2561)class_2561.method_43470((String)"Generic Augmentation").method_27692(class_124.field_1064));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These augments are always active").method_27692(class_124.field_1075))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You do not need to augment your Tome to receive their boons").method_27692(class_124.field_1075))));
                        } else if (curItemLevel >= tiers.length) {
                            augmentItem2 = new GuiElementBuilder(class_1802.field_8301);
                            augmentItem2.hideDefaultTooltip().glow().setName((class_2561)class_2561.method_43470((String)"Level ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43470((String)("" + curItemLevel)).method_27692(class_124.field_1076)));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Max Level").method_27692(class_124.field_1075))));
                        } else if (augmentLvl == 0 && curItemLevel == 0) {
                            augmentItem2 = new GuiElementBuilder(class_1802.field_8281);
                            augmentItem2.hideDefaultTooltip().glow().setName((class_2561)class_2561.method_43470((String)"Not Augmented").method_27692(class_124.field_1064));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Augment Locked!").method_27692(class_124.field_1079))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Spend ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Skill Points").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to unlock this augment").method_27692(class_124.field_1062))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Unlock augments on the item's page").method_27692(class_124.field_1062))));
                        } else if (curItemLevel >= augmentLvl) {
                            augmentItem2 = new GuiElementBuilder(class_1802.field_8281);
                            augmentItem2.hideDefaultTooltip().glow().setName((class_2561)class_2561.method_43470((String)"Current Level: ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43470((String)("" + curItemLevel)).method_27692(class_124.field_1076)));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have only unlocked level ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)("" + augmentLvl)).method_27692(class_124.field_1061))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Spend ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Skill Points").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to unlock higher levels").method_27692(class_124.field_1062))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Unlock augments on the item's page").method_27692(class_124.field_1062))));
                        } else if (ArcanaAugments.isIncompatible(item, augment.id)) {
                            augmentItem2 = new GuiElementBuilder(class_1802.field_8615);
                            augmentItem2.hideDefaultTooltip().glow().setName((class_2561)class_2561.method_43470((String)"Incompatible Augment").method_27692(class_124.field_1064));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This augment is incompatible with present augments").method_27692(class_124.field_1079))));
                        } else if (curItemLevel == 0 || curItemLevel == -1) {
                            augmentItem2 = GuiElementBuilder.from((class_1799)ArcanaRarity.getAugmentCatalyst(tiers[0]).getPrefItemNoLore());
                            augmentItem2.hideDefaultTooltip().setName((class_2561)class_2561.method_43470((String)"Not Augmented").method_27692(class_124.field_1064));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Level: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"1").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1078)).method_10852(ArcanaRarity.getColoredLabel(tiers[0], false)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1078))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Applying augments requires an ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Augment Catalyst").method_27692(ArcanaRarity.getColor(tiers[0])))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to consume a ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Catalyst").method_27692(ArcanaRarity.getColor(tiers[0]))).method_10852((class_2561)class_2561.method_43470((String)" to augment your item").method_27692(class_124.field_1062))));
                        } else {
                            augmentItem2 = GuiElementBuilder.from((class_1799)ArcanaRarity.getAugmentCatalyst(tiers[curItemLevel]).getPrefItemNoLore());
                            augmentItem2.hideDefaultTooltip().setName((class_2561)class_2561.method_43470((String)"Current Level: ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43470((String)("" + curItemLevel)).method_27692(class_124.field_1076)));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Level: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)("" + (curItemLevel + 1))).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1078)).method_10852(ArcanaRarity.getColoredLabel(tiers[curItemLevel], false)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1078))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Applying augments requires an ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Augment Catalyst").method_27692(ArcanaRarity.getColor(tiers[curItemLevel])))));
                            augmentItem2.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to consume a ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Catalyst").method_27692(ArcanaRarity.getColor(tiers[curItemLevel]))).method_10852((class_2561)class_2561.method_43470((String)" to augment your item").method_27692(class_124.field_1062))));
                        }
                        this.setSlot(10 + augmentSlots[i], (GuiElementBuilderInterface)augmentItem1);
                        this.setSlot(19 + augmentSlots[i], (GuiElementBuilderInterface)augmentItem2);
                    }
                }
            }
        } else if (this.mode == 1) {
            class_1799 input1 = inv.method_5438(0);
            class_1799 input2 = inv.method_5438(1);
            TwilightAnvilBlockEntity.AnvilOutputSet outputSet = this.blockEntity.calculateOutput(input1, input2);
            GuiElementBuilder xpItem = new GuiElementBuilder(class_1802.field_8287).hideDefaultTooltip();
            xpItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"XP Cost").method_27692(class_124.field_1060)));
            if (!outputSet.output().method_7960()) {
                this.setSlot(14, outputSet.output());
                if (outputSet.levelCost() <= 64) {
                    xpItem.setCount(outputSet.levelCost());
                }
                xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(outputSet.levelCost() + " Levels (" + LevelUtils.vanillaLevelToTotalXp(outputSet.levelCost()) + " Points)")).method_27692(class_124.field_1077))));
                this.setSlot(16, (GuiElementBuilderInterface)xpItem);
            } else {
                this.setSlot(14, class_1799.field_8037);
                xpItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"XP Cost will be shown here").method_27692(class_124.field_1077))));
                this.setSlot(16, (GuiElementBuilderInterface)xpItem);
            }
        }
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled()) {
            this.close();
        }
        super.onTick();
    }

    @Override
    public void onClose() {
        if (this.mode == 4) {
            this.tinkerSlotType = 0;
            this.blockEntity.openGui(2, this.player, "");
        }
        MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
    }

    public void close() {
        super.close();
    }
}

