/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaItemContainer;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3829;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class ChestTranslocator
extends EnergyItem
implements ArcanaItemContainer.ArcanaItemContainerHaver {
    public static final String ID = "chest_translocator";
    public static final String CONTENTS_TAG = "contents";
    public static final String STATE_TAG = "state";

    public ChestTranslocator() {
        this.id = ID;
        this.name = "Chest Translocator";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8486;
        this.item = new ChestTranslocatorItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.chest_translocator", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        this.researchTasks = new class_5321[]{ResearchTasks.USE_ENDER_CHEST, ResearchTasks.EFFECT_STRENGTH};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        ChestTranslocator.putProperty(stack, CONTENTS_TAG, (class_2520)new class_2487());
        ChestTranslocator.putProperty(stack, STATE_TAG, (class_2520)new class_2487());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Moving items").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" from one ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"chest ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"another ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"is a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"hassle").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Chests").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" are ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"heavy").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" and carrying them ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"slows ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"you down ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"significantly").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"chest ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"store ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"it in the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Translocator").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"place ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"stored ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"chest").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" down.").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int cdLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.RAPID_TRANSLOCATION.id));
        return 30 - 8 * cdLvl;
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public ArcanaItemContainer getArcanaItemContainer(class_1799 item) {
        class_2487 contents = ChestTranslocator.getCompoundProperty(item, CONTENTS_TAG);
        class_1277 inv = new class_1277(27);
        for (int i = 0; i < inv.method_5439(); ++i) {
            inv.method_5447(i, class_1799.field_8037.method_7972());
        }
        if (!contents.method_33133()) {
            class_2499 items = contents.method_68569("Items");
            for (int i = 0; i < items.size(); ++i) {
                class_2487 stack = items.method_68582(i);
                class_1799 itemStack = class_1799.field_24671.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)ArcanaNovum.SERVER.method_30611()), (Object)stack).result().orElse(class_1799.field_8037);
                inv.method_5447((int)stack.method_68562("Slot", (byte)0), itemStack);
            }
        }
        return new ArcanaItemContainer((class_1263)inv, 27, 25, "CT", "Chest Translocator", 0.5);
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2487 contents = ChestTranslocator.getCompoundProperty(stack, CONTENTS_TAG);
        class_2487 state = ChestTranslocator.getCompoundProperty(stack, STATE_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        ChestTranslocator.putProperty(newStack, CONTENTS_TAG, (class_2520)contents);
        ChestTranslocator.putProperty(newStack, STATE_TAG, (class_2520)state);
        return this.buildItemLore(newStack, server);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8106, 12);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 2);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_16307, 12);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8449, 4);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8993);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8466, 4);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"       Chest\n   Translocator").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nChests are great for storage and organization. However, whenever I try to move them, their contents spill all over the place.\nMaybe I can do something about that").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"       Chest\n   Translocator").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nusing an augmented Ender Chest and some additional strength.\n\nUsing the Translocator on a Chest, Trapped Chest, or Barrel will pick it up at the cost of a significant loss in dexterity.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"       Chest\n   Translocator").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nUsing the Translocator again places the container down, contents intact.").method_27692(class_124.field_1074)));
        return list;
    }

    public class ChestTranslocatorItem
    extends ArcanaPolymerItem {
        public ChestTranslocatorItem() {
            super(ChestTranslocator.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            class_2487 contents = ArcanaItem.getCompoundProperty(itemStack, ChestTranslocator.CONTENTS_TAG);
            class_2487 state = ArcanaItem.getCompoundProperty(itemStack, ChestTranslocator.STATE_TAG);
            if (!contents.method_33133()) {
                class_2680 blockState = class_2512.method_10681((class_7871)class_7923.field_41175, (class_2487)state);
                if (blockState.method_27852(class_2246.field_10034) || blockState.method_27852(class_2246.field_10380)) {
                    stringList.add("chest");
                } else if (blockState.method_27852(class_2246.field_16328)) {
                    stringList.add("barrel");
                }
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public class_1269 method_7884(class_1838 context) {
            class_1799 stack = context.method_8041();
            class_1657 playerEntity = context.method_8036();
            if (!ArcanaItemUtils.isArcane(stack) || !(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            class_1937 world = context.method_8045();
            class_2338 blockPos = context.method_8037();
            class_2487 contents = ArcanaItem.getCompoundProperty(stack, ChestTranslocator.CONTENTS_TAG);
            class_2487 stateTag = ArcanaItem.getCompoundProperty(stack, ChestTranslocator.STATE_TAG);
            int cooldown = ChestTranslocator.this.getEnergy(stack);
            class_2680 state = world.method_8320(blockPos);
            if (contents.method_33133()) {
                if (!state.method_27852(class_2246.field_10034) && !state.method_27852(class_2246.field_10380) && !state.method_27852(class_2246.field_16328)) return class_1269.field_5811;
                if (cooldown == 0) {
                    class_2586 be = world.method_8321(blockPos);
                    if (be == null) {
                        return class_1269.field_5811;
                    }
                    class_2487 contentData = be.method_38242((class_7225.class_7874)ArcanaNovum.SERVER.method_30611());
                    ArcanaItem.putProperty(stack, ChestTranslocator.CONTENTS_TAG, (class_2520)contentData);
                    ArcanaItem.putProperty(stack, ChestTranslocator.STATE_TAG, (class_2520)class_2512.method_10686((class_2680)state));
                    if (be instanceof class_3829) {
                        class_3829 clearable = (class_3829)be;
                        clearable.method_5448();
                    }
                    world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                    SoundUtils.playSound((class_1937)world, (class_2338)blockPos, (class_3414)class_3417.field_15215, (class_3419)class_3419.field_15245, (float)1.0f, (float)1.0f);
                    ChestTranslocator.this.setEnergy(stack, ChestTranslocator.this.getMaxEnergy(stack));
                    return class_1269.field_52422;
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Translocator Cooldown: " + cooldown + (cooldown != 1 ? " seconds" : " second"))).method_27692(class_124.field_1065), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                }
                return class_1269.field_52422;
            } else {
                class_2350 side = context.method_8038();
                class_2338 placePos = blockPos.method_10081(side.method_62675());
                if (world.method_8320(placePos).method_26215()) {
                    class_2680 blockState = class_2512.method_10681((class_7871)world.method_45448(class_7924.field_41254), (class_2487)stateTag);
                    class_1750 ipc = new class_1750((class_1657)player, context.method_20287(), context.method_8041(), new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699()));
                    if (blockState.method_27852(class_2246.field_10034)) {
                        blockState = class_2246.field_10034.method_9605(ipc);
                    } else if (blockState.method_27852(class_2246.field_10380)) {
                        blockState = class_2246.field_10380.method_9605(ipc);
                    } else if (blockState.method_27852(class_2246.field_16328)) {
                        blockState = class_2246.field_16328.method_9605(ipc);
                    }
                    world.method_8652(placePos, blockState, 3);
                    class_2586 blockEntity = class_2586.method_11005((class_2338)placePos, (class_2680)blockState, (class_2487)contents, (class_7225.class_7874)world.method_30349());
                    if (blockEntity != null) {
                        world.method_8438(blockEntity);
                        if (blockEntity instanceof class_2621) {
                            class_2621 container = (class_2621)blockEntity;
                            int size = container.method_5439();
                            int filled = 0;
                            for (int i = 0; i < size; ++i) {
                                filled += container.method_5438(i).method_7960() ? 0 : 1;
                            }
                            if (filled == size) {
                                ArcanaAchievements.progress(player, ArcanaAchievements.STORAGE_RELOCATION.id, 1);
                            } else if (filled == 0) {
                                ArcanaAchievements.grant(player, ArcanaAchievements.PEAK_LAZINESS.id);
                            }
                        }
                    }
                    ArcanaItem.putProperty(stack, ChestTranslocator.CONTENTS_TAG, (class_2520)new class_2487());
                    ArcanaItem.putProperty(stack, ChestTranslocator.STATE_TAG, (class_2520)new class_2487());
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CHEST_TRANSLOCATOR_USE));
                    SoundUtils.playSound((class_1937)world, (class_2338)placePos, (class_3414)class_3417.field_14718, (class_3419)class_3419.field_15245, (float)1.0f, (float)1.0f);
                    return class_1269.field_52422;
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The chest cannot be placed here.").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                }
            }
            return class_1269.field_52422;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            block7: {
                block6: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block6;
                    class_3218 serverWorld = world;
                    if (entity instanceof class_3222) break block7;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            class_2487 contents = ArcanaItem.getCompoundProperty(stack, ChestTranslocator.CONTENTS_TAG);
            if (!contents.method_33133()) {
                class_1293 slow = new class_1293(class_1294.field_5909, 20, 2, false, false, true);
                class_1293 fatigue = new class_1293(class_1294.field_5901, 20, 0, false, false, true);
                player.method_6092(slow);
                player.method_6092(fatigue);
            }
            if (world.method_8503().method_3780() % 20 == 0) {
                ChestTranslocator.this.addEnergy(stack, -1);
            }
        }

        public class_1799 method_7854() {
            return ChestTranslocator.this.prefItem;
        }

        @Override
        public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return ChestTranslocator.this.vanillaItem;
            }
            class_2487 contents = ArcanaItem.getCompoundProperty(itemStack, ChestTranslocator.CONTENTS_TAG);
            return !contents.method_33133() ? class_1802.field_38217 : ChestTranslocator.this.vanillaItem;
        }
    }
}

