/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class ContainmentCirclet
extends ArcanaItem {
    public static final String ID = "containment_circlet";
    public static final String CONTENTS_TAG = "contents";
    public static final String HP_TAG = "hp";
    public static final String MAX_HP_TAG = "maxHP";

    public ContainmentCirclet() {
        this.id = ID;
        this.name = "Containment Circlet";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8207;
        this.item = new ContainmentCircletItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.containment_circlet", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1062});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_TAME_AN_ANIMAL, ResearchTasks.USE_ENDER_CHEST};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        ContainmentCirclet.putProperty(stack, CONTENTS_TAG, (class_2520)new class_2487());
        ContainmentCirclet.putProperty(stack, HP_TAG, 0.0f);
        ContainmentCirclet.putProperty(stack, MAX_HP_TAG, 0.0f);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Animals ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"often have a ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"mind of their own").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" They must be ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"contained").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The Circlet").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" stores animals").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" for safe ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"keeping ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"and easy ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"transport").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"passive animal").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"contain ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"them.").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" again to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"release ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"them.").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)""));
        boolean hasCreature = false;
        if (itemStack != null) {
            class_2487 contents = ContainmentCirclet.getCompoundProperty(itemStack, CONTENTS_TAG);
            int hp = (int)ContainmentCirclet.getFloatProperty(itemStack, HP_TAG);
            int maxHp = (int)ContainmentCirclet.getFloatProperty(itemStack, MAX_HP_TAG);
            if (ArcanaNovum.SERVER != null) {
                try (class_8942.class_11340 logging = new class_8942.class_11340(LogUtils.getLogger());){
                    class_11368 readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)ArcanaNovum.SERVER.method_30611(), (class_2487)contents);
                    Optional entity = class_1299.method_17684((class_11368)readView);
                    if (!contents.method_33133() && entity.isPresent()) {
                        String entityTypeName = ((class_1299)entity.get()).method_5897().getString();
                        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contains").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(entityTypeName + " (" + hp + "/" + maxHp + ")")).method_27692(class_124.field_1060)));
                        hasCreature = true;
                    }
                }
            }
        }
        if (!hasCreature) {
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contains").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"Nothing").method_27692(class_124.field_1060)));
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2487 contents = ContainmentCirclet.getCompoundProperty(stack, CONTENTS_TAG);
        float hp = ContainmentCirclet.getFloatProperty(stack, HP_TAG);
        float maxHp = ContainmentCirclet.getFloatProperty(stack, MAX_HP_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        ContainmentCirclet.putProperty(newStack, CONTENTS_TAG, (class_2520)contents);
        ContainmentCirclet.putProperty(newStack, HP_TAG, hp);
        ContainmentCirclet.putProperty(newStack, MAX_HP_TAG, maxHp);
        return this.buildItemLore(newStack, server);
    }

    public class_1269 useOnEntity(class_1657 user, class_1309 entity, class_1268 hand) {
        boolean hostiles;
        class_1799 stack = user.method_5998(hand);
        if (!ArcanaItemUtils.isArcane(stack)) {
            return class_1269.field_5811;
        }
        class_2487 contents = ContainmentCirclet.getCompoundProperty(stack, CONTENTS_TAG);
        if (!contents.method_33133()) {
            user.method_7353((class_2561)class_2561.method_43470((String)"The Circlet is occupied").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)((class_3222)user), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
            return class_1269.field_52422;
        }
        if (entity.method_5864().method_20210(ArcanaRegistry.CONTAINMENT_CIRCLET_DISALLOWED) || entity.method_29504()) {
            user.method_7353((class_2561)class_2561.method_43470((String)"The Circlet cannot contain this creature").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)((class_3222)user), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
            return class_1269.field_52422;
        }
        boolean bl = hostiles = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.CONFINEMENT.id) > 0;
        if (entity instanceof class_1569 && !hostiles) {
            user.method_7353((class_2561)class_2561.method_43470((String)"This Circlet cannot capture hostile creatures").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)((class_3222)user), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
        } else if (entity instanceof class_1308) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71370(), LogUtils.getLogger());){
                class_11362 writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)entity.method_37908().method_30349());
                entity.method_5647((class_11372)writeView);
                class_2487 data = writeView.method_71475();
                data.method_10582("id", class_1299.method_5890((class_1299)entity.method_5864()).toString());
                ContainmentCirclet.putProperty(stack, CONTENTS_TAG, (class_2520)data);
                ContainmentCirclet.putProperty(stack, HP_TAG, entity.method_6032());
                ContainmentCirclet.putProperty(stack, MAX_HP_TAG, entity.method_6063());
                entity.method_31472();
                user.method_7353((class_2561)class_2561.method_43470((String)"The Circlet contains the creature").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)((class_3222)user), (class_3414)class_3417.field_15013, (float)1.0f, (float)1.5f);
                ArcanaNovum.data(user).addXP(ArcanaConfig.getInt(ArcanaRegistry.CONTAINMENT_CIRCLET_USE));
                this.buildItemLore(stack, user.method_5682());
            }
        }
        return class_1269.field_52422;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 4);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 4);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8076, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_23983, 12);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8786, 8);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8466, 4);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Containment Circlet").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nPets are amazing companions. They\u2019re also masochistic idiots with a love for getting into trouble. If only I had some sort of pocket ball, a pokeb\u2026 a Containment Circlet to keep them safe.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Containment Circlet").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nUsing the Circlet on a passive or tamed mob captures it.\n\nUsing the Circlet again releases the creature.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class ContainmentCircletItem
    extends ArcanaPolymerItem {
        public ContainmentCircletItem() {
            super(ContainmentCirclet.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            class_2487 contents = ArcanaItem.getCompoundProperty(itemStack, ContainmentCirclet.CONTENTS_TAG);
            boolean confinement = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.CONFINEMENT.id) >= 1;
            ArrayList<String> stringList = new ArrayList<String>();
            if (confinement) {
                if (contents.method_33133()) {
                    stringList.add("confinement_empty");
                } else {
                    stringList.add("confinement_filled");
                }
            } else if (contents.method_33133()) {
                stringList.add("empty");
            } else {
                stringList.add("filled");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1269 method_7884(class_1838 context) {
            class_1799 stack = context.method_8041();
            if (!ArcanaItemUtils.isArcane(stack) || context.method_8036() == null) {
                return class_1269.field_5811;
            }
            class_2487 contents = ArcanaItem.getCompoundProperty(stack, ContainmentCirclet.CONTENTS_TAG);
            float hp = ArcanaItem.getFloatProperty(stack, ContainmentCirclet.HP_TAG);
            if (contents.method_33133()) {
                return class_1269.field_5811;
            }
            try (class_8942.class_11340 logging = new class_8942.class_11340(context.method_8036().method_71370(), LogUtils.getLogger());){
                class_1937 class_19372;
                class_11368 readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)context.method_8045().method_30349(), (class_2487)contents);
                Optional optional = class_1299.method_5892((class_11368)readView, (class_1937)context.method_8045(), (class_3730)class_3730.field_16471);
                class_243 summonPos = context.method_17698().method_1031(0.0, 0.5, 0.0);
                if (optional.isPresent() && (class_19372 = context.method_8045()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_1297 newEntity = (class_1297)optional.get();
                    newEntity.method_5808(summonPos.method_10216(), summonPos.method_10214(), summonPos.method_10215(), newEntity.method_36454(), newEntity.method_36455());
                    if (newEntity instanceof class_1309) {
                        class_1309 living = (class_1309)newEntity;
                        living.method_6033(hp);
                    }
                    serverWorld.method_8649(newEntity);
                    ArcanaItem.putProperty(stack, ContainmentCirclet.CONTENTS_TAG, (class_2520)new class_2487());
                    class_1657 class_16572 = context.method_8036();
                    if (class_16572 instanceof class_3222) {
                        class_1321 tameable;
                        class_3222 player = (class_3222)class_16572;
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Circlet releases its captive").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15013, (float)1.0f, (float)1.5f);
                        if (newEntity instanceof class_1321 && (tameable = (class_1321)newEntity).method_6171((class_1309)player)) {
                            ArcanaAchievements.grant(player, ArcanaAchievements.I_CHOOSE_YOU.id);
                        }
                    }
                    ContainmentCirclet.this.buildItemLore(stack, serverWorld.method_8503());
                    class_1269.class_9860 class_98602 = class_1269.field_52422;
                    return class_98602;
                }
            }
            return class_1269.field_5811;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            boolean heals;
            class_3218 serverWorld;
            block6: {
                block5: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block5;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block6;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            float hp = ArcanaItem.getFloatProperty(stack, ContainmentCirclet.HP_TAG);
            float maxHp = ArcanaItem.getFloatProperty(stack, ContainmentCirclet.MAX_HP_TAG);
            boolean bl = heals = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.HEALING_CIRCLET.id) > 0;
            if (heals && player.method_5682().method_3780() % 1200 == 0) {
                ArcanaItem.putProperty(stack, ContainmentCirclet.HP_TAG, Math.min(maxHp, hp + 1.0f));
                ContainmentCirclet.this.buildItemLore(stack, serverWorld.method_8503());
            }
        }

        public class_1799 method_7854() {
            return ContainmentCirclet.this.prefItem;
        }
    }
}

