/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ExoticMatter
extends EnergyItem {
    public static final String ID = "exotic_matter";
    private static final double[] lvlMultiplier = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 5.0};

    public ExoticMatter() {
        this.id = ID;
        this.name = "Exotic Matter";
        this.rarity = ArcanaRarity.MUNDANE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.initEnergy = 600000;
        this.vanillaItem = class_1802.field_8238;
        this.item = new ExoticMatterItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.exotic_matter", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_TEMPORAL_MOMENT, ResearchTasks.OBTAIN_CLOCK, ResearchTasks.ADVANCEMENT_SLEEP_IN_BED, ResearchTasks.OBTAIN_END_CRYSTAL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"strange matter").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" seems to warp ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"spacetime").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Perhaps it could be ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"useful").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})).method_10852((class_2561)class_2561.method_43470((String)" for something...").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Used as ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"fuel").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" for the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Continuum Anchor").method_27692(class_124.field_1058)));
        lore.add(class_2561.method_43470((String)""));
        String timeText = itemStack == null ? "7 Days" : this.getDuration(itemStack);
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Fuel - ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)timeText).method_27692(class_124.field_1078)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_1799 newStack = super.updateItem(stack, server);
        this.setFuel(newStack, this.getEnergy(newStack));
        return this.buildItemLore(newStack, server);
    }

    @Override
    public class_1799 onAugment(class_1799 stack, ArcanaAugment augment, int level) {
        if (ArcanaItemUtils.identifyItem(stack) instanceof ExoticMatter && augment == ArcanaAugments.TIME_IN_A_BOTTLE) {
            this.setFuel(stack, this.getMaxEnergy(stack));
        }
        return stack;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int level = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.TIME_IN_A_BOTTLE.id));
        return (int)(600000.0 * lvlMultiplier[level]);
    }

    public int useFuel(class_1799 item, int fuel) {
        int newFuel = class_3532.method_15340((int)(this.getEnergy(item) - fuel), (int)0, (int)this.getMaxEnergy(item));
        this.setEnergy(item, newFuel);
        this.buildItemLore(item, ArcanaNovum.SERVER);
        return newFuel;
    }

    public void setFuel(class_1799 item, int fuel) {
        int newFuel = class_3532.method_15340((int)fuel, (int)0, (int)this.getMaxEnergy(item));
        this.setEnergy(item, newFuel);
        this.buildItemLore(item, ArcanaNovum.SERVER);
    }

    public String getDuration(class_1799 item) {
        int energy = this.getEnergy(item);
        String duration = energy >= 172800 ? energy / 86400 + 1 + " Days" : (energy >= 6000 ? energy / 3600 + 1 + " Hours" : (energy >= 100 ? energy / 60 + 1 + " Minutes" : energy + " Seconds"));
        return duration;
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Exotic Matter").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThe components of this matter seem to spontaneously warp spacetime when combined with a Temporal Moment. Perhaps this can be exploited\u2026").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 8);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 8);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8477, 2);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8301, 2);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.TEMPORAL_MOMENT, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, a}, {d, a, d, a, b}, {c, d, m, d, c}, {b, a, d, a, d}, {a, d, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    public class ExoticMatterItem
    extends ArcanaPolymerItem {
        public ExoticMatterItem() {
            super(ExoticMatter.this.getThis());
        }

        public class_1799 method_7854() {
            return ExoticMatter.this.prefItem;
        }
    }
}

