/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerMaceItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.tracker.PlayerMovementEntry;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10124;
import net.minecraft.class_10590;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2431;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GravitonMaul
extends ArcanaItem {
    public static final String ID = "graviton_maul";
    public static final String FALL_START_HEIGHT_TAG = "fallStart";

    public GravitonMaul() {
        this.id = ID;
        this.name = "Graviton Maul";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_49814;
        this.item = new GravitonMaulItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.graviton_maul", (String)this.name).method_27692(class_124.field_1067).method_54663(1387734);
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_MACE, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.OBTAIN_NETHER_STAR, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.ADVANCEMENT_OVER_OVERKILL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        GravitonMaul.putProperty(stack, "mode", 0);
        GravitonMaul.putProperty(stack, FALL_START_HEIGHT_TAG, Double.NaN);
        this.setPrefStack(stack);
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        int mode = GravitonMaul.getIntProperty(stack, "mode");
        double fallHeight = GravitonMaul.getDoubleProperty(stack, FALL_START_HEIGHT_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        GravitonMaul.putProperty(newStack, "mode", mode);
        GravitonMaul.putProperty(newStack, FALL_START_HEIGHT_TAG, fallHeight);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"heavy core").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" has been brought to its ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"limit").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", becoming a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"singularity").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"maul ").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)"acts as a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"mace ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"combined with an ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"axe").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"maul ").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)"can ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"disable shields").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" and deal ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"massive damage").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" while falling.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"maul's ").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)"gravity well").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" can ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"fell trees").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" in a single blow.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Clicking").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" with the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"maul ").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)"launches ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"you in the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"air").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Clicking in the air").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"rockets ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"you ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"downward").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", causing a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"powerful impact").method_54663(1387734)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void finalizePrefItem(MinecraftServer server) {
        super.finalizePrefItem(server);
        class_1799 curPrefItem = this.getPrefItem();
        curPrefItem.method_57379(class_9334.field_49633, (Object)MinecraftUtils.makeEnchantComponent((class_1889[])new class_1889[]{new class_1889(MinecraftUtils.getEnchantment((class_5455)server.method_30611(), (class_5321)class_1893.field_50158), 5)}));
        this.prefItem = this.buildItemLore(curPrefItem, server);
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 maceStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        newArcanaItem.method_7978(MinecraftUtils.getEnchantment((class_5321)class_1893.field_50158), 5);
        if (maceStack.method_7942()) {
            for (class_6880 enchantment : maceStack.method_58657().method_57534()) {
                if (!class_1890.method_8201((Collection)newArcanaItem.method_58657().method_57534(), (class_6880)enchantment)) continue;
                newArcanaItem.method_7978(enchantment, maceStack.method_58657().method_57536(enchantment));
            }
        }
        if (GravitonMaul.hasProperty(maceStack, EnhancedStatUtils.ENHANCED_STAT_TAG)) {
            EnhancedStatUtils.enhanceItem(newArcanaItem, GravitonMaul.getDoubleProperty(maceStack, EnhancedStatUtils.ENHANCED_STAT_TAG));
        }
        return newArcanaItem;
    }

    public void treeFell(class_1937 world, class_1657 player, class_1799 item, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2248 type = world.method_8320(pos).method_26204();
        if (!world.method_8320(pos).method_26164(class_3481.field_15475)) {
            return;
        }
        int maxBlocks = 128;
        LinkedList queue = Lists.newLinkedList();
        LinkedList visited = Lists.newLinkedList();
        queue.add(new class_3545((Object)pos, (Object)0));
        ArrayList<class_2338> toMine = new ArrayList<class_2338>();
        while (!queue.isEmpty()) {
            class_3545 pair = (class_3545)queue.poll();
            class_2338 blockPos = (class_2338)pair.method_15442();
            int depth = (Integer)pair.method_15441();
            visited.add(blockPos);
            class_2248 curType = world.method_8320(blockPos).method_26204();
            if (curType != type || toMine.contains(blockPos)) continue;
            toMine.add(blockPos);
            if (toMine.size() >= maxBlocks) break;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0) continue;
                        class_2338 pos2 = blockPos.method_10069(i, j, k);
                        if (!queue.stream().noneMatch(p -> ((class_2338)p.method_15442()).equals((Object)pos2)) || visited.contains(pos2)) continue;
                        queue.add(new class_3545((Object)pos2, (Object)(depth + 1)));
                    }
                }
            }
        }
        ArrayList drops = new ArrayList();
        class_1799 veinAxe = new class_1799((class_1935)class_1802.field_22025);
        for (class_2338 blockPos : toMine) {
            drops.addAll(class_2248.method_9609((class_2680)world.method_8320(blockPos), (class_3218)serverWorld, (class_2338)blockPos, null, (class_1297)player, (class_1799)veinAxe));
            world.method_8651(blockPos, false, (class_1297)player);
            if (!(type instanceof class_2431)) continue;
            class_2431 experienceBlock = (class_2431)type;
            experienceBlock.method_9565(world.method_8320(blockPos), serverWorld, pos, veinAxe, true);
        }
        for (class_1799 stack : drops) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack);
        }
    }

    private List<class_1297> getAffectedEntities(class_3222 player, boolean includePlayer, double range) {
        ArrayList<class_1297> entities = new ArrayList<class_1297>(player.method_51469().method_8333((class_1297)player, player.method_5829().method_1014(range * 2.0), e -> (double)e.method_5739((class_1297)player) <= range));
        if (includePlayer) {
            entities.add((class_1297)player);
        }
        return entities;
    }

    private void gravityEffects(class_3222 player, class_1799 stack) {
        boolean domain;
        int mode = GravitonMaul.getIntProperty(stack, "mode");
        boolean bl = domain = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.GRAVITIC_DOMAIN) > 0;
        if (mode == 0) {
            for (class_1297 class_12972 : domain ? this.getAffectedEntities(player, true, 3.5) : List.of(player)) {
                class_12972.method_5762(0.0, 0.085, 0.0);
                if (class_12972 instanceof class_3222) {
                    class_3222 affectedPlayer = (class_3222)class_12972;
                    affectedPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)affectedPlayer));
                    affectedPlayer.field_13987.field_14138 = 0;
                }
                if (class_12972.field_5992 && !class_12972.field_36331 && class_12972 instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)class_12972;
                    livingEntity.method_64397(player.method_51469(), player.method_48923().method_48828(), 2.0f);
                    if ((double)livingEntity.method_6032() < 2.0 && livingEntity instanceof class_3222) {
                        class_3222 affectedPlayer = (class_3222)livingEntity;
                        ArcanaAchievements.grant(affectedPlayer, ArcanaAchievements.RAISE_THE_ROOF);
                    }
                }
                player.method_51469().method_65096((class_2394)class_2398.field_50247, class_12972.method_23317(), class_12972.method_23318() + (double)(class_12972.method_17682() / 2.0f), class_12972.method_23321(), 5, (double)(class_12972.method_17681() / 2.0f), (double)(class_12972.method_17682() / 2.0f), (double)(class_12972.method_17681() / 2.0f), 0.01);
            }
        } else if (mode == 1) {
            for (class_1297 class_12973 : domain ? this.getAffectedEntities(player, true, 3.5) : List.of(player)) {
                player.method_51469().method_65096((class_2394)class_2398.field_50247, class_12973.method_23317(), class_12973.method_23318() + (double)(class_12973.method_17682() / 2.0f), class_12973.method_23321(), 5, (double)(class_12973.method_17681() / 2.0f), (double)(class_12973.method_17682() / 2.0f), (double)(class_12973.method_17681() / 2.0f), 0.01);
            }
            if (player.method_24828()) {
                if (player.method_6048() >= 11) {
                    double impactVel = class_3532.method_15350((double)((PlayerMovementEntry)BorisLib.PLAYER_MOVEMENT_TRACKER.get(player)).velocity().method_10214(), (double)-3.0, (double)-0.5);
                    double radius = 3.0 - impactVel;
                    double totalDmg = 0.0;
                    for (class_1297 affectedEntity : this.getAffectedEntities(player, false, radius)) {
                        class_243 diff = player.method_19538().method_1020(affectedEntity.method_19538());
                        double multiplier = class_3532.method_15350((double)(diff.method_1033() * 0.2), (double)0.03, (double)2.0);
                        class_243 motion = diff.method_1029().method_18805(-multiplier, 0.0, -multiplier).method_1031(0.0, radius * 0.15, 0.0);
                        affectedEntity.method_5762(motion.field_1352, motion.field_1351, motion.field_1350);
                        if (affectedEntity instanceof class_3222) {
                            class_3222 affectedPlayer = (class_3222)affectedEntity;
                            affectedPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)affectedPlayer));
                        }
                        if (!(affectedEntity instanceof class_1309)) continue;
                        class_1309 livingEntity = (class_1309)affectedEntity;
                        livingEntity.method_64397(player.method_51469(), player.method_48923().method_48798((class_1297)player), (float)radius);
                        totalDmg += radius;
                    }
                    ArcanaNovum.data((class_1657)player).addXP((int)Math.min((double)ArcanaConfig.getInt(ArcanaRegistry.GRAVITON_MAUL_IMPACT_DAMAGE_PER_10) * totalDmg / 10.0, (double)ArcanaConfig.getInt(ArcanaRegistry.GRAVITON_MAUL_IMPACT_DAMAGE_CAP)));
                    ArcanaEffectUtils.gravitonMaulSlam(player.method_51469(), player.method_23312(), radius, 0);
                    player.method_6075();
                    player.method_7357().method_62835(stack, 40);
                } else {
                    player.method_6075();
                    player.method_7357().method_62835(stack, 5);
                }
                double fallStart = GravitonMaul.getDoubleProperty(stack, FALL_START_HEIGHT_TAG);
                if (!Double.isNaN(fallStart)) {
                    if (fallStart - player.method_23318() >= 300.0) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.QUICK_WAY_DOWN);
                    }
                    GravitonMaul.putProperty(stack, FALL_START_HEIGHT_TAG, Double.NaN);
                }
            }
        } else if (mode == 2) {
            for (class_1297 class_12974 : this.getAffectedEntities(player, false, 5.5)) {
                class_243 diff = class_12974.method_19538().method_1020(player.method_19538().method_1031(0.0, 0.1, 0.0));
                double multiplier = class_3532.method_15350((double)(diff.method_1033() * 0.2), (double)0.03, (double)2.0);
                class_243 motion = diff.method_1031(0.0, 0.0, 0.0).method_1029().method_1021(-multiplier);
                class_12974.method_18800(motion.field_1352, motion.field_1351, motion.field_1350);
                if (class_12974 instanceof class_3222) {
                    class_3222 affectedPlayer = (class_3222)class_12974;
                    affectedPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)affectedPlayer));
                }
                if (!(class_12974 instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)class_12974;
                class_1293 amp = new class_1293(ArcanaRegistry.DAMAGE_AMP_EFFECT, 10, 1, false, true, true);
                livingEntity.method_6092(amp);
                livingEntity.method_64397(player.method_51469(), player.method_48923().method_48823(), 1.0f);
            }
            ArcanaEffectUtils.gravitonMaulMaelstrom(player, player.method_6048());
            class_1293 res = new class_1293(class_1294.field_5907, 10, 2, false, false, true);
            class_1293 class_12932 = new class_1293(class_1294.field_5909, 10, 3, false, false, true);
            player.method_6092(res);
            player.method_6092(class_12932);
        }
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 32);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 32);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_50158), 4));
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8786, 32);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22020, 3);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_49821, 32);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_8137, 3);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_49814, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {k, l, m, l, k}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withCore().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Graviton Maul").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nAfter much experimentation with the Heavy Core, I have brought it to its apex. A singularity, a point of infinite density, contained by an Arcane casing. Gravity itself is at my will.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Graviton Maul").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nThe Maul is an empowered mace that has damage that scales with fall height. To aid in this ability, Using the Maul while on the ground causes a localized lapse in gravity, sending me into the air.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Graviton Maul").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nHowever, I have to be careful not to hit my head on the ceiling. As to not give my foe time to react, I can Use the Maul in the air to amplify gravity and rapidly send me downwards. Impacting the ground causes damage to nearby creatures. ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Graviton Maul").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nThe Maul\u2019s immense gravity also gives it the heft to fell entire trees at once and bust through shields.").method_27692(class_124.field_1074)));
        return list;
    }

    public class GravitonMaulItem
    extends ArcanaPolymerMaceItem {
        public GravitonMaulItem() {
            super(GravitonMaul.this.getThis(), GravitonMaul.this.getEquipmentArcanaItemComponents().method_57349(class_9334.field_50077, (Object)new class_9424(List.of(), 1.0f, 2, false)).method_57349(class_9334.field_53964, (Object)class_10124.method_62850().method_62852(72000.0f).method_62853(class_1839.field_8953).method_62855(class_7923.field_41172.method_47983((Object)class_3417.field_26980)).method_62851()).method_57349(class_9334.field_55878, (Object)new class_10590(1, 7.5f)).method_57348(class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(field_8006, 5.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(field_8001, (double)-3.4f, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_49077, new class_1322(class_2960.method_60655((String)"arcananovum", (String)GravitonMaul.this.id), (double)-0.8f, class_1322.class_1323.field_6331), class_9274.field_49217).method_57486()).method_61649(15));
        }

        public class_1799 method_7854() {
            return GravitonMaul.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            if (player.method_24828()) {
                boolean maelstrom;
                boolean bl = maelstrom = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SINGULARITY_MAELSTROM) > 0;
                if (maelstrom && player.method_5715()) {
                    ArcanaItem.putProperty(stack, "mode", 2);
                } else {
                    ArcanaItem.putProperty(stack, "mode", 0);
                    boolean domain = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.GRAVITIC_DOMAIN) > 0;
                    for (class_1297 class_12972 : domain ? GravitonMaul.this.getAffectedEntities(player, true, 3.5) : List.of(player)) {
                        if (class_12972.method_18798().method_10214() < 0.75) {
                            class_12972.method_18799(class_12972.method_18798().method_18805(1.0, 0.0, 1.0).method_1031(0.0, 0.75, 0.0));
                        }
                        if (!(class_12972 instanceof class_3222)) continue;
                        class_3222 affectedPlayer = (class_3222)class_12972;
                        affectedPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)affectedPlayer));
                    }
                    ArcanaEffectUtils.circle((class_3218)player.method_51469(), null, (class_243)player.method_19538().method_1031(0.0, 0.25, 0.0), (class_2394)class_2398.field_50247, (double)(domain ? 3.5 : 0.5), (int)40, (int)5, (double)0.1, (double)0.01);
                }
            } else {
                ArcanaItem.putProperty(stack, "mode", 1);
                ArcanaItem.putProperty(stack, GravitonMaul.FALL_START_HEIGHT_TAG, player.method_23318());
                boolean domain = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.GRAVITIC_DOMAIN) > 0;
                for (class_1297 class_12973 : domain ? GravitonMaul.this.getAffectedEntities(player, true, 3.5) : List.of(player)) {
                    if (class_12973.method_18798().method_10214() > -1.0) {
                        class_12973.method_18799(class_12973.method_18798().method_18805(1.0, 0.0, 1.0).method_1031(0.0, -1.0, 0.0));
                    }
                    if (!(class_12973 instanceof class_3222)) continue;
                    class_3222 class_32222 = (class_3222)class_12973;
                    class_32222.field_13987.method_14364((class_2596)new class_2743((class_1297)class_32222));
                }
                ArcanaEffectUtils.circle((class_3218)player.method_51469(), null, (class_243)player.method_19538().method_1031(0.0, 0.25, 0.0), (class_2394)class_2398.field_50247, (double)(domain ? 3.5 : 0.5), (int)40, (int)5, (double)0.1, (double)0.01);
            }
            GravitonMaul.this.gravityEffects(player, stack);
            playerEntity.method_6019(hand);
            return class_1269.field_21466;
        }

        public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
            if (!(user instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)user;
            GravitonMaul.this.gravityEffects(player, stack);
        }

        public int method_7881(class_1799 stack, class_1309 user) {
            return 72000;
        }

        public class_1839 method_7853(class_1799 stack) {
            return class_1839.field_8953;
        }
    }
}

