/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class MagmaticEversource
extends EnergyItem {
    public static final String ID = "magmatic_eversource";
    public static final String USES_TAG = "charges";

    public MagmaticEversource() {
        this.id = ID;
        this.name = "Magmatic Eversource";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_8187;
        this.item = new MagmaticEversourceItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.magmatic_eversource", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_LAVA_BUCKET, ResearchTasks.ADVANCEMENT_OBTAIN_ANCIENT_DEBRIS, ResearchTasks.UNLOCK_TWILIGHT_ANVIL, ResearchTasks.UNLOCK_AQUATIC_EVERSOURCE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        MagmaticEversource.putProperty(stack, "mode", 0);
        MagmaticEversource.putProperty(stack, USES_TAG, 1);
        this.setPrefStack(stack);
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        int mode = MagmaticEversource.getIntProperty(stack, "mode");
        int charges = MagmaticEversource.getIntProperty(stack, USES_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        MagmaticEversource.putProperty(newStack, "mode", mode);
        MagmaticEversource.putProperty(newStack, USES_TAG, charges);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Lava ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"is harder to create than ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"water").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)", luckily there's a ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"dimension ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"made of it.").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Unfortunately, it takes ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"time ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"to pull ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"lava ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"between worlds.").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"materialize ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"or ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"dismiss ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"lava ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"from the world.").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" to switch between ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"placing ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"removing ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"lava").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        if (itemStack != null && this.getMaxCharges(itemStack) > 1) {
            int charges = MagmaticEversource.getIntProperty(itemStack, USES_TAG);
            lore.add(class_2561.method_43470((String)""));
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Charges ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)("" + charges)).method_27692(class_124.field_1061)));
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int cdLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.ERUPTION.id));
        return 30 - 8 * cdLvl;
    }

    public int getMaxCharges(class_1799 item) {
        int[] chargeCount = new int[]{1, 3, 5, 10, 25};
        return chargeCount[Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.VOLCANIC_CHAMBER.id))];
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8550, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_22021, 1);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8183, 32);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8894, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8354, 24);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8135, 48);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"      Magmatic\n    Eversource").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nMy inventory issue expands to lava as well as water. Unfortunately, there isn\u2019t lava in the air I can pull from and condense.\nA different solution is in order: The Nether.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Magmatic\n    Eversource").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nA limitless realm of molten rock that I can pull from through a microscopic portal. The only downside is that it takes time to siphon lava through the portal. The Magmatic Eversource functions exactly like the Aquatic  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Magmatic\n    Eversource").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nEversource, however it takes time to recharge after creating lava.\n\nUsing the Eversource will generate or drain lava.\nSneak Using will switch the mode of the Eversource.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class MagmaticEversourceItem
    extends ArcanaPolymerItem {
        public MagmaticEversourceItem() {
            super(MagmaticEversource.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            int mode = ArcanaItem.getIntProperty(itemStack, "mode");
            boolean onCD = ArcanaItem.getIntProperty(itemStack, MagmaticEversource.USES_TAG) <= 0;
            ArrayList<String> stringList = new ArrayList<String>();
            if (!onCD) {
                if (mode == 1) {
                    stringList.add("remove");
                } else {
                    stringList.add("place");
                }
            } else if (mode == 1) {
                stringList.add("remove_cooldown");
            } else {
                stringList.add("place_cooldown");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return MagmaticEversource.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            int maxCharges;
            int charges;
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218)) {
                return;
            }
            if (world.method_8503().method_3780() % 20 == 0 && (charges = ArcanaItem.getIntProperty(stack, MagmaticEversource.USES_TAG)) < (maxCharges = MagmaticEversource.this.getMaxCharges(stack))) {
                MagmaticEversource.this.addEnergy(stack, 1);
                if (MagmaticEversource.this.getEnergy(stack) >= MagmaticEversource.this.getMaxEnergy(stack)) {
                    MagmaticEversource.this.setEnergy(stack, 0);
                    ArcanaItem.putProperty(stack, MagmaticEversource.USES_TAG, charges + 1);
                    MagmaticEversource.this.buildItemLore(stack, entity.method_5682());
                }
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            int mode = ArcanaItem.getIntProperty(stack, "mode");
            int charges = ArcanaItem.getIntProperty(stack, MagmaticEversource.USES_TAG);
            if (playerEntity.method_5715()) {
                int newMode = (mode + 1) % 2;
                ArcanaItem.putProperty(stack, "mode", newMode);
                if (newMode == 1) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Eversource Evaporates").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15010, (float)1.0f, (float)1.0f);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Eversource Condenses").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15202, (float)1.0f, (float)1.0f);
                }
                return class_1269.field_52422;
            }
            if (mode != 1 && charges <= 0) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Eversource is Recharging").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
                return class_1269.field_5811;
            }
            Object fluid = mode == 1 ? class_3612.field_15906 : class_3612.field_15908;
            class_3965 blockHitResult = class_1755.method_7872((class_1937)world, (class_1657)playerEntity, (class_3959.class_242)(fluid == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348));
            if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
                return class_1269.field_5811;
            }
            if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
                class_2338 blockPos3;
                class_2338 blockPos = blockHitResult.method_17777();
                class_2350 direction = blockHitResult.method_17780();
                class_2338 blockPos2 = blockPos.method_10093(direction);
                if (!world.method_8505((class_1297)playerEntity, blockPos) || !playerEntity.method_7343(blockPos2, direction, stack)) {
                    return class_1269.field_5814;
                }
                if (fluid == class_3612.field_15906) {
                    class_2263 fluidDrainable;
                    class_2680 blockState = world.method_8320(blockPos);
                    class_2248 block = blockState.method_26204();
                    if (block instanceof class_2263 && !(fluidDrainable = (class_2263)block).method_9700((class_1309)playerEntity, (class_1936)world, blockPos, blockState).method_7960()) {
                        playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
                        fluidDrainable.method_32351().ifPresent(sound -> playerEntity.method_5783(sound, 1.0f, 1.0f));
                        world.method_33596((class_1297)playerEntity, (class_6880)class_5712.field_28167, blockPos);
                        return class_1269.field_52422;
                    }
                    return class_1269.field_5814;
                }
                class_2680 blockState = world.method_8320(blockPos);
                class_2338 class_23382 = blockPos3 = blockState.method_26204() instanceof class_2402 ? blockPos : blockPos2;
                if (this.placeFluid((class_3611)fluid, playerEntity, world, blockPos3, blockHitResult)) {
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.MAGMATIC_EVERSOURCE_USE));
                    ArcanaAchievements.progress(player, ArcanaAchievements.HELLGATE.id, 1);
                    ArcanaItem.putProperty(stack, MagmaticEversource.USES_TAG, charges - 1);
                    MagmaticEversource.this.buildItemLore(stack, playerEntity.method_5682());
                    playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
                    return class_1269.field_52422;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        }

        public boolean placeFluid(class_3611 fluid, @Nullable class_1657 player, class_1937 world, class_2338 pos, @Nullable class_3965 hitResult) {
            boolean bl2;
            if (!(fluid instanceof class_3609)) {
                return false;
            }
            class_3609 flowableFluid = (class_3609)fluid;
            class_2680 blockState = world.method_8320(pos);
            class_2248 block = blockState.method_26204();
            boolean bl = blockState.method_26188(fluid);
            boolean bl3 = bl2 = blockState.method_26215() || bl || block instanceof class_2402 && ((class_2402)block).method_10310((class_1309)player, (class_1922)world, pos, blockState, fluid);
            if (!bl2) {
                return hitResult != null && this.placeFluid(fluid, player, world, hitResult.method_17777().method_10093(hitResult.method_17780()), null);
            }
            if (block instanceof class_2402) {
                class_2402 fluidFillable = (class_2402)block;
                if (fluid == class_3612.field_15908) {
                    fluidFillable.method_10311((class_1936)world, pos, blockState, flowableFluid.method_15729(false));
                    world.method_8396((class_1297)player, pos, class_3417.field_15010, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_33596((class_1297)player, (class_6880)class_5712.field_28166, pos);
                    return true;
                }
            }
            if (!world.field_9236 && bl && !blockState.method_51176()) {
                world.method_22352(pos, true);
            }
            if (world.method_8652(pos, fluid.method_15785().method_15759(), 11) || blockState.method_26227().method_15771()) {
                world.method_8396((class_1297)player, pos, class_3417.field_15010, class_3419.field_15245, 1.0f, 1.0f);
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28166, pos);
                return true;
            }
            return false;
        }
    }
}

