/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import com.mojang.serialization.DynamicOps;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.shulkercore.ShulkerCoreGui;
import net.borisshoes.arcananovum.gui.shulkercore.ShulkerCoreInventoryListener;
import net.borisshoes.arcananovum.items.Soulstone;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.SoulstoneIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ShulkerCore
extends EnergyItem {
    public static final String ID = "shulker_core";
    public static final String SPEED_TAG = "speed";
    public static final String SPEED_CD_TAG = "speedCD";
    public static final String STONE_TAG = "stone";
    public static final String STONE_DATA_TAG = "stoneData";

    public ShulkerCore() {
        this.id = ID;
        this.name = "Shulker Core";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.initEnergy = 1000;
        this.vanillaItem = class_1802.field_8545;
        this.item = new ShulkerCoreItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.shulker_core", (String)this.name).method_27692(class_124.field_1067).method_54663(0xFFFF99);
        this.itemVersion = 1;
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_SOULSTONE, ResearchTasks.ADVANCEMENT_LEVITATE, ResearchTasks.EFFECT_SLOW_FALLING, ResearchTasks.UNLOCK_STELLAR_CORE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        ShulkerCore.putProperty(stack, SPEED_TAG, 1);
        ShulkerCore.putProperty(stack, SPEED_CD_TAG, 0);
        ShulkerCore.putProperty(stack, STONE_TAG, true);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shulkers ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"possess a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"unique ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"ability to defy ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"gravity").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Core ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"has ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"harnessed").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" that ability to allow ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"controlled").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" levitation").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Core").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" must be ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"refilled ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"with ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Shulkers").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to grant ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"levitation").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to change the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"speed ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"of ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"levitation").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click in off-hand ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"refill ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Core").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)""));
        int energy = itemStack != null ? this.getEnergy(itemStack) : 1000;
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shulkers Left").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("" + energy)).method_27692(class_124.field_1054)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        return Integer.MAX_VALUE;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        int speed = ShulkerCore.getIntProperty(stack, SPEED_TAG);
        int speedCD = ShulkerCore.getIntProperty(stack, SPEED_CD_TAG);
        boolean stone = ShulkerCore.getBooleanProperty(stack, STONE_TAG);
        class_2487 stoneData = ShulkerCore.getCompoundProperty(stack, STONE_DATA_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        ShulkerCore.putProperty(newStack, SPEED_TAG, speed);
        ShulkerCore.putProperty(newStack, SPEED_CD_TAG, speedCD);
        ShulkerCore.putProperty(newStack, STONE_TAG, stone);
        ShulkerCore.putProperty(newStack, STONE_DATA_TAG, (class_2520)stoneData);
        return this.buildItemLore(newStack, server);
    }

    private void changeSpeed(class_1657 playerEntity, class_1937 world, class_1268 hand) {
        int maxSpeed;
        class_1799 stack = playerEntity.method_5998(hand);
        int speed = ShulkerCore.getIntProperty(stack, SPEED_TAG);
        int speedCD = ShulkerCore.getIntProperty(stack, SPEED_CD_TAG);
        boolean reabsorb = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.LEVITATIVE_REABSORPTION.id)) >= 1;
        int n = maxSpeed = reabsorb ? 11 : 9;
        if (speedCD == 0) {
            if ((speed += 2) > maxSpeed) {
                speed = 1;
            } else if (speed < 1) {
                speed = maxSpeed;
            }
            ShulkerCore.putProperty(stack, SPEED_TAG, speed);
            ShulkerCore.putProperty(stack, SPEED_CD_TAG, 5);
            if (playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (speed == 11) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Shulker Core Mode: Reabsorption").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_6880.class_6883)class_3417.field_18308, (float)0.5f, (float)1.0f);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Shulker Core Speed: " + (speed / 2 + 1))).method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}), true);
                    float pitch = (float)(0.1875 * (double)speed + 0.3125);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_6880.class_6883)class_3417.field_14776, (float)0.5f, (float)pitch);
                }
            }
        }
    }

    private void levitate(class_1657 playerEntity, class_1937 world, class_1268 hand) {
        class_1799 stack = playerEntity.method_5998(hand);
        int speed = ShulkerCore.getIntProperty(stack, SPEED_TAG);
        int duration = 100;
        if (speed == 11) {
            if (playerEntity.method_6059(class_1294.field_5902)) {
                playerEntity.method_6016(class_1294.field_5902);
                SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_15000, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.8f);
            }
        } else if (this.getEnergy(stack) > 0) {
            class_1293 effect = playerEntity.method_6112(class_1294.field_5902);
            if (effect == null || effect.method_5579() != class_1294.field_5902 || effect.method_5578() < speed || effect.method_5584() < 10 || effect.method_5584() > 100) {
                class_1293 levit = new class_1293(class_1294.field_5902, 100, speed, false, false, false);
                double[] dArray = new double[]{0.0, 0.1, 0.25, 0.5};
                if (Math.random() >= dArray[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SHULKER_RECYCLER.id))]) {
                    this.addEnergy(stack, -(speed / 2 + 1));
                }
                playerEntity.method_6092(levit);
                SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_15000, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.8f);
                ArcanaNovum.data(playerEntity).addXP(ArcanaConfig.getInt(ArcanaRegistry.SHULKER_CORE_PER_SOUL) * (speed / 2 + 1));
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    ArcanaEffectUtils.shulkerCoreLevitate(serverWorld, playerEntity, 100);
                }
                this.buildItemLore(stack, playerEntity.method_5682());
            }
        } else {
            playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Shulker Core is empty.").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
        }
    }

    public void openGui(class_1657 playerEntity, class_1799 stack) {
        if (!(playerEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerEntity;
        ShulkerCoreGui gui = new ShulkerCoreGui(class_3917.field_17337, player, this, stack);
        boolean hasStone = ShulkerCore.getBooleanProperty(stack, STONE_TAG);
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.clearSlot(i);
        }
        GuiElementBuilder pane = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)(hasStone ? 7996617 : 2756918)));
        String paneText = hasStone ? LevelUtils.readableInt(this.getEnergy(stack)) + " Shulker Souls" : "No Soulstone Inserted";
        class_124 textColor = hasStone ? class_124.field_1054 : class_124.field_1061;
        gui.setSlot(0, (GuiElementBuilderInterface)pane.setName((class_2561)class_2561.method_43470((String)paneText).method_27692(textColor)));
        gui.setSlot(1, (GuiElementBuilderInterface)pane.setName((class_2561)class_2561.method_43470((String)paneText).method_27692(textColor)));
        gui.setSlot(3, (GuiElementBuilderInterface)pane.setName((class_2561)class_2561.method_43470((String)paneText).method_27692(textColor)));
        gui.setSlot(4, (GuiElementBuilderInterface)pane.setName((class_2561)class_2561.method_43470((String)paneText).method_27692(textColor)));
        class_1277 inv = new class_1277(1);
        ShulkerCoreInventoryListener listener = new ShulkerCoreInventoryListener(this, gui, stack);
        inv.method_5489((class_1265)listener);
        listener.setUpdating();
        gui.setSlotRedirect(2, new class_1735((class_1263)inv, 0, 0, 0));
        if (hasStone) {
            class_2487 stoneData = ShulkerCore.getCompoundProperty(stack, STONE_DATA_TAG);
            class_1799 stone = stoneData == null || stoneData.method_33133() ? Soulstone.setType(ArcanaRegistry.SOULSTONE.getNewItem(), class_1299.field_6109) : class_1799.field_24671.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)player.method_56673()), (Object)stoneData).result().orElse(class_1799.field_8037);
            stone = Soulstone.setSouls(stone, this.getEnergy(stack));
            inv.method_5447(0, stone);
            gui.validStone(stone);
        } else {
            gui.notValid();
        }
        gui.setTitle((class_2561)class_2561.method_43470((String)"Shulker Core"));
        listener.finishUpdate();
        gui.open();
    }

    public boolean hasStone(class_1799 stack) {
        return ShulkerCore.getBooleanProperty(stack, STONE_TAG);
    }

    public class_1799 getStone(class_1799 stack) {
        if (ArcanaItemUtils.identifyItem(stack) instanceof ShulkerCore && ShulkerCore.getBooleanProperty(stack, STONE_TAG)) {
            class_2487 stoneData = ShulkerCore.getCompoundProperty(stack, STONE_DATA_TAG);
            class_1799 stone = stoneData == null || stoneData.method_33133() ? Soulstone.setType(ArcanaRegistry.SOULSTONE.getNewItem(), class_1299.field_6109) : class_1799.field_24671.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)ArcanaNovum.SERVER.method_30611()), (Object)stoneData).result().orElse(class_1799.field_8037);
            stone = Soulstone.setSouls(stone, this.getEnergy(stack));
            return stone;
        }
        return null;
    }

    public void setStone(class_1799 stack, class_1799 stone) {
        if (stone == null || stone.method_7960()) {
            ShulkerCore.putProperty(stack, STONE_TAG, false);
            ShulkerCore.putProperty(stack, STONE_DATA_TAG, (class_2520)new class_2487());
            this.setEnergy(stack, 0);
        } else {
            ShulkerCore.putProperty(stack, STONE_TAG, true);
            ShulkerCore.putProperty(stack, STONE_DATA_TAG, (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)ArcanaNovum.SERVER.method_30611()), (Object)stone).getOrThrow());
            this.setEnergy(stack, Soulstone.getSouls(stone));
        }
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 soulstoneStack = inv.method_5438(12);
        class_1799 newArcanaItem = null;
        if (ArcanaItemUtils.identifyItem(soulstoneStack) instanceof Soulstone) {
            newArcanaItem = this.getNewItem();
            this.setStone(newArcanaItem, soulstoneStack);
            this.buildItemLore(newArcanaItem, ArcanaNovum.SERVER);
        }
        return newArcanaItem;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        SoulstoneIngredient t = new SoulstoneIngredient(Soulstone.tiers[4], false, true, false, class_1299.method_5890((class_1299)class_1299.field_6109).toString());
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8614, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8815, 8);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8964);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8601, 32);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8137, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, t, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withCore().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Shulker Core").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nShulkers are fascinating creatures. Their unique levitation effect could be a precursor to true flight if I combined a bit of their essence\u2026 er\u2026 a lot of their essence\u2026 What\u2019s a bit of genocide anyways?").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Shulker Core").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nAfter a massacre that took too long to comprehend, I have enough souls to control their power.\nUse the Core to grant levitation. Sneak Use to change the speed. Sneak Use in my off-hand to access the Soulstone for refuelling.").method_27692(class_124.field_1074)));
        return list;
    }

    public class ShulkerCoreItem
    extends ArcanaPolymerItem {
        public ShulkerCoreItem() {
            super(ShulkerCore.this.getThis());
        }

        public class_1799 method_7854() {
            return ShulkerCore.this.prefItem;
        }

        public class_1269 method_7884(class_1838 context) {
            class_1657 playerEntity = context.method_8036();
            class_1799 stack = context.method_8041();
            if (playerEntity != null && playerEntity.method_5715()) {
                if (context.method_20287() == class_1268.field_5808) {
                    ShulkerCore.this.changeSpeed(playerEntity, context.method_8045(), context.method_20287());
                } else {
                    ShulkerCore.this.openGui(playerEntity, stack);
                }
            } else if (playerEntity != null) {
                ShulkerCore.this.levitate(playerEntity, context.method_8045(), context.method_20287());
            }
            return class_1269.field_52422;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            if (playerEntity.method_5715()) {
                if (hand == class_1268.field_5808) {
                    ShulkerCore.this.changeSpeed(playerEntity, world, hand);
                } else {
                    ShulkerCore.this.openGui(playerEntity, playerEntity.method_5998(hand));
                }
            } else {
                ShulkerCore.this.levitate(playerEntity, world, hand);
            }
            return class_1269.field_52422;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            int speedCD = ArcanaItem.getIntProperty(stack, ShulkerCore.SPEED_CD_TAG);
            if (speedCD > 0) {
                ArcanaItem.putProperty(stack, ShulkerCore.SPEED_CD_TAG, --speedCD);
            }
        }
    }
}

