/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class Soulstone
extends ArcanaItem {
    public static final String ID = "soulstone";
    public static final String TYPE_TAG = "type";
    public static final String SOULS_TAG = "souls";
    public static final String MAX_TIER_TAG = "maxTier";
    public static final String SOULS_FROM_SPEAR_TAG = "soulsFromSpear";
    public static int[] tiers = new int[]{25, 100, 250, 500, 1000, 5000, 10000};

    public Soulstone() {
        this.id = ID;
        this.name = "Soulstone";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_8814;
        this.item = new SoulstoneItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.soulstone", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1079});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_KILL_A_MOB, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.USE_SOUL_SPEED, ResearchTasks.UNLOCK_STELLAR_CORE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        Soulstone.putProperty(stack, TYPE_TAG, "unattuned");
        Soulstone.putProperty(stack, SOULS_TAG, 0);
        Soulstone.putProperty(stack, MAX_TIER_TAG, 0);
        Soulstone.putProperty(stack, SOULS_FROM_SPEAR_TAG, 0);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The dark stone ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"crackles").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"red energy").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)SOULS_TAG).method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" of mobs ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"killed").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" seems to get ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"trapped").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" inside...").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)""));
        Object attunedString = "Unattuned";
        int souls = 0;
        int tier = 0;
        if (itemStack != null) {
            String type = Soulstone.getType(itemStack);
            souls = Soulstone.getSouls(itemStack);
            tier = Soulstone.soulsToTier(souls);
            Optional opt = class_1299.method_5898((String)type);
            if (!type.equals("unattuned") && opt.isPresent()) {
                String entityTypeName = ((class_1299)opt.get()).method_5897().getString();
                attunedString = "Attuned - " + entityTypeName;
            }
        }
        lore.add(class_2561.method_43470((String)attunedString).method_27692(class_124.field_1076));
        lore.add(class_2561.method_43470((String)("Tier " + tier + " - (" + LevelUtils.readableInt(souls) + " Mobs Killed)")).method_27692(class_124.field_1080));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        int souls = Soulstone.getIntProperty(stack, SOULS_TAG);
        int maxTier = Soulstone.getIntProperty(stack, MAX_TIER_TAG);
        int soulsFromSpear = Soulstone.getIntProperty(stack, SOULS_FROM_SPEAR_TAG);
        String type = Soulstone.getStringProperty(stack, TYPE_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        Soulstone.putProperty(newStack, TYPE_TAG, type);
        Soulstone.putProperty(newStack, SOULS_TAG, souls);
        Soulstone.putProperty(newStack, MAX_TIER_TAG, maxTier);
        Soulstone.putProperty(newStack, SOULS_FROM_SPEAR_TAG, soulsFromSpear);
        return this.buildItemLore(newStack, server);
    }

    public void killedEntity(class_3218 world, class_3222 player, class_1309 dead, class_1799 stone, class_1799 weapon) {
        int tier;
        int souls = Soulstone.getIntProperty(stone, SOULS_TAG);
        int maxTier = Soulstone.getIntProperty(stone, MAX_TIER_TAG);
        int soulsFromSpear = Soulstone.getIntProperty(stone, SOULS_FROM_SPEAR_TAG);
        if (weapon == null) {
            weapon = class_1799.field_8037;
        }
        String entityTypeId = class_1299.method_5890((class_1299)dead.method_5864()).toString();
        int toAdd = (new int[]{1, 2, 3, 4, 5, 10})[Math.max(0, ArcanaAugments.getAugmentOnItem(stone, ArcanaAugments.SOUL_REAPER.id))];
        if (weapon.method_31574(ArcanaRegistry.SPEAR_OF_TENBROUS.getItem())) {
            if (ArcanaAugments.getAugmentOnItem(weapon, ArcanaAugments.ETERNAL_CRUELTY) > 0) {
                toAdd *= 2;
            }
            soulsFromSpear += toAdd;
        }
        if ((tier = Soulstone.soulsToTier(souls += toAdd)) != Soulstone.soulsToTier(souls - toAdd)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Your Soulstone crackles with new power!").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23116, (float)1.0f, (float)1.0f);
            if (tier > maxTier) {
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.SOULSTONE_LEVEL_UP_PER_SOUL) * souls);
                Soulstone.putProperty(stone, MAX_TIER_TAG, tier);
            }
            if (tier == 7) {
                ArcanaAchievements.grant(player, ArcanaAchievements.PRIME_EVIL);
                if (Soulstone.soulsToTier(soulsFromSpear) == 7) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.HISTORY_CARVED_IN_STONE);
                }
            }
            if (tier == 5) {
                ArcanaAchievements.grant(player, ArcanaAchievements.PHILOSOPHER_STONE);
            }
            if (tier == 3 && entityTypeId.equals(class_1299.method_5890((class_1299)class_1299.field_6077).toString())) {
                ArcanaAchievements.grant(player, ArcanaAchievements.TOOK_A_VILLAGE);
            }
        }
        Soulstone.putProperty(stone, SOULS_FROM_SPEAR_TAG, soulsFromSpear);
        Soulstone.putProperty(stone, SOULS_TAG, souls);
        this.buildItemLore(stone, player.method_5682());
    }

    public static String getType(class_1799 stack) {
        if (!(ArcanaItemUtils.identifyItem(stack) instanceof Soulstone)) {
            return "unattuned";
        }
        String type = Soulstone.getStringProperty(stack, TYPE_TAG);
        return type == null || type.isBlank() ? "unattuned" : type;
    }

    public static class_1799 setType(class_1799 stack, class_1299<?> type) {
        if (!(ArcanaItemUtils.identifyItem(stack) instanceof Soulstone)) {
            return null;
        }
        class_1799 item = stack.method_7972();
        String entityTypeId = class_1299.method_5890(type).toString();
        Soulstone.putProperty(item, TYPE_TAG, entityTypeId);
        return ArcanaRegistry.SOULSTONE.buildItemLore(item, ArcanaNovum.SERVER);
    }

    public static class_1799 setUnattuned(class_1799 stack) {
        if (!(ArcanaItemUtils.identifyItem(stack) instanceof Soulstone)) {
            return null;
        }
        class_1799 item = Soulstone.setSouls(stack, 0);
        Soulstone.putProperty(item, TYPE_TAG, "unattuned");
        return ArcanaRegistry.SOULSTONE.buildItemLore(item, ArcanaNovum.SERVER);
    }

    public static int getSouls(class_1799 item) {
        if (!(ArcanaItemUtils.identifyItem(item) instanceof Soulstone)) {
            return -1;
        }
        return Soulstone.getIntProperty(item, SOULS_TAG);
    }

    public static class_1799 setSouls(class_1799 stack, int newSouls) {
        if (!(ArcanaItemUtils.identifyItem(stack) instanceof Soulstone)) {
            return null;
        }
        class_1799 item = stack.method_7972();
        newSouls = class_3532.method_15340((int)newSouls, (int)0, (int)Integer.MAX_VALUE);
        Soulstone.putProperty(item, SOULS_TAG, newSouls);
        Soulstone.putProperty(item, SOULS_FROM_SPEAR_TAG, Math.min(Soulstone.getIntProperty(item, SOULS_FROM_SPEAR_TAG), newSouls));
        return ArcanaRegistry.SOULSTONE.buildItemLore(item, ArcanaNovum.SERVER);
    }

    public static class_1799 getShowcaseItem(int souls, @Nullable String typeId) {
        class_1799 item = ArcanaRegistry.SOULSTONE.getItem().method_7854().method_7972();
        if (typeId != null && class_1299.method_5898((String)typeId).isPresent()) {
            class_1299 type = (class_1299)class_1299.method_5898((String)typeId).get();
            item = Soulstone.setType(item, type);
        }
        item = Soulstone.setSouls(item, souls);
        return ArcanaRegistry.SOULSTONE.buildItemLore(item, ArcanaNovum.SERVER);
    }

    public static int soulsToTier(int souls) {
        for (int i = 0; i < tiers.length; ++i) {
            if (souls >= tiers[i] || souls >= tiers[i]) continue;
            return i;
        }
        return tiers.length;
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"     Soulstone").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nI have found that souls contain a unique flavor of Arcana, a quite powerful one at that. If I am to be surrounded by death, I might as well use it. Now, how to imprison a soul\u2026\nA seemingly impossible  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"     Soulstone").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\ntask if it weren\u2019t for some materials the Nether-dwellers have been working with for eons. Soulsand seems to have souls naturally imbued in it, perhaps from ancient battles?\nCombining this with Crying Obsidian and Netherite yields a \n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"     Soulstone").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nStone that can act as an inescapable bulk prison for souls of a single variety. I know not why soul types refuse to combine.\n\nThe Soulstone should be able to attune to a type of mob by merely using it to draw blood.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"     Soulstone").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nAfter that, any souls of that type that are freed from their mortal prisons should be sucked into the Stone like a black hole, never to be released\u2026\n\nUntil I find a way to use them\u2026\n").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_20410, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8067, 32);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_22018, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, c, h, c, b}, {c, h, m, h, c}, {b, c, h, c, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withCore().withAnvil());
    }

    public class SoulstoneItem
    extends ArcanaPolymerItem {
        public SoulstoneItem() {
            super(Soulstone.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack) || Soulstone.getType(itemStack).equals("unattuned")) {
                return baseStack;
            }
            ArrayList<CallSite> stringList = new ArrayList<CallSite>();
            int tier = Soulstone.soulsToTier(Soulstone.getSouls(itemStack));
            stringList.add((CallSite)((Object)("" + tier)));
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return Soulstone.this.prefItem;
        }

        public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
            if (!(attacker instanceof class_1657)) {
                return;
            }
            class_1657 playerEntity = (class_1657)attacker;
            String type = ArcanaItem.getStringProperty(stack, Soulstone.TYPE_TAG);
            if (type.equals("unattuned") && target instanceof class_1308) {
                class_1308 attackedEntity = (class_1308)target;
                if (playerEntity instanceof class_3222) {
                    class_3222 player = (class_3222)playerEntity;
                    if (attackedEntity.method_5864().method_20210(ArcanaRegistry.SOULSTONE_DISALLOWED)) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Soulstone cannot attune to this creature.").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056}), true);
                    } else {
                        String entityTypeId = class_1299.method_5890((class_1299)attackedEntity.method_5864()).toString();
                        String entityTypeName = ((class_1299)class_1299.method_5898((String)entityTypeId).get()).method_5897().getString();
                        ArcanaItem.putProperty(stack, Soulstone.TYPE_TAG, entityTypeId);
                        Soulstone.this.buildItemLore(stack, player.method_5682());
                        player.method_7353((class_2561)class_2561.method_43470((String)("The Soulstone attunes to the essence of " + entityTypeName)).method_27695(new class_124[]{class_124.field_1079, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23118, (float)1.0f, (float)0.5f);
                    }
                }
            }
        }
    }
}

