/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;

public class BlinkArrows
extends RunicArrow {
    public static final String ID = "blink_arrows";
    private static final int[] phaseDur = new int[]{0, 20, 60, 100};

    public BlinkArrows() {
        this.id = ID;
        this.name = "Blink Arrows";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new BlinkArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.blink_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1062});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.USE_ENDER_PEARL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Blink Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1062}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" take after ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"Ender Pearls").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Upon ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"impact ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"or ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"hitting a target").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" you get ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"teleported").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to the ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"arrow").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_243 tpPos = entityHitResult.method_17784();
            if (tpPos.method_1022(player.method_19538()) >= 100.0) {
                ArcanaAchievements.grant(player, ArcanaAchievements.NOW_YOU_SEE_ME.id);
            }
            player.method_61275(new class_5454(player.method_51469(), tpPos.method_1031(0.0, 0.25, 0.0), class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52245));
            ArcanaEffectUtils.blinkArrowTp(player.method_51469(), player.method_19538());
            SoundUtils.playSound((class_1937)arrow.method_37908(), (class_2338)player.method_24515(), (class_3414)class_3417.field_14879, (class_3419)class_3419.field_15248, (float)0.8f, (float)0.9f);
            int phaseLvl = arrow.getAugment(ArcanaAugments.PHASE_IN.id);
            class_1293 invuln = new class_1293(class_1294.field_5907, phaseDur[phaseLvl], 3, false, false, true);
            player.method_6092(invuln);
        }
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_243 offset = new class_243(blockHitResult.method_17780().method_23955());
            class_243 tpPos = blockHitResult.method_17784().method_1019(offset);
            if (tpPos.method_1022(player.method_19538()) >= 100.0) {
                ArcanaAchievements.grant(player, ArcanaAchievements.NOW_YOU_SEE_ME.id);
            }
            player.method_61275(new class_5454(player.method_51469(), tpPos.method_1031(0.0, 0.25, 0.0), class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52245));
            ArcanaEffectUtils.blinkArrowTp(player.method_51469(), player.method_19538());
            SoundUtils.playSound((class_1937)arrow.method_37908(), (class_2338)player.method_24515(), (class_3414)class_3417.field_14879, (class_3419)class_3419.field_15248, (float)0.8f, (float)0.9f);
            int phaseLvl = arrow.getAugment(ArcanaAugments.PHASE_IN.id);
            class_1293 invuln = new class_1293(class_1294.field_5907, phaseDur[phaseLvl], 3, false, false, true);
            player.method_6092(invuln);
        }
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8634, 8);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, c, h, c, a}, {c, h, m, h, c}, {a, c, h, c, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Blink Arrows").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis Runic Matrix has been configured for invoking teleportation spells, and now the arrows act like a thrown Ender Pearl.").method_27692(class_124.field_1074)));
        return list;
    }

    public class BlinkArrowsItem
    extends ArcanaPolymerArrowItem {
        public BlinkArrowsItem() {
            super(BlinkArrows.this.getThis(), BlinkArrows.this.getArcanaArrowItemComponents(1404502));
        }

        public class_1799 method_7854() {
            return BlinkArrows.this.prefItem;
        }
    }
}

