/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.RepeatTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class EnsnarementArrows
extends RunicArrow {
    public static final String ID = "ensnarement_arrows";

    public EnsnarementArrows() {
        this.id = ID;
        this.name = "Ensnarement Arrows";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new EnsnarementArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.ensnarement_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1064});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.EFFECT_SLOWNESS};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Ensnarement Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1064}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" restrain ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"target ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"from ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"moving ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"of their own will.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Arrows ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"have a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"reduced effect").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" on ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"players").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        int entrapment = arrow.getAugment(ArcanaAugments.ENTRAPMENT.id);
        boolean anchor = arrow.getAugment(ArcanaAugments.ETHEREAL_ANCHOR.id) > 0;
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            int duration = living instanceof class_3222 ? entrapment + 1 : (entrapment + 1) * 5;
            living.method_37222(new class_1293(ArcanaRegistry.ENSNAREMENT_EFFECT, duration * 20, anchor ? 1 : 0), arrow.method_24921());
            class_1297 class_12973 = arrow.method_24921();
            if (class_12973 instanceof class_3222) {
                class_3222 player = (class_3222)class_12973;
                if (living.method_5669() <= 0) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.WATERBOARDING.id);
                }
                if (!ArcanaAchievements.isTimerActive(player, ArcanaAchievements.SHACKLED.id)) {
                    ArcanaAchievements.progress(player, ArcanaAchievements.SHACKLED.id, 10);
                    BorisLib.addTickTimerCallback((TickTimerCallback)new RepeatTimer(10, 120, () -> {
                        if (living.method_5805() && living.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT) != null) {
                            ArcanaAchievements.progress(player, ArcanaAchievements.SHACKLED.id, 10);
                        } else {
                            ArcanaAchievements.reset(player, ArcanaAchievements.SHACKLED.id);
                        }
                    }, null));
                }
            }
        }
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_22421, 24);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8786, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8976);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, g, a}, {k, h, m, h, k}, {a, g, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Ensnarement\n       Arrows").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThese arrows unleash Arcane chains around the target creature. These chains fully stop the creature from moving of their own will. They are still affected by the ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Ensnarement\n       Arrows").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nenvironment. Players are affected less.").method_27692(class_124.field_1074)));
        return list;
    }

    public class EnsnarementArrowsItem
    extends ArcanaPolymerArrowItem {
        public EnsnarementArrowsItem() {
            super(EnsnarementArrows.this.getThis(), EnsnarementArrows.this.getArcanaArrowItemComponents(5046527));
        }

        public class_1799 method_7854() {
            return EnsnarementArrows.this.prefItem;
        }
    }
}

