/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.catalysts;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.entities.NulConstructEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2276;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2700;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class SovereignCatalyst
extends ArcanaItem {
    public static final String ID = "sovereign_catalyst";

    public SovereignCatalyst() {
        this.id = ID;
        this.name = "Sovereign Augment Catalyst";
        this.rarity = ArcanaRarity.MUNDANE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.CATALYSTS};
        this.vanillaItem = class_1802.field_8695;
        this.item = new SovereignCatalystItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.sovereign_catalyst", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_EXOTIC_CATALYST, ResearchTasks.OBTAIN_GOLD_INGOT, ResearchTasks.UNLOCK_TWILIGHT_ANVIL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Augment ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Catalysts").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" can be used to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"augment ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"your ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Augments ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"require more ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"powerful ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Catalysts ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"at higher levels").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Apply ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"these ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Catalysts ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"in the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Tinkering Menu").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" of a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Twilight Anvil").method_27692(class_124.field_1060)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8281, 24);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_22421, 24);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8695, 12);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.EXOTIC_CATALYST, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, g, a}, {c, h, m, h, c}, {a, g, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"     Sovereign\n   Augmentation\n      Catalyst").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nGOLD! The gemstones already provide enough reinforcement. Gold lets the energy be more malleable to more creative applications. But, I ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"     Sovereign\n   Augmentation\n      Catalyst").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nthink there\u2019s a little more potential here\u2026").method_27692(class_124.field_1074)));
        return list;
    }

    public class SovereignCatalystItem
    extends ArcanaPolymerItem {
        public SovereignCatalystItem() {
            super(SovereignCatalyst.this.getThis());
        }

        public class_1799 method_7854() {
            return SovereignCatalyst.this.prefItem;
        }

        public class_1269 method_7884(class_1838 context) {
            class_2700 pattern;
            class_2700.class_2702 patternResult;
            boolean canSpawn;
            class_1937 world = context.method_8045();
            class_1657 playerEntity = context.method_8036();
            class_2338 pos = context.method_8037();
            class_2680 state = world.method_8320(pos);
            boolean bl = canSpawn = world.method_8407() != class_1267.field_5801;
            if (canSpawn && playerEntity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)playerEntity;
                canSpawn = ArcanaNovum.data((class_1657)serverPlayer).hasResearched(ArcanaRegistry.DIVINE_CATALYST);
            }
            if (state.method_27852(class_2246.field_22108) && pos.method_10264() >= world.method_31607() && canSpawn && (patternResult = (pattern = NulConstructEntity.getConstructPattern()).method_11708((class_4538)world, pos.method_10069(-1, -1, -1))) != null) {
                NulConstructEntity constructEntity = (NulConstructEntity)ArcanaRegistry.NUL_CONSTRUCT_ENTITY.method_5883(world, class_3730.field_16461);
                if (constructEntity != null && world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    class_2276.method_45454((class_1937)world, (class_2700.class_2702)patternResult);
                    class_2338 blockPos = patternResult.method_11717(1, 1, 0).method_11683();
                    constructEntity.method_5808((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.55, (double)blockPos.method_10260() + 0.5, patternResult.method_11719().method_10166() == class_2350.class_2351.field_11048 ? 0.0f : 90.0f, 0.0f);
                    constructEntity.field_6283 = patternResult.method_11719().method_10166() == class_2350.class_2351.field_11048 ? 0.0f : 90.0f;
                    constructEntity.onSummoned(playerEntity);
                    world.method_8649((class_1297)constructEntity);
                    class_2276.method_45456((class_1937)world, (class_2700.class_2702)patternResult);
                    if (playerEntity instanceof class_3222) {
                        class_3222 player = (class_3222)playerEntity;
                        ArcanaAchievements.grant(player, ArcanaAchievements.DOOR_OF_DIVINITY.id);
                    }
                    context.method_8041().method_7934(1);
                }
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }
    }
}

