/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class CetaceaCharm
extends ArcanaItem {
    public static final String ID = "cetacea_charm";

    public CetaceaCharm() {
        this.id = ID;
        this.name = "Charm of Cetacea";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS, TomeGui.TomeFilter.CHARMS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8429;
        this.item = new CetaceaCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.cetacea_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1078, class_124.field_1067});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_CONDUIT, ResearchTasks.CATCH_FISH, ResearchTasks.EFFECT_DOLPHINS_GRACE, ResearchTasks.DROWNING_DAMAGE};
        this.attributions = new class_3545[]{new class_3545((Object)class_2561.method_43471((String)"credits_and_attribution.arcananovum.texture_by"), (Object)class_2561.method_43470((String)"Rookodzol"))};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        CetaceaCharm.putProperty(stack, "active", true);
        this.setPrefStack(stack);
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean active = CetaceaCharm.getBooleanProperty(stack, "active");
        class_1799 newStack = super.updateItem(stack, server);
        CetaceaCharm.putProperty(newStack, "active", active);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"charm ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"is ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"slippery ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"wet ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"like it just went for a ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"swim").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1075)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Wearing the ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"charm ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"gives you the grace of a ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"dolphin ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"when in the ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"water").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1075)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"disable ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"charm's").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" effect.").method_27692(class_124.field_1075)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_9001);
        ArcanaIngredient q = new ArcanaIngredient(class_1802.field_8429, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8434, 4);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8161, 4);
        ArcanaIngredient s = new ArcanaIngredient(class_1802.field_8209, 16);
        ArcanaIngredient e = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8966);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8323, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8864, 1);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_8846, 16);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8140, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, e}, {b, g, h, i, b}, {c, h, m, h, c}, {b, q, h, s, b}, {e, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Charm of Cetacea").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nDolphins are such graceful creatures, and this conduit that I have reconstructed opens up some possibilities. I believe I can miniaturize the conduit such that it gives me similar aquatic  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Charm of Cetacea").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nmaneuverability as dolphins.\n\nSneak Using the Charm toggles the aquatic buffs.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class CetaceaCharmItem
    extends ArcanaPolymerItem {
        public CetaceaCharmItem() {
            super(CetaceaCharm.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            boolean delphinidae = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.DELPHINIDAE) > 0;
            ArrayList<String> stringList = new ArrayList<String>();
            if (active) {
                if (delphinidae) {
                    stringList.add("delphinidae_on");
                } else {
                    stringList.add("on");
                }
            } else if (delphinidae) {
                stringList.add("delphinidae_off");
            } else {
                stringList.add("off");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return CetaceaCharm.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            boolean gills;
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean active = ArcanaItem.getBooleanProperty(stack, "active");
            boolean delphinidae = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.DELPHINIDAE) > 0;
            boolean bl = gills = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.GILLS) > 0;
            if (active) {
                if (player.method_5799()) {
                    class_1293 grace = new class_1293(class_1294.field_5900, 110, delphinidae ? 1 : 0, false, false, true);
                    player.method_6092(grace);
                    if (world.method_8503().method_3780() % 20 == 0) {
                        ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CETACEA_CHARM_PER_SECOND));
                    }
                }
                if (player.method_5869() && gills) {
                    class_1293 waterBreath = new class_1293(class_1294.field_5923, 110, 0, false, false, true);
                    player.method_6092(waterBreath);
                }
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            if (player.method_5715()) {
                boolean active = !ArcanaItem.getBooleanProperty(stack, "active");
                ArcanaItem.putProperty(stack, "active", active);
                if (active) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Charm moistens").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14888, (float)0.5f, (float)0.8f);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Charm dries out").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15133, (float)0.5f, (float)0.7f);
                }
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }
    }
}

