/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class LeadershipCharm
extends ArcanaItem {
    public static final String ID = "leadership_charm";

    public LeadershipCharm() {
        this.id = ID;
        this.name = "Charm of Leadership";
        this.rarity = ArcanaRarity.DIVINE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.CHARMS, TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_27063;
        this.item = new LeadershipCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.leadership_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1076});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_LEADERSHIP_CHARM};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Gods ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"have acknowledged ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"your ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"boundless ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"courage").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"They grant this ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Charm ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"to empower ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"you ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"and your ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"allies ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"in the coming fight!").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Grants AoE ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"regen").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"resistance").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"strength ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"mends gear").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n     Leadership").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nA rare pendant, gifted only by Divine Entities. Whoever holds the amulet is imbued with a surge of confidence powerful enough to radiate a visible aura. They say anything is possible when ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n     Leadership").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nfollowing a glowing leader\u2026\n\nThe Charm grants the wielder and all those nearby a bout of regeneration, strength and resistance. It also has the ability to mend ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n     Leadership").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nthe gear of all players in its radius without need for the Mending enchantment. ").method_27692(class_124.field_1074)));
        return list;
    }

    public class LeadershipCharmItem
    extends ArcanaPolymerItem {
        public LeadershipCharmItem() {
            super(LeadershipCharm.this.getThis());
        }

        public class_1799 method_7854() {
            return LeadershipCharm.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            class_3218 serverWorld;
            block10: {
                block9: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block9;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block10;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            int invigor = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.INVIGORATION.id));
            double effectRange = 8.5 + (double)invigor;
            class_243 playerPos = player.method_19538();
            List inRangePlayers = serverWorld.method_18766(p -> p.method_5707(playerPos) <= effectRange * effectRange);
            class_1293 glow = new class_1293(class_1294.field_5912, 105, 0, false, false, true);
            player.method_6092(glow);
            for (class_3222 plyr : inRangePlayers) {
                class_1293 str = new class_1293(class_1294.field_5910, 105, 1 + invigor, false, false, true);
                class_1293 res = new class_1293(class_1294.field_5907, 105, 1 + invigor / 2, false, false, true);
                class_1293 regen = new class_1293(class_1294.field_5924, 105, 1 + invigor, false, false, true);
                plyr.method_6092(str);
                plyr.method_6092(res);
                plyr.method_6092(regen);
                if (serverWorld.method_8503().method_3780() % 20 != 0) continue;
                class_1661 inv = plyr.method_31548();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    int durability;
                    class_1799 item = inv.method_5438(i);
                    if (item.method_7960() || (durability = item.method_7919()) <= 0) continue;
                    durability = class_3532.method_15340((int)(durability - 15 * (1 + invigor)), (int)0, (int)Integer.MAX_VALUE);
                    item.method_7974(durability);
                }
            }
            if (inRangePlayers.size() >= 6) {
                ArcanaAchievements.grant(player, ArcanaAchievements.RAID_LEADER.id);
            }
            if (serverWorld.method_8503().method_3780() % 10 == 0) {
                double theta = 0.039269908169872414 * (double)(serverWorld.method_8503().method_3780() % 160);
                ArcanaEffectUtils.sphere((class_3218)serverWorld, null, (class_243)player.method_19538(), (class_2394)class_2398.field_11211, (double)effectRange, (int)100, (int)1, (double)0.1, (double)0.0, (double)theta);
                ArcanaEffectUtils.circle((class_3218)serverWorld, null, (class_243)player.method_19538(), (class_2394)class_2398.field_11211, (double)effectRange, (int)100, (int)1, (double)0.1, (double)0.0);
                for (class_3222 plyr : inRangePlayers) {
                    if (plyr.equals((Object)player)) continue;
                    serverWorld.method_65096((class_2394)class_2398.field_11211, plyr.method_23317(), plyr.method_23318() + 0.75, plyr.method_23321(), 4, 0.2, 0.2, 0.2, 10.0);
                    serverWorld.method_14166(plyr, (class_2394)class_2398.field_11211, false, true, player.method_23317(), player.method_23318() + 3.0, player.method_23321(), 5, 0.1, 0.3, 0.1, 10.0);
                }
            }
        }
    }
}

