/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.lootfunctions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.ArcaneSingularityBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_7225;
import net.minecraft.class_9334;

public class ArcanaBlockEntityLootFunction
extends class_120 {
    public static final MapCodec<ArcanaBlockEntityLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> ArcanaBlockEntityLootFunction.method_53344((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ArcanaBlockEntityLootFunction::new));

    protected ArcanaBlockEntityLootFunction(List<class_5341> conditions) {
        super(conditions);
    }

    public class_5339<? extends class_120> method_29321() {
        return ArcanaRegistry.ARCANA_BLOCK_ENTITY_LOOT_FUNCTION;
    }

    protected class_1799 method_522(class_1799 stack, class_47 context) {
        class_2586 blockEntity = (class_2586)context.method_65013(class_181.field_1228);
        if (!(blockEntity instanceof ArcanaBlockEntity)) {
            return stack;
        }
        ArcanaBlockEntity arcanaBlockEntity = (ArcanaBlockEntity)blockEntity;
        class_3218 world = context.method_299();
        String uuid = arcanaBlockEntity.getUuid();
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
        }
        class_2487 augmentsTag = new class_2487();
        if (arcanaBlockEntity.getAugments() != null) {
            for (Map.Entry<ArcanaAugment, Integer> entry : arcanaBlockEntity.getAugments().entrySet()) {
                augmentsTag.method_10569(entry.getKey().id, entry.getValue().intValue());
            }
        } else {
            augmentsTag = null;
        }
        ArcanaItem arcanaItem = arcanaBlockEntity.getArcanaItem();
        arcanaItem.initializeArcanaTag(stack, false);
        stack = arcanaItem.addCrafter(stack, arcanaBlockEntity.getCrafterId(), arcanaBlockEntity.isSynthetic(), world.method_8503());
        if (augmentsTag != null) {
            ArcanaItem.putProperty(stack, "augments", (class_2520)augmentsTag);
        }
        ArcanaItem.putProperty(stack, "uuid", uuid);
        if (arcanaBlockEntity.getCustomArcanaName() != null && !arcanaBlockEntity.getCustomArcanaName().isEmpty()) {
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)arcanaBlockEntity.getCustomArcanaName()));
        }
        if (arcanaBlockEntity instanceof ArcaneSingularityBlockEntity) {
            ArcaneSingularityBlockEntity singularity = (ArcaneSingularityBlockEntity)arcanaBlockEntity;
            ArcanaItem.putProperty(stack, "books", (class_2520)singularity.saveBooks((class_7225.class_7874)world.method_30349()));
        }
        if (arcanaBlockEntity instanceof StarpathAltarBlockEntity) {
            StarpathAltarBlockEntity altar = (StarpathAltarBlockEntity)arcanaBlockEntity;
            ArcanaItem.putProperty(stack, "targets", (class_2520)altar.writeTargets());
        }
        if (arcanaBlockEntity instanceof StarlightForgeBlockEntity) {
            StarlightForgeBlockEntity forge = (StarlightForgeBlockEntity)arcanaBlockEntity;
            ArcanaItem.putProperty(stack, "seedUses", forge.getSeedUses());
        }
        arcanaItem.buildItemLore(stack, world.method_8503());
        return stack;
    }
}

