/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.mixins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.ArcanistsBelt;
import net.borisshoes.arcananovum.items.charms.CindersCharm;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.minecraft.class_1277;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1661.class})
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public class_1657 field_7546;
    @Unique
    private final Map<Integer, class_1799> anchoredItems = new HashMap<Integer, class_1799>();

    @Inject(method={"dropAll"}, at={@At(value="HEAD")})
    private void arcananovum_fateAnchorSave(CallbackInfo ci) {
        class_1661 inv = (class_1661)this;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 itemStack = inv.method_5438(i);
            if (itemStack.method_7960() || !this.field_7546.method_5805() && class_1890.method_8225((class_6880)MinecraftUtils.getEnchantment(ArcanaRegistry.FATE_ANCHOR), (class_1799)itemStack) <= 0) continue;
            this.anchoredItems.put(i, itemStack);
            inv.method_5447(i, class_1799.field_8037);
        }
    }

    @Inject(method={"dropAll"}, at={@At(value="RETURN")})
    private void arcananovum_fateAnchorRestore(CallbackInfo ci) {
        class_1661 inv = (class_1661)this;
        for (Map.Entry<Integer, class_1799> entry : this.anchoredItems.entrySet()) {
            inv.method_5447(entry.getKey().intValue(), entry.getValue());
        }
        this.anchoredItems.clear();
    }

    @Inject(method={"insertStack(ILnet/minecraft/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void arcananovum_onPickup(int slot, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        try {
            class_1661 playerInv = (class_1661)this;
            List<class_3545<List<class_1799>, class_1799>> allItems = ArcanaUtils.getAllItems(playerInv.field_7546);
            if (playerInv.field_7546.method_5715()) {
                return;
            }
            for (int i = 0; i < allItems.size(); ++i) {
                List itemList = (List)allItems.get(i).method_15442();
                class_1799 carrier = (class_1799)allItems.get(i).method_15441();
                class_1277 sinv = new class_1277(itemList.size());
                for (int j = 0; j < itemList.size(); ++j) {
                    CindersCharm charm;
                    class_1799 output;
                    class_1799 item = (class_1799)itemList.get(j);
                    boolean isArcane = ArcanaItemUtils.isArcane(item);
                    if (!isArcane) {
                        sinv.method_5447(j, item);
                        continue;
                    }
                    ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
                    if (arcanaItem instanceof CindersCharm && (output = (charm = (CindersCharm)arcanaItem).smelt(item, playerInv.field_7546, stack)) != null) {
                        cir.setReturnValue((Object)this.customPickUp(stack, slot, playerInv, output));
                        cir.cancel();
                    }
                    sinv.method_5447(j, item);
                }
                ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(carrier);
                if (!(arcanaItem instanceof ArcanistsBelt)) continue;
                ArcanistsBelt belt = (ArcanistsBelt)arcanaItem;
                belt.buildItemLore(carrier, ArcanaNovum.SERVER);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Shadow
    protected abstract int method_7366(class_1799 var1);

    @Shadow
    protected abstract int method_7385(int var1, class_1799 var2);

    private boolean customPickUp(class_1799 oldStack, int slot, class_1661 inv, class_1799 stack) {
        oldStack.method_7939(0);
        try {
            int i;
            if (stack.method_7986()) {
                if (slot == -1) {
                    slot = inv.method_7376();
                }
                if (slot >= 0) {
                    inv.method_5447(slot, stack.method_7972());
                    inv.method_5438(slot).method_7912(5);
                    stack.method_7939(0);
                    return true;
                }
                if (inv.field_7546.method_31549().field_7477) {
                    stack.method_7939(0);
                    return true;
                }
                return false;
            }
            do {
                i = stack.method_7947();
                if (slot == -1) {
                    stack.method_7939(this.method_7366(stack));
                    continue;
                }
                stack.method_7939(this.method_7385(slot, stack));
            } while (!stack.method_7960() && stack.method_7947() < i);
            if (stack.method_7947() == i && inv.field_7546.method_31549().field_7477) {
                stack.method_7939(0);
                return true;
            }
            return stack.method_7947() < i;
        }
        catch (Throwable var6) {
            class_128 crashReport = class_128.method_560((Throwable)var6, (String)"Adding item to inventory");
            class_129 crashReportSection = crashReport.method_562("Item being added");
            crashReportSection.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
            crashReportSection.method_578("Item data", (Object)stack.method_7919());
            crashReportSection.method_577("Item name", () -> stack.method_7964().getString());
            throw new class_148(crashReport);
        }
    }
}

