/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.mixins;

import java.util.Set;
import java.util.UUID;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.items.AlchemicalArbalest;
import net.borisshoes.arcananovum.items.BinaryBlades;
import net.borisshoes.arcananovum.items.GreavesOfGaialtus;
import net.borisshoes.arcananovum.items.OverflowingQuiver;
import net.borisshoes.arcananovum.items.QuiverItem;
import net.borisshoes.arcananovum.items.RunicBow;
import net.borisshoes.arcananovum.items.RunicQuiver;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_10182;
import net.minecraft.class_10387;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2708;
import net.minecraft.class_2709;
import net.minecraft.class_2743;
import net.minecraft.class_2824;
import net.minecraft.class_2828;
import net.minecraft.class_2846;
import net.minecraft.class_2879;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public class ServerPlayNetworkHandlerMixin {
    @Shadow
    public class_3222 field_14140;
    @Shadow
    private int field_14123;
    @Shadow
    private class_243 field_14119;

    @Inject(method={"onPlayerAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;", ordinal=0)})
    private void arcananovum_onHandSwap(class_2846 packet, CallbackInfo ci) {
        class_1799 offHand = this.field_14140.method_6079();
        if (BinaryBlades.isFakeBlade(offHand)) {
            this.field_14140.method_6122(class_1268.field_5810, class_1799.field_8037);
            ArcanaNovum.data((class_1657)this.field_14140).restoreOffhand();
        }
    }

    @Inject(method={"onPlayerLoaded"}, at={@At(value="TAIL")})
    private void arcananovum_onPlayerLoad(class_10387 packet, CallbackInfo ci) {
        for (UUID uuid2 : ArcanaNovum.TOTEM_KILL_LIST) {
            if (!uuid2.equals(this.field_14140.method_5667())) continue;
            this.field_14140.method_64397(this.field_14140.method_51469(), ArcanaDamageTypes.of((class_1937)this.field_14140.method_51469(), ArcanaDamageTypes.VENGEANCE_TOTEM, (class_1297)this.field_14140), this.field_14140.method_6063() * 10.0f);
            break;
        }
        ArcanaNovum.TOTEM_KILL_LIST.removeIf(uuid -> uuid.equals(this.field_14140.method_5667()));
    }

    @Inject(method={"onHandSwing"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V")})
    private void arcananovum_handSwing(class_2879 packet, CallbackInfo ci) {
        boolean runic;
        class_238 box;
        class_243 view;
        class_243 rayEnd;
        class_3244 networkHandler = (class_3244)this;
        double range = this.field_14140.method_55755();
        class_243 startPos = this.field_14140.method_33571();
        class_3966 hitEntity = class_1675.method_18075((class_1297)this.field_14140, (class_243)startPos, (class_243)(rayEnd = startPos.method_1019((view = this.field_14140.method_5663()).method_1021(range))), (class_238)(box = this.field_14140.method_5829().method_18804(view.method_1021(range)).method_1009(1.0, 1.0, 1.0)), e -> {
            if (!(e instanceof class_1309)) return false;
            class_1309 living = (class_1309)e;
            if (e.method_7325()) return false;
            if (!living.method_6059(ArcanaRegistry.GREATER_INVISIBILITY_EFFECT)) return false;
            return true;
        }, (double)range);
        if (hitEntity != null && hitEntity.method_17782() != null) {
            networkHandler.method_12062(class_2824.method_34206((class_1297)hitEntity.method_17782(), (boolean)this.field_14140.method_5715()));
        }
        class_1799 bow = this.field_14140.method_5998(class_1268.field_5808);
        boolean arbalest = ArcanaItemUtils.identifyItem(bow) instanceof AlchemicalArbalest;
        boolean crossbow = bow.method_31574(class_1802.field_8399) || arbalest;
        boolean bl = runic = ArcanaItemUtils.identifyItem(bow) instanceof RunicBow || arbalest && ArcanaAugments.getAugmentOnItem(bow, ArcanaAugments.RUNIC_ARBALEST.id) >= 1;
        if (!(bow.method_31574(class_1802.field_8102) || runic || crossbow)) {
            return;
        }
        class_1661 inv = this.field_14140.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            ArcanaItem arcanaItem;
            class_1799 item = inv.method_5438(i);
            if (item.method_7960() || !((arcanaItem = ArcanaItemUtils.identifyItem(item)) instanceof RunicQuiver) && !(arcanaItem instanceof OverflowingQuiver)) continue;
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.field_14140);
            int cooldown = ((class_2497)profile.getMiscData("QuiverCD")).method_10701();
            if (cooldown <= 0) {
                QuiverItem.switchArrowOption(this.field_14140, runic, true);
                profile.addMiscData("QuiverCD", (class_2520)class_2497.method_23247((int)3));
            }
            return;
        }
    }

    @Inject(method={"requestTeleport(Lnet/minecraft/entity/player/PlayerPosition;Ljava/util/Set;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void arcananovum_ensnarementPlayerTeleport(class_10182 pos, Set<class_2709> flags, CallbackInfo ci) {
        class_1293 effect = this.field_14140.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT);
        if (effect != null && effect.method_5578() > 0) {
            this.field_14140.method_7353((class_2561)class_2561.method_43470((String)"Your teleport has been ensnared!").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)this.field_14140, (class_3414)class_3417.field_14545, (float)2.0f, (float)0.1f);
            ci.cancel();
        }
    }

    @Inject(method={"onPlayerMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V")})
    private void arcananovum_ensnarementPlayerOnMove(class_2828 packet, CallbackInfo ci) {
        class_1293 effect = this.field_14140.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT);
        if (effect != null) {
            if (++this.field_14123 == Integer.MAX_VALUE) {
                this.field_14123 = 0;
            }
            this.field_14119 = this.field_14140.method_19538();
            this.field_14140.field_13987.method_14364((class_2596)new class_2708(this.field_14123, new class_10182(this.field_14140.method_19538(), class_243.field_1353, 0.0f, 0.0f), class_2709.method_11744((int)24)));
        } else {
            class_1799 pants = this.field_14140.method_6118(class_1304.field_6172);
            if (ArcanaItemUtils.identifyItem(pants) instanceof GreavesOfGaialtus && ArcanaAugments.getAugmentOnItem(pants, ArcanaAugments.EARTHEN_ASCENT) >= 1 && packet.method_61225() && !this.field_14140.method_31549().field_7479 && this.field_14140.method_5715()) {
                this.field_14140.method_18799(new class_243(this.field_14140.method_18798().method_10216(), 0.2, this.field_14140.method_18798().method_10215()));
                this.field_14140.field_13987.method_14364((class_2596)new class_2743((class_1297)this.field_14140));
                this.field_14140.field_13987.field_14138 = 0;
            }
        }
    }

    @ModifyVariable(method={"onPlayerMove"}, at=@At(value="STORE"), ordinal=0)
    private double arcananovum_ensnarementPlayerX(double x) {
        if (this.field_14140.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT) != null) {
            return this.field_14140.method_23317();
        }
        return x;
    }

    @ModifyVariable(method={"onPlayerMove"}, at=@At(value="STORE"), ordinal=1)
    private double arcananovum_ensnarementPlayerY(double y) {
        if (this.field_14140.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT) != null) {
            return this.field_14140.method_23318();
        }
        return y;
    }

    @ModifyVariable(method={"onPlayerMove"}, at=@At(value="STORE"), ordinal=2)
    private double arcananovum_ensnarementPlayerZ(double z) {
        if (this.field_14140.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT) != null) {
            return this.field_14140.method_23321();
        }
        return z;
    }
}

