/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.transmutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.items.AequalisScientia;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipe;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class AequalisCatalystTransmutationRecipe
extends TransmutationRecipe {
    public AequalisCatalystTransmutationRecipe(String name) {
        super(name, new class_1799((class_1935)ArcanaRegistry.STARDUST, 64), new class_1799((class_1935)ArcanaRegistry.NEBULOUS_ESSENCE, 64));
    }

    @Override
    public List<class_1799> doTransmutation(class_1799 positiveInput, class_1799 negativeInput, class_1799 reagent1, class_1799 reagent2, class_1799 aequalisInput, class_3222 player) {
        return List.of(positiveInput, negativeInput, reagent1, reagent2, aequalisInput);
    }

    @Override
    public List<class_3545<class_1799, String>> doTransmutation(class_1542 input1Entity, class_1542 input2Entity, class_1542 reagent1Entity, class_1542 reagent2Entity, class_1542 aequalisEntity, TransmutationAltarBlockEntity altar, class_3222 player) {
        class_1799 reagent2;
        boolean cross;
        String outputPos;
        class_1542 catalystEntity;
        class_1542 arcanaItemEntity;
        class_1799 catalystStack;
        class_1799 arcanaItemStack;
        class_1799 aequalisStack;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        class_1799 input1Stack = input1Entity != null ? input1Entity.method_6983() : class_1799.field_8037;
        class_1799 input2Stack = input2Entity != null ? input2Entity.method_6983() : class_1799.field_8037;
        class_1799 reagent1Stack = reagent1Entity != null ? reagent1Entity.method_6983() : class_1799.field_8037;
        class_1799 reagent2Stack = reagent2Entity != null ? reagent2Entity.method_6983() : class_1799.field_8037;
        class_1799 class_17992 = aequalisStack = aequalisEntity != null ? aequalisEntity.method_6983() : class_1799.field_8037;
        if (!this.canTransmute(input1Stack, input2Stack, reagent1Stack, reagent2Stack, aequalisStack, altar)) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        if (ArcanaItemUtils.isArcane(input1Stack) && !input1Stack.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem())) {
            arcanaItemStack = input1Stack;
            catalystStack = input2Stack;
            arcanaItemEntity = input1Entity;
            catalystEntity = input2Entity;
            outputPos = "negative";
        } else if (ArcanaItemUtils.isArcane(input2Stack) && !input2Stack.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem())) {
            arcanaItemStack = input2Stack;
            catalystStack = input1Stack;
            arcanaItemEntity = input2Entity;
            catalystEntity = input1Entity;
            outputPos = "positive";
        } else {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(arcanaItemStack);
        if (arcanaItem instanceof RunicArrow) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        ArrayList<class_3545<class_1799, String>> outputs = new ArrayList<class_3545<class_1799, String>>();
        int consumedCatas = 0;
        class_2499 catas = ArcanaItem.getListProperty(arcanaItemStack, "catalysts");
        TreeMap<ArcanaAugment, Integer> curAugments = ArcanaAugments.getAugmentsOnItem(arcanaItemStack);
        if (curAugments == null) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        while (consumedCatas < catalystStack.method_7947()) {
            Object augType2;
            ArrayList<class_3545> options = new ArrayList<class_3545>();
            ArrayList augTypes = new ArrayList(curAugments.keySet().stream().toList());
            Collections.shuffle(augTypes);
            for (Object augType2 : augTypes) {
                options.add(new class_3545(augType2, (Object)curAugments.get(augType2)));
            }
            boolean cataFound = false;
            augType2 = options.iterator();
            while (augType2.hasNext()) {
                class_3545 option = (class_3545)augType2.next();
                ArcanaAugment augment = (ArcanaAugment)option.method_15442();
                int level = (Integer)option.method_15441();
                Iterator iter = catas.iterator();
                while (iter.hasNext()) {
                    class_2487 cata = (class_2487)iter.next();
                    String aug = cata.method_68564("augment", "");
                    int lvl = cata.method_68083("level", 0);
                    ArcanaRarity rarity = ArcanaRarity.rarityFromInt(cata.method_68083("rarity", 0));
                    if (!aug.equals(augment.id) || level != lvl) continue;
                    ArcanaItem arcanaCata = ArcanaRarity.getAugmentCatalyst(rarity);
                    class_1799 catalyst = arcanaCata.addCrafter(arcanaCata.getNewItem(), arcanaItem.getCrafter(arcanaItemStack), false, altar.method_10997().method_8503());
                    outputs.add((class_3545<class_1799, String>)new class_3545((Object)catalyst, (Object)outputPos));
                    ++consumedCatas;
                    cataFound = true;
                    if (lvl - 1 <= 0) {
                        curAugments.remove(augment);
                    } else {
                        curAugments.put(augment, lvl - 1);
                    }
                    iter.remove();
                    break;
                }
                if (!cataFound) continue;
                break;
            }
            if (cataFound) continue;
            break;
        }
        ArcanaItem.putProperty(arcanaItemStack, "catalysts", (class_2520)catas);
        ArcanaAugments.setAugmentsOnItem(arcanaItemStack, curAugments);
        if (aequalisEntity != null) {
            boolean timeless = ArcanaAugments.getAugmentOnItem(aequalisStack, ArcanaAugments.TIMELESS_WISDOM.id) > 0;
            int uses = ArcanaItem.getIntProperty(aequalisStack, "uses");
            if (!timeless && uses <= 1) {
                aequalisEntity.method_31472();
            } else if (!timeless) {
                ArcanaItem.putProperty(aequalisStack, "uses", uses - 1);
                ArcanaRegistry.AEQUALIS_SCIENTIA.buildItemLore(aequalisStack, ArcanaNovum.SERVER);
                aequalisEntity.method_6979(aequalisStack);
            }
        }
        if (arcanaItemEntity != null) {
            arcanaItemEntity.method_6979(arcanaItemStack);
        }
        if (catalystEntity != null) {
            if (catalystStack.method_7947() == consumedCatas) {
                catalystEntity.method_31472();
            } else {
                catalystStack.method_7934(consumedCatas);
                catalystEntity.method_6979(catalystStack);
            }
        }
        boolean m11 = this.validStack(re1, reagent1Stack);
        boolean m22 = this.validStack(re2, reagent2Stack);
        boolean m12 = this.validStack(re1, reagent2Stack);
        boolean m21 = this.validStack(re2, reagent1Stack);
        boolean straight = m11 && m22;
        boolean bl = cross = !straight && m12 && m21;
        if (!straight && !cross) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        class_1799 reagent1 = straight ? re1 : re2;
        class_1799 class_17993 = reagent2 = straight ? re2 : re1;
        if (reagent1Entity != null) {
            int take;
            int n = take = reagent1.method_7960() ? 0 : reagent1.method_7947();
            if (take > 0) {
                if (reagent1Stack.method_7947() == take) {
                    reagent1Entity.method_31472();
                } else {
                    reagent1Stack.method_7934(take);
                    reagent1Entity.method_6979(reagent1Stack);
                }
            }
        }
        if (reagent2Entity != null) {
            int take;
            int n = take = reagent2.method_7960() ? 0 : reagent2.method_7947();
            if (take > 0) {
                if (reagent2Stack.method_7947() == take) {
                    reagent2Entity.method_31472();
                } else {
                    reagent2Stack.method_7934(take);
                    reagent2Entity.method_6979(reagent2Stack);
                }
            }
        }
        if (player != null) {
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.AEQUALIS_SCIENTIA_CATALYST_TRANSMUTE));
        }
        return outputs;
    }

    @Override
    public boolean canTransmute(class_1799 input1, class_1799 input2, class_1799 reagent1Input, class_1799 reagent2Input, class_1799 aequalisInput, TransmutationAltarBlockEntity altar) {
        boolean arrowCheck;
        boolean reagentCheck2;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        boolean reagentCheck1 = this.validStack(re1, reagent1Input) && this.validStack(re2, reagent2Input);
        boolean bl = reagentCheck2 = this.validStack(re1, reagent2Input) && this.validStack(re2, reagent1Input);
        if (!reagentCheck1 && !reagentCheck2) {
            return false;
        }
        boolean matrixCheck = input1.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem()) || input2.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem());
        boolean arcanaItemCheck = ArcanaItemUtils.isArcane(input1) && !input1.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem()) || ArcanaItemUtils.isArcane(input2) && !input2.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem());
        boolean bl2 = arrowCheck = ArcanaItemUtils.identifyItem(input1) instanceof RunicArrow || ArcanaItemUtils.identifyItem(input2) instanceof RunicArrow;
        if (!matrixCheck || !arcanaItemCheck || arrowCheck) {
            return false;
        }
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(aequalisInput);
        if (!(arcanaItem instanceof AequalisScientia)) {
            return false;
        }
        AequalisScientia as = (AequalisScientia)arcanaItem;
        try {
            boolean hasAugment;
            boolean bl3 = hasAugment = ArcanaAugments.getAugmentOnItem(aequalisInput, ArcanaAugments.EQUIVALENT_EXCHANGE.id) > 0;
            if (!hasAugment) {
                return false;
            }
            class_3222 player = altar.method_10997().method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)as.getCrafter(aequalisInput)));
            if (player != null) {
                return ArcanaNovum.data((class_1657)player).hasResearched(ArcanaRegistry.AEQUALIS_SCIENTIA);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public class_1799 getViewStack() {
        return ArcanaRegistry.CATALYTIC_MATRIX.getPrefItemNoLore().method_46651(1);
    }
}

